/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Set a nested property value.
*
* @module @stdlib/utils/deep-set
*
* @example
* var deepSet = require( '@stdlib/utils/deep-set' );
*
* var obj = { 'a': { 'b': { 'c': 'd' } } };
* var bool = deepSet( obj, 'a.b.c', 'beep' );
* // returns true
*
* var dset = deepSet.factory( 'a/b/c', {
*     'create': true,
*     'sep': '/'
* });
*
* obj = { 'a': { 'b': { 'c': 'd' } } };
*
* bool = dset( obj, 'beep' );
* // returns true
*/

// MODULES //

var setReadOnly = require( './../../define-nonenumerable-read-only-property' );
var deepSet = require( './deep_set.js' );
var factory = require( './factory.js' );


// MAIN //

setReadOnly( deepSet, 'factory', factory );


// EXPORTS //

module.exports = deepSet;
