package HashData::ColorCode::CMYK::Pantone;

use strict;
use Role::Tiny::With;
with 'HashDataRole::Source::LinesInDATA';
#with 'Role::TinyCommons::Collection::FindItem::Iterator';         # add find_item() (has_item already added above)
#with 'Role::TinyCommons::Collection::PickItems::RandomSeekLines'; # add pick_items() that uses binary search

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-10'; # DATE
our $DIST = 'HashData-ColorCode-CMYK-Pantone'; # DIST
our $VERSION = '0.002'; # VERSION

# STATS

1;
# ABSTRACT: Mapping of Pantone color names to CMYK values

=pod

=encoding UTF-8

=head1 NAME

HashData::ColorCode::CMYK::Pantone - Mapping of Pantone color names to CMYK values

=head1 VERSION

This document describes version 0.002 of HashData::ColorCode::CMYK::Pantone (from Perl distribution HashData-ColorCode-CMYK-Pantone), released on 2024-05-10.

=head1 DESCRIPTION

CMKY value are in this format: I<C>,I<M>,I<Y>,I<K>. Where each C/M/Y/K value is
an integer from 0 to 100.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/HashData-ColorCode-CMYK-Pantone>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-HashData-Color-PantoneToCMYK>.

=head1 SEE ALSO

Source: L<https://vectorization.eu/pantone-to-cmyk-converter/>

L<Graphics::ColorNames::Pantone>, L<Graphics::ColorNames::PantoneReport>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=HashData-ColorCode-CMYK-Pantone>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
100C:1,0,70,0
101C:1,0,78,0
102C:0,0,100,0
103C:0,8,100,19
104C:3,10,100,29
105C:15,20,93,42
106C:1,0,79,0
107C:0,1,88,0
108C:0,2,99,0
109C:0,5,100,0
110C:0,20,100,8
111C:0,17,100,33
112C:3,18,100,38
113C:0,1,74,0
114C:0,2,80,0
115C:0,4,88,0
116C:0,10,98,0
117C:0,26,100,15
118C:0,26,100,31
119C:11,24,96,45
120C:0,5,66,0
121C:0,6,72,0
122C:0,9,80,0
123C:0,16,89,0
124C:0,29,100,1
125C:0,31,100,25
126C:0,30,100,40
127C:0,3,63,0
128C:0,7,75,0
129C:0,10,80,0
130C:0,32,100,0
131C:0,39,100,11
132C:0,34,100,36
133C:12,33,98,60
134C:0,11,62,0
135C:0,18,72,0
136C:0,22,83,0
137C:0,36,100,0
138C:0,54,100,1
139C:0,48,100,26
140C:6,43,100,58
141C:0,16,68,0
142C:0,21,77,0
143C:0,27,85,0
144C:0,49,100,0
145C:0,49,100,8
146C:0,47,100,31
147C:19,38,87,52
148C:0,17,47,0
149C:0,22,56,0
150C:0,30,71,0
151C:0,54,100,0
152C:0,61,100,0
153C:0,57,100,17
154C:0,57,100,38
155C:0,13,35,0
156C:0,23,51,0
157C:0,40,71,0
158C:0,62,97,0
159C:0,68,100,7
160C:0,64,100,32
161C:11,61,92,65
162C:0,27,32,0
163C:0,44,57,0
164C:0,59,81,0
165C:0,68,96,0
166C:0,76,100,0
167C:0,73,100,15
168C:2,74,94,57
169C:0,34,21,0
170C:0,56,48,0
171C:0,74,85,0
172C:0,80,98,0
173C:0,83,99,4
174C:0,84,95,37
175C:13,78,77,59
176C:0,34,9,0
177C:0,58,29,0
178C:0,75,57,0
179C:0,88,85,0
180C:1,87,77,13
181C:6,87,71,47
182C:0,30,0,0
183C:0,46,6,0
184C:0,79,31,0
185C:0,100,89,0
186C:0,100,80,5
187C:0,100,74,26
188C:5,96,56,54
189C:0,42,3,0
190C:0,65,11,0
191C:0,85,30,0
192C:0,100,62,0
193C:0,100,59,11
194C:2,97,43,33
196C:0,21,2,0
197C:0,45,7,0
198C:0,85,41,0
199C:0,100,79,0
200C:0,100,76,13
201C:0,100,63,31
202C:1,98,58,44
203C:0,34,0,0
204C:0,58,1,0
205C:0,84,15,0
206C:0,100,69,2
207C:0,100,59,26
208C:0,100,29,44
209C:15,96,31,55
210C:1,44,0,0
211C:0,60,0,0
212C:0,78,2,0
213C:0,95,9,0
214C:1,100,14,3
215C:2,100,14,21
216C:12,98,17,46
217C:1,27,0,0
218C:2,66,0,0
219C:0,95,0,0
220C:0,100,13,26
221C:0,100,14,38
222C:21,100,7,52
223C:4,48,0,0
224C:5,64,0,0
225C:4,90,0,0
226C:0,100,0,2
227C:3,100,0,20
228C:17,100,0,33
229C:27,100,9,54
230C:3,39,0,0
231C:5,61,0,0
232C:7,81,0,0
233C:11,100,0,0
234C:16,100,0,17
235C:18,100,0,37
236C:5,38,0,0
237C:7,53,0,0
238C:11,70,0,0
239C:14,81,0,0
240C:20,90,0,0
241C:28,100,0,0
242C:32,100,0,29
243C:6,29,0,0
244C:10,43,0,0
245C:14,56,0,0
246C:27,89,0,0
247C:30,94,0,0
248C:37,100,0,0
249C:43,100,0,17
250C:7,29,0,0
251C:13,42,0,0
252C:26,67,0,0
253C:40,95,0,0
254C:46,98,0,0
255C:53,100,0,16
256C:11,24,0,0
257C:19,39,0,0
258C:51,84,0,0
259C:64,100,0,7
260C:60,100,0,22
261C:60,100,0,31
262C:58,96,6,49
263C:11,20,0,0
264C:23,34,0,0
265C:54,67,0,0
266C:71,88,0,0
267C:81,99,0,0
268C:79,100,0,0
269C:76,100,0,18
270C:29,23,0,0
271C:44,38,0,0
272C:61,55,0,0
273C:98,97,0,37
274C:98,97,0,49
275C:98,99,0,58
276C:94,93,0,79
277C:32,8,0,0
278C:43,17,0,0
279C:69,34,0,0
280C:100,85,0,39
281C:100,78,0,57
282C:100,72,0,73
283C:41,11,0,0
284C:54,19,0,0
285C:90,47,0,0
286C:100,80,0,12
287C:100,81,0,23
288C:100,79,0,37
289C:100,66,0,76
290C:25,1,0,0
291C:38,4,0,0
292C:55,13,0,0
293C:100,76,0,9
294C:100,74,0,45
295C:100,63,0,67
296C:100,46,0,89
297C:52,0,0,0
298C:65,3,0,0
299C:79,7,0,0
300C:100,56,0,3
301C:100,51,0,34
302C:100,32,0,68
303C:100,33,6,84
304C:35,0,2,0
305C:55,0,1,0
306C:76,0,0,0
307C:100,20,0,25
308C:100,10,0,52
309C:100,8,20,76
310C:50,0,4,0
311C:65,0,6,0
312C:92,0,12,0
313C:100,0,11,6
314C:100,0,13,22
315C:100,0,17,44
316C:100,10,29,68
317C:26,0,6,0
318C:39,0,9,0
319C:60,0,16,0
320C:100,0,36,1
321C:100,0,37,10
322C:100,0,39,33
323C:100,0,41,51
324C:34,0,10,0
325C:54,0,20,0
326C:81,0,38,0
327C:100,0,59,13
328C:100,0,56,30
329C:100,0,55,42
330C:93,14,53,57
331C:27,0,15,0
332C:35,0,21,0
333C:54,0,34,0
334C:100,0,68,1
335C:100,0,67,23
336C:99,1,67,45
337C:40,0,29,0
338C:52,0,36,0
339C:79,0,60,0
340C:100,0,81,0
341C:95,1,75,26
342C:93,4,75,43
343C:87,13,72,56
344C:35,0,35,0
345C:40,0,38,0
346C:52,0,50,0
347C:92,0,97,0
348C:93,0,98,17
349C:85,3,91,44
350C:74,18,81,62
351C:32,0,33,0
352C:37,0,38,0
353C:42,0,44,0
354C:85,0,98,0
355C:93,0,100,0
356C:91,0,100,26
357C:80,9,88,60
358C:32,0,51,0
359C:38,0,58,0
360C:59,0,90,0
361C:68,0,100,0
362C:66,0,100,9
363C:64,0,100,24
364C:59,0,100,43
365C:23,0,56,0
366C:29,0,64,0
367C:37,0,77,0
368C:54,0,100,0
369C:58,0,100,4
370C:49,0,100,30
371C:40,10,98,59
372C:15,0,53,0
373C:18,0,60,0
374C:23,0,69,0
375C:40,0,98,0
376C:48,0,100,1
377C:41,0,100,22
378C:32,9,100,60
379C:9,0,69,0
380C:13,0,83,0
381C:18,0,99,0
382C:22,0,100,0
383C:19,0,100,18
384C:14,0,100,35
385C:17,15,96,52
386C:6,0,67,0
387C:10,0,86,0
388C:11,0,91,0
389C:15,0,99,0
390C:20,0,100,8
391C:10,0,100,35
392C:9,7,100,49
393C:3,0,63,0
394C:5,0,84,0
395C:6,0,92,0
396C:7,0,100,0
397C:11,0,100,13
398C:8,0,100,26
399C:2,5,100,36
400C:20,17,19,0
401C:28,25,28,3
402C:34,30,33,8
403C:39,36,40,14
404C:45,43,47,25
405C:49,47,51,32
406C:20,19,17,0
408C:35,36,32,10
409C:40,42,40,18
410C:45,48,45,26
411C:51,55,52,39
412C:61,68,64,74
413C:25,17,22,0
414C:31,23,29,3
415C:39,29,36,9
416C:45,35,43,18
417C:53,42,52,31
418C:59,48,58,44
419C:76,65,66,90
420C:18,13,10,0
421C:28,20,20,1
422C:36,26,23,4
423C:44,33,29,9
424C:52,41,38,20
425C:63,51,45,33
426C:81,67,55,83
427C:14,8,4,0
428C:21,13,8,0
429C:35,23,19,2
430C:50,34,27,11
431C:63,45,34,25
432C:78,57,39,56
433C:88,63,40,85
434C:14,17,10,0
435C:21,24,14,0
436C:30,33,22,4
437C:44,51,39,24
438C:52,62,51,47
439C:56,68,59,64
440C:61,69,63,75
441C:24,12,14,0
442C:36,20,23,2
443C:43,25,26,5
444C:54,35,35,17
445C:66,47,47,37
446C:71,53,55,53
447C:70,57,63,65
448C:39,47,81,67
449C:29,43,87,67
450C:25,42,88,64
451C:27,24,61,16
452C:24,20,48,6
453C:20,16,37,2
454C:17,12,29,0
455C:18,30,94,59
456C:12,20,91,29
457C:7,16,96,22
458C:10,9,71,2
459C:9,8,67,1
460C:7,4,55,0
461C:4,1,43,0
462C:27,52,82,61
463C:13,54,88,53
464C:7,53,89,42
465C:13,31,63,12
466C:13,25,52,6
467C:11,19,42,2
468C:8,14,33,0
469C:11,64,89,61
470C:3,62,88,30
471C:1,63,94,19
472C:0,40,54,1
473C:0,24,33,0
474C:0,20,28,0
475C:0,15,23,0
476C:33,66,76,68
477C:19,69,78,60
478C:12,72,81,54
479C:17,44,50,15
480C:14,29,34,3
481C:11,23,24,0
482C:8,17,20,0
483C:10,82,81,63
484C:1,90,92,33
485C:0,95,100,0
486C:0,50,42,0
487C:0,37,31,0
488C:0,28,23,0
489C:0,22,20,0
490C:18,88,59,66
491C:9,89,59,48
492C:6,89,60,39
494C:0,41,7,0
495C:0,28,1,0
496C:0,23,1,0
497C:34,77,62,67
498C:23,76,61,54
499C:18,75,60,46
500C:12,50,21,5
501C:7,37,11,0
502C:2,27,6,0
503C:1,22,7,0
504C:29,88,45,65
505C:21,90,34,52
506C:20,87,28,37
507C:7,47,6,1
508C:1,37,3,0
509C:0,32,1,0
510C:0,26,2,0
511C:45,92,12,47
512C:48,96,1,10
513C:48,96,0,0
514C:14,51,0,0
515C:7,35,0,0
516C:4,26,0,0
517C:1,22,0,0
518C:60,84,22,54
519C:62,92,6,34
520C:63,99,0,20
521C:35,54,0,0
522C:24,40,0,0
523C:16,30,0,0
524C:11,21,0,0
525C:64,98,1,33
526C:66,100,0,0
527C:62,93,0,0
528C:31,54,0,0
529C:19,38,0,0
530C:12,27,0,0
531C:8,20,0,0
532C:92,73,29,89
533C:94,73,5,69
534C:100,71,0,51
535C:44,27,5,2
536C:36,19,3,0
537C:24,12,1,0
538C:19,9,2,0
539C:100,43,0,83
540C:100,53,0,65
541C:100,61,0,43
542C:51,16,0,0
543C:35,7,0,0
544C:24,4,0,0
545C:20,3,0,0
546C:97,32,34,86
547C:100,11,20,82
548C:100,8,11,74
549C:57,16,10,2
550C:44,10,6,0
551C:35,6,4,0
552C:25,4,1,0
553C:77,28,74,67
554C:80,16,72,51
555C:77,12,68,35
556C:56,12,44,7
557C:48,10,36,3
558C:40,7,29,0
559C:31,4,22,0
560C:86,30,65,75
561C:91,13,60,53
562C:92,7,55,35
563C:58,0,31,0
564C:47,0,25,0
565C:35,0,19,0
566C:25,0,14,0
567C:88,24,66,74
569C:96,1,59,20
570C:54,0,30,0
571C:36,0,18,0
572C:30,0,15,0
573C:24,0,11,0
574C:49,22,85,58
575C:47,9,86,35
576C:48,6,79,17
577C:34,3,55,1
578C:28,1,44,0
579C:25,1,42,0
580C:21,0,38,0
581C:22,21,96,60
582C:16,4,100,37
583C:24,0,99,6
584C:17,0,75,0
585C:12,0,64,0
586C:9,0,59,0
587C:7,0,51,0
600C:1,0,44,0
601C:2,0,49,0
602C:2,0,59,0
603C:4,0,78,0
604C:5,0,88,0
605C:4,1,100,4
606C:0,6,100,13
607C:4,0,44,0
608C:5,0,53,0
609C:7,0,60,0
610C:10,3,74,0
611C:11,5,90,4
612C:4,5,100,17
613C:1,9,100,28
614C:11,5,41,0
615C:13,8,48,0
616C:15,9,52,1
617C:19,13,66,6
618C:19,16,82,18
619C:16,16,91,28
620C:10,16,98,44
621C:13,0,9,0
622C:27,5,18,0
623C:40,10,27,1
624C:53,16,38,7
625C:66,21,49,22
626C:80,21,60,48
627C:89,28,66,83
628C:25,0,4,0
629C:36,0,5,0
630C:50,0,8,0
631C:67,2,11,0
632C:87,8,14,7
633C:100,5,9,30
634C:100,6,1,48
635C:32,0,1,0
636C:42,0,0,0
637C:60,0,2,0
638C:77,0,3,0
639C:97,4,3,2
640C:100,8,0,12
641C:100,22,0,29
642C:15,4,0,0
643C:20,6,0,0
644C:38,15,0,0
645C:51,23,0,1
646C:65,34,2,1
647C:88,52,3,12
648C:100,69,0,56
649C:11,3,0,0
650C:16,6,0,0
651C:33,15,0,0
652C:52,27,0,1
653C:84,54,3,10
654C:100,73,0,33
655C:100,73,0,61
656C:10,2,0,0
657C:19,7,0,0
658C:29,11,0,0
659C:51,26,0,0
660C:74,44,0,0
661C:100,81,0,13
662C:100,87,0,36
663C:5,6,0,0
664C:6,8,0,0
665C:19,22,0,0
666C:35,39,4,2
667C:52,58,8,8
668C:65,72,8,18
669C:80,97,0,45
670C:1,15,0,0
671C:2,28,0,0
672C:5,42,0,0
673C:6,55,0,0
674C:14,76,0,0
675C:17,98,1,7
676C:0,100,7,35
677C:3,17,0,0
678C:4,20,0,0
679C:6,25,0,0
680C:14,44,0,0
681C:24,64,4,3
682C:29,80,8,12
683C:25,96,7,38
684C:4,21,0,0
685C:6,29,0,0
686C:11,39,1,0
687C:19,51,5,2
688C:26,65,9,7
689C:32,85,12,23
690C:26,98,13,59
691C:1,17,5,0
692C:3,25,8,0
693C:7,38,14,0
694C:12,51,21,5
695C:15,61,26,11
696C:16,76,38,27
697C:15,80,46,36
698C:0,15,3,0
699C:0,25,4,0
700C:0,37,9,0
701C:0,56,16,0
702C:2,73,30,3
703C:3,88,52,16
704C:1,95,75,31
705C:0,12,0,0
706C:0,19,0,0
707C:0,33,4,0
708C:0,52,15,0
709C:0,73,32,0
710C:0,88,58,0
711C:0,94,84,5
712C:0,19,40,0
713C:0,25,49,0
714C:0,36,66,0
715C:0,50,93,0
716C:0,59,100,0
717C:0,69,100,2
718C:0,74,100,12
719C:1,18,31,0
720C:2,26,43,0
721C:4,34,54,3
722C:4,46,75,13
723C:1,55,94,25
724C:0,64,100,41
725C:0,68,100,53
726C:6,21,33,0
727C:8,26,39,2
728C:10,32,49,6
729C:10,43,65,18
730C:7,51,85,33
731C:0,63,100,57
732C:0,69,100,68
801C:85,0,8,0
802C:51,0,85,0
803C:0,3,97,0
804C:0,41,63,0
805C:0,58,41,0
806C:0,72,0,0
807C:12,76,0,0
808C:100,0,18,28
809C:2,0,82,9
810C:0,16,79,0
811C:0,44,58,0
812C:0,63,36,0
813C:0,71,22,2
814C:35,50,0,17
1205C:0,4,48,0
1215C:0,7,61,0
1225C:0,16,80,0
1235C:0,25,94,0
1245C:2,31,98,16
1255C:3,30,95,29
1265C:10,32,92,45
1345C:0,13,50,0
1355C:0,19,61,0
1365C:0,28,79,0
1375C:0,40,97,0
1385C:0,54,100,5
1395C:0,51,100,39
1405C:8,49,97,60
1485C:0,34,68,0
1495C:0,49,96,0
1505C:0,64,100,0
1525C:0,77,100,14
1535C:0,71,100,38
1545C:0,68,100,67
1555C:0,29,40,0
1565C:0,42,60,0
1575C:0,59,90,0
1585C:0,66,99,0
1595C:0,70,100,2
1605C:1,66,95,30
1615C:1,68,98,44
1625C:0,41,39,0
1635C:0,53,55,0
1645C:0,68,85,0
1655C:0,77,100,0
1665C:0,82,100,0
1675C:0,79,100,26
1685C:1,79,95,48
1765C:0,42,9,0
1767C:0,36,5,0
1775C:0,53,15,0
1777C:0,72,30,0
1785C:0,82,51,0
1787C:0,89,66,0
1788C:0,93,82,0
1795C:0,96,82,1
1797C:0,92,72,6
1805C:0,97,78,22
1807C:3,90,65,28
1815C:2,97,72,52
1817C:23,80,58,57
1895C:0,32,0,0
1905C:0,47,2,0
1915C:0,81,16,0
1925C:0,100,52,0
1935C:0,100,59,8
1945C:0,100,48,26
1955C:0,100,43,43
2365C:3,29,0,0
2375C:12,59,0,0
2385C:19,82,0,0
2395C:23,96,0,0
2405C:31,100,0,1
2415C:35,100,0,6
2425C:36,100,0,23
2562C:14,35,0,0
2563C:18,38,0,0
2567C:24,38,0,0
2572C:23,49,0,0
2573C:28,52,0,0
2577C:39,56,0,0
2582C:41,77,0,0
2583C:42,71,0,0
2587C:61,83,0,0
2592C:52,93,0,0
2593C:59,94,0,0
2597C:82,100,0,4
2602C:58,99,0,0
2603C:66,100,0,4
2607C:85,100,0,13
2612C:61,100,0,1
2613C:68,100,0,8
2617C:85,100,0,23
2622C:57,95,3,27
2623C:66,100,0,20
2627C:83,100,0,44
2635C:21,27,0,0
2645C:34,41,0,0
2655C:49,55,0,0
2665C:65,73,0,0
2685C:97,100,0,19
2695C:89,100,0,58
2705C:36,32,0,0
2706C:18,11,0,0
2707C:21,7,0,0
2708C:25,12,0,0
2715C:52,47,0,0
2716C:38,26,0,0
2717C:32,13,0,0
2718C:65,40,0,0
2725C:73,68,0,0
2726C:83,66,0,0
2727C:75,45,0,0
2728C:99,76,0,0
2735C:99,99,0,5
2736C:100,90,0,2
2738C:100,91,0,13
2745C:100,98,0,22
2746C:100,91,0,10
2747C:100,85,0,37
2748C:100,86,0,35
2755C:99,98,0,35
2756C:100,92,0,26
2757C:100,81,0,51
2758C:100,83,0,47
2765C:98,98,0,60
2766C:100,87,0,58
2767C:100,71,0,66
2768C:100,78,0,66
2905C:43,3,0,0
2915C:58,8,0,0
2925C:75,18,0,0
2935C:100,63,0,2
2945C:100,64,0,16
2955C:100,52,0,58
2965C:100,40,0,82
2975C:37,0,0,0
2985C:58,0,0,0
2995C:79,3,0,0
3005C:100,35,0,2
3015C:100,32,0,25
3025C:100,19,0,56
3035C:100,19,10,72
3105C:49,0,7,0
3115C:70,0,13,0
3125C:89,0,19,0
3135C:100,0,22,10
3145C:100,0,24,30
3155C:100,0,25,47
3165C:100,0,29,64
3242C:44,0,17,0
3245C:40,0,19,0
3248C:52,0,32,0
3252C:59,0,26,0
3255C:58,0,30,0
3258C:62,0,35,0
3262C:81,0,40,0
3265C:75,0,43,0
3268C:86,0,55,0
3272C:100,0,51,0
3275C:93,0,57,0
3278C:100,0,65,0
3282C:100,0,54,15
3285C:100,0,57,1
3288C:100,0,67,17
3292C:100,0,56,56
3295C:100,0,61,28
3298C:100,0,67,40
3302C:95,12,56,64
3305C:93,13,61,62
3308C:92,14,67,70
3375C:41,0,31,0
3385C:55,0,45,0
3395C:77,0,67,0
3405C:92,0,85,0
3415C:100,0,85,29
3425C:96,2,80,47
3435C:87,15,77,69
3935C:2,0,72,0
3945C:2,0,98,0
3955C:2,0,100,0
3965C:2,0,100,1
3975C:3,6,100,23
3985C:2,12,100,41
3995C:17,25,96,60
4485C:21,40,90,61
4495C:17,29,84,37
4505C:20,27,75,26
4515C:20,22,59,10
4525C:17,17,49,4
4535C:15,13,42,1
4545C:12,11,36,0
4625C:14,75,91,76
4635C:11,54,76,34
4645C:14,44,59,18
4655C:14,37,47,8
4665C:12,30,40,3
4675C:8,21,27,0
4685C:6,18,24,0
4695C:19,75,79,66
4705C:19,64,67,42
4715C:21,50,54,24
4725C:20,41,41,11
4735C:17,31,33,4
4745C:14,25,23,0
4755C:10,19,17,0
4975C:27,90,62,83
4985C:24,70,41,31
4995C:23,61,34,19
5005C:20,50,27,9
5015C:13,36,17,1
5025C:8,27,9,0
5035C:6,22,9,0
5115C:48,91,17,59
5125C:48,82,16,34
5135C:43,68,17,19
5145C:34,53,13,7
5155C:20,33,7,1
5165C:11,21,3,0
5175C:9,18,3,0
5185C:57,82,30,59
5195C:50,73,26,35
5205C:41,58,21,16
5215C:27,38,12,3
5225C:18,27,7,0
5235C:13,22,5,0
5245C:8,15,1,0
5255C:100,94,0,78
5265C:80,78,11,38
5275C:67,63,15,21
5285C:44,40,10,5
5295C:28,24,4,0
5305C:19,16,1,0
5315C:11,9,0,0
5395C:100,44,10,91
5405C:69,37,19,16
5415C:65,34,16,11
5425C:52,25,13,4
5435C:34,14,6,0
5445C:26,10,3,0
5455C:23,8,2,0
5463C:99,31,34,90
5467C:88,37,59,80
5473C:86,24,33,43
5477C:71,36,48,39
5483C:68,23,28,14
5487C:61,32,39,21
5493C:51,15,20,3
5497C:48,24,29,7
5503C:42,11,16,0
5507C:38,18,22,1
5513C:32,7,10,0
5517C:29,13,16,0
5523C:27,5,8,0
5527C:24,10,13,0
5535C:87,31,69,86
5545C:70,27,54,35
5555C:62,24,47,21
5565C:50,19,36,7
5575C:43,16,30,3
5585C:34,11,25,0
5595C:23,6,18,0
5605C:78,35,74,78
5615C:57,30,53,27
5625C:52,27,45,17
5635C:40,20,33,5
5645C:35,17,28,2
5655C:29,13,23,0
5665C:24,11,19,0
5743C:49,26,88,70
5747C:39,19,96,76
5753C:44,24,80,47
5757C:32,17,89,46
5763C:41,23,69,31
5767C:33,18,75,25
5773C:38,22,59,18
5777C:30,16,60,11
5783C:32,18,47,7
5787C:24,12,46,3
5793C:27,14,38,2
5797C:20,9,39,0
5803C:21,11,32,0
5807C:16,6,31,0
5815C:29,29,91,65
5825C:26,22,80,32
5835C:26,20,67,16
5845C:24,18,57,8
5855C:21,14,47,3
5865C:17,10,43,1
5875C:14,8,37,0
100U:0,4,50,0
106U:0,8,59,0
113U:0,12,63,0
120U:0,20,86,0
1205U:0,11,42,0
127U:0,10,47,1
134U:0,17,53,0
1345U:0,16,43,0
141U:0,22,56,2
101U:0,5,60,0
107U:0,10,68,0
114U:0,15,71,0
121U:0,20,68,0
1215U:0,15,51,0
128U:0,18,62,1
135U:0,24,60,0
1355U:0,22,51,0
142U:0,29,63,3
102U:0,7,82,0
108U:0,13,79,0
115U:0,19,82,0
122U:0,25,75,0
1225U:0,27,69,0
129U:0,30,75,2
136U:0,32,71,0
1365U:0,32,64,0
143U:0,35,69,4
109U:0,22,100,0
116U:0,29,93,0
123U:0,33,81,0
1235U:0,32,77,0
130U:0,37,81,3
137U:0,38,78,0
1375U:0,40,75,0
144U:0,42,75,5
103U:0,12,77,29
110U:0,22,81,20
Orange 021U:0,42,75,5
Process Black U:0,5,12,83
Process Cyan U:100,22,0,16
Process Magenta U:0,100,49,16
Process Yellow U:0,6,91,4
117U:0,23,74,28
124U:0,33,76,16
1245U:0,26,65,27
131U:0,31,73,27
138U:0,41,76,17
1385U:0,39,70,20
145U:0,36,97,24
red 032U:0,67,64,4
104U:0,9,63,39
111U:0,13,62,39
118U:0,18,64,38
125U:0,22,63,35
1255U:0,19,56,37
132U:0,19,60,41
139U:0,29,62,38
1395U:0,26,55,42
146U:0,26,59,38
Blue 072 U:64,61,0,32
105U:0,6,43,51
112U:0,12,55,46
119U:0,10,45,48
126U:0,16,54,44
1265U:0,14,46,47
133U:0,10,43,51
140U:0,17,46,50
1405U:0,16,40,53
147U:0,11,37,54
148U:0,22,47,0
1485U:0,35,61,0
155U:0,19,40,3
1555U:0,24,38,0
162U:0,27,39,0
1625U:0,34,43,0
169U:0,28,32,0
176U:0,31,27,0
1765U:0,35,29,0
1767U:0,27,21,0
1495U:0,42,68,0
149U:0,29,54,3
156U:0,25,47,3
1565U:0,33,49,0
163U:0,39,54,0
1635U:0,41,51,0
170U:0,45,51,0
177U:0,45,43,0
1775U:0,45,40,0
1777U:0,50,43,0
150U:0,40,67,0
1505U:0,50,78,0
157U:0,38,60,5
1575U:0,41,60,0
164U:0,47,63,0
1645U:0,50,62,0
171U:0,53,60,0
178U:0,54,53,0
1785U:0,60,55,0
1787U:0,61,55,1
151U:0,47,76,0
158U:0,47,68,7
1585U:0,48,69,0
165U:0,54,72,0
1655U:0,56,70,0
172U:0,60,70,0
warm red U:0,74,83,4
1788U:0,62,61,2
152U:0,46,72,12
1525U:0,47,70,26
159U:0,44,65,21
1595U:0,47,67,17
166U:0,54,72,12
1665U:0,55,68,10
173U:0,53,64,19
179U:0,58,62,12
1795U:0,59,59,15
1797U:0,61,59,20
153U:0,35,62,33
1535U:0,35,57,41
160U:0,32,55,38
1605U:0,35,54,35
167U:0,43,61,29
1675U:0,43,57,33
174U:0,42,53,39
180U:0,50,53,25
1805U:0,51,51,29
1807U:0,51,50,35
154U:0,29,53,43
1545U:0,22,41,52
161U:0,18,39,53
1615U:0,31,50,42
168U:0,30,46,46
1685U:0,35,48,42
175U:0,29,38,51
181U:0,36,41,45
1815U:0,40,43,44
1817U:0,31,31,53
182U:0,28,21,0
189U:0,33,24,0
1895U:0,30,19,0
196U:0,20,17,4
203U:0,28,17,4
210U:0,36,20,0
217U:0,21,8,4
223U:0,34,13,2
230U:0,30,12,0
236U:0,33,10,3
183U:0,45,36,0
190U:0,47,36,0
1905U:0,38,26,1
197U:0,33,26,5
204U:0,45,31,7
211U:0,47,28,1
218U:0,45,23,6
224U:0,45,19,4
231U:0,47,19,2
237U:0,42,13,5
184U:0,56,48,1
191U:0,55,45,3
1915U:0,55,41,4
198U:0,54,46,9
205U:0,57,42,10
212U:0,56,36,4
219U:0,60,34,11
225U:0,59,29,8
232U:0,56,24,5
238U:0,52,18,9
185U:0,67,60,5
192U:0,65,55,7
1925U:0,66,53,9
199U:0,64,56,13
206U:0,69,53,15
213U:0,64,43,9
rubine red U:0,67,42,14
226U:0,100,47,18
Rhodamine red U:0,67,32,11
239U:0,61,22,14
186U:0,61,55,18
193U:0,58,49,23
1935U:0,62,51,21
200U:0,58,51,26
207U:0,58,51,26
214U:0,61,42,18
220U:0,57,34,31
227U:0,59,31,31
233U:0,65,32,22
240U:0,56,21,24
187U:0,52,47,32
194U:0,45,38,36
1945U:0,52,41,31
201U:0,46,40,37
208U:0,41,28,44
215U:0,53,35,32
221U:0,52,30,38
228U:0,45,23,45
234U:0,55,26,33
241U:0,52,21,31
188U:0,38,35,46
195U:0,34,29,47
1955U:0,45,36,41
202U:0,39,35,44
209U:0,32,23,49
216U:0,38,26,46
222U:0,34,18,49
229U:0,31,16,52
235U:0,46,21,43
242U:0,37,16,45
2365U:0,23,7,3
243U:0,26,5,5
250U:0,22,2,7
256U:3,17,0,15
2562U:5,25,0,9
2563U:6,25,0,15
2567U:12,27,0,14
263U:6,15,0,8
2635U:13,21,0,9
270U:22,22,0,13
2375U:0,42,10,8
244U:0,34,6,8
251U:0,33,0,12
257U:4,24,0,20
2572U:8,35,0,13
2573U:9,33,0,20
2577U:17,36,0,22
264U:16,29,0,11
2645U:19,28,0,11
271U:27,27,0,17
2385U:0,50,13,12
245U:0,43,7,12
252U:0,46,1,19
258U:7,32,0,32
2582U:10,43,0,19
2583U:10,37,0,29
2587U:20,40,0,28
265U:25,42,0,18
2655U:25,37,0,15
272U:33,32,0,22
2395U:0,59,18,16
246U:0,58,13,19
Purple U:0,57,5,25
259U:5,34,0,39
2592U:11,50,0,25
2593U:11,42,0,37
2597U:21,45,0,36
266U:30,48,0,23
2665U:31,45,0,21
273U:35,40,0,39
2405U:0,54,16,27
247U:0,57,14,26
253U:0,52,3,29
260U:2,28,0,45
2602U:9,48,0,35
2603U:9,39,0,43
2607U:19,41,0,41
267U:27,47,0,32
Violet U:34,51,0,30
274U:32,37,0,45
2415U:0,51,15,33
248U:0,51,13,37
254U:0,47,3,38
261U:2,25,0,49
2612U:5,38,0,45
2613U:7,36,0,47
2617U:16,39,0,46
268U:20,38,0,44
2685U:29,46,0,35
275U:29,34,0,49
2425U:0,45,15,41
249U:0,36,11,47
255U:0,34,5,49
262U:0,20,1,54
2622U:0,26,1,52
2623U:4,30,0,52
2627U:11,34,0,51
269U:13,31,0,50
2695U:16,27,0,50
276U:17,23,0,56
2705U:21,22,0,9
2706U:15,12,0,5
2707U:18,10,0,4
2708U:26,16,0,6
277U:28,14,0,5
283U:35,16,0,7
290U:30,11,0,7
2905U:42,15,0,7
297U:47,14,0,7
2975U:42,11,0,7
2715U:29,32,0,13
2716U:31,25,0,9
2717U:31,18,0,4
2718U:51,38,0,15
278U:41,22,0,7
284U:47,24,0,9
291U:46,19,0,8
2915U:57,23,0,9
298U:67,22,0,9
2985U:69,20,0,9
2725U:35,40,0,17
2726U:45,41,0,19
2727U:57,38,0,9
2728U:58,46,0,24
279U:58,35,0,14
285U:65,37,0,19
292U:57,27,0,10
2925U:71,31,0,14
299U:92,31,0,15
2995U:94,28,0,14
2735U:42,51,0,30
2736U:49,48,0,27
2738U:57,53,0,36
286U:70,48,0,36
293U:79,46,0,34
2935U:84,44,0,33
300U:100,40,0,29
3005U:100,37,0,25
2745U:37,45,0,40
2746U:46,44,0,35
2747U:54,45,0,44
2748U:49,44,0,45
280U:53,43,0,49
287U:60,41,0,41
294U:59,35,0,47
2945U:71,37,0,45
301U:72,31,0,44
3015U:78,29,0,42
2755U:33,40,0,45
2756U:37,34,0,45
2757U:45,37,0,51
2758U:41,37,0,52
281U:46,37,0,54
288U:55,38,0,47
295U:52,29,0,55
2955U:51,26,0,54
302U:54,21,0,53
3025U:55,20,0,52
2765U:27,34,0,53
2766U:30,27,0,51
2767U:26,24,0,61
2768U:32,28,0,57
282U:35,29,0,60
289U:36,25,0,59
296U:30,17,0,62
2965U:40,19,0,60
303U:38,16,0,60
3035U:37,14,0,60
304U:40,7,0,7
310U:60,10,0,10
3105U:66,7,0,13
317U:25,0,0,9
324U:40,0,1,15
3242U:58,0,4,14
3245U:65,0,8,14
3248U:49,0,10,19
331U:37,0,9,9
337U:39,0,13,16
305U:65,14,0,7
311U:100,13,0,14
3115U:100,9,0,17
318U:52,2,0,13
325U:67,0,3,24
3255U:100,0,10,19
3258U:63,0,11,24
332U:50,0,10,11
338U:61,0,17,24
306U:100,21,0,11
312U:100,16,0,18
3125U:100,12,0,24
319U:82,3,0,18
326U:100,0,5,33
3262U:100,0,6,27
3265U:100,0,11,25
3268U:78,0,13,30
333U:100,0,15,18
339U:80,0,21,32
Process Blue U:100,33,0,24
313U:100,20,0,31
3135U:100,14,0,35
320U:100,5,0,35
327U:100,0,7,44
3272U:100,0,7,44
3275U:100,0,14,33
3278U:100,0,17,39
Green U:100,0,19,33
340U:100,0,25,38
307U:100,28,0,36
314U:100,18,0,40
3145U:100,12,0,47
321U:100,5,0,46
328U:85,0,3,51
3282U:100,0,5,47
3285U:100,0,10,44
3288U:100,0,10,44
334U:100,0,15,42
341U:57,0,18,53
308U:57,0,18,53
315U:74,15,0,53
3155U:77,11,0,54
322U:82,4,0,53
329U:61,0,3,54
3292U:53,0,4,57
3295U:72,0,8,51
3298U:52,0,9,55
335U:71,0,12,51
342U:43,0,14,56
309U:37,12,0,61
316U:37,8,0,62
3165U:54,10,0,60
323U:53,4,0,60
330U:32,0,1,61
3302U:33,0,2,62
3305U:33,0,5,59
3308U:26,0,6,62
336U:49,0,10,55
343U:29,0,10,60
3375U:58,0,18,12
344U:34,0,20,15
351U:36,0,22,10
358U:30,0,36,15
365U:16,0,37,10
372U:13,0,40,6
379U:3,0,48,7
386U:1,0,50,5
393U:0,2,47,3
3935U:0,4,46,1
3385U:73,0,21,17
345U:46,0,24,20
352U:50,0,27,12
359U:39,0,42,20
366U:24,0,43,14
373U:21,0,51,9
380U:7,0,61,11
387U:4,0,64,7
394U:0,2,64,5
3945U:0,5,62,1
3395U:100,0,25,22
346U:59,0,28,26
353U:63,0,32,16
360U:49,0,46,28
367U:32,0,49,18
374U:27,0,58,11
381U:13,0,73,16
388U:8,0,75,9
395U:0,0,73,7
3955U:0,6,78,2
3405U:100,0,31,30
347U:86,0,37,39
354U:100,0,46,34
361U:55,0,53,33
368U:42,0,61,30
375U:43,0,78,21
382U:24,0,83,24
389U:14,0,98,14
396U:3,0,100,11
3965U:0,6,91,3
3415U:63,0,20,49
348U:61,0,32,48
355U:83,0,38,41
362U:42,0,47,42
369U:39,0,58,37
376U:35,0,68,33
383U:8,0,65,40
390U:11,0,78,34
397U:1,0,71,33
3975U:0,8,75,29
3425U:45,0,16,53
349U:38,0,23,55
356U:55,0,30,51
363U:35,0,41,48
370U:24,0,48,46
377U:20,0,55,44
384U:4,0,57,45
391U:1,0,57,46
398U:0,0,62,42
3985U:0,8,60,39
3435U:26,0,11,60
350U:18,0,15,60
357U:26,0,18,57
364U:25,0,36,53
371U:9,0,32,55
378U:6,0,37,52
385U:0,2,40,51
392U:0,1,48,51
399U:0,4,60,46
3995U:0,6,44,49
400U:0,3,7,22
406U:0,5,7,22
413U:1,0,5,26
420U:1,0,1,25
427U:4,1,0,21
434U:0,6,5,16
441U:5,0,1,24
401U:0,3,7,29
407U:0,5,6,33
414U:1,0,4,33
421U:1,0,0,29
428U:7,3,0,28
435U:0,8,5,28
442U:5,0,0,29
402U:0,3,7,36
408U:0,5,6,38
415U:1,0,4,38
422U:2,1,0,36
429U:9,4,0,38
436U:0,8,6,34
443U:8,1,0,39
403U:0,3,7,43
409U:0,6,7,42
416U:1,0,4,43
423U:4,1,0,41
430U:12,6,0,43
437U:0,10,7,45
444U:8,2,0,46
404U:0,4,7,45
410U:0,6,7,46
417U:2,0,4,48
424U:1,1,0,46
431U:12,5,0,49
438U:0,12,9,49
445U:7,2,0,55
405U:0,4,8,53
411U:0,7,9,52
418U:1,0,5,52
425U:2,1,0,50
432U:10,6,0,55
439U:0,10,9,55
446U:6,0,1,59
Black U:0,4,8,62
412U:0,8,11,61
419U:0,0,4,65
426U:1,1,0,59
433U:7,5,0,62
440U:0,8,10,59
447U:3,0,3,62
warm gray 1U:0,3,6,14
warm gray 2U:0,4,7,19
warm gray 3U:0,4,8,25
warm gray 4U:0,4,8,29
warm gray 5U:0,5,8,34
warm gray 6U:0,4,7,36
warm gray 7U:0,5,7,41
warm gray 8U:0,5,8,44
warm gray 9U:0,5,7,47
warm gray 10U:0,5,8,49
warm gray 11U:0,5,8,51
cool gray 1:0,0,2,15
cool gray 2:0,0,1,21
cool gray 3:4,3,0,20
cool gray 4U:1,1,0,27
cool gray 5U:2,1,0,31
cool gray 6U:2,1,0,34
cool gray 7U:3,1,0,37
cool gray 8U:3,2,0,40
cool gray 9U:4,2,0,44
cool gray 10U:4,3,0,47
cool gray 11U:5,3,0,49
448U:0,6,24,60
449U:0,6,26,55
450U:0,7,30,50
451U:0,3,22,42
452U:0,1,20,34
453U:0,2,19,26
454U:0,1,15,21
4485U:0,10,39,52
4495U:0,8,34,44
4505U:0,7,31,36
4515U:0,7,29,31
4525U:0,6,27,24
4535U:0,6,26,21
4545U:0,6,23,16
455U:0,7,39,53
456U:0,10,52,44
457U:0,12,61,32
458U:0,10,51,19
459U:0,8,46,13
460U:0,6,40,9
461U:0,5,33,7
462U:0,13,31,56
463U:0,17,39,48
464U:0,20,45,39
465U:0,16,37,31
466U:0,14,34,24
467U:0,11,30,18
468U:0,8,24,12
4625U:0,22,39,56
4635U:0,23,36,43
4645U:0,22,33,37
4655U:0,20,31,30
4665U:0,18,30,21
4675U:0,15,26,15
4685U:0,12,22,10
469U:0,22,39,52
470U:0,31,50,36
471U:0,35,56,25
472U:0,33,48,14
473U:0,28,43,7
474U:0,23,36,4
475U:0,19,31,1
4695U:0,23,33,53
4705U:0,20,27,45
4715U:0,18,25,40
4725U:0,17,22,32
4735U:0,15,21,26
4745U:0,13,18,19
4755U:0,10,15,14
476U:0,15,25,57
477U:0,19,31,51
478U:0,23,35,44
479U:0,19,27,33
480U:0,18,26,22
481U:0,13,21,17
482U:0,10,18,13
483U:0,27,37,51
484U:0,43,51,37
485U:0,59,65,11
486U:0,41,47,6
487U:0,33,40,5
488U:0,24,31,4
489U:0,19,25,4
490U:0,29,29,53
491U:0,37,37,44
492U:0,41,39,38
493U:0,38,31,22
494U:0,32,27,10
495U:0,27,22,5
496U:0,22,18,2
497U:0,21,24,56
498U:0,27,29,50
499U:0,31,33,45
500U:0,28,24,26
501U:0,24,20,15
502U:0,20,18,10
503U:0,15,14,5
4975U:0,26,28,55
4985U:0,26,22,44
4995U:0,25,20,38
5005U:0,22,19,30
5015U:0,20,18,21
5025U:0,17,15,14
5035U:0,14,13,10
504U:0,27,23,50
505U:0,33,26,46
506U:0,36,26,40
507U:0,31,21,19
508U:0,30,22,13
509U:0,26,19,8
510U:0,21,16,5
511U:0,27,11,55
512U:0,36,8,46
513U:0,40,4,38
514U:0,33,5,19
515U:0,27,6,11
516U:0,22,5,9
517U:0,17,6,5
5115U:0,23,10,56
5125U:0,21,4,51
5135U:0,19,4,45
5145U:0,16,3,36
5155U:0,15,4,27
5165U:0,12,4,20
523U:2,14,0,16
524U:1,10,0,14
5185U:0,18,10,54
5195U:0,16,7,49
5205U:0,15,4,44
5215U:0,14,4,36
5225U:0,11,5,24
5235U:0,9,5,16
5245U:0,8,4,12
525U:2,26,0,54
526U:12,40,0,43
527U:16,45,0,31
528U:12,35,0,18
529U:8,27,0,12
530U:5,20,0,9
531U:3,15,0,8
5255U:14,20,0,58
5265U:16,18,0,49
5275U:16,17,0,43
5285U:13,14,0,33
5295U:9,10,0,24
5305U:6,8,0,18
5315U:3,4,0,12
532U:9,8,0,61
533U:22,16,0,53
534U:31,21,0,49
535U:24,15,0,28
536U:19,11,0,20
537U:13,7,0,15
538U:9,4,0,12
539U:29,18,0,62
540U:43,26,0,56
541U:53,31,0,51
542U:47,21,0,22
543U:42,19,0,18
544U:32,13,0,13
545U:24,10,0,10
5395U:20,15,0,65
5405U:29,13,0,50
5415U:29,12,0,43
5425U:27,11,0,35
5435U:20,8,0,23
5445U:15,6,0,17
5455U:11,4,0,12
546U:20,9,0,65
547U:36,14,0,60
548U:44,15,0,56
549U:40,12,0,32
550U:36,11,0,25
551U:27,7,0,19
552U:20,5,0,14
5463U:28,9,0,66
5473U:31,7,0,54
5483U:31,5,0,46
5493U:28,4,0,36
5503U:21,3,0,26
5513U:16,1,0,20
5523U:12,0,0,16
5467U:12,0,0,63
5477U:15,0,0,56
5487U:16,1,0,51
5497U:13,0,0,42
5507U:11,0,1,34
5517U:9,0,2,27
5527U:8,0,2,22
553U:13,0,11,59
554U:25,0,14,54
555U:32,0,16,51
556U:28,0,12,38
557U:24,0,11,30
558U:20,0,9,25
559U:13,0,8,18
5535U:19,0,3,65
5545U:19,0,6,54
5555U:17,0,5,44
5565U:15,0,5,36
5575U:13,0,5,29
5585U:12,0,5,27
5595U:8,0,5,18
560U:20,0,3,63
561U:36,0,5,57
562U:48,0,5,50
563U:36,0,5,27
564U:31,0,5,22
565U:31,0,6,18
566U:20,0,5,12
5605U:10,0,10,59
5615U:12,0,7,53
5625U:12,0,6,46
5635U:10,0,6,38
5645U:9,0,6,31
5655U:7,0,5,25
5665U:6,0,5,22
567U:25,0,6,61
574U:8,0,26,55
5743U:5,0,23,59
5747U:3,0,33,55
581U:0,3,39,53
5815U:0,3,34,55
600U:0,3,34,55
607U:0,4,34,5
614U:0,4,28,12
621U:9,0,5,13
568U:46,0,9,50
575U:15,0,34,49
5753U:6,0,22,51
5757U:3,0,31,48
582U:0,0,52,43
5825U:0,4,33,45
601U:0,3,42,3
608U:0,4,40,6
615U:0,4,31,15
622U:12,0,5,20
569U:69,0,9,44
576U:21,0,37,39
5763U:7,0,19,47
5767U:3,0,29,40
583U:7,0,64,30
5835U:0,3,31,42
602U:0,4,47,3
609U:0,5,45,7
616U:0,4,34,20
623U:17,0,6,29
570U:49,0,9,24
577U:17,0,32,30
5773U:4,0,18,37
5777U:2,0,27,34
584U:4,0,53,16
5845U:0,2,30,35
603U:0,6,59,5
610U:0,6,54,12
617U:0,5,37,27
624U:19,0,6,37
571U:38,0,7,15
578U:15,0,28,23
5783U:3,0,15,27
5787U:2,0,25,25
585U:1,0,42,10
5855U:0,3,28,26
604U:0,7,68,7
611U:0,8,61,22
618U:0,5,41,35
625U:22,0,6,46
572U:33,0,7,13
579U:11,0,25,18
5793U:2,0,13,21
5797U:1,0,23,21
586U:1,0,42,9
6865U:0,2,27,20
605U:0,10,75,11
612U:0,9,66,28
619U:0,6,44,41
626U:24,0,5,54
573U:21,0,4,9
580U:9,0,22,14
5803U:2,0,13,17
5807U:1,0,20,17
587U:0,0,36,7
5875U:0,2,25,16
606U:0,11,80,19
613U:0,9,65,36
620U:0,6,46,47
627U:26,0,5,64
628U:22,3,0,10
635U:29,6,0,6
642U:10,4,0,8
635U:29,6,0,6
649U:5,3,0,7
656U:7,3,0,5
663U:0,4,0,11
670U:0,12,6,5
677U:0,13,7,6
684U:0,14,8,7
691U:0,12,12,5
629U:36,6,0,13
636U:42,9,0,7
643U:17,8,0,10
650U:9,5,0,8
657U:12,7,0,5
664U:1,6,0,13
671U:0,18,8,6
678U:0,16,7,10
685U:0,17,10,10
692U:0,18,15,9
630U:46,9,0,16
637U:59,13,0,10
644U:26,13,0,16
651U:20,11,0,14
658U:23,13,0,7
665U:4,11,0,19
672U:0,28,12,9
679U:0,23,10,13
686U:0,22,11,16
693U:0,25,21,14
631U:58,12,0,20
638U:78,17,0,13
645U:33,17,0,23
652U:30,17,0,23
659U:34,21,0,10
666U:7,14,0,26
673U:0,37,17,13
680U:0,28,12,25
687U:0,27,14,25
694U:0,28,23,24
632U:69,16,0,29
639U:100,23,0,20
646U:37,20,0,31
653U:37,22,0,36
660U:50,32,0,20
667U:11,19,0,37
674U:0,44,21,20
681U:0,32,15,35
688U:0,29,14,36
695U:0,32,26,32
633U:75,18,0,38
640U:100,26,0,27
647U:39,22,0,38
654U:39,25,0,45
661U:56,39,0,33
668U:11,21,0,43
675U:0,50,26,24
682U:0,35,17,44
689U:0,31,17,44
696U:0,34,29,40
634U:75,20,0,46
641U:100,28,0,35
648U:40,25,0,49
655U:39,27,0,50
662U:54,42,0,44
669U:11,22,0,50
676U:0,52,28,34
683U:0,37,21,49
690U:0,35,23,51
697U:0,37,34,46
698U:0,14,13,2
705U:0,13,11,0
712U:0,21,38,0
719U:0,18,33,5
726U:0,15,27,9
699U:0,23,19,1
706U:0,21,17,0
713U:0,24,44,0
720U:0,21,38,7
727U:0,18,32,14
700U:0,31,27,3
707U:0,31,25,0
714U:0,31,52,0
721U:0,25,43,12
728U:0,20,36,21
701U:0,39,33,9
708U:0,40,34,0
715U:0,39,60,2
722U:0,28,47,21
729U:0,22,37,27
702U:0,44,38,15
709U:0,50,44,3
716U:0,43,65,8
723U:0,30,49,27
730U:0,24,41,35
703U:0,50,44,29
710U:0,57,51,11
717U:0,46,70,16
724U:0,30,52,35
731U:0,24,42,42
704U:0,51,47,36
711U:0,61,59,19
718U:0,46,69,22
725U:0,30,52,42
732U:0,24,43,47
black 2U:0,4,18,61
black 3U:4,0,4,64
black 4U:0,9,18,59
black 5U:0,14,12,59
black 6U:12,9,0,66
black 7U:0,4,7,58
801U:100,24,0,20
802U:72,0,71,18
803U:0,9,91,0
804U:0,33,68,0
805U:0,55,53,0
806U:0,72,31,0
807U:0,76,18,9
808U:100,0,17,33
809U:2,0,75,9
810U:0,17,76,0
811U:0,47,60,0
812U:0,65,42,0
813U:0,73,25,4
814U:38,53,0,22
4278C:3,3,0,49
4278U:3,3,0,47
7547U:13,10,0,64
7547C:54,27,0,84
7546U:16,8,0,52
7546C:47,21,0,73
7545U:15,8,0,44
7545C:33,14,0,61
7544C:19,8,0,43
7544U:12,6,0,31
7543U:9,4,0,25
7543C:13,6,0,32
7542C:15,3,0,24
7541C:4,0,0,11
7541U:4,1,0,10
7540U:10,6,0,51
7540C:11,6,0,67
7539C:1,0,5,44
7539U:2,1,0,37
7538U:3,0,1,33
7538C:4,0,6,40
7537C:3,0,6,33
7537U:2,0,1,28
7536U:0,4,10,31
7536C:0,4,18,35
7535C:0,4,15,28
7535U:0,3,8,25
7534C:0,2,10,18
7534U:0,2,6,18
7533C:0,23,42,72
7533U:0,9,16,57
7532C:0,18,38,61
7532U:0,8,15,53
7531C:0,15,30,52
7531U:0,9,13,45
7530C:0,10,20,36
7530U:0,8,12,34
7529C:0,8,16,28
7529U:0,6,10,27
7529U:0,6,10,27
7528C:0,6,13,23
7528U:0,5,7,18
7528U:0,5,7,18
7527C:0,2,8,16
7527U:0,2,5,14
7526C:0,59,80,46
7526U:0,35,44,43
7525C:0,31,49,40
7525U:0,21,27,40
7524C:0,50,56,36
7524U:0,33,35,36
7523C:0,46,49,33
7523U:0,31,30,34
7522C:0,41,53,29
7522U:0,31,35,31
7521C:0,19,32,25
7521U:0,18,24,23
7520C:0,19,25,8
7520U:0,19,21,5
7519C:0,19,35,64
7519U:0,9,13,54
7518C:0,28,35,57
7518U:0,12,12,49
7517C:0,50,77,48
7517U:0,29,41,42
7516C:0,29,41,42
7516U:0,28,39,37
7515C:0,29,47,23
7515U:0,26,35,24
7514C:0,24,37,16
7514U:0,22,28,15
7513C:0,19,26,12
7513U:0,19,22,9
7512C:0,40,84,35
7512U:0,29,53,41
7511C:0,35,78,28
7511U:0,29,52,35
7510C:0,31,68,22
7510U:0,27,49,25
7509C:0,23,55,16
7509U:0,23,45,18
7508C:0,18,44,12
7508U:0,20,41,12
7508U:0,20,41,12
7507C:0,17,39,1
7507U:0,13,33,0
7506C:0,8,26,6
7506U:0,10,27,2
7505C:0,26,50,49
7505U:0,14,25,47
7504C:0,18,37,42
7504U:0,12,23,42
7503C:0,9,38,34
7503U:0,7,27,38
7502C:0,11,34,19
7502U:0,12,32,22
7501C:0,8,27,15
7501U:0,9,26,13
7500C:0,6,25,13
7500U:0,7,26,10
7499C:0,5,26,5
7499U:0,5,25,2
7498C:7,0,45,62
7498U:5,0,20,51
7497C:0,7,30,52
7497U:0,4,14,45
7496C:13,0,79,47
7496U:11,0,45,48
7495C:7,0,59,40
7495U:8,0,37,44
7494C:11,0,22,31
7494U:10,0,18,31
7493C:5,0,26,23
7493U:5,0,23,24
7492C:6,0,37,20
7492U:7,0,33,21
7491C:10,0,55,47
7491U:8,0,31,45
7490C:26,0,52,40
7490U:22,0,32,38
7489C:32,0,53,33
7489U:29,0,36,33
7488C:44,0,65,16
7488U:52,0,57,18
7487C:36,0,54,13
7487U:38,0,47,12
7486U:19,0,35,11
7486C:16,0,34,12
7485C:6,0,16,13
7485U:7,0,16,11
7484C:100,0,28,66
7484U:37,0,13,57
7483C:58,0,40,64
7483U:26,0,18,53
7482C:100,0,52,38
7482U:77,0,33,35
7481C:100,0,57,28
7481U:100,0,41,27
7480C:100,0,42,25
7480U:100,0,34,24
7479C:82,0,40,18
7479U:80,0,38,20
7478C:32,0,16,11
7478U:32,0,16,8
7477C:60,16,0,65
7477U:23,7,0,53
7476C:85,6,0,66
7476U:27,3,0,52
7475C:42,1,0,52
7475U:24,1,0,45
7474C:100,9,0,49
7474U:53,7,0,42
7473C:75,0,10,40
7473U:43,0,7,35
7472C:50,0,3,28
7472U:43,0,2,26
7471C:43,0,5,13
7471U:44,0,4,11
7470C:100,19,0,56
7470U:49,15,0,49
7469C:100,29,0,47
7469U:56,20,0,46
7468C:100,24,0,40
7468U:57,19,0,42
7467C:100,6,0,32
7467U:100,5,0,31
7465C:67,0,11,24
7465U:57,0,9,22
7464C:23,0,3,18
7464U:22,0,2,14
7463C:100,41,0,71
7463U:35,19,0,51
7462C:100,39,0,45
7462U:48,25,0,36
7461C:100,33,0,27
7461U:66,26,0,22
7460C:100,30,0,25
7460U:100,26,0,25
7459C:64,16,0,29
7459U:52,16,0,33
7458C:44,11,0,21
7458U:46,14,0,25
7457C:19,3,0,10
7457U:19,4,0,7
7456C:46,38,0,30
7456U:33,29,0,25
7455C:67,47,0,32
7455U:42,32,0,27
7454C:47,21,0,29
7454U:37,18,0,27
7453C:44,25,0,13
7453U:40,24,0,11
7452C:42,33,0,13
7452U:36,30,0,11
7451C:40,25,0,11
7451U:37,24,0,8
7450C:14,10,0,14
7450U:13,9,0,12
7449C:0,40,9,75
7449U:0,18,7,61
7448C:1,26,0,70
7448U:2,10,0,55
7447C:22,40,0,53
7447U:13,21,0,43
7446C:32,34,0,21
7446U:29,29,0,19
7445C:14,17,0,24
7445U:14,16,0,22
7444C:17,16,0,14
7444U:17,16,0,11
7443C:5,6,0,9
7443U:6,8,0,8
7443U:6,8,0,8
7442C:21,68,0,26
7442U:17,48,0,25
7441C:17,52,0,25
7441U:14,38,0,21
7440C:2,28,0,35
7440U:2,19,0,27
7439C:4,26,0,27
7439U:3,21,0,22
7438C:1,27,0,16
7438U:0,28,0,16
7437C:2,16,0,18
7437U:1,15,0,16
7436C:0,8,2,7
7436U:0,12,2,5
7435C:0,72,40,47
7435U:0,39,24,45
7434C:0,67,43,39
7434U:0,39,26,34
7433C:0,65,40,35
7433U:0,65,40,35
7432C:0,49,29,29
7432U:0,35,22,23
7431C:0,36,21,21
7431U:0,26,16,14
7430C:0,23,13,14
7430U:0,21,13,10
7429C:0,17,10,11
7429U:0,14,9,7
7428C:0,58,42,58
7428U:0,28,20,50
7427C:0,82,69,41
7427U:0,50,44,35
7426C:0,89,62,36
7426U:0,52,40,31
7425C:0,80,53,29
7425U:0,52,39,27
7424C:0,69,41,11
7424U:0,60,42,15
7423C:0,56,40,12
7423U:0,48,37,11
7422C:0,16,13,4
7422U:0,16,14,1
7421C:0,72,50,60
7421U:0,38,27,51
7420C:0,78,57,39
7420U:0,47,37,36
7419C:0,58,49,31
7419U:0,58,49,31
7418C:0,59,56,20
7418U:0,48,47,25
7417C:0,65,75,12
7417U:0,54,58,9
7416C:0,54,63,10
7416U:0,50,55,8
7415C:0,19,27,10
7415U:0,23,30,8
7414C:0,44,88,24
7414U:0,34,57,25
7413C:0,39,77,14
7413U:0,38,60,13
7412C:0,38,75,17
7412U:0,33,54,18
7411C:0,28,60,10
7411U:0,31,52,9
7410C:0,32,53,0
7410U:0,37,57,0
7409C:0,25,85,6
7409U:0,30,68,3
7408C:0,23,100,4
7408U:0,34,84,7
7407C:0,21,60,20
7407U:0,20,46,20
7406C:0,19,100,5
7406U:0,24,83,5
7405C:0,15,100,5
7405U:0,23,94,10
7404C:0,11,74,4
7404U:0,18,74,1
7403C:0,11,45,7
7403U:0,15,47,4
7402C:0,6,34,7
7402U:0,10,37,5
7401C:0,8,33,4
7401U:0,10,35,0
5865U:0,2,27,20
3252U:100,0,5,20
