(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by stolfi on Thu Sep 15 02:51:58 1988               *)
(* Last modified on Tue Feb 11 21:39:44 PST 1992 by muller     *)
(*      modified on Thu Oct 25  6:25:43 PDT 1990 by stolfi     *)

MODULE IntensityScale;

IMPORT Intensity;

PROCEDURE New (n: CARDINAL; a, b: Intensity.T; ratio: REAL := 1.0e+00): REF T =
  VAR s := NEW (REF T, n);
  BEGIN
    IF n <= 0 THEN RETURN s END;
    (* Compute scale in [0 _ 1]: *)
    s[0] := 0.0;
    IF n > 2 THEN
      s[1] := 1.0;
      FOR i := 2 TO n - 1 DO
        s[i] := s[i - 1] + ratio * (s[i - 1] - s[i - 2])
      END;
      FOR i := 1 TO n - 2 DO s[i] := s[i] / s[n - 1] END;
    END;
    s[n - 1] := 1.0;
    (* Convert to [a _ b] *)
    s[0] := a;
    FOR i := 1 TO n - 2 DO s[i] := a + (b - a) * s[i] END;
    s[n - 1] := b;
    RETURN s
  END New;

PROCEDURE Equal (
    READONLY a, b: T; 
    err: REAL := 1.0e-6;
    small: REAL := 1.0e-30
  ): BOOLEAN =
  BEGIN
    IF (NUMBER (a) # NUMBER (b)) THEN RETURN FALSE END;
    FOR i := 0 TO LAST (a) DO
      IF NOT Intensity.Equal(a[i], b[i], err, small) THEN RETURN FALSE END
    END;
    RETURN TRUE
  END Equal;

BEGIN
END IntensityScale.

