(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ProcType.i3                                           *)
(* Last Modified On Thu Feb 13 09:52:20 PST 1992 By kalsow     *)
(*      Modified On Wed Aug 29 02:55:06 1990 By muller         *)

INTERFACE ProcType;

IMPORT M3, Type, Scope, Value, Token, CallExpr, String;

PROCEDURE Parse          (READONLY fail: Token.Set): Type.T;
PROCEDURE ParseSignature (READONLY fail: Token.Set; name: String.T): Type.T;

PROCEDURE MethodSigAsProcSig (sig, objType: Type.T): Type.T;

PROCEDURE Is        (t: Type.T): BOOLEAN;
PROCEDURE Formals   (t: Type.T): Scope.T;
PROCEDURE Result    (t: Type.T): Type.T;
PROCEDURE CResult   (t: Type.T): Type.T;
PROCEDURE Raises    (t: Type.T): M3.ExSet;
PROCEDURE Methods   (t: Type.T): CallExpr.MethodList;

PROCEDURE LargeResult (t: Type.T): BOOLEAN;
PROCEDURE IsCompatible (procSig, objectType, methodSig: Type.T): BOOLEAN;

PROCEDURE New (READONLY formals: ARRAY OF Value.T;  result: Type.T): Type.T;
PROCEDURE SetMethods (t: Type.T;  m: CallExpr.MethodList);
PROCEDURE CopyValueOpenArrayParameters (t: Type.T);

END ProcType.
