ns_register_proc GET  /NS/GetSearchForm getsearchform
ns_register_proc GET  /NS/GetEntryForm getentryform
ns_register_proc GET  /NS/GetUpdateForm getupdateform
ns_register_proc POST /NS/DeleteRow deleterow
ns_register_proc GET  /NS/SearchQBF searchqbf
ns_register_proc POST /NS/SearchQBF searchqbf
ns_register_proc POST /NS/InsertRow insertrow
ns_register_proc POST /NS/UpdateRow updaterow

proc getsearchform {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set description [ns_table description $table]

    if {$description == ""} {
	set description $table
    }

    if [catch {
	set form [ns_table searchform $table]
    } errMsg] {
	ns_returnerror $conn 500 "Could not build search form"
	return
    }

    ns_return $conn 200 text/html \
"<HTML><HEAD><TITLE>Search Form for Table: $table </TITLE></HEAD>
<BODY>
<IMG SRC=/NS/Asset/search.gif>
<H3>$description</H3>
<A HREF=/NS/Asset/searchhp.htm>Help</A> on searching.
$form
</BODY></HTML>
"
}


proc getentryform {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set description [ns_table description $table]

    if {$description == ""} {
	set description $table
    }

    if [catch {
	set formdata [ns_conn form $conn]
	set hidden ""
	if {$formdata != ""} {
	    foreach subform [ns_set split $formdata] {
		if {[ns_set name $subform] == "Hide"} {
		    set hidden $subform
		}
	    }
	}
	if {$hidden == ""} {
	    set form [ns_table entryform $table]
	} else {
	    set form [ns_table entryform $table $hidden] 
	}
    } errMsg] {
	ns_returnerror $conn 500 "Could not build entry form"
	return
    }

    ns_return $conn 200 text/html \
"<HTML><HEAD><TITLE>Entry Form for Table: $table </TITLE></HEAD>
<BODY>
<IMG SRC=/NS/Asset/entry.gif>
<H3>$description</H3>
When done filling in the fields below, press the \"Enter\" button
to insert your data into the database.
$form
</BODY></HTML>
"
}


proc getupdateform {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set description [ns_table description $table]

    if {$description == ""} {
	set description $table
    }

    set formdata [ns_conn form $conn]
    if {$formdata == ""} {
	ns_returnerror $conn 500 "No rowid specified"
	return
    }
    set rowid [ns_set get $formdata "RowID"]
    if {$rowid == ""} {
	ns_returnerror $conn 500 "No rowid specified"
	return
    }

    if [catch {
	set form [ns_table updateform $table $rowid]
    } errMsg] {
	ns_returnerror $conn 500 "Could not build update form"
	return
    }

    set db [ns_conn db $conn]
    if [catch {
	set row [ns_db 1row $db "select * from $table where oid = '$rowid';"]
    } errMsg] {
	ns_returnerror $conn 500 "Could not find row"
	return
    }

    ns_denormalize $table $row

    set formrow [ns_set new Foo]
    set size [ns_set size $row]
    for {set i 0} {$i < $size} {incr i} {
	ns_set put $formrow "ColValue.[ns_set key $row $i]" [ns_set value $row $i]
    }

    set output \
"<HTML><HEAD><TITLE>Update Form for Table: $table </TITLE></HEAD>
<BODY>
<IMG SRC=/NS/Asset/update.gif>
<H3>$description</H3>
To update this data in the database, press the \"Update\"
button after modifying any of the values in the fields below.
If you would like to forget your edits and start over with
the existing values in the database, press the \"Reset\" button.
If you would like to just delete this data from the database,
press the \"Delete\" button.
$form
</BODY></HTML>
"
    ns_return $conn 200 text/html [ns_mergepage $output $formrow]
}


proc deleterow {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set form [ns_conn form $conn]

    if {$form == ""} {
	ns_returnerror $conn 500 "Request is missing form data."
	return
    }

    set rowid [ns_set get $form QueryInfo.RowID]
    
    if {$rowid == ""} {
	ns_returnerror $conn 500 "Request is missing row id."
	return
    }

    if [catch {
	ns_db dml [ns_conn db $conn] "delete from $table where oid = '$rowid';"
    } errMsg] {
	ns_dbreturnerror $conn 500 "Could not delete row $rowid from database"
	return
    }

    ns_return $conn 200 text/html \
"<HTML><HEAD><TITLE>Delete Successful</TITLE></HEAD>
<BODY>
<IMG SRC=/NS/Asset/naviserv.gif>
<H1>Delete Successful</H1>
Successfully deleted record from table $table.
</BODY></HTML>
"
}

proc searchqbf {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set formdata [ns_conn form $conn]

    set headers [ns_conn headers $conn]
    if {$headers != ""} {
	set html3tablep [ns_supportshtml3tables [ns_set get $headers "USER-AGENT"]]
    } else {
	set html3tablep "0"
    }

    if [catch {
	set results [ns_db searchqbf [ns_conn db $conn] $table $formdata $html3tablep]
    } errMsg] {
	ns_dbreturnerror $conn 500 "Could not perform search."
	return
    }

    if {[ns_table value $table "table_kind"] == "t" && [ns_column value $table ns_url column_type] == ""} {
	set addnewrow "\n<A HREF=/NS/GetEntryForm/$table>Add</A> a new row\n"
    } else {
	set addnewrow ""
    }

    ns_return $conn 200 text/html \
"<HTML><HEAD><TITLE>Search Results</TITLE></HEAD>
<BODY><IMG SRC=/NS/Asset/results.gif><BR>
$results
$addnewrow
</BODY></HTML>"
}


proc insertrow {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set formdata [ns_conn form $conn]

    if [catch {
	ns_db insertrow [ns_conn db $conn] $table $formdata
    } errMsg] {
	ns_dbreturnerror $conn 500 "Could not insert row."
	return
    }

    set nsurl [ns_table value $table "table_inserturl"]

    if {$nsurl != ""} {
	ns_returnfile $conn 200 text/html [ns_info pageroot]/$nsurl
    } else {
	ns_return $conn 200 text/html \
"<HTML><HEAD><TITLE>Insert Successful</TITLE></HEAD>
<BODY><IMG SRC=/NS/Asset/naviserv.gif>
<H1>Insert Successful</H1>
Successfully inserted new record into table $table.<P>
</BODY></HTML>"
    }
}


proc updaterow {conn ignore} {

    if {[ns_conn urlc $conn] != 3} {
	return [ns_returnerror $conn 500 "Incorrect arguments"]
    }

    set table [lindex [ns_conn urlv $conn] 2]

    if ![ns_table exists $table] {
	return [ns_returnerror $conn 500 "$table does not exist."]
    }

    set formdata [ns_conn form $conn]

    set db [ns_conn db $conn]

    if [catch {
	ns_db updaterow $db $table $formdata
    } errMsg] {
	ns_dbreturnerror $conn 500 "Could not update row."
	return
    }

    set updatelink "<A HREF=/NS/GetUpdateForm/$table?RowID=[ns_set get $formdata QueryInfo.RowID]>Verify/Update</A>"

    ns_return $conn 200 text/html \
"<HTML><HEAD><TITLE>Update Successful</TITLE></HEAD>
<BODY><IMG SRC=/NS/Asset/naviserv.gif>
<H1>Update Successful</H1>
Successfully updated record in table $table.<P>
$updatelink
</BODY></HTML>"
}
