@echo off
setlocal
set defdb=betadb
if not exist %1\bin\iqt32.exe goto missing
if not exist %2\bin\nsd.exe goto missing
if not exist %2\nsd.ini goto missing
if not exist %2\log goto missing
if not exist %2\lib\sql\nsbuild.sql goto missing
if not exist %2\lib\sql\nssample.sql goto missing
if not exist %1\extend\document\install\doc.sql got missing
if not exist %1\extend\document\install\conversions.sql got missing
if not exist %1\extend\document\install\doccnvtusersupport.sql got missing

set db=%defdb%
if not "%3" == "" set db=%3%


echo.
echo                       NaviServer Installation
echo.
echo This batch file configures NaviServer to run on your system.  The
echo Illustra database system must already be installed using the procedure
echo outlined in the detailed installation instructions.  This batch file
echo will start Illustra and create the "%db%" database for use by the
echo NaviServer.   The installation will take 10 minutes or more to complete.
echo No intervention will be required.  Press Ctrl-C to cancel installation.
echo.
pause


echo.
echo Starting the Illustra database (ignore any "already started" messages)...
net start "illustra default"


path=%1\bin;%2\bin;%path%
if exist %2\log\nsinitdb.old del %2\log\nsinitdb.old
if exist %2\log\nsinitdb.log rename %2\log\nsinitdb.log nsinitdb.old


set MI_USER=miadmin
set MI_DATABASE=template1
set MI_SERVER=default


echo.
echo Checking for the nsadmin Illustra user...
iqt32 -o %2\log\nsinitdb.tmp -t -n -c 'select user_name from users;'
type %2\log\nsinitdb.tmp >> %2\log\nsinitdb.log
findstr/c:"rows selected" %2\log\nsinitdb.tmp > nul:
if errorlevel 1 goto queryfailed
findstr/c:"nsadmin" %2\log\nsinitdb.tmp > nul:
if not errorlevel 1 goto nsadminok


echo.
echo Adding the nsadmin Illustra user...
iqt32 -o %2\log\nsinitdb.tmp -t -n -c "insert into users values (0,'f','f','f','f',0,'nsadmin',NULL);"
type %2\log\nsinitdb.tmp >> %2\log\nsinitdb.log
findstr/c:"one row inserted" %2\log\nsinitdb.tmp > nul:
if errorlevel 1 goto queryfailed


:nsadminok
echo.
echo Creating the %db% Illustra database...
iqt32 -o %2\log\nsinitdb.tmp -t -n -c 'create database %db%;'
type %2\log\nsinitdb.tmp >> %2\log\nsinitdb.log
findstr/c:"Done" %2\log\nsinitdb.tmp > nul:
if errorlevel 1 goto queryfailed


echo.
echo Initializing the %db% database (this may take 5 minutes or more)...

set MI_DATABASE=%db%
cd %1\extend\document\install
iqt32 -t -n -i doc.sql -o %2\log\nsinitdb.tmp
iqt32 -t -n -i doccnvtusersupport.sql -a -o %2\log\nsinitdb.tmp
iqt32 -t -n -i conversions.sql -a -o %2\log\nsinitdb.tmp
cd %2\lib\sql
iqt32 -t -n -i nsbuild.sql -a -o %2\log\nsinitdb.tmp
iqt32 -t -n -i nssample.sql -a -o %2\log\nsinitdb.tmp
type %2\log\nsinitdb.tmp >> %2\log\nsinitdb.log
rem findstr/c:"Batch Warning" %2\log\nsinitdb.tmp > nul:
rem if not errorlevel 1 goto queryfailed


echo.
echo The Illustra %db% database has been initialized for use by the NaviServer.
echo You should now test the installation by running NaviServer in a Command 
echo Prompt (MS-DOS) window using:
echo.
echo        %2\bin\nsd
echo.
echo The NaviServer should start, initialize the database services, and indicate
echo it is ready to accept connections.  Press Ctrl-C to stop the NaviServer.
echo Once the NaviServer is installed properly, you can install it as an NT
echo service using the command:
echo.
echo        %2\bin\nsd -i
echo.
echo This will add the NaviServer entry to the Service Control Panel which you
echo can use to start and stop the NaviServer service.  For more information,
echo consult the on-line server documation located at:
echo.
echo        http://www.navisoft.com/servdoc/
echo.
echo NaviServer installation is complete.
echo.
goto end


:missing
echo.
echo One or more files required for the NaviServer installation are missing.
echo Please check the arguments to %0 or call NaviSoft support for help.


:usage
echo.
echo Usage:
echo         nsinitdb IllustraDir NaviServerDir [database (default: %defdb%)]
echo.
echo e.g.
echo         nsinitdb d:\illustra d:\naviserver mydb
echo.
goto end


:noill
echo.
echo The Illustra database does not appear to be running.
echo.
goto end

:queryfailed
echo.
echo An Illustra database script failed.  Please review the installation log
echo for detailed error messages:
echo.
echo	%2\log\nsinitdb.log
echo.
echo Call NaviSoft support if you cannot resolve the problem.
echo.


:end
if exist %2\log\nsinitdb.tmp del %2\log\nsinitdb.tmp
endlocal
