CREATE TABLE func_update_project(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    name VARCHAR(40),
    parent_id INTEGER,
    parent_uuid INTEGER,
    project_status_id INTEGER,
    project_status_uuid VARCHAR(40),
    hub_id INTEGER,
    title VARCHAR
);

CREATE TRIGGER
    func_update_project_bi_1
BEFORE INSERT ON
    func_update_project
FOR EACH ROW BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.name,
        NEW.parent_id,
        NEW.parent_uuid,
        NEW.project_status_id,
        NEW.project_status_uuid,
        NEW.hub_id,
        NEW.title
    );


    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: update_project' || x'0A'
                || '  hub_uuid: ' || COALESCE(h.uuid,'~') || x'0A'
                || '  name: ' || COALESCE(NEW.name,'~') || x'0A'
                || '  parent_uuid: ' || COALESCE(pp.uuid,'~') || x'0A'
                || '  project_status_uuid: ' || COALESCE(ps.uuid,'~') || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
                || '  uuid: ' || p.uuid || x'0A'
            FROM
                topics p
            LEFT JOIN
                topics pp
            ON
                pp.id = NEW.parent_id
            LEFT JOIN
                topics ps
            ON
                ps.id = NEW.project_status_id
            LEFT JOIN
                topics h
            ON
                h.id = NEW.hub_id
            WHERE
                p.id = NEW.id
        )
    WHERE
        id = NEW.change_id
    ;


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'update_project'
    );


    INSERT INTO
        topic_deltas(
            id,
            change_id,
            topic_id,
            parent_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.parent_id,
        NEW.name
    );

    INSERT INTO
        project_deltas(
            id,
            change_id,
            project_id,
            title,
            project_status_id,
            hub_id
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.title,
        NEW.project_status_id,
        NEW.hub_id
    );

    SELECT RAISE(IGNORE);
END;
