CREATE TABLE func_new_work(
    topic_id INTEGER NOT NULL,
    change_id INTEGER NOT NULL,
    offset INTEGER NOT NULL,
    start INTEGER NOT NULL,
    stop INTEGER NOT NULL,
    start_comment TEXT,
    stop_comment TEXT
);


CREATE TRIGGER
    func_new_work_bi_1
BEFORE INSERT ON
    func_new_work
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.topic_id,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.start_comment,
        NEW.stop_comment
    );

    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_work' || x'0A'
                || '  offset: ' || NEW.offset || x'0A'
                || '  start: ' || NEW.start || x'0A'
                ||
                    CASE WHEN
                        NEW.start_comment IS NULL
                    THEN
                        '  start_comment: ~' || x'0A'
                    WHEN
                        NEW.start_comment = '-'
                    THEN
                        '  start_comment: ''-''' || x'0A'
                    WHEN
                        instr(NEW.start_comment, x'0A') OR
                        instr(NEW.start_comment, '\\')
                    THEN
                        '  start_comment: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.start_comment, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.start_comment, ' ') OR
                        NEW.start_comment = '' -- not at all sufficient
                    THEN
                        '  start_comment: ''' || NEW.start_comment || '''' || x'0A'
                    ELSE
                        '  start_comment: ' || NEW.start_comment || x'0A'
                    END
                || '  stop: ' || NEW.stop || x'0A'
                ||
                    CASE WHEN
                        NEW.stop_comment IS NULL
                    THEN
                        '  stop_comment: ~' || x'0A'
                    WHEN
                        NEW.stop_comment = '-'
                    THEN
                        '  stop_comment: ''-''' || x'0A'
                    WHEN
                        instr(NEW.stop_comment, x'0A') OR
                        instr(NEW.stop_comment, '\\')
                    THEN
                        '  stop_comment: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.stop_comment, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.stop_comment, ' ') OR
                        NEW.stop_comment = '' -- not at all sufficient
                    THEN
                        '  stop_comment: ''' || NEW.stop_comment || '''' || x'0A'
                    ELSE
                        '  stop_comment: ' || NEW.stop_comment || x'0A'
                    END
                || '  topic_uuid: ' || t.uuid || x'0A'
            FROM
                topics t
            WHERE
                t.id = NEW.topic_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_work'
    );

    INSERT INTO
        work_deltas(
            id,
            change_id,
            topic_id,
            offset,
            start,
            stop,
            start_comment,
            stop_comment
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.topic_id,
        NEW.offset,
        NEW.start,
        NEW.stop,
        NEW.start_comment,
        NEW.stop_comment
    );

    SELECT RAISE(IGNORE);
END;
