
/*  gnutrition - a nutrition and diet analysis program.
 *  Copyright (C) 2000 Edgar Denny (e.denny@ic.ac.uk)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

typedef struct Score_s {
	Food_t *food;
	gdouble food_score;
} Score_t;

void
gnutr_show_srch_dlg( void);

void
gnutr_hide_srch_dlg( void);

void
on_gnutr_srch_search_button_released( GtkButton *, gpointer);

void
on_gnutr_srch_cancel_button_released( GtkButton *, gpointer);

void
on_gnutr_srch_nut_max_add_button_released( GtkButton *, gpointer);

void
on_gnutr_srch_nut_max_remove_button_released( GtkButton *, gpointer);

void
on_gnutr_srch_nut_min_add_button_released( GtkButton *, gpointer);

void
on_gnutr_srch_nut_min_remove_button_released( GtkButton *, gpointer);

void
on_gnutr_srch_nut_max_clist_select_row( GtkCList *, gint, gint);

void
on_gnutr_srch_nut_min_clist_select_row( GtkCList *, gint, gint);

void
on_gnutr_srch_nut_max_clist_unselect_row( GtkCList *, gint, gint);

void
on_gnutr_srch_nut_min_clist_unselect_row( GtkCList *, gint, gint);

gint compare_food_score( Score_t *, Score_t *);
