/* AMD pp. 265 - 273
 * Random model, unbalanced
 */

#include <dap.h>

void main()
{
  infile("amd265.dat", " ")
    {
       char plant[2], site[2], worker[2];
       double efficiency;
       input("plant worker site efficiency");
       outset("amd265", "");
       skip(1);
       while (step())
         output();
    }

  sort("amd265", "plant site worker", "");
  means("amd265.srt", "efficiency", "MEAN N VAR", "plant site worker");

  effects("amd265.srt.mns", "efficiency plant site worker",
        "plant plant*worker plant*site plant*site*worker", "");

  ftest("amd265.srt.mns.con", "efficiency plant site worker",
        "plant", "plant*worker plant*site plant*site*worker", "");
  lsmeans("amd265.srt.mns.tst", "TUKEY", 0.05, "efficiency plant site worker",
        "plant", "", "7.3");

  ftest("amd265.srt.mns.con", "efficiency plant site worker",
                "site*worker*plant", "", "");
  ftest("amd265.srt.mns.con", "efficiency plant site worker",
                "site*plant", "site*worker*plant", "");
  ftest("amd265.srt.mns.con", "efficiency plant site worker",
                "worker*plant", "site*worker*plant", "");
}
