#!/bin/sh
# Create directories for each category in a GNATS categories file. 
# Copyright (C) 1993 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com) and
# Tim Wicinski (wicinski@barn.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_ROOT=@GNATS_ROOT@
GNATS_SITE=@GNATS_SITE@
LIBDIR=@LIBDIR@

CATEGORIES=`grep -v '^#' $GNATS_ROOT/gnats-adm/categories | sed -e 's/:.*//g'`

if [ ! -d $GNATS_ROOT/gnats-dist ]; then
  echo "$0: No directory $GNATS_ROOT/gnats-dist!"
  exit 1
fi

if [ ! -d $LIBDIR/gnats ]; then
  echo "$0: $LIBDIR/gnats/$GNATS_SITE doesn't exist"
  exit 1
fi

for i in $CATEGORIES; do
    
    if test -d $GNATS_ROOT/$i; then
	true
    else
	mkdir $GNATS_ROOT/$i
        echo creating category $GNATS_ROOT/$i
	echo $i >> $GNATS_ROOT/gnats-dist/categories
	echo $i >> $LIBDIR/gnats/$GNATS_SITE
    fi
done

exit 0
