.\" Copyright (c) 1993 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution .in +0.9i
.TH query-pr 1 "April 1993" "GNATS @VERSION@" "GNATS User Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
query-pr \- query problem reports in the 
.B GNATS
database
.SH SYNOPSIS
.hy 0
.na
.B query-pr
.RS
[
.I gnats-id
]
[
.B -i | --sql
] [
.B -F | --full
]
.br
[
.B -d \fIdirectory\fB | --directory=\fIdirectory\fB
]
.br
[
.B -c \fIcategory\fB | --category=\fIcategory\fB
]
.br
[
.B -S \fIsubmitter\fB | --submitter=\fIsubmitter\fB
]
.br
[
.B -r \fIresponsible\fB | --responsible=\fIresponsible\fB
]
.br
[
.B -s \fIstate\fB | --state=\fIstate\fB
]
.br
[
.B -C [\fIyes\fB|\fIno\fB] | --confidential=[\fIyes\fB|\fIno\fB]
]
.br
[
.B -e \fIseverity\fB | --severity=\fIseverity\fB
]
.br
[
.B -p \fIpriority\fB | --priority=\fIpriority\fB
]
.br
[
.B -O \fIname\fB | --originator=\fIname\fB
]
.br
[
.B -o \fIoutfile\fB | --output=\fIoutfile\fB
]
.br
[
.B -q | --summary
]
.br
[
.B -V | --version
]
[
.B -h | --help 
]

.ad b
.hy 1
.SH DESCRIPTION
Queries the 
.B GNATS
database according to options and displays bugreports on standard output.
Using the argument displays the bug report
.IR gnats-id .
.B send-pr
with no options or arguments yields summary information for every report
in the database.
.LP
All options are connected with a logical
.BR AND .
For example,
.RS
.B query\-pr \-\-category=\fIcategory\fB \-\-responsible=\fIresponsible\fR
.RE
only prints PRs which have a 
.B >Category:
field of
.I category
and a 
.B >Responsible:
field of
.IR responsible .
.SH OPTIONS
.TP 0.5i
.B -i, --sql
Prints data in a format readable by a relational database (see
.B gnats.texi
for a full explanation).
.TP
.B -F, --full
Prints the full Problem Report rather than just a summary.
.TP
.B -d \fIdirectory\fB, --directory=\fIdirectory\fB
Changes the search directory to 
.IR directory .
.TP
.B -c \fIcategory\fB, --category=\fIcategory\fB
Search only for PRs with a
.B >Category:
field of 
.IR category .
.TP
.B -S \fIsubmitter\fB, --submitter=\fIsubmitter\fB
Search only for PRs with a
.B >Submitter-Id:
field of 
.IR submitter .
.TP
.B -r \fIresponsible\fB, --responsible=\fIresponsible\fB
Search only for PRs with a
.B >Responsible:
field of 
.IR responsible .
.TP
.B -s \fIstate\fB, --state=\fIstate\fB
Search only for PRs with a
.B >State:
field of 
.IR state .
.TP
.B -C [\fIyes\fB|\fIno\fB], --confidential=[\fIyes\fB|\fIno\fB]
Search only for PRs with a 
.B >Confidential:
field of either
.I yes
or 
.IR no ,
respectively.  If this option is not given, all PRs will be eligible
for the search, regardless of their confidentiality.
.TP
.B -e \fIseverity\fB, --severity=\fIseverity\fB
Search only for PRs with a
.B >Severity:
field of
.IR severity .
.TP
.B -O \fIname\fB, --originator=\fIname\fB
Search for \fIname\fB in the
.B >Originator:
field of each PR.  Name need only be enough to uniquely identify the
person.  For example, to find "Steve Williams", you could use a
\fIname\fB of "Steve W" to match against it.
It's suggested that you use another search option (e.g., against
state), to accelerate the speed of the search.  Using
.B -O
by itself can tend to be slow with a large database.  Note you must enclose
the name with double-quotes to make sure your shell passes it as a
single string, and not as separate arguments to
.BR query-pr .
.TP
.B -p \fIpriority\fB, --priority=\fIpriority\fB
Search only for PRs with a
.B >Priority:
field of
.IR priority .
.TP
.B -o \fIoutfile\fB, --output=\fIoutfile\fB
Print all output to
.I outfile
rather than to the standard output.
.TP
.B -q, --summary
Give a short summary line for PRs. 
.TP
.B -V, --version
Prints the version number of
.BR send-pr .
.B -h, --help 
Prints a brief usage summary.
.SH "SEE ALSO"
.B gnats.texi
and
.BR send-pr.texi ,
which are also installed as GNU
.B Info
files
.B gnats.info
and 
.BR send-pr.info ;
.LP
.BR gnats (l),
.BR send-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR queue-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdist (8).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
