/* Mail header fields.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Tim Wicinski (wicinski@barn.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#ifndef _headers_h_
#define _headers_h_ 1

/* This file is based on RFC-822 headers and its successors.  This file
   should not need to be modified.  */

typedef enum {
    SM_FROM,		/* Stupid UNIX sendmail `From' field ! */
    RETURN_PATH, 
    RECEIVED,		/* received, GNATS keeps only the first rcvd header */
    MSG_ID,		/* Message-Id */
    DATE,
    FROM,		/* the "From:" field, as opposed to unix 'From' */
    SENDER,
    REPLY_TO,
    TO,
    APPAR_TO,		/* Apparently-To */
    CC,
    IN_REP_TO,		/* In-Reply-To */
    SUBJECT,
    REFERENCES,
    COMMENTS,
    KEYWORDS,
    X_SEND_PR,
    NUM_HEADER_ITEMS	/* Last entry, don't put anything in after this.  */
} Header_Name;

#endif /* _headers_h_ */
