/* window.c -- a *very* simple window management. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#include <stdio.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else /* !HAVE_STDLIB_H */
#include "ansi_stdlib.h"
#endif /* !HAVE_STDLIB_H */

#include "window.h"
#include "xmalloc.h"
#include "tty.h"


window *window_init(_startx, _starty, _rows, _columns)
    int _startx, _starty, _rows, _columns;
{
    window *this  = (window *)xmalloc(sizeof(window));
    this->startx  = _startx;
    this->starty  = _starty;
    this->rows    = _rows;
    this->columns = _columns;
    this->cursorx = this->cursory = 0; 
    return this;   
}


void window_end(win)
    window *win;
{
    if (win)
	free(win);
}


int window_write(str, length)
    char *str;
    int length;
{
    return tty_write(str, length);
}


int window_putch(c)
    char c;
{
    return tty_put_char(c);
}


void window_cursormove_notify(this, y, x)
    window *this;
    int y, x;
{
    tty_cursormove_notify(y + this->starty, x + this->startx);
}


void window_cursormove(this, y, x)
    window *this;
    int y, x;
{
    tty_cursormove(y + this->starty, x + this->startx);
}
