/* inputline.h -- prototypes for the functions in inputline.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_INPUTLINE_H
#define _GIT_INPUTLINE_H


#include "stdc.h"
#include "window.h"


#define IL_RECORD	0
#define IL_PREVIOUS	1
#define IL_NEXT		2


#define IL_DONT_STORE	0
#define IL_DONT_KILL	0
#define IL_STORE	1
#define IL_KILL		2


typedef struct
{
    window *win;
    int columns;		/* number of columns.  */
    int point;			/* point position.  */
    int mark;			/* mark position.  */
    int length;			/* total length of the input line.  */
    int static_length;		/* static text length.  */
    int dynamic_length;		/* dynamic text length.  */
    int size;			/* current buffer size.  */
    int last_operation;		/* last basic edit operation performed.  */
    char *buffer;		/* buffer.  */
    char *kill_ring;		/* the kill ring :-).  */
    char *history_file;
} input_line;


extern input_line *il;


extern void il_init __P((int, int));
extern void il_end __P(());

extern input_line *il_save __P(());
extern void il_restore __P((input_line *));

extern void il_set_mark __P(());
extern void il_kill_region __P(());
extern void il_kill_ring_save __P(());
extern void il_yank __P(());
extern void il_exchange_point_and_mark __P(());
extern void il_backward_char __P(());
extern void il_forward_char __P(());
extern void il_backward_word __P(());
extern void il_forward_word __P(());
extern void il_beginning_of_line __P(());
extern void il_end_of_line __P(());
extern void il_insert_char __P((char));
extern void il_delete_char __P(());
extern void il_backward_delete_char __P(());
extern void il_backward_kill_word __P(());
extern void il_reset_line __P(());
extern void il_kill_line __P((int));
extern void il_kill_to_beginning_of_line __P(());
extern void il_kill_to_end_of_line __P(());
extern void il_just_one_space __P(());
extern void il_delete_horizontal_space __P(());
extern void il_set_static_text __P((char *));
extern void il_insert_text __P((char *));
extern void il_update_point __P(());
extern void il_update __P(());
extern int il_get_contents __P((char **));
extern void il_history __P((int));


#endif	/* _GIT_INPUTLINE_H */
