/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#ifndef GAMEOVER_H
#define GAMEOVER_H

#include <vector>
#include <iostream>
#include <sstream>
using namespace std;

#include "SDL.h"
#include "SDL_image.h"

#include "gamestate.h"
#include "globals.h"

class GameOver:public GameState
{

private:
  static GameOver m_instance;
  SDL_Surface *imgBall;
  long time;
  long currentTime;
  int m_ball_count;
  int m_balls_left;
  string levelsetFilename;
public:
  static GameOver *instance ()
  {
    return &m_instance;
  }
  void init ();
  void cleanup ();
  void pause ();
  void resume ();
  void handleEvents (GameStateManager * gameStateManager);
  void draw (GameStateManager * gameStateManager);
  void update (GameStateManager * gameStateManager);
  void start ();
  bool done ()
  {
    return currentTime >= time;
  }
  void setBallCount (int ball_count);
  void setLevelsetFilename (string levelsetFilename);
  bool getTransitioning ()
  {
    return false;
  }
protected:
  GameOver ()
  {
  };
};

#endif
