/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "font.h"

Font::Font (string filename, int charWidth, int charHeight)
{
  SDL_Surface *temp = IMG_Load (filename.c_str ());
  if (temp != NULL)
    image = SDL_DisplayFormat (temp);
  SDL_FreeSurface (temp);
  SDL_SetColorKey (image, SDL_SRCCOLORKEY | SDL_RLEACCEL, 0x00FF00FF);
  this->charWidth = charWidth;
  this->charHeight = charHeight;
}

Font::Font (SDL_Surface * image, int charWidth, int charHeight)
{
  this->image = image;
  this->charWidth = charWidth;
  this->charHeight = charHeight;
}

Font::Font ()
{
}

Font::~Font ()
{
  SDL_FreeSurface (image);
}

void
Font::drawString (string text, SDL_Surface * dest, int x, int y)
{
  SDL_Rect s;
  s.w = charWidth;
  s.h = charHeight;
  for (int i = 0; i < text.length (); i++)
    {
      s.x = (text[i] - ' ') % 16 * charWidth;
      s.y = (text[i] - ' ') / 16 * charHeight;
      SDL_Rect d = { x + charWidth * i, y, 0, 0 };
      SDL_BlitSurface (image, &s, dest, &d);
    }
}

void
Font::drawStringCentered (string text, SDL_Surface * dest, int x, int y)
{
  int x1 = x - (text.length () * charWidth) / 2;
  SDL_Rect s;
  s.w = charWidth;
  s.h = charHeight;
  for (int i = 0; i < text.length (); i++)
    {
      s.x = (text[i] - ' ') % 16 * charWidth;
      s.y = (text[i] - ' ') / 16 * charHeight;
      SDL_Rect d = { x1 + charWidth * i, y, 0, 0 };
      SDL_BlitSurface (image, &s, dest, &d);
    }
}
