////////////////////////////////////////////////////////////////////////
//
// Copyright (C) 1993-2025 The Octave Project Developers
//
// See the file COPYRIGHT.md in the top-level directory of this
// distribution or <https://octave.org/copyright/>.
//
// This file is part of Octave.
//
// Octave is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Octave is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Octave; see the file COPYING.  If not, see
// <https://www.gnu.org/licenses/>.
//
////////////////////////////////////////////////////////////////////////

#if defined (HAVE_CONFIG_H)
#  include "config.h"
#endif

#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // This one needs to be global.
#  pragma GCC diagnostic ignored "-Wunused-function"
   // Disable these warnings for code that is generated by flex,
   // including pattern rules.  Push the current state so we can
   // restore the warning state prior to functions we define at
   // the bottom of the file.
#  pragma GCC diagnostic push
#  pragma GCC diagnostic ignored "-Wold-style-cast"
#  pragma GCC diagnostic ignored "-Wsign-compare"
#  pragma GCC diagnostic ignored "-Wzero-as-null-pointer-constant"
#  if defined (HAVE_WARN_IMPLICIT_FALLTHROUGH)
#    pragma GCC diagnostic ignored "-Wimplicit-fallthrough"
#  endif
#endif

// Define away the deprecated register storage class specifier to avoid
// potential warnings about it.
#if ! defined (register)
#  define register
#endif

#line 53 "libinterp/parse-tree/lex.cc"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define octave__create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer octave__create_buffer
#endif

#ifdef yy_delete_buffer
#define octave__delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer octave__delete_buffer
#endif

#ifdef yy_scan_buffer
#define octave__scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer octave__scan_buffer
#endif

#ifdef yy_scan_string
#define octave__scan_string_ALREADY_DEFINED
#else
#define yy_scan_string octave__scan_string
#endif

#ifdef yy_scan_bytes
#define octave__scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes octave__scan_bytes
#endif

#ifdef yy_init_buffer
#define octave__init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer octave__init_buffer
#endif

#ifdef yy_flush_buffer
#define octave__flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer octave__flush_buffer
#endif

#ifdef yy_load_buffer_state
#define octave__load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state octave__load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define octave__switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer octave__switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define octave_push_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state octave_push_buffer_state
#endif

#ifdef yypop_buffer_state
#define octave_pop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state octave_pop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define octave_ensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack octave_ensure_buffer_stack
#endif

#ifdef yylex
#define octave_lex_ALREADY_DEFINED
#else
#define yylex octave_lex
#endif

#ifdef yyrestart
#define octave_restart_ALREADY_DEFINED
#else
#define yyrestart octave_restart
#endif

#ifdef yylex_init
#define octave_lex_init_ALREADY_DEFINED
#else
#define yylex_init octave_lex_init
#endif

#ifdef yylex_init_extra
#define octave_lex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra octave_lex_init_extra
#endif

#ifdef yylex_destroy
#define octave_lex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy octave_lex_destroy
#endif

#ifdef yyget_debug
#define octave_get_debug_ALREADY_DEFINED
#else
#define yyget_debug octave_get_debug
#endif

#ifdef yyset_debug
#define octave_set_debug_ALREADY_DEFINED
#else
#define yyset_debug octave_set_debug
#endif

#ifdef yyget_extra
#define octave_get_extra_ALREADY_DEFINED
#else
#define yyget_extra octave_get_extra
#endif

#ifdef yyset_extra
#define octave_set_extra_ALREADY_DEFINED
#else
#define yyset_extra octave_set_extra
#endif

#ifdef yyget_in
#define octave_get_in_ALREADY_DEFINED
#else
#define yyget_in octave_get_in
#endif

#ifdef yyset_in
#define octave_set_in_ALREADY_DEFINED
#else
#define yyset_in octave_set_in
#endif

#ifdef yyget_out
#define octave_get_out_ALREADY_DEFINED
#else
#define yyget_out octave_get_out
#endif

#ifdef yyset_out
#define octave_set_out_ALREADY_DEFINED
#else
#define yyset_out octave_set_out
#endif

#ifdef yyget_leng
#define octave_get_leng_ALREADY_DEFINED
#else
#define yyget_leng octave_get_leng
#endif

#ifdef yyget_text
#define octave_get_text_ALREADY_DEFINED
#else
#define yyget_text octave_get_text
#endif

#ifdef yyget_lineno
#define octave_get_lineno_ALREADY_DEFINED
#else
#define yyget_lineno octave_get_lineno
#endif

#ifdef yyset_lineno
#define octave_set_lineno_ALREADY_DEFINED
#else
#define yyset_lineno octave_set_lineno
#endif

#ifdef yyget_column
#define octave_get_column_ALREADY_DEFINED
#else
#define yyget_column octave_get_column
#endif

#ifdef yyset_column
#define octave_set_column_ALREADY_DEFINED
#else
#define yyset_column octave_set_column
#endif

#ifdef yywrap
#define octave_wrap_ALREADY_DEFINED
#else
#define yywrap octave_wrap
#endif

#ifdef yyget_lval
#define octave_get_lval_ALREADY_DEFINED
#else
#define yyget_lval octave_get_lval
#endif

#ifdef yyset_lval
#define octave_set_lval_ALREADY_DEFINED
#else
#define yyset_lval octave_set_lval
#endif

#ifdef yyalloc
#define octave_alloc_ALREADY_DEFINED
#else
#define yyalloc octave_alloc
#endif

#ifdef yyrealloc
#define octave_realloc_ALREADY_DEFINED
#else
#define yyrealloc octave_realloc
#endif

#ifdef yyfree
#define octave_free_ALREADY_DEFINED
#else
#define yyfree octave_free
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define octave_wrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef int yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 112
#define YY_END_OF_BUFFER 113
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[290] =
    {   0,
        0,    0,    5,    5,   10,   10,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  113,  111,
       53,   61,   61,   88,   63,  111,   74,   62,   93,   94,
       78,   85,   89,   86,   95,   79,   51,   51,   64,   84,
       76,   96,   77,  111,   59,   56,   15,   80,   16,   81,
       56,   56,  109,   75,  110,   87,   53,  111,    9,    8,
        3,    3,    7,  112,    5,    6,    4,    9,   10,   11,
       11,   95,   13,   14,   10,    1,    1,  112,   20,   20,
      112,  112,   24,   24,   24,   24,   24,   24,   39,   40,
       40,   26,   38,  112,   43,   44,   44,   42,   48,   46,

       48,   48,   45,   53,    0,   61,   71,    0,   21,   21,
       82,  107,   99,   91,   97,   92,   98,   90,   65,    0,
       66,   51,   67,   68,  100,   51,   51,    0,    0,   51,
        0,   69,   70,   73,    0,   58,    0,   60,    0,    0,
       56,    0,  101,  105,   56,   56,  108,   83,   72,   53,
        0,    0,    9,    8,    3,    0,    3,    5,    6,    0,
       10,   11,    0,   10,    1,    0,   20,   20,    0,    0,
        0,    0,    0,    0,   24,    0,   23,   23,    0,    0,
        0,   39,   40,   25,   37,   36,   36,   27,   29,   30,
       31,   32,   33,   34,   35,   37,   43,   44,   41,   46,

       48,    0,    0,    0,   45,  102,    0,  103,   51,  104,
      106,   50,   49,    0,   51,   52,    0,    0,   58,    0,
        0,   60,    0,    0,    0,   57,   56,    0,   17,   17,
        0,    0,    0,   18,   18,    0,   19,   19,    0,   22,
       22,   27,   28,    0,    0,   45,    0,   54,   54,   49,
        0,   51,   52,    0,    0,   58,    0,   60,    0,    0,
        0,   57,    0,   55,    0,    2,    2,    0,   12,   12,
       27,    0,   47,   47,   45,    0,    0,    0,   49,    0,
        0,    0,   52,   58,   60,    0,   57,   57,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    1,    7,    8,    9,   10,
       11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
       21,   22,   23,   24,   23,   25,   26,   27,   28,   29,
       30,   31,   32,   33,   34,   35,   34,   36,   36,   34,
       37,   37,   38,   38,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   39,   37,   37,
       40,   41,   42,   43,   44,    1,   45,   46,   34,   36,

       47,   48,   49,   37,   38,   38,   37,   37,   37,   50,
       37,   37,   37,   51,   52,   53,   54,   55,   37,   56,
       37,   37,   57,   58,   59,   60,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[61] =
    {   0,
        1,    2,    3,    3,    1,    4,    5,    1,    6,    5,
        5,    7,    8,    5,    8,    9,    7,   10,   10,   10,
       10,   10,   10,   10,   10,   10,    1,    5,    1,    1,
        1,    1,   11,   12,   12,   13,   14,   15,   14,    5,
       16,    5,    7,   17,   12,   12,   13,   12,   14,   14,
       14,   18,   14,   18,   14,   14,    5,    1,    5,    1
    } ;

static const flex_int16_t yy_base[334] =
    {   0,
        0,   59,   65,  123,   61,   81,  750,  749,   83,   87,
       94,  102,  112,  132,  108,  110,  181,  236,  752, 1235,
       71, 1235,  748,  720, 1235,   96,   62, 1235, 1235, 1235,
      716,  128, 1235,   65,  133,  708,  277,  108, 1235, 1235,
      707,  706,  705,  732,  731,  144, 1235,  699, 1235,  694,
      153,  154, 1235,   52, 1235,  693,  150,  164,    0,  720,
     1235,  718, 1235,  158,  149,  133, 1235,  704,  164, 1235,
      716,  302, 1235, 1235,  177, 1235,  715,  187, 1235,  714,
      191,  199, 1235,  197,  713,  204,  203,  208,    0, 1235,
      709,  701, 1235,  343,    0, 1235,  703,  696, 1235,  702,

      700,  686,  207,  237,  210, 1235, 1235,  238, 1235,  698,
     1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235,  670,  683,
      666,  207,  665,  664, 1235,  391,    0,  228,  209, 1235,
        0, 1235, 1235, 1235,  691,  246,  690,  247,  292,  687,
      304,  539, 1235, 1235,  315,  320, 1235, 1235, 1235,  248,
      273,  257,    0,  536, 1235,  263,  533,  269,  293,  519,
      262, 1235,  518,  303, 1235,  324, 1235,  530,  337,  347,
      352,  355,  327,  366, 1235,  368, 1235,  529,  372,  373,
      378,    0, 1235, 1235, 1235, 1235,  528,  400, 1235, 1235,
     1235, 1235, 1235, 1235, 1235,    0,    0, 1235, 1235,  528,

     1235,  513,  376,  521,  381, 1235,  381, 1235,  390, 1235,
     1235, 1235,  417,  238,  459,  353,  385,  400,  423,  429,
      393,  431,  388,  439,  384,  438,  440,  449, 1235,  372,
      440,  445,  455, 1235,  357,  460, 1235,  346,  463, 1235,
      339,  456,    0,  478,  336,  444,  480, 1235,  329,  467,
      468,  269,  416,  475,  276,  486,  266,  488,  489,  493,
      255,  496,  504, 1235,  504, 1235,  193,  512, 1235,  185,
     1235,  514, 1235,  178,  508,  154,  152,  109, 1235,   97,
       88,   80, 1235,  511,  523,   60,  524,  526, 1235,  542,
      560,  578,  596,  614,  632,  650,  668,  681,  696,  713,

      730,  748,  766,  784,  802,  820,  838,  856,  873,  882,
      493,  890,  902,  919,  936,  953,  962,  974,  992, 1001,
     1009, 1026, 1043, 1060, 1077, 1095, 1113, 1131, 1148, 1165,
     1182, 1199, 1216
    } ;

static const flex_int16_t yy_def[334] =
    {   0,
      289,    1,  290,  290,    1,    1,  291,  291,  292,  292,
      293,  293,  294,  294,  295,  295,  296,  296,  289,  289,
      289,  289,  289,  289,  289,  297,  289,  289,  289,  289,
      289,  289,  289,  289,  298,  289,  289,   37,  289,  289,
      289,  289,  289,  299,  300,  301,  289,  289,  289,  289,
      301,  301,  289,  289,  289,  289,  289,  297,  302,  289,
      289,  289,  289,  303,  289,  289,  289,  289,  289,  289,
      289,  298,  289,  289,  289,  289,  289,  304,  289,  289,
      304,  304,  289,  289,  289,  305,  289,  305,  306,  289,
      289,  289,  289,  307,  308,  289,  289,  289,  289,  289,

      289,  289,  309,  289,  297,  289,  289,  297,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  310,  289,  289,  289,  289,   38,  289,  311,  289,
      312,  289,  289,  289,  299,  313,  300,  314,  289,  315,
      301,  316,  289,  289,  301,  301,  289,  289,  289,  289,
      297,  297,  302,  289,  289,  303,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  304,  289,  289,  304,  304,
      304,  304,  289,  305,  289,  305,  289,  289,  289,  305,
      305,  306,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  317,  308,  289,  289,  289,

      289,  289,  289,  318,  309,  289,  319,  289,  310,  289,
      289,  289,  289,  311,  320,  321,  289,  322,  313,  289,
      323,  314,  315,  324,  316,  325,  301,  297,  289,  289,
      326,  327,  304,  289,  289,  304,  289,  289,  305,  289,
      289,  289,  317,  328,  318,  329,  319,  289,  289,  289,
      289,  320,  321,  289,  322,  330,  323,  331,  324,  289,
      332,  325,  289,  289,  326,  289,  289,  327,  289,  289,
      289,  328,  289,  289,  329,  289,  289,  289,  289,  289,
      289,  289,  289,  330,  331,  332,  333,  333,    0,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,

      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289
    } ;

static const flex_int16_t yy_nxt[1296] =
    {   0,
       20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
       30,   31,   32,   33,   34,   35,   36,   37,   38,   38,
       38,   38,   38,   38,   38,   38,   39,   40,   41,   42,
       43,   44,   45,   46,   46,   46,   46,   46,   46,   47,
       48,   49,   50,   46,   46,   46,   46,   46,   51,   46,
       46,   52,   46,   46,   46,   46,   53,   54,   55,   56,
       57,  286,   69,   70,   71,   58,   60,   61,   62,  111,
       63,   64,  104,   63,   65,   66,   72,  105,   67,  116,
       68,  147,   75,   70,   71,   79,   80,   58,   81,   79,
       80,  112,   67,   82,  117,   84,   72,   85,  109,  110,

       86,  283,   73,   87,   65,   85,   66,  283,   88,  148,
       96,   97,   96,   97,   90,   91,   98,   92,   98,   74,
      283,   65,   73,   66,   60,   61,   62,   93,   63,   64,
      279,   63,   65,   66,   90,   91,   67,   92,   68,   74,
      114,  118,  289,  159,  119,  139,  289,   93,  120,  121,
       67,  150,   94,  289,  139,  139,  151,  115,  158,  140,
      155,  157,   65,  289,   66,  161,  109,  110,  140,  140,
      105,  279,   94,  123,  159,  124,  142,  279,  164,   65,
      273,   66,  100,  151,  101,  142,  142,  269,  158,  167,
      168,  159,  169,  167,  168,  266,  102,  170,  173,  145,

      146,  167,  168,  174,  179,  158,  177,  178,  203,  180,
      177,  178,  109,  110,  103,  103,  103,  103,  103,  103,
      152,  214,  204,  214,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  100,  104,  101,
      109,  110,  129,  105,  130,  213,  213,  217,  220,  150,
      289,  102,  289,  129,  151,  171,  286,  172,  228,  229,
      230,  218,  221,  161,  181,  155,  157,  257,  105,  103,
      103,  103,  103,  103,  103,  109,  110,  255,  158,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  126,  139,  127,  127,  127,  127,  127,  127,

      127,  127,  127,  159,  164,  139,  130,  140,  158,  151,
      118,  128,  129,  119,  130,  131,  139,  163,  121,  140,
      127,  139,  128,  129,  142,  158,  167,  168,  173,  152,
      140,  248,  131,  174,  159,  140,  142,  245,  169,  167,
      168,  240,  123,  170,  124,  186,  187,  142,  237,  167,
      168,  159,  142,  233,  234,  235,  236,  237,  238,  234,
      188,  188,  188,  188,  188,  188,  188,  227,  177,  178,
      177,  178,  227,  179,  229,  177,  178,  203,  180,  239,
      240,  241,  203,  248,  249,  225,  217,  189,  190,  223,
      191,  204,  192,  193,  257,  194,  204,  195,  196,  212,

      218,  255,  212,  171,  254,  172,  254,  212,  122,  122,
      122,  122,  122,  122,  122,  122,  122,  242,  242,  242,
      242,  242,  242,  242,  217,  129,  129,  130,  130,  181,
      220,  212,  220,  212,  250,  250,  129,  129,  218,  260,
      139,  263,  266,  267,  221,  203,  221,  269,  270,  264,
      228,  229,  230,  261,  140,  140,  233,  234,  235,  204,
      250,  236,  237,  238,  239,  240,  241,  254,  251,  254,
      251,  142,  142,  271,  271,  271,  271,  271,  271,  271,
      273,  274,  248,  249,  250,  250,  276,  217,  277,  220,
      139,  278,  279,  280,  260,  281,  130,  260,  282,  283,

      215,  218,  215,  221,  140,  263,  266,  267,  261,  203,
      250,  261,  217,  264,  269,  270,  273,  274,  251,  140,
      251,  142,  245,  204,  220,  260,  218,  260,  244,  200,
      186,  177,  167,  232,  231,  155,  142,  154,  221,  261,
      225,  261,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   83,   83,   83,   83,

       83,   83,   83,   83,   83,   83,   83,   83,   83,   83,
       83,   83,   83,   83,   89,   89,   89,   89,   89,   89,
       89,   89,   89,   89,   89,   89,   89,   89,   89,   89,
       89,   89,   95,   95,   95,   95,   95,   95,   95,   95,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   95,
       99,   99,   99,   99,   99,   99,   99,   99,   99,   99,
       99,   99,   99,   99,   99,   99,   99,   99,  108,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
      108,  108,  108,  108,  108,  108,  122,  122,  223,  122,
      122,  137,  135,  211,  210,  208,  122,  136,  207,  206,

      109,  202,  201,  200,  199,  198,  184,  136,  136,  136,
      136,  183,  136,  136,  138,  175,  167,  165,  162,  160,
      155,  154,  149,  144,  138,  138,  138,  138,  143,  138,
      138,  141,  137,  135,  134,  133,  132,  125,  141,  141,
      141,  141,  141,  141,  141,  113,  141,  141,  153,  107,
      106,  289,   77,   77,  153,  153,  289,  153,  153,  153,
      153,  153,  153,  153,  153,  153,  156,  156,  156,  156,
      156,  156,  156,  156,  156,  156,  156,  156,  156,  156,
      156,  156,  156,  156,  166,  166,  166,  166,  166,  166,
      166,  166,  166,  166,  166,  166,  166,  166,  166,  166,

      166,  166,  176,  176,  176,  176,  176,  176,  176,  176,
      176,  176,  176,  176,  176,  176,  176,  176,  176,  176,
      182,  182,  289,  289,  182,  182,  182,  182,  289,  182,
      182,  182,  182,  182,  182,  289,  182,  182,  185,  185,
      185,  185,  185,  185,  185,  185,  185,  185,  185,  185,
      185,  185,  185,  185,  185,  185,  197,  197,  289,  197,
      197,  289,  197,  197,  197,  197,  197,  197,  197,  197,
      197,  197,  197,  197,  205,  289,  289,  289,  289,  289,
      289,  205,  205,  289,  205,  205,  205,  205,  289,  205,
      205,  209,  289,  289,  209,  289,  209,  289,  209,  216,

      289,  216,  216,  219,  289,  289,  289,  289,  289,  289,
      219,  219,  289,  219,  219,  219,  219,  289,  219,  219,
      222,  289,  289,  289,  289,  289,  289,  222,  222,  289,
      222,  222,  222,  222,  289,  222,  222,  224,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  224,  224,  224,
      224,  289,  224,  224,  226,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  226,  226,  226,  226,  289,  226,
      226,  243,  289,  243,  243,  246,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  246,  246,  246,  246,  289,
      246,  246,  247,  247,  247,  247,  247,  247,  247,  247,

      247,  247,  247,  247,  247,  247,  247,  247,  247,  247,
      252,  289,  289,  289,  289,  252,  289,  252,  253,  289,
      253,  253,  289,  289,  289,  253,  253,  256,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  256,  256,  256,
      256,  289,  256,  256,  258,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  258,  258,  258,  258,  289,  258,
      258,  259,  289,  289,  289,  289,  289,  289,  259,  259,
      259,  259,  259,  259,  259,  289,  259,  259,  262,  289,
      289,  289,  289,  289,  289,  262,  262,  289,  262,  262,
      262,  262,  289,  262,  262,  265,  265,  265,  265,  265,

      265,  265,  265,  265,  265,  265,  265,  265,  265,  265,
      265,  265,  265,  268,  268,  268,  268,  268,  268,  268,
      268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
      268,  272,  272,  272,  272,  272,  272,  272,  272,  272,
      272,  272,  272,  272,  272,  272,  272,  272,  272,  275,
      289,  289,  289,  289,  289,  289,  275,  275,  289,  275,
      275,  275,  275,  289,  275,  275,  284,  289,  289,  289,
      289,  289,  289,  284,  284,  289,  284,  284,  284,  284,
      289,  284,  284,  285,  289,  289,  289,  289,  289,  289,
      285,  285,  289,  285,  285,  285,  285,  289,  285,  285,

      287,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      287,  287,  287,  287,  289,  287,  287,  288,  289,  289,
      289,  289,  289,  289,  288,  288,  289,  288,  288,  288,
      288,  289,  288,  288,   19,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289

    } ;

static const flex_int16_t yy_chk[1296] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        2,  286,    5,    5,    5,    2,    3,    3,    3,   27,
        3,    3,   21,    3,    3,    3,    5,   21,    3,   34,
        3,   54,    6,    6,    6,    9,    9,    6,   10,   10,
       10,   27,    3,   10,   34,   11,    6,   11,   26,   26,

       11,  282,    5,   12,    3,   12,    3,  281,   12,   54,
       15,   15,   16,   16,   13,   13,   15,   13,   16,    5,
      280,    3,    6,    3,    4,    4,    4,   13,    4,    4,
      278,    4,    4,    4,   14,   14,    4,   14,    4,    6,
       32,   35,   38,   66,   35,   46,   38,   14,   35,   35,
        4,   57,   13,   38,   51,   52,   57,   32,   65,   46,
       64,   64,    4,   38,    4,   69,   58,   58,   51,   52,
       69,  277,   14,   35,   66,   35,   46,  276,   75,    4,
      274,    4,   17,   75,   17,   51,   52,  270,   65,   78,
       78,   66,   81,   81,   81,  267,   17,   81,   84,   51,

       52,   82,   82,   84,   87,   65,   86,   86,  103,   87,
       88,   88,  105,  105,   17,   17,   17,   17,   17,   17,
       58,  129,  103,  129,   17,   17,   17,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,  104,   18,
      108,  108,  122,  104,  122,  128,  128,  136,  138,  150,
      214,   18,  214,  122,  150,   82,  261,   82,  152,  152,
      152,  136,  138,  161,   88,  156,  156,  257,  161,   18,
       18,   18,   18,   18,   18,  151,  151,  255,  158,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   37,  139,   37,   37,   37,   37,   37,   37,

       37,   37,   37,  159,  164,  141,  252,  139,  158,  164,
       72,   37,   37,   72,   37,   37,  145,   72,   72,  141,
       37,  146,   37,   37,  139,  158,  166,  166,  173,  151,
      145,  249,   37,  173,  159,  146,  141,  245,  169,  169,
      169,  241,   72,  169,   72,   94,   94,  145,  238,  170,
      170,  159,  146,  171,  171,  171,  172,  172,  172,  235,
       94,   94,   94,   94,   94,   94,   94,  145,  174,  174,
      176,  176,  146,  179,  230,  180,  180,  203,  179,  181,
      181,  181,  205,  207,  207,  225,  217,   94,   94,  223,
       94,  203,   94,   94,  221,   94,  205,   94,   94,  126,

      217,  218,  126,  170,  216,  170,  216,  126,  126,  126,
      126,  126,  126,  126,  126,  126,  126,  188,  188,  188,
      188,  188,  188,  188,  219,  209,  126,  209,  126,  180,
      220,  126,  222,  126,  213,  213,  209,  126,  219,  226,
      224,  227,  231,  231,  220,  246,  222,  232,  232,  227,
      228,  228,  228,  226,  224,  227,  233,  233,  233,  246,
      213,  236,  236,  236,  239,  239,  239,  253,  213,  253,
      213,  224,  227,  242,  242,  242,  242,  242,  242,  242,
      244,  244,  247,  247,  250,  250,  251,  256,  251,  258,
      259,  251,  251,  254,  260,  254,  215,  262,  254,  254,

      311,  256,  311,  258,  259,  263,  265,  265,  260,  275,
      250,  262,  284,  263,  268,  268,  272,  272,  250,  263,
      250,  259,  204,  275,  285,  287,  284,  288,  202,  200,
      187,  178,  168,  163,  160,  157,  263,  154,  285,  287,
      142,  288,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      291,  291,  291,  291,  291,  291,  291,  291,  291,  291,
      291,  291,  291,  291,  291,  291,  291,  291,  292,  292,
      292,  292,  292,  292,  292,  292,  292,  292,  292,  292,
      292,  292,  292,  292,  292,  292,  293,  293,  293,  293,

      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  294,  294,  294,  294,  294,  294,
      294,  294,  294,  294,  294,  294,  294,  294,  294,  294,
      294,  294,  295,  295,  295,  295,  295,  295,  295,  295,
      295,  295,  295,  295,  295,  295,  295,  295,  295,  295,
      296,  296,  296,  296,  296,  296,  296,  296,  296,  296,
      296,  296,  296,  296,  296,  296,  296,  296,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  298,  298,  140,  298,
      298,  137,  135,  124,  123,  121,  298,  299,  120,  119,

      110,  102,  101,  100,   98,   97,   92,  299,  299,  299,
      299,   91,  299,  299,  300,   85,   80,   77,   71,   68,
       62,   60,   56,   50,  300,  300,  300,  300,   48,  300,
      300,  301,   45,   44,   43,   42,   41,   36,  301,  301,
      301,  301,  301,  301,  301,   31,  301,  301,  302,   24,
       23,   19,    8,    7,  302,  302,    0,  302,  302,  302,
      302,  302,  302,  302,  302,  302,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,

      304,  304,  305,  305,  305,  305,  305,  305,  305,  305,
      305,  305,  305,  305,  305,  305,  305,  305,  305,  305,
      306,  306,    0,    0,  306,  306,  306,  306,    0,  306,
      306,  306,  306,  306,  306,    0,  306,  306,  307,  307,
      307,  307,  307,  307,  307,  307,  307,  307,  307,  307,
      307,  307,  307,  307,  307,  307,  308,  308,    0,  308,
      308,    0,  308,  308,  308,  308,  308,  308,  308,  308,
      308,  308,  308,  308,  309,    0,    0,    0,    0,    0,
        0,  309,  309,    0,  309,  309,  309,  309,    0,  309,
      309,  310,    0,    0,  310,    0,  310,    0,  310,  312,

        0,  312,  312,  313,    0,    0,    0,    0,    0,    0,
      313,  313,    0,  313,  313,  313,  313,    0,  313,  313,
      314,    0,    0,    0,    0,    0,    0,  314,  314,    0,
      314,  314,  314,  314,    0,  314,  314,  315,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  315,  315,  315,
      315,    0,  315,  315,  316,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  316,  316,  316,  316,    0,  316,
      316,  317,    0,  317,  317,  318,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  318,  318,  318,  318,    0,
      318,  318,  319,  319,  319,  319,  319,  319,  319,  319,

      319,  319,  319,  319,  319,  319,  319,  319,  319,  319,
      320,    0,    0,    0,    0,  320,    0,  320,  321,    0,
      321,  321,    0,    0,    0,  321,  321,  322,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  322,  322,  322,
      322,    0,  322,  322,  323,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  323,  323,  323,  323,    0,  323,
      323,  324,    0,    0,    0,    0,    0,    0,  324,  324,
      324,  324,  324,  324,  324,    0,  324,  324,  325,    0,
        0,    0,    0,    0,    0,  325,  325,    0,  325,  325,
      325,  325,    0,  325,  325,  326,  326,  326,  326,  326,

      326,  326,  326,  326,  326,  326,  326,  326,  326,  326,
      326,  326,  326,  327,  327,  327,  327,  327,  327,  327,
      327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
      327,  328,  328,  328,  328,  328,  328,  328,  328,  328,
      328,  328,  328,  328,  328,  328,  328,  328,  328,  329,
        0,    0,    0,    0,    0,    0,  329,  329,    0,  329,
      329,  329,  329,    0,  329,  329,  330,    0,    0,    0,
        0,    0,    0,  330,  330,    0,  330,  330,  330,  330,
        0,  330,  330,  331,    0,    0,    0,    0,    0,    0,
      331,  331,    0,  331,  331,  331,  331,    0,  331,  331,

      332,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      332,  332,  332,  332,    0,  332,  332,  333,    0,    0,
        0,    0,    0,    0,  333,  333,    0,  333,  333,  333,
      333,    0,  333,  333,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "../libinterp/parse-tree/lex.ll"
/*

We are using the pure parser interface and the reentrant lexer interface
but the Octave parser and lexer are NOT properly reentrant because both
still use many global variables.  It should be safe to create a parser
object and call it while another parser object is active (to parse a
callback function while the main interactive parser is waiting for
input, for example) if you take care to properly save and restore
(typically with an unwind_protect object) relevant global values before
and after the nested call.

*/









#line 91 "../libinterp/parse-tree/lex.ll"

#include <cctype>
#include <cstring>

#include <algorithm>
#include <iostream>
#include <set>
#include <sstream>
#include <string>
#include <stack>

#include "cmd-edit.h"
#include "lo-mappers.h"
#include "quit.h"
#include "unistd-wrappers.h"

// These would be alphabetical, but oct-parse.h must be included before
// oct-gperf.h and oct-parse.h must be included after token.h and the tree
// class declarations.  We can't include oct-parse.h in oct-gperf.h
// because it may not be protected to allow it to be included multiple
// times.

#include "Cell.h"
#include "defun.h"
#include "error.h"
#include "errwarn.h"
#include "input.h"
#include "interpreter.h"
#include "lex.h"
#include "octave.h"
#include "ov-magic-int.h"
#include "ov.h"
#include "parse.h"
#include "pt-all.h"
#include "symtab.h"
#include "token.h"
#include "utils.h"
#include "variables.h"
#include "oct-parse.h"
#include "oct-gperf.h"

// FIXME: with bison 3.x, OCTAVE_STYPE appears in the generated
// oct-parse.h file, but there is no definition for YYSTYPE, which is
// needed by the code that is generated by flex.  I can't seem to find a
// way to tell flex to use OCTAVE_STYPE instead of YYSTYPE in the code
// it generates, or to tell bison to provide the definition of YYSTYPE
// in the generated oct-parse.h file.

#if defined (OCTAVE_STYPE_IS_DECLARED) && ! defined YYSTYPE
#  define YYSTYPE OCTAVE_STYPE
#endif

#define YY_NO_UNISTD_H 1
#define isatty octave_isatty_wrapper

#if ! (defined (FLEX_SCANNER)                                           \
       && defined (YY_FLEX_MAJOR_VERSION) && YY_FLEX_MAJOR_VERSION >= 2 \
       && defined (YY_FLEX_MINOR_VERSION) && YY_FLEX_MINOR_VERSION >= 5)
#error lex.l requires flex version 2.5.4 or later
#endif

#define YY_EXTRA_TYPE octave::base_lexer *
#define curr_lexer yyextra

// Arrange to get input via readline.

#if defined (YY_INPUT)
#  undef YY_INPUT
#endif
#define YY_INPUT(buf, result, max_size)                 \
  result = curr_lexer->fill_flex_buffer (buf, max_size)

// Try to avoid crashing out completely on fatal scanner errors.

#if defined (YY_FATAL_ERROR)
#  undef YY_FATAL_ERROR
#endif
#define YY_FATAL_ERROR(msg)                     \
   (yyget_extra (yyscanner))->fatal_error (msg)

#define CMD_OR_OP(PATTERN, TOK_ID, COMPAT)                      \
   do                                                           \
     {                                                          \
       curr_lexer->lexer_debug (PATTERN);                       \
                                                                \
       if (curr_lexer->looks_like_command_arg ())               \
         {                                                      \
           yyless (0);                                          \
           curr_lexer->push_start_state (COMMAND_START);        \
         }                                                      \
       else                                                     \
         return curr_lexer->handle_op (TOK_ID, false, COMPAT);  \
     }                                                          \
   while (0)

#define CMD_OR_UNARY_OP(PATTERN, TOK_ID, COMPAT)                        \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->previous_token_may_be_command ())                \
         {                                                              \
           if (curr_lexer->looks_like_command_arg ())                   \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->push_start_state (COMMAND_START);            \
             }                                                          \
           else                                                         \
             return curr_lexer->handle_op (TOK_ID, false, COMPAT);      \
         }                                                              \
       else                                                             \
         {                                                              \
           if (curr_lexer->maybe_unput_comma_before_unary_op (TOK_ID))  \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->xunput (',');                                \
             }                                                          \
           else                                                         \
             return curr_lexer->handle_op (TOK_ID, false, COMPAT);      \
         }                                                              \
     }                                                                  \
   while (0)

#define HANDLE_EOB_OR_EOF(STATUS)                       \
   do                                                   \
     {                                                  \
       if (curr_lexer->is_push_lexer ())                \
         {                                              \
           if (curr_lexer->at_end_of_buffer ())         \
             return STATUS;                             \
                                                        \
           if (curr_lexer->at_end_of_file ())           \
             return curr_lexer->handle_end_of_input (); \
         }                                              \
     }                                                  \
   while (0)

   // If we are at the end of the buffer, ask for more input.
   // If we are at the end of the file, deal with it.
   // Otherwise, just keep going with the text from the current buffer.
#define HANDLE_STRING_CONTINUATION              \
   do                                           \
     {                                          \
       curr_lexer->m_filepos.next_line ();      \
                                                \
       HANDLE_EOB_OR_EOF (-1);                  \
     }                                          \
   while (0)

#define HANDLE_NUMBER(PATTERN, BASE)                                    \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (PATTERN);                               \
                                                                        \
       if (curr_lexer->previous_token_may_be_command ()                 \
           &&  curr_lexer->space_follows_previous_token ())             \
         {                                                              \
           yyless (0);                                                  \
           curr_lexer->push_start_state (COMMAND_START);                \
         }                                                              \
       else                                                             \
         {                                                              \
           int tok_id = curr_lexer->previous_token_id ();               \
                                                                        \
           if (curr_lexer->whitespace_is_significant ()                 \
               && curr_lexer->space_follows_previous_token ()           \
               && ! (tok_id == '[' || tok_id == '{'                     \
                     || curr_lexer->previous_token_is_binop ()))        \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->xunput (',');                                \
             }                                                          \
           else                                                         \
             return curr_lexer->handle_number<BASE> ();                 \
         }                                                              \
     }                                                                  \
   while (0)

#define HANDLE_IDENTIFIER(pattern, get_set)                             \
   do                                                                   \
     {                                                                  \
       curr_lexer->lexer_debug (pattern);                               \
                                                                        \
       int tok_id = curr_lexer->previous_token_id ();                   \
                                                                        \
       if (curr_lexer->whitespace_is_significant ()                     \
           && curr_lexer->space_follows_previous_token ()               \
           && ! (tok_id == '[' || tok_id == '{'                         \
                 || curr_lexer->previous_token_is_binop ()))            \
         {                                                              \
           yyless (0);                                                  \
           curr_lexer->xunput (',');                                    \
         }                                                              \
       else                                                             \
         {                                                              \
           if (! curr_lexer->m_looking_at_decl_list                     \
               && curr_lexer->previous_token_may_be_command ())         \
             {                                                          \
               yyless (0);                                              \
               curr_lexer->push_start_state (COMMAND_START);            \
             }                                                          \
           else                                                         \
             {                                                          \
               if (get_set)                                             \
                 {                                                      \
                   yyless (3);                                          \
                   curr_lexer->m_filepos.increment_column (3);          \
                   curr_lexer->m_maybe_classdef_get_set_method = false; \
                 }                                                      \
                                                                        \
               return curr_lexer->handle_identifier ();                 \
             }                                                          \
         }                                                              \
     }                                                                  \
   while (0)

static inline bool
is_space_or_tab (char c)
{
  return c == ' ' || c == '\t';
}

static inline bool
is_space_or_tab_or_eol (char c)
{
  return c == ' ' || c == '\t' || c == '\n' || c == '\r';
}

OCTAVE_BEGIN_NAMESPACE(octave)

  bool iskeyword (const std::string& s)
  {
    // Parsing function names like "set.property_name" inside
    // classdef-style class definitions is simplified by handling the
    // "set" and "get" portions of the names using the same mechanism
    // as is used for keywords.  However, they are not really keywords
    // in the language, so omit them from the list of possible
    // keywords.  Likewise for "arguments", "enumeration", "events",
    // "methods", and "properties".

    // FIXME: The following check is duplicated in Fiskeyword.
    return (octave_kw_hash::in_word_set (s.c_str (), s.length ()) != nullptr
            && ! (s == "set" || s == "get" || s == "arguments"
                  || s == "enumeration" || s == "events"
                  || s == "methods" || s == "properties"));
  }

OCTAVE_END_NAMESPACE(octave)

#line 1355 "libinterp/parse-tree/lex.cc"
#line 351 "../libinterp/parse-tree/lex.ll"
// Decimal numbers may be real or imaginary but always create
// double precision constants initially.  Any conversion to single
// precision happens as part of an expression evaluation in the
// interpreter, not the lexer and parser.
#line 1361 "libinterp/parse-tree/lex.cc"
#line 364 "../libinterp/parse-tree/lex.ll"
// It is possible to specify signedness and size for binary and
// hexadecimal numbers but there is no special syntax for imaginary
// constants.  Binary and hexadecimal constants always create integer
// valued constants ({u,}int{8,16,32,64}).  If a size is not specified,
// the smallest integer type that will hold the value is used.  Negative
// values may be created with a signed size specification by applying
// twos-complement conversion (for example, 0xffs8 produces an 8-bit
// signed integer equal to -1 and 0b10000000s8 produces an 8-bit signed
// integer equal to -128).
#line 1372 "libinterp/parse-tree/lex.cc"
#line 1373 "libinterp/parse-tree/lex.cc"

#define INITIAL 0
#define COMMAND_START 1
#define MATRIX_START 2
#define INPUT_FILE_START 3
#define BLOCK_COMMENT_START 4
#define LINE_COMMENT_START 5
#define DQ_STRING_START 6
#define SQ_STRING_START 7
#define FQ_IDENT_START 8

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  , yyscan_t yyscanner);
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 384 "../libinterp/parse-tree/lex.ll"



#line 388 "../libinterp/parse-tree/lex.ll"
// Make script and function files start with an invalid token. This makes
// the parser go down a special path.


#line 1667 "libinterp/parse-tree/lex.cc"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yyg->yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				yyg->yy_last_accepting_state = yy_current_state;
				yyg->yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 290 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 1235 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yyg->yy_hold_char;
			yy_cp = yyg->yy_last_accepting_cpos;
			yy_current_state = yyg->yy_last_accepting_state;
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 392 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<INPUT_FILE_START>{ANY_INCLUDING_NL}");

    curr_lexer->xunput (yytext[0]);

    // May be reset later if we see "function" or "classdef" appears
    // as the first token.
    curr_lexer->m_reading_script_file = true;

    curr_lexer->pop_start_state ();

    return curr_lexer->show_token (INPUT_FILE);
  }
	YY_BREAK
case YY_STATE_EOF(INPUT_FILE_START):
#line 406 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<INPUT_FILE_START><<EOF>>");

    // May be reset later if we see "function" or "classdef" appears
    // as the first token.
    curr_lexer->m_reading_script_file = true;

    curr_lexer->pop_start_state ();

    return curr_lexer->show_token (INPUT_FILE);
  }
	YY_BREAK

// Help and other command-style functions.


// Commands can be continued on a second line using the ellipsis.
// If an argument is in construction, it is completed.

case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 427 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>(\\.\\.\\.){ANY_EXCEPT_NL}*{NL}");

    if (! curr_lexer->m_string_text.empty ())
      {
        yyless (0);
        curr_lexer->m_tok_end = curr_lexer->m_filepos;
        return curr_lexer->finish_command_arg ();
      }

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK

// Commands normally end at the end of a line or a semicolon.

case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 444 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>({CCHAR}{ANY_EXCEPT_NL}*)?{NL}");

    if (! curr_lexer->m_string_text.empty ())
      {
        yyless (0);
        curr_lexer->m_tok_end = curr_lexer->m_filepos;
        return curr_lexer->finish_command_arg ();
      }

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_filepos.next_line ();
    curr_lexer->m_looking_for_object_index = false;
    curr_lexer->pop_start_state ();
    curr_lexer->m_comment_uses_hash_char = yytext[0] == '#';
    curr_lexer->finish_comment (octave::comment_elt::end_of_line);

    return curr_lexer->handle_token ('\n');
  }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 465 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\,\\;]");

    if (yytext[0] != ',' || curr_lexer->m_command_arg_paren_count == 0)
      {
        if (! curr_lexer->m_string_text.empty ())
          {
            yyless (0);
            curr_lexer->m_tok_end = curr_lexer->m_filepos;
            return curr_lexer->finish_command_arg ();
          }

        curr_lexer->update_token_positions (yyleng);

        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = true;
        curr_lexer->pop_start_state ();

        return curr_lexer->handle_token (yytext[0]);
      }
    else
      {
        curr_lexer->m_string_text += yytext;
        curr_lexer->m_filepos.increment_column (yyleng);
      }
  }
	YY_BREAK

// Unbalanced parentheses serve as pseudo-quotes: they are included in
// the final argument string, but they cause parentheses and quotes to
// be slurped into that argument as well.

case 5:
YY_RULE_SETUP
#line 498 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\(\\[\\{]+");

    curr_lexer->m_command_arg_paren_count += yyleng;
    curr_lexer->m_string_text += yytext;
    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 506 "../libinterp/parse-tree/lex.ll"
{
   curr_lexer->lexer_debug ("<COMMAND_START>[\\)\\]\\}]+");

   curr_lexer->m_command_arg_paren_count -= yyleng;
   curr_lexer->m_string_text += yytext;
   curr_lexer->m_filepos.increment_column (yyleng);
}
	YY_BREAK

// Handle quoted strings.  Quoted strings that are not separated by
// whitespace from other argument text are combined with that previous
// text.  For instance,
//
//   command 'text1'"text2"
//
// has a single argument text1text2, not two separate arguments.
// That's why we must test to see if we are in command argument mode
// when processing the end of a string.

case 7:
YY_RULE_SETUP
#line 526 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>[\\\"\\']");

    if (curr_lexer->m_command_arg_paren_count == 0)
      curr_lexer->begin_string (yytext[0] == '"'
                                ? DQ_STRING_START : SQ_STRING_START);
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK

// In standard command argument processing, whitespace separates
// arguments.  In the presence of unbalanced parentheses, it is
// incorporated into the argument.

case 8:
YY_RULE_SETUP
#line 544 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>{S}*");

    if (curr_lexer->m_command_arg_paren_count == 0)
      {
        if (! curr_lexer->m_string_text.empty ())
          {
            yyless (0);
            curr_lexer->m_tok_end = curr_lexer->m_filepos;
            return curr_lexer->finish_command_arg ();
          }
      }
    else
      curr_lexer->m_string_text += yytext;

    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK

// Everything else is slurped into the command arguments.

case 9:
YY_RULE_SETUP
#line 566 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<COMMAND_START>([\\.]|[^#% \\t\\r\\n\\.\\,\\;\\\"\\'\\(\\[\\{\\}\\]\\)]*");

    curr_lexer->m_string_text += yytext;
    curr_lexer->m_filepos.increment_column (yyleng);
  }
	YY_BREAK

// Whitespace inside matrix lists.

case 10:
YY_RULE_SETUP
#line 577 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>{S}*");

    curr_lexer->m_filepos.increment_column (yyleng);

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK
case 11:
/* rule 11 can match eol */
YY_RULE_SETUP
#line 585 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>{NL}");

    curr_lexer->m_filepos.next_line ();

    if (curr_lexer->m_nesting_level.is_paren ())
      curr_lexer->warn_language_extension ("bare newline inside parentheses");
    else
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (! (tok_id == ';' || tok_id == '[' || tok_id == '{'))
          curr_lexer->xunput (';');
      }
  }
	YY_BREAK

// Continuation lines in matrix constants are handled as whitespace.
// Allow arbitrary text after the continuation marker.

case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 606 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\.\\.\\.{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->handle_continuation ();

    // Even if there wasn't a space before or after the continuation
    // marker, treat the continuation as if it were.  But since it will
    // be transformed to a separator later anyway, there's no need to
    // actually unput a space on the input stream.

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK

// For this and the next two rules, we're looking at ']', and we
// need to know if the next token is '=' or '=='.
//
// It would have been so much easier if the delimiters were simply
// different for the expression on the left hand side of the equals
// operator.
//
// It's also a pain in the ass to decide whether to insert a comma
// after seeing a ']' character...

// FIXME: we need to handle block comments here.

case 13:
YY_RULE_SETUP
#line 633 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\]");

    curr_lexer->update_token_positions (yyleng);
    return curr_lexer->handle_close_bracket (']');
  }
	YY_BREAK

// FIXME: we need to handle block comments here.

case 14:
YY_RULE_SETUP
#line 644 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<MATRIX_START>\\}*");

    curr_lexer->update_token_positions (yyleng);
    return curr_lexer->handle_close_bracket ('}');
  }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 651 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\[");

        bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (! (tok_id == '[' || tok_id == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        curr_lexer->m_nesting_level.bracket ();

        curr_lexer->m_looking_at_object_index.push_front (false);

        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        if (curr_lexer->m_defining_fcn
            && ! curr_lexer->m_parsed_function_name.top ())
          curr_lexer->m_looking_at_return_list = true;
        else
          curr_lexer->m_looking_at_matrix_or_assign_lhs = true;

        curr_lexer->m_bracketflag++;

        curr_lexer->push_start_state (MATRIX_START);

        return curr_lexer->handle_token ('[');
      }
  }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 696 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\]");

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_nesting_level.remove ();

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    return curr_lexer->handle_token (']');
  }
	YY_BREAK

// Gobble comments.  Both BLOCK_COMMENT_START and LINE_COMMENT_START
// are exclusive start states.  We try to grab a continuous series of
// line-oriented comments as a single collection of comments.


// Start of a block comment.  Since comment start states are exclusive,
// this pattern will not match a block comment that immediately follows
// a line-oriented comment.  All we need to do is push the matched text
// back on the input stream and push the new start state.

case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 724 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("^{S}*{CCHAR}\\{{S}*{NL}");

    yyless (0);

    curr_lexer->push_start_state (BLOCK_COMMENT_START);
  }
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 732 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>^{S}*{CCHAR}\\{{S}*{NL}");

    curr_lexer->m_filepos.next_line ();

    if (curr_lexer->m_block_comment_nesting_level)
      curr_lexer->m_comment_text = "\n";
    else
      curr_lexer->check_comment_for_hash_char (yytext, yyleng);

    curr_lexer->m_block_comment_nesting_level++;

    HANDLE_EOB_OR_EOF (-1);
  }
	YY_BREAK

// End of a block comment.  If this block comment is nested inside
// another, wait for the outermost block comment to be closed before
// storing the comment.

// NOTE: This pattern must appear before the one below.  Both may match
// the same text and this one should take precedence over the one that
// follows.

case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 757 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>^{S}*{CCHAR}\\}{S}*{NL}");

    curr_lexer->m_filepos.next_line ();

    if (curr_lexer->m_block_comment_nesting_level > 1)
      curr_lexer->m_comment_text = "\n";
    else
      {
        curr_lexer->check_comment_for_hash_char (yytext, yyleng);
        curr_lexer->finish_comment (octave::comment_elt::block);
      }

    curr_lexer->m_block_comment_nesting_level--;

    if (curr_lexer->m_block_comment_nesting_level == 0)
      {
        curr_lexer->pop_start_state ();

        if (curr_lexer->pending_token_count () > 0)
          HANDLE_EOB_OR_EOF (-1);
        else
          HANDLE_EOB_OR_EOF (-2);
      }
    else
      HANDLE_EOB_OR_EOF (-1);
  }
	YY_BREAK

// Body of a block comment.

case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 789 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<BLOCK_COMMENT_START>{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->m_filepos.next_line ();
    curr_lexer->m_comment_text += yytext;

    HANDLE_EOB_OR_EOF (-1);
  }
	YY_BREAK

// Full-line or end-of-line comment.

case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 802 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->push_start_state (LINE_COMMENT_START);
    yyless (0);
  }
	YY_BREAK

// Beginning of a block comment while we are looking at a series of
// line-oriented comments.  Finish previous comment, push current
// text back on input stream, and switch start states.

// NOTE: This pattern must appear before the one below.  Both may match
// the same text and this one should take precedence over the one that
// follows.

case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 819 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>^{S}*{CCHAR}\\{{S}*{NL}");

    if (! curr_lexer->m_comment_text.empty ())
      curr_lexer->finish_comment (octave::comment_elt::full_line);

    curr_lexer->pop_start_state ();
    curr_lexer->push_start_state (BLOCK_COMMENT_START);
    yyless (0);
  }
	YY_BREAK

// Line-oriented comment.  If we are at the beginning of a line, this is
// part of a series of full-line comments.  Otherwise, this is an end of
// line comment.  We don't need to parse the matched text to determine
// whether we are looking at the start of a block comment as that
// pattern is handled above.

// NOTE: This pattern must appear before the one below.  Both may match
// the same text and this one should take precedence over the one that
// follows.

case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 842 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>{S}*{CCHAR}{ANY_EXCEPT_NL}*{NL}");

    // Grab text of comment without leading space or comment
    // characters.

    std::size_t i = 0;
    while (i < yyleng && is_space_or_tab (yytext[i]))
      i++;

    bool have_space = (i > 0);

    bool first = true;

    while (i < yyleng)
      {
        char c = yytext[i];

        if (c == '#' || c == '%')
          {
            if (first && c == '#')
              {
                curr_lexer->m_comment_uses_hash_char = true;
                first = false;
              }

            i++;
          }
        else
          break;
      }

    curr_lexer->m_comment_text += &yytext[i];

    if (curr_lexer->m_filepos.column () == 1)
      {
        curr_lexer->m_filepos.next_line ();
      }
    else
      {
        // End of line comment.

        if (have_space)
          curr_lexer->mark_previous_token_trailing_space ();

        curr_lexer->finish_comment (octave::comment_elt::end_of_line);

        curr_lexer->pop_start_state ();

        // Push the newline character back on the input and skip
        // incrementing the line count so we don't have to duplicate
        // all the possible actions that happen with newlines here.

        curr_lexer->xunput ('\n');

        // The next action should recognize a newline character and set
        // the input column back to 1, but we should try to keep the
        // input column location accurate anyway, so update here.
        curr_lexer->m_filepos.increment_column (yyleng);
      }
  }
	YY_BREAK

// End of a series of full-line because some other character was
// found on the input stream.

case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 909 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START>{ANY_INCLUDING_NL}");

    if (yytext[0] == '\001')
      {
        // We are here because we are using the push parser/lexer
        // interface and we hit the end of the input buffer or file.
        // The special ASCII 1 marker is added to the input by
        // push_lexer::fill_flex_buffer.

        if (curr_lexer->pending_token_count () > 0)
          {
            // We are in the middle of parsing a command, expresison,
            // etc., so set the return status so that if we are at the
            // end of the buffer we'll continue looking for more input,
            // possibly buffering a series of line oriented comments as
            // a single block.

            HANDLE_EOB_OR_EOF (-1);
          }
        else
          {
            // We are not in the process of parsing a command,
            // expression, etc., so end any current sequence of comments
            // with this full line comment, pop the start state and
            // return as if we have just finished parsing a complete
            // statement.

            curr_lexer->finish_comment (octave::comment_elt::full_line);

            curr_lexer->pop_start_state ();

            HANDLE_EOB_OR_EOF (-2);
          }
      }
    else
      {
        // End any current sequence of comments, pop the start state,
        // and unput the pending input character that ended the series
        // of comments.

        curr_lexer->finish_comment (octave::comment_elt::full_line);

        curr_lexer->pop_start_state ();

        curr_lexer->xunput (yytext[0]);
      }
  }
	YY_BREAK

// End of file will also end a series of full-line comments.

case YY_STATE_EOF(LINE_COMMENT_START):
#line 962 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<LINE_COMMENT_START><<EOF>>");

    curr_lexer->finish_comment (octave::comment_elt::full_line);

    curr_lexer->pop_start_state ();
  }
	YY_BREAK

// Double-quoted character strings.

case 25:
YY_RULE_SETUP
#line 974 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\"\\\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '"';
  }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 981 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\"");

    // m_tok_beg was set when we started parsing the string.
    curr_lexer->m_tok_end = curr_lexer->m_filepos;
    curr_lexer->m_filepos.increment_column ();

    curr_lexer->pop_start_state ();

    if (curr_lexer->start_state() != COMMAND_START)
      {
        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        octave::token *tok = new octave::token (DQ_STRING, curr_lexer->m_string_text, curr_lexer->m_tok_beg, curr_lexer->m_tok_end, curr_lexer->get_comment_list ());

        curr_lexer->m_string_text = "";

        return curr_lexer->handle_token (tok);
      }
  }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 1003 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\[0-7]{1,3}");

    curr_lexer->update_token_positions (yyleng);

    unsigned int result;
    if (sscanf (yytext+1, "%o", &result) != 1)
      curr_lexer->fatal_error ("scanf failed in lexer rule <DQ_STRING_START>\\\\[0-7]{1,3} - please report this bug");

    if (result > 0xff)
      {
        // Use location of octal digits for error token.
        std::string msg {"invalid octal escape sequence in character string"};
        return curr_lexer->syntax_error (msg);
      }
    else
      curr_lexer->m_string_text += static_cast<unsigned char> (result);
  }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 1022 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\x[0-9a-fA-F]+");

    curr_lexer->m_filepos.increment_column (yyleng);

    unsigned int result;
    if (sscanf (yytext+2, "%x", &result) != 1)
      curr_lexer->fatal_error ("scanf failed in lexer rule <DQ_STRING_START>\\\\x[0-9a-fA-F]+ - please report this bug");

    // Truncate the value silently instead of checking the range like
    // we do for octal above.  This is to match C/C++ where any number
    // of digits is allowed but the value is implementation-defined if
    // it exceeds the range of the character type.
    curr_lexer->m_string_text += static_cast<unsigned char> (result);
  }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 1038 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\a\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\a';
  }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 1045 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\b\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\b';
  }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 1052 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\f\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\f';
  }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 1059 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\n\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\n';
  }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 1066 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\r\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\r';
  }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 1073 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\t\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\t';
  }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 1080 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\"\\\\v\"");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\v';
  }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 1087 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\{NL}");

    HANDLE_STRING_CONTINUATION;
  }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 1093 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\\\.");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += yytext[1];
  }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 1100 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>\\.");

    curr_lexer->m_filepos.increment_column ();
    curr_lexer->m_string_text += yytext[0];
  }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 1107 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>[^\\.\\\\\\r\\n\\\"]+");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += yytext;
  }
	YY_BREAK
case 40:
/* rule 40 can match eol */
YY_RULE_SETUP
#line 1114 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<DQ_STRING_START>{NL}");

    // Use current file position for error token.
    std::string msg {"unterminated character string constant"};
    return curr_lexer->syntax_error (msg, curr_lexer->m_filepos);
  }
	YY_BREAK

// Single-quoted character strings.

case 41:
YY_RULE_SETUP
#line 1126 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>\\'\\'");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += '\'';
  }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 1133 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>\\'");

    // m_tok_beg was set when we started parsing the string.
    curr_lexer->m_tok_end = curr_lexer->m_filepos;
    curr_lexer->m_filepos.increment_column ();

    curr_lexer->pop_start_state ();

    if (curr_lexer->start_state() != COMMAND_START)
      {
        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        octave::token *tok = new octave::token (SQ_STRING, curr_lexer->m_string_text, curr_lexer->m_tok_beg, curr_lexer->m_tok_end, curr_lexer->get_comment_list ());

        curr_lexer->m_string_text = "";

        return curr_lexer->handle_token (tok);
      }
  }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 1155 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>[^\\'\\n\\r]+");

    curr_lexer->m_filepos.increment_column (yyleng);
    curr_lexer->m_string_text += yytext;
  }
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 1162 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<SQ_STRING_START>{NL}");

    // Use current file position for error token.
    std::string msg {"unterminated character string constant"};
    return curr_lexer->syntax_error (msg, curr_lexer->m_filepos);
  }
	YY_BREAK

// Fully-qualified identifiers (used for classdef).

case 45:
YY_RULE_SETUP
#line 1174 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{FQIDENT}{S}*");

    curr_lexer->pop_start_state ();

    curr_lexer->update_token_positions (yyleng);

    std::string ident = yytext;

    ident.erase (std::remove_if (ident.begin (), ident.end (), is_space_or_tab), ident.end ());

    if (curr_lexer->fq_identifier_contains_keyword (ident))
      return curr_lexer->syntax_error ("function, method, class, and package names may not be keywords");

    octave::token *tok = curr_lexer->make_fq_identifier_token (ident);

    return curr_lexer->handle_token (tok);
  }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 1193 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{S}+");

    curr_lexer->m_filepos.increment_column (yyleng);

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK
case 47:
/* rule 47 can match eol */
YY_RULE_SETUP
#line 1201 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>(\\.\\.\\.){ANY_EXCEPT_NL}*{NL}");

    curr_lexer->m_filepos.next_line ();
  }
	YY_BREAK
case 48:
/* rule 48 can match eol */
YY_RULE_SETUP
#line 1207 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("<FQ_IDENT_START>{ANY_INCLUDING_NL}");

    // If input doesn't match FQIDENT, return char and go to previous
    // start state.

    yyless (0);
    curr_lexer->pop_start_state ();
  }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 1217 "../libinterp/parse-tree/lex.ll"
{
    HANDLE_NUMBER ("{BINARY_NUMBER}", 2);
  }
	YY_BREAK

// Decimal numbers.  For expressions that are just digits followed
// directly by an element-by-element operator, don't grab the '.'
// part of the operator as part of the constant (for example, in an
// expression like "13./x").

case 50:
*yy_cp = yyg->yy_hold_char; /* undo effects of setting up yytext */
yyg->yy_c_buf_p = yy_cp -= 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
#line 1229 "../libinterp/parse-tree/lex.ll"
case 51:
YY_RULE_SETUP
#line 1229 "../libinterp/parse-tree/lex.ll"
{
    HANDLE_NUMBER ("{DECIMAL_DIGITS}/\\.[\\*/\\\\^\\']|{DECIMAL_NUMBER}", 10);
  }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 1233 "../libinterp/parse-tree/lex.ll"
{
    HANDLE_NUMBER ("{HEXADECIMAL_NUMBER}", 16);
  }
	YY_BREAK

// Eat whitespace.  Whitespace inside matrix constants is handled by
// the <MATRIX_START> start state code above.

case 53:
YY_RULE_SETUP
#line 1242 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->m_filepos.increment_column (yyleng);

    curr_lexer->mark_previous_token_trailing_space ();
  }
	YY_BREAK

// Continuation lines.  Allow arbitrary text after continuations.

case 54:
/* rule 54 can match eol */
YY_RULE_SETUP
#line 1252 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\.\\.\\.{ANY_EXCEPT_NL}*{NL}");

    curr_lexer->handle_continuation ();
  }
	YY_BREAK

// Deprecated C preprocessor style continuation markers.


// End of file.

case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMAND_START):
case YY_STATE_EOF(MATRIX_START):
case YY_STATE_EOF(BLOCK_COMMENT_START):
case YY_STATE_EOF(DQ_STRING_START):
case YY_STATE_EOF(SQ_STRING_START):
case YY_STATE_EOF(FQ_IDENT_START):
#line 1267 "../libinterp/parse-tree/lex.ll"
{
   return curr_lexer->handle_end_of_input ();
  }
	YY_BREAK

// Identifiers.

// Don't allow get and set to be recognized as keywords if they are
// followed by "(".

case 55:
YY_RULE_SETUP
#line 1278 "../libinterp/parse-tree/lex.ll"
{
    HANDLE_IDENTIFIER ("(set|get){S}*\\(", true);
  }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 1282 "../libinterp/parse-tree/lex.ll"
{
    HANDLE_IDENTIFIER ("{IDENT}", false);
  }
	YY_BREAK

// Superclass method identifiers.

case 57:
YY_RULE_SETUP
#line 1290 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{FQIDENT}{S}*@{S}*{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        if (curr_lexer->m_at_beginning_of_statement)
          {
            std::string txt = yytext;

            std::size_t at_or_dot_pos = txt.find_first_of ("@.");

            if (at_or_dot_pos != std::string::npos)
              {
                std::size_t spc_pos = txt.find_first_of (" \t");

                if (spc_pos != std::string::npos && spc_pos < at_or_dot_pos)
                  {
                    yyless (spc_pos);
                    curr_lexer->m_filepos.increment_column (spc_pos);

                    return curr_lexer->handle_identifier ();
                  }
              }
          }

        curr_lexer->m_looking_for_object_index = true;
        curr_lexer->m_at_beginning_of_statement = false;

        return curr_lexer->handle_superclass_identifier ();
      }
  }
	YY_BREAK

// Metaclass query

case 58:
YY_RULE_SETUP
#line 1331 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\?{S}*{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        std::string txt = yytext;

        txt.erase (std::remove_if (txt.begin (), txt.end (), is_space_or_tab), txt.end ());

        // Eliminate leading '?'
        std::string cls = txt.substr (1);

        if (curr_lexer->fq_identifier_contains_keyword (cls))
          return curr_lexer->syntax_error ("class and package names may not be keywords");

        octave::token *tok = curr_lexer->make_meta_identifier_token (cls);

        return curr_lexer->handle_token (tok);
      }
  }
	YY_BREAK
case 59:
#line 1361 "../libinterp/parse-tree/lex.ll"
case 60:
YY_RULE_SETUP
#line 1361 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\@|\\@{S}*{FQIDENT}");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (curr_lexer->whitespace_is_significant ()
            && curr_lexer->space_follows_previous_token ()
            && ! (tok_id == '[' || tok_id == '{'
                  || curr_lexer->previous_token_is_binop ()))
          {
            yyless (0);
            curr_lexer->xunput (',');
          }
        else
          {
            curr_lexer->update_token_positions (yyleng);

            curr_lexer->m_at_beginning_of_statement = false;

            std::string ident = yytext;

            if (ident == "@")
              {
                curr_lexer->m_looking_at_function_handle++;
                curr_lexer->m_looking_for_object_index = false;

                return curr_lexer->handle_token ('@');
              }
            else
              {
                ident = ident.substr (1);
                ident.erase (std::remove_if (ident.begin (), ident.end (),
                                             is_space_or_tab), ident.end ());

                octave::token *tok;

                if (octave::iskeyword (ident))
                  {
                    std::string msg {"function handles may not refer to keywords"};
                    return curr_lexer->syntax_error (msg);
                  }

                curr_lexer->m_looking_for_object_index = true;

                tok = new octave::token (FCN_HANDLE, ident, curr_lexer->m_tok_beg, curr_lexer->m_tok_end, curr_lexer->get_comment_list ());

                return curr_lexer->handle_token (tok);
              }
          }
      }
  }
	YY_BREAK

// A new line character.  New line characters inside matrix constants
// are handled by the <MATRIX_START> start state code above.  If closest
// nesting is inside parentheses, don't return a row separator.

case 61:
/* rule 61 can match eol */
YY_RULE_SETUP
#line 1427 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{NL}");

    if (curr_lexer->m_nesting_level.is_paren ())
      {
        curr_lexer->m_filepos.next_line ();

        curr_lexer->m_at_beginning_of_statement = false;
        curr_lexer->warn_language_extension
          ("bare newline inside parentheses");
      }
    else if (curr_lexer->m_nesting_level.none ()
        || curr_lexer->m_nesting_level.is_anon_fcn_body ())
      {
        curr_lexer->update_token_positions (yyleng);
        curr_lexer->m_filepos.next_line ();

        curr_lexer->m_at_beginning_of_statement = true;

        return curr_lexer->handle_token ('\n');
      }
    else if (curr_lexer->m_nesting_level.is_bracket_or_brace ())
      {
        curr_lexer->update_token_positions (yyleng);
        curr_lexer->m_filepos.next_line ();

        // Use current file position for error token.
        std::string msg {"unexpected internal lexer error"};
        return curr_lexer->syntax_error (msg, curr_lexer->m_filepos);
      }
  }
	YY_BREAK

// Single quote can either be the beginning of a string or a transpose
// operator.

case 62:
YY_RULE_SETUP
#line 1464 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("'");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        curr_lexer->m_filepos.increment_column ();
        curr_lexer->push_start_state (COMMAND_START);
        curr_lexer->begin_string (SQ_STRING_START);
      }
    else if (curr_lexer->m_at_beginning_of_statement)
      {
        curr_lexer->m_filepos.increment_column ();
        curr_lexer->begin_string (SQ_STRING_START);
      }
    else
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (curr_lexer->whitespace_is_significant ())
          {
            if (curr_lexer->space_follows_previous_token ())
              {
                if (tok_id == '[' || tok_id == '{'
                    || curr_lexer->previous_token_is_binop ())
                  {
                    curr_lexer->m_filepos.increment_column ();
                    curr_lexer->begin_string (SQ_STRING_START);
                  }
                else
                  {
                    yyless (0);
                    curr_lexer->xunput (',');
                  }
              }
            else
              {
                if (tok_id == '[' || tok_id == '{'
                    || curr_lexer->previous_token_is_binop ()
                    || curr_lexer->previous_token_is_keyword ())
                  {
                    curr_lexer->m_filepos.increment_column ();
                    curr_lexer->begin_string (SQ_STRING_START);
                  }
                else
                  {
                    curr_lexer->m_filepos.increment_column ();
                    return curr_lexer->handle_token (HERMITIAN);
                  }
              }
          }
        else
          {
            if (! tok_id || tok_id == '[' || tok_id == '{' || tok_id == '('
                || curr_lexer->previous_token_is_binop ()
                || curr_lexer->previous_token_is_keyword ())
              {
                curr_lexer->m_filepos.increment_column ();
                curr_lexer->begin_string (SQ_STRING_START);
              }
            else
              {
                curr_lexer->m_filepos.increment_column ();
                return curr_lexer->handle_token (HERMITIAN);
              }
          }
      }
  }
	YY_BREAK

// Double quotes always begin strings.

case 63:
YY_RULE_SETUP
#line 1537 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("\\\"");

    if (curr_lexer->previous_token_may_be_command ()
        &&  curr_lexer->space_follows_previous_token ())
      {
        curr_lexer->m_filepos.increment_column ();
        curr_lexer->push_start_state (COMMAND_START);
        curr_lexer->begin_string (DQ_STRING_START);
      }
    else
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (curr_lexer->whitespace_is_significant ())
          {
            if (curr_lexer->space_follows_previous_token ())
              {
                if (tok_id == '[' || tok_id == '{'
                    || curr_lexer->previous_token_is_binop ())
                  {
                    curr_lexer->m_filepos.increment_column ();
                    curr_lexer->begin_string (DQ_STRING_START);
                  }
                else
                  {
                    yyless (0);
                    curr_lexer->xunput (',');
                  }
              }
            else
              {
                curr_lexer->m_filepos.increment_column ();
                curr_lexer->begin_string (DQ_STRING_START);
              }
          }
        else
          {
            curr_lexer->m_filepos.increment_column ();
            curr_lexer->begin_string (DQ_STRING_START);
          }
      }
  }
	YY_BREAK

// Other operators.

case 64:
YY_RULE_SETUP
#line 1585 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (":", ':', true); }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1586 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".*", EMUL, true); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1587 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("./", EDIV, true); }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1588 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".\\", ELEFTDIV, true); }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1589 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".^", EPOW, true); }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1590 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("<=", EXPR_LE, true); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1591 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("==", EXPR_EQ, true); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1592 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("!=", EXPR_NE, false); }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1593 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("~=", EXPR_NE, true); }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1594 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (">=", EXPR_GE, true); }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1595 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&", EXPR_AND, true); }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1596 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("|", EXPR_OR, true); }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1597 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("<", EXPR_LT, true); }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1598 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (">", EXPR_GT, true); }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 1599 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("*", '*', true); }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 1600 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("/", '/', true); }
	YY_BREAK

// In Matlab, '\' may also trigger command syntax.

case 80:
YY_RULE_SETUP
#line 1606 "../libinterp/parse-tree/lex.ll"
{
    // FIXME: After backslash is no longer handled as a line
    // continuation marker outside of character strings, this
    // action may be replaced with
    //
    //   CMD_OR_OP ("\\", LEFTDIV, true);

    curr_lexer->lexer_debug ("\\");

    return curr_lexer->handle_op (LEFTDIV);
  }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 1618 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("^", POW, true); }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1619 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&&", EXPR_AND_AND, true); }
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1620 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("||", EXPR_OR_OR, true); }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1622 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (";");

    bool at_beginning_of_statement
      = (! (curr_lexer->whitespace_is_significant ()
            || curr_lexer->m_looking_at_object_index.front ()));

    return curr_lexer->handle_op (';', at_beginning_of_statement);
  }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1632 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("+", '+', true); }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1633 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("-", '-', true); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1635 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("~", '~', true); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1636 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("!", '!', false); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1638 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (",");

    bool at_beginning_of_statement
      = (! (curr_lexer->whitespace_is_significant ()
            || curr_lexer->m_looking_at_object_index.front ()));

    return curr_lexer->handle_op (',', at_beginning_of_statement);
  }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1648 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".'");

    return curr_lexer->handle_op (TRANSPOSE);
  }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1654 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("++", PLUS_PLUS, false); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1655 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_UNARY_OP ("--", MINUS_MINUS, false); }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1657 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("(");

    bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (! (tok_id == '[' || tok_id == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        // If we are looking for an object index, then push TRUE for
        // m_looking_at_object_index.  Otherwise, just push whatever state
        // is current (so that we can pop it off the stack when we find
        // the matching close paren).

        curr_lexer->m_looking_at_object_index.push_front
          (curr_lexer->m_looking_for_object_index);

        curr_lexer->m_looking_at_indirect_ref = false;
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->m_nesting_level.paren ();

        return curr_lexer->handle_token ('(');
      }
  }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 1699 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (")");

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_nesting_level.remove ();

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    if (curr_lexer->m_looking_at_anon_fcn_args)
      {
        curr_lexer->m_looking_at_anon_fcn_args = false;
        curr_lexer->m_nesting_level.anon_fcn_body ();
      }

    return curr_lexer->handle_token (')');
  }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1720 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".");

    if (curr_lexer->previous_token_may_be_command ()
        && curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        curr_lexer->update_token_positions (yyleng);

        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        return curr_lexer->handle_token ('.');
      }
  }
	YY_BREAK

// = and op= operators.

case 96:
YY_RULE_SETUP
#line 1744 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("=");

    return curr_lexer->handle_op ('=');
  }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1750 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("+=", ADD_EQ, false); }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1751 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("-=", SUB_EQ, false); }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1752 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("*=", MUL_EQ, false); }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1753 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("/=", DIV_EQ, false); }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1754 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("\\=", LEFTDIV_EQ, false); }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1755 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".*=", EMUL_EQ, false); }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1756 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("./=", EDIV_EQ, false); }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1757 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".\\=", ELEFTDIV_EQ, false); }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1758 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("^=", POW_EQ, false); }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1759 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP (".^=", EPOW_EQ, false); }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1760 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("&=", AND_EQ, false); }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1761 "../libinterp/parse-tree/lex.ll"
{ CMD_OR_OP ("|=", OR_EQ, false); }
	YY_BREAK

// In Matlab, '{' may also trigger command syntax.

case 109:
YY_RULE_SETUP
#line 1767 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("{");

    bool unput_comma = false;

    if (curr_lexer->whitespace_is_significant ()
        && curr_lexer->space_follows_previous_token ())
      {
        int tok_id = curr_lexer->previous_token_id ();

        if (! (tok_id == '[' || tok_id == '{'
               || curr_lexer->previous_token_is_binop ()))
          unput_comma = true;
      }

    if (unput_comma)
      {
        yyless (0);
        curr_lexer->xunput (',');
      }
    else
      {
        curr_lexer->m_nesting_level.brace ();

        curr_lexer->m_looking_at_object_index.push_front
          (curr_lexer->m_looking_for_object_index);

        curr_lexer->m_filepos.increment_column (yyleng);
        curr_lexer->m_looking_for_object_index = false;
        curr_lexer->m_at_beginning_of_statement = false;

        curr_lexer->m_braceflag++;

        curr_lexer->push_start_state (MATRIX_START);

        return curr_lexer->handle_token ('{');
      }
  }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1806 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug ("}");

    curr_lexer->update_token_positions (yyleng);

    curr_lexer->m_looking_at_object_index.pop_front ();

    curr_lexer->m_looking_for_object_index = true;
    curr_lexer->m_at_beginning_of_statement = false;

    curr_lexer->m_nesting_level.remove ();

    return curr_lexer->handle_token ('}');
  }
	YY_BREAK

// Unrecognized input.  If the previous token may be a command and is
// followed by a space, parse the remainder of this statement as a
// command-style function call.  Otherwise, unrecognized input is a
// lexical error.

case 111:
YY_RULE_SETUP
#line 1828 "../libinterp/parse-tree/lex.ll"
{
    curr_lexer->lexer_debug (".");

    // Check for possible command syntax before doing any other operations
    // that may modify the input buffer.

    if (curr_lexer->previous_token_may_be_command ()
        && curr_lexer->space_follows_previous_token ())
      {
        yyless (0);
        curr_lexer->push_start_state (COMMAND_START);
      }
    else
      {
        curr_lexer->xunput (yytext[0]);

        int c = curr_lexer->text_yyinput ();

        if (c == 1)
          return -1;
        else if (c == EOF)
          return curr_lexer->handle_end_of_input ();
        else
          {
            std::ostringstream buf;

            buf << "invalid character '"
                << octave::undo_string_escape (static_cast<char> (c))
                << "' (ASCII " << c << ")";

            curr_lexer->update_token_positions (yyleng);

            return curr_lexer->syntax_error (buf.str ());
          }
      }
  }
	YY_BREAK

#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // Disable these warnings for flex code.
#  pragma GCC diagnostic ignored "-Wold-style-cast"
#  pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

case 112:
YY_RULE_SETUP
#line 1873 "../libinterp/parse-tree/lex.ll"
ECHO;
	YY_BREAK
#line 3565 "libinterp/parse-tree/lex.cc"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yyg->yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yyg->yy_last_accepting_state = yy_current_state;
			yyg->yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 290 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */
	char *yy_cp = yyg->yy_c_buf_p;

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yyg->yy_last_accepting_state = yy_current_state;
		yyg->yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 290 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 289);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp , yyscan_t yyscanner)
{
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yy_cp = yyg->yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yyg->yy_hold_char;

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = yyg->yy_n_chars + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			yyg->yy_n_chars = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	yyg->yytext_ptr = yy_bp;
	yyg->yy_hold_char = *yy_cp;
	yyg->yy_c_buf_p = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1873 "../libinterp/parse-tree/lex.ll"


#if defined (HAVE_PRAGMA_GCC_DIAGNOSTIC)
   // Restore prevailing warning state for remainder of the file.
#  pragma GCC diagnostic pop
#endif

void *
octave_alloc (yy_size_t size, yyscan_t)
{
  return std::malloc (size);
}

void *
octave_realloc (void *ptr, yy_size_t size, yyscan_t)
{
  return std::realloc (ptr, size);
}

void
octave_free (void *ptr, yyscan_t)
{
  std::free (ptr);
}

static void
display_character (char c)
{
  if (isgraph (c))
    std::cerr << c;
  else
    switch (c)
      {
      case 0:
        std::cerr << "NUL";
        break;

      case 1:
        std::cerr << "SOH";
        break;

      case 2:
        std::cerr << "STX";
        break;

      case 3:
        std::cerr << "ETX";
        break;

      case 4:
        std::cerr << "EOT";
        break;

      case 5:
        std::cerr << "ENQ";
        break;

      case 6:
        std::cerr << "ACK";
        break;

      case 7:
        std::cerr << "\\a";
        break;

      case 8:
        std::cerr << "\\b";
        break;

      case 9:
        std::cerr << "\\t";
        break;

      case 10:
        std::cerr << "\\n";
        break;

      case 11:
        std::cerr << "\\v";
        break;

      case 12:
        std::cerr << "\\f";
        break;

      case 13:
        std::cerr << "\\r";
        break;

      case 14:
        std::cerr << "SO";
        break;

      case 15:
        std::cerr << "SI";
        break;

      case 16:
        std::cerr << "DLE";
        break;

      case 17:
        std::cerr << "DC1";
        break;

      case 18:
        std::cerr << "DC2";
        break;

      case 19:
        std::cerr << "DC3";
        break;

      case 20:
        std::cerr << "DC4";
        break;

      case 21:
        std::cerr << "NAK";
        break;

      case 22:
        std::cerr << "SYN";
        break;

      case 23:
        std::cerr << "ETB";
        break;

      case 24:
        std::cerr << "CAN";
        break;

      case 25:
        std::cerr << "EM";
        break;

      case 26:
        std::cerr << "SUB";
        break;

      case 27:
        std::cerr << "ESC";
        break;

      case 28:
        std::cerr << "FS";
        break;

      case 29:
        std::cerr << "GS";
        break;

      case 30:
        std::cerr << "RS";
        break;

      case 31:
        std::cerr << "US";
        break;

      case 32:
        std::cerr << "SPACE";
        break;

      case 127:
        std::cerr << "DEL";
        break;
      }
}

OCTAVE_BEGIN_NAMESPACE(octave)

DEFUN (iskeyword, args, ,
       doc: /* -*- texinfo -*-
@deftypefn  {} {} iskeyword ()
@deftypefnx {} {} iskeyword (@var{name})
Return true if @var{name} is an Octave keyword.

If @var{name} is omitted, return a list of keywords.
@seealso{isvarname, exist}
@end deftypefn */)
{
  octave_value retval;

  int nargin = args.length ();

  if (nargin > 1)
    print_usage ();

  if (nargin == 0)
    {
      // Neither set nor get are keywords.  See the note in the
      // iskeyword function for additional details.

      string_vector lst (TOTAL_KEYWORDS);

      int j = 0;

      for (int i = 0; i < TOTAL_KEYWORDS; i++)
        {
          std::string kword = wordlist[i].name;

          // FIXME: The following check is duplicated in iskeyword.
          if (! (kword == "set" || kword == "get" || kword == "arguments"
                 || kword == "enumeration" || kword == "events"
                 || kword == "methods" || kword == "properties"))
            lst[j++] = kword;
        }

      lst.resize (j);

      retval = Cell (lst.sort ());
    }
  else
    {
      std::string name = args(0).xstring_value ("iskeyword: NAME must be a string");
      retval = iskeyword (name);
    }

  return retval;
}

/*

%!assert (iskeyword ("for"))
%!assert (iskeyword ("fort"), false)
%!assert (iskeyword ("fft"), false)
%!assert (iskeyword ("get"), false)
%!assert (iskeyword ("set"), false)

%!error iskeyword ("A", "B")
%!error <NAME must be a string> iskeyword (1)

*/

  void
  lexical_feedback::symbol_table_context::clear ()
  {
    while (! m_frame_stack.empty ())
      m_frame_stack.pop_front ();
  }

  void
  lexical_feedback::symbol_table_context::pop ()
  {
    if (empty ())
      error ("unexpected: empty stack in lexical_feedback::symbol_table_context::pop - please report this bug");

    m_frame_stack.pop_front ();
  }

  symbol_scope
  lexical_feedback::symbol_table_context::curr_scope () const
  {
    if (empty ())
      return m_interpreter.get_current_scope ();
    else
      return m_frame_stack.front ();
  }

  symbol_scope
  lexical_feedback::symbol_table_context::parent_scope () const
  {
    std::size_t sz = size ();

    return (sz > 1
            ? m_frame_stack[1]
            : (sz == 1 ? m_frame_stack[0] : symbol_scope::invalid ()));
  }

  lexical_feedback::~lexical_feedback ()
  {
    m_tokens.clear ();
  }

  void
  lexical_feedback::init ()
  {
    // The closest paren, brace, or bracket nesting is not an object
    // index.
    m_looking_at_object_index.push_front (false);
  }

  void
  lexical_feedback::reset ()
  {
    m_end_of_input = false;
    m_allow_command_syntax = true;
    m_at_beginning_of_statement = true;
    m_looking_at_anon_fcn_args = false;
    m_looking_at_return_list = false;
    m_looking_at_parameter_list = false;
    m_looking_at_decl_list = false;
    m_looking_at_matrix_or_assign_lhs = false;
    m_looking_for_object_index = false;
    m_looking_at_indirect_ref = false;
    m_arguments_is_keyword = false;
    m_classdef_element_names_are_keywords = false;
    m_parsing_anon_fcn_body = false;
    m_parsing_class_method = false;
    m_parsing_classdef = false;
    m_parsing_classdef_decl = false;
    m_parsing_classdef_superclass = false;
    m_maybe_classdef_get_set_method = false;
    m_parsing_classdef_get_method = false;
    m_parsing_classdef_set_method = false;
    m_quote_is_transpose = false;
    m_force_script = false;
    m_reading_fcn_file = false;
    m_reading_script_file = false;
    m_reading_classdef_file = false;
    m_buffer_function_text = false;
    m_comment_uses_hash_char = false;
    m_bracketflag = 0;
    m_braceflag = 0;
    m_looping = 0;
    m_defining_fcn = 0;
    m_looking_at_function_handle = 0;
    m_block_comment_nesting_level = 0;
    m_command_arg_paren_count = 0;
    m_token_count = 0;
    m_filepos = filepos (1, 1);
    m_tok_beg = filepos ();
    m_tok_end = filepos ();
    m_string_text = "";
    m_current_input_line = "";
    m_comment_text = "";
    m_function_text = "";
    m_fcn_file_name = "";
    m_fcn_file_full_name = "";
    m_dir_name = "";
    m_package_name = "";
    m_looking_at_object_index.clear ();
    m_looking_at_object_index.push_front (false);

    while (! m_parsed_function_name.empty ())
      m_parsed_function_name.pop ();

    m_symtab_context.clear ();
    m_nesting_level.reset ();
    m_tokens.clear ();
  }

  token *
  lexical_feedback::previous_token ()
  {
    return m_tokens.front ();
  }

  const token *
  lexical_feedback::previous_token () const
  {
    return m_tokens.front ();
  }

  int
  lexical_feedback::previous_token_id () const
  {
    const token *prev_tok = previous_token ();
    return prev_tok ? prev_tok->token_id () : 0;
  }

  bool
  lexical_feedback::previous_token_is (int tok_id) const
  {
    const token *prev_tok = previous_token ();
    return prev_tok ? prev_tok->token_is (tok_id) : false;
  }

  bool
  lexical_feedback::previous_token_is (const token *tok) const
  {
    const token *prev_tok = previous_token ();
    return prev_tok ? prev_tok->token_is (tok) : false;
  }

  void
  lexical_feedback::mark_previous_token_trailing_space ()
  {
    token *prev_tok = previous_token ();
    if (prev_tok && ! previous_token_is ('\n'))
      prev_tok->mark_trailing_space ();
  }

  bool
  lexical_feedback::space_follows_previous_token () const
  {
    const token *prev_tok = previous_token ();
    return prev_tok ? prev_tok->space_follows_token () : false;
  }

  bool
  lexical_feedback::previous_token_is_binop () const
  {
    int tok_id = previous_token_id ();

    return (tok_id == '+' || tok_id == '-' || tok_id == '@' || tok_id == '~' || tok_id == '!'
            || tok_id == ',' || tok_id == ';' || tok_id == '*' || tok_id == '/'
            || tok_id == ':' || tok_id == '=' || tok_id == ADD_EQ
            || tok_id == AND_EQ || tok_id == DIV_EQ || tok_id == EDIV
            || tok_id == EDIV_EQ || tok_id == ELEFTDIV || tok_id == ELEFTDIV_EQ
            || tok_id == EMUL || tok_id == EMUL_EQ
            || tok_id == EPOW || tok_id == EPOW_EQ || tok_id == EXPR_AND
            || tok_id == EXPR_AND_AND || tok_id == EXPR_EQ || tok_id == EXPR_GE
            || tok_id == EXPR_GT || tok_id == EXPR_LE || tok_id == EXPR_LT
            || tok_id == EXPR_NE || tok_id == EXPR_OR
            || tok_id == EXPR_OR_OR || tok_id == LEFTDIV || tok_id == LEFTDIV_EQ
            || tok_id == MUL_EQ || tok_id == OR_EQ || tok_id == POW
            || tok_id == POW_EQ || tok_id == SUB_EQ);
  }

  bool
  lexical_feedback::previous_token_is_keyword () const
  {
    const token *prev_tok = previous_token ();
    return prev_tok ? prev_tok->iskeyword () : false;
  }

  void
  lexical_feedback::mark_as_variable (const std::string& nm)
  {
    symbol_scope scope = m_symtab_context.curr_scope ();

    if (scope)
      scope.mark_as_variable (nm);
  }

  void
  lexical_feedback::mark_as_variables (const std::list<std::string>& lst)
  {
    symbol_scope scope = m_symtab_context.curr_scope ();

    if (scope)
      scope.mark_as_variables (lst);
  }

  bool
  lexical_feedback::previous_token_may_be_command () const
  {
    if (! m_allow_command_syntax)
      return false;

    const token *prev_tok = previous_token ();
    return prev_tok ? prev_tok->may_be_command () : false;
  }

static bool
looks_like_copyright (const std::string& s)
{
  if (s.empty ())
    return false;

  // Comment characters have been stripped but whitespace
  // (including newlines) remains.

  std::size_t offset = s.find_first_not_of (" \t\n\r");

  return (offset != std::string::npos
          && (s.substr (offset, 9) == "Copyright"
              || s.substr (offset, 6) == "Author"
              || s.substr (offset, 23) == "SPDX-License-Identifier"));
}

static bool
looks_like_shebang (const std::string& s)
{
  return ((! s.empty ()) && (s[0] == '!'));
}

  void
  base_lexer::input_buffer::fill (const std::string& input, bool eof_arg)
  {
    m_buffer = input;
    m_chars_left = m_buffer.length ();
    m_offset = 0;
    m_eof = eof_arg;
  }

  // If BY_LINES is true, return chunks to the lexer line by line.
  int
  base_lexer::input_buffer::copy_chunk (char *buf, std::size_t max_size,
                                        bool by_lines)
  {
    static const char * const eol = "\n";

    std::size_t len = 0;
    if (by_lines)
      {
        std::size_t newline_pos = m_buffer.find ('\n', m_offset);
        len = (newline_pos != std::string::npos
               ? newline_pos - m_offset + 1
               : (max_size > m_chars_left ? m_chars_left : max_size));
      }
    else
      len = max_size > m_chars_left ? m_chars_left : max_size;

    if (len <= 0)
      error ("unexpected: buffer underflow in base_lexer::input_buffer::copy_chunk - please report this bug");

    memcpy (buf, m_buffer.c_str () + m_offset, len);

    m_chars_left -= len;
    m_offset += len;

    // Make sure the final input returned to the lexer ends with a new
    // line character.

    if (m_chars_left == 0 && buf[len-1] != '\n')
      {
        if (len < max_size)
          {
            // There is enough room to plug the newline character in
            // the buffer.
            buf[len++] = '\n';
          }
        else
          {
            // There isn't enough room to plug the newline character
            // in BUF so arrange to have it returned on the next call
            // to base_lexer::read.

            // At this point we've exhausted the original input
            // (m_chars_left is zero) so we can overwrite the initial
            // buffer with a single newline character to be returned on
            // the next call.

            m_buffer = eol;
            m_chars_left = 1;
            m_offset = 0;
          }
      }

    return len;
  }

  base_lexer::~base_lexer ()
  {
    yylex_destroy (m_scanner);
  }

  void
  base_lexer::init ()
  {
    yylex_init (&m_scanner);

    // Make base_lexer object available through yyextra in
    // flex-generated lexer.
    yyset_extra (this, m_scanner);

    clear_start_state ();
  }

  // Inside Flex-generated functions, yyg is the scanner cast to its real
  // type.  Some flex macros that we use in base_lexer member functions
  // (for example, BEGIN) use yyg.  If we could perform the actions of
  // these macros with functions instead, we could eliminate the
  // OCTAVE_YYG macro.

#define OCTAVE_YYG                                                      \
  struct yyguts_t *yyg = static_cast<struct yyguts_t*> (m_scanner)

  void
  base_lexer::reset ()
  {
    // Start off on the right foot.
    clear_start_state ();

    m_symtab_context.clear ();

    // Only ask for input from stdin if we are expecting interactive
    // input.

    if (m_interpreter.interactive ()
        && ! (m_reading_fcn_file
              || m_reading_classdef_file
              || m_reading_script_file
              || input_from_eval_string ()))
      yyrestart (stdin, m_scanner);

    lexical_feedback::reset ();

    m_comment_list.clear ();
  }

  void
  base_lexer::prep_for_file ()
  {
    m_reading_script_file = true;

    push_start_state (INPUT_FILE_START);
  }

  void
  base_lexer::begin_string (int state)
  {
    m_tok_beg = m_filepos;

    push_start_state (state);
  }

  int
  base_lexer::handle_end_of_input ()
  {
    lexer_debug ("<<EOF>>");

    m_tok_beg = m_filepos;
    m_tok_end = m_filepos;

    if (m_block_comment_nesting_level != 0)
      {
        std::string msg {"block comment unterminated at end of input"};

        if ((m_reading_fcn_file || m_reading_script_file || m_reading_classdef_file)
            && ! m_fcn_file_name.empty ())
          msg += " near line " + std::to_string (m_filepos.line () - 1) + " of file '" + m_fcn_file_name + ".m'";

        syntax_error (msg);
      }

    token *tok = new token (END_OF_INPUT, m_tok_beg, m_tok_end, get_comment_list ());

    return handle_token (tok);
  }

  char *
  base_lexer::flex_yytext ()
  {
    return yyget_text (m_scanner);
  }

  int
  base_lexer::flex_yyleng ()
  {
    return yyget_leng (m_scanner);
  }

  int
  base_lexer::text_yyinput ()
  {
    int c = yyinput (m_scanner);

    if (debug_flag ())
      {
        std::cerr << "I: ";
        display_character (c);
        std::cerr << std::endl;
      }

    // Convert CRLF into just LF and single CR into LF.

    if (c == '\r')
      {
        c = yyinput (m_scanner);

        if (debug_flag ())
          {
            std::cerr << "I: ";
            display_character (c);
            std::cerr << std::endl;
          }

        if (c != '\n')
          {
            xunput (c);
            c = '\n';
          }
      }

    return c;
  }

  void
  base_lexer::xunput (char c, char *buf)
  {
    if (c != EOF)
      {
        if (debug_flag ())
          {
            std::cerr << "U: ";
            display_character (c);
            std::cerr << std::endl;
          }

        yyunput (c, buf, m_scanner);
      }
  }

  void
  base_lexer::xunput (char c)
  {
    char *yytxt = flex_yytext ();

    xunput (c, yytxt);
  }

  void
  base_lexer::update_token_positions (int tok_len)
  {
    m_tok_beg = m_filepos;
    m_tok_end = m_filepos;

    if (tok_len > 1)
      m_tok_end.increment_column (tok_len - 1);

    m_filepos.increment_column (tok_len);
  }

  bool
  base_lexer::looking_at_space ()
  {
    int c = text_yyinput ();
    xunput (c);
    return is_space_or_tab (c);
  }

  bool
  base_lexer::inside_any_object_index ()
  {
    bool retval = false;

    for (const bool is_obj_idx : m_looking_at_object_index)
      {
        if (is_obj_idx)
          {
            retval = true;
            break;
          }
      }

    return retval;
  }

  token *
  base_lexer::make_keyword_token (const std::string& s)
  {
    // Token positions should have already been updated before this
    // function is called.

    int slen = s.length ();

    const octave_kw *kw = octave_kw_hash::in_word_set (s.c_str (), slen);

    if (! kw)
      return nullptr;

    bool previous_at_bos = m_at_beginning_of_statement;

    // May be reset to true for some token types.
    m_at_beginning_of_statement = false;

    token *tok = nullptr;

    switch (kw->kw_id)
      {
      case break_kw:
      case catch_kw:
      case continue_kw:
      case else_kw:
      case otherwise_kw:
      case return_kw:
      case unwind_protect_cleanup_kw:
        m_at_beginning_of_statement = true;
        break;

      case persistent_kw:
      case global_kw:
        m_looking_at_decl_list = true;
        break;

      case case_kw:
      case elseif_kw:
      case until_kw:
        break;

      case end_kw:
        if (inside_any_object_index ()
            || (m_defining_fcn
                && ! (m_looking_at_return_list
                      || m_parsed_function_name.top ())))
          {
            m_at_beginning_of_statement = previous_at_bos;
            return nullptr;
          }

        tok = new token (kw->tok_id, token::simple_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case end_try_catch_kw:
        tok = new token (kw->tok_id, token::try_catch_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case end_unwind_protect_kw:
        tok = new token (kw->tok_id, token::unwind_protect_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endfor_kw:
        tok = new token (kw->tok_id, token::for_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endfunction_kw:
        tok = new token (kw->tok_id, token::function_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endif_kw:
        tok = new token (kw->tok_id, token::if_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endparfor_kw:
        tok = new token (kw->tok_id, token::parfor_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endswitch_kw:
        tok = new token (kw->tok_id, token::switch_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endwhile_kw:
        tok = new token (kw->tok_id, token::while_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endarguments_kw:
#if defined (DISABLE_ARGUMENTS_VALIDATION_BLOCK)
        return nullptr;
#else
        tok = new token (kw->tok_id, token::arguments_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;
#endif

      case endclassdef_kw:
        tok = new token (kw->tok_id, token::classdef_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endenumeration_kw:
        tok = new token (kw->tok_id, token::enumeration_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endevents_kw:
        tok = new token (kw->tok_id, token::events_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endmethods_kw:
        tok = new token (kw->tok_id, token::methods_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case endproperties_kw:
        tok = new token (kw->tok_id, token::properties_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case for_kw:
      case parfor_kw:
      case while_kw:
        m_looping++;
        break;

      case do_kw:
        m_at_beginning_of_statement = true;
        m_looping++;
        break;

      case try_kw:
      case unwind_protect_kw:
        m_at_beginning_of_statement = true;
        break;

      case if_kw:
      case switch_kw:
        break;

      case get_kw:
      case set_kw:
        // 'get' and 'set' are keywords in classdef method
        // declarations.
        if (! m_maybe_classdef_get_set_method)
          {
            m_at_beginning_of_statement = previous_at_bos;
            return nullptr;
          }
        break;

      case enumeration_kw:
      case events_kw:
      case methods_kw:
      case properties_kw:
        // 'properties', 'methods' and 'events' are keywords for
        // classdef blocks.
        if (! m_classdef_element_names_are_keywords)
          {
            m_at_beginning_of_statement = previous_at_bos;
            return nullptr;
          }
        // fall through ...

      case classdef_kw:
        // 'classdef' is always a keyword.
        if (! m_force_script && m_token_count == 0 && input_from_file ())
          {
            m_reading_classdef_file = true;
            m_reading_script_file = false;
          }
        break;

      case function_kw:
        m_defining_fcn++;
        m_parsed_function_name.push (false);

        if (! m_force_script && m_token_count == 0 && input_from_file ())
          {
            m_reading_fcn_file = true;
            m_reading_script_file = false;
          }

        // FIXME: should we be asking directly whether input is coming
        // from an eval string instead of that it is not coming from a
        // file?

        if (! (m_reading_fcn_file || m_reading_script_file
               || m_reading_classdef_file))
          {
            // Input must be coming from the terminal or stdin?
            m_buffer_function_text = true;
            m_function_text += (m_current_input_line + "\n");

            // FIXME: do we need to save and restore the file position
            // or just reset the line number here?  The goal is to
            // track line info for command-line functions relative
            // to the function keyword.  Should we really be setting
            // the line and column info to (1, 1) here?

            m_filepos = filepos (1, 1);
            update_token_positions (slen);
          }
        break;

      case arguments_kw:
#if defined (DISABLE_ARGUMENTS_VALIDATION_BLOCK)
        return nullptr;
#else
        if (! m_arguments_is_keyword)
          return nullptr;
        break;
#endif

      case spmd_kw:
        m_at_beginning_of_statement = true;
        break;

      case endspmd_kw:
        tok = new token (kw->tok_id, token::spmd_end, m_tok_beg, m_tok_end, get_comment_list ());
        m_at_beginning_of_statement = true;
        break;

      case magic_file_kw:
        {
          if ((m_reading_fcn_file || m_reading_script_file
               || m_reading_classdef_file)
              && ! m_fcn_file_full_name.empty ())
            tok = new token (kw->tok_id, m_fcn_file_full_name, m_tok_beg, m_tok_end, get_comment_list ());
          else
            tok = new token (kw->tok_id, "stdin", m_tok_beg, m_tok_end, get_comment_list ());
        }
        break;

      case magic_line_kw:
        {
          int l = m_tok_beg.line ();
          octave_value ov_value (static_cast<double> (l));
          tok = new token (kw->tok_id, ov_value, "", m_tok_beg, m_tok_end, get_comment_list ());
        }
        break;

        // We should have handled all possible enum values above.  Rely
        // on compiler diagnostics to warn if we haven't.  For example,
        // GCC's -Wswitch option, enabled by -Wall, will provide a
        // warning.
      }

    if (! tok)
      tok = new token (kw->tok_id, true, m_tok_beg, m_tok_end, get_comment_list ());

    return tok;
  }

/*

## check if magic file and line keywords are working
%!assert <*62587> (ischar (__FILE__))
%!assert <*62587> (isnumeric (__LINE__))

*/

  bool
  base_lexer::fq_identifier_contains_keyword (const std::string& s)
  {
    std::size_t p1 = 0;
    std::size_t p2;

    std::string s_part;

    do
      {
        p2 = s.find ('.', p1);

        if (p2 != std::string::npos)
          {
            s_part = s.substr (p1, p2 - p1);
            p1 = p2 + 1;
          }
        else
          s_part = s.substr (p1);

        if (iskeyword (s_part))
          return true;
      }
    while (p2 != std::string::npos);

    return false;
  }

  bool
  base_lexer::whitespace_is_significant ()
  {
    return (m_nesting_level.is_bracket ()
            || (m_nesting_level.is_brace ()
                && ! m_looking_at_object_index.front ()));
  }

static inline bool
looks_like_bin (const char *s, int len)
{
  return (len > 2 && s[0] == '0' && (s[1] == 'b' || s[1] == 'B'));
}

static inline bool
looks_like_hex (const char *s, int len)
{
  return (len > 2 && s[0] == '0' && (s[1] == 'x' || s[1] == 'X'));
}

OCTAVE_NORETURN static void
error_unexpected_bytes (int bytes)
{
  error ("unexpected: bytes (= %d) not 1, 2, 4, or 8 in make_integer_value - please report this bug", bytes);
}

static inline octave_value
make_integer_value (uintmax_t long_int_val, bool unsigned_val, int bytes)
{
  if (unsigned_val)
    {
     switch (bytes)
       {
       case 1:
         return octave_value (octave_uint8 (long_int_val));

       case 2:
         return octave_value (octave_uint16 (long_int_val));

       case 4:
         return octave_value (octave_uint32 (long_int_val));

       case 8:
         return octave_value (octave_uint64 (long_int_val));

       default:
         error_unexpected_bytes (bytes);
       };
    }
  else
    {
      // FIXME: Conversion to signed values is supposed to follow
      // twos-complement rules.  Do we need to be more carefule here?

      switch (bytes)
        {
        case 1:
          return octave_value (octave_int8 (int8_t (long_int_val)));

        case 2:
          return octave_value (octave_int16 (int16_t (long_int_val)));

        case 4:
          return octave_value (octave_int32 (int32_t (long_int_val)));

        case 8:
        return octave_value (octave_int64 (int64_t (long_int_val)));

        default:
          error_unexpected_bytes (bytes);
        };
    }

  return octave_value ();
}

  template <>
  int
  base_lexer::handle_number<2> ()
  {
    // Skip 0[bB] prefix.
    std::string yytxt (flex_yytext () + 2);

    yytxt.erase (std::remove (yytxt.begin (), yytxt.end (), '_'),
                 yytxt.end ());

    std::size_t pos = yytxt.find_first_of ("su");

    bool unsigned_val = true;
    int bytes = -1;

    if (pos == std::string::npos)
      {
        std::size_t num_digits = yytxt.length ();

        if (num_digits <= 8)
          bytes = 1;
        else if (num_digits <= 16)
          bytes = 2;
        else if (num_digits <= 32)
          bytes = 4;
        else if (num_digits <= 64)
          bytes = 8;
      }
    else
      {
        unsigned_val = (yytxt[pos] == 'u');
        std::string size_str = yytxt.substr (pos+1);
        yytxt = yytxt.substr (0, pos);
        std::size_t num_digits = yytxt.length ();

        if (size_str == "8" && num_digits <= 8)
          bytes = 1;
        else if (size_str == "16" && num_digits <= 16)
          bytes = 2;
        else if (size_str == "32" && num_digits <= 32)
          bytes = 4;
        else if (size_str == "64" && num_digits <= 64)
          bytes = 8;
      }

    if (bytes < 0)
      {
        std::string msg {"too many digits for binary constant"};
        return syntax_error (msg);
      }

    // FIXME: is there a better way?  Can uintmax_t be anything other
    // than long or long long?  Should we just be using uint64_t instead
    // of uintmax_t?

    errno = 0;
    char *end;
    uintmax_t long_int_val;
    if (sizeof (uintmax_t) == sizeof (unsigned long long))
      long_int_val = strtoull (yytxt.c_str (), &end, 2);
    else if (sizeof (uintmax_t) == sizeof (unsigned long))
      long_int_val = strtoul (yytxt.c_str (), &end, 2);
    else
      error ("unexpected: size mismatch: uintmax_t vs unsigned long or unsigned long long in base_lexer::handle_number<2> - please report this bug");

    if (errno == ERANGE)
      error ("unexpected: ERANGE error in base_lexer::handle_number<2> - please report this bug");

    octave_value ov_value
      = make_integer_value (long_int_val, unsigned_val, bytes);

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = false;

    update_token_positions (flex_yyleng ());

    token *tok = new token (NUMBER, ov_value, yytxt, m_tok_beg, m_tok_end, get_comment_list ());

    return handle_token (tok);
  }

  static uint64_t
  flintmax ()
  {
    return (static_cast<uint64_t> (1) << std::numeric_limits<double>::digits);
  }

  template <>
  int
  base_lexer::handle_number<10> ()
  {
    bool imag = false;
    bool digits_only = true;

    char *yytxt = flex_yytext ();
    std::size_t yylng = flex_yyleng ();

    OCTAVE_LOCAL_BUFFER (char, tmptxt, yylng + 1);
    char *rp = yytxt;
    char *p = &tmptxt[0];

    char ch;
    while ((ch = *rp++))
      {
        switch (ch)
          {
          case '_':
            break;

          case 'D':
          case 'd':
            *p++ = 'e';
            digits_only = false;
            break;

          case 'I':
          case 'J':
          case 'i':
          case 'j':
            // Octave does not provide imaginary integers.
            digits_only = false;
            imag = true;
            break;

          case '+':
          case '-':
          case '.':
          case 'E':
          case 'e':
            digits_only = false;
            *p++ = ch;
            break;

          default:
            *p++ = ch;
            break;
          }
      }

    *p = '\0';

    double value = 0.0;
    if (sscanf (tmptxt, "%lf", &value) != 1)
      fatal_error ("scanf failed in base_lexer::handle_number<10> - please report this bug");

    octave_value ov_value;

    // Use >= because > will not return true until value is greater than
    // flintmax + 2!

    if (digits_only && value >= flintmax ())
      {
        // Try reading as an unsigned 64-bit integer.  If there is a
        // range error, then create a double value.  Otherwise, create a
        // special uint64 object that will be automatically converted to
        // double unless it appears as the argument to one of the int64
        // or uint64 functions.

        errno = 0;
        char *end;
        uintmax_t long_int_val;
        if (sizeof (uintmax_t) == sizeof (unsigned long long))
          long_int_val = strtoull (tmptxt, &end, 10);
        else if (sizeof (uintmax_t) == sizeof (unsigned long))
          long_int_val = strtoul (tmptxt, &end, 10);
        else
          error ("unexpected: size mismatch: uintmax_t vs unsigned long or unsigned long long in base_lexer::handle_number<10> - please report this bug");

        if (errno != ERANGE)
          {
            // If possible, store the value as a signed integer.

            octave_base_value *magic_int;
            if (long_int_val > std::numeric_limits<int64_t>::max ())
              magic_int = new octave_magic_uint (octave_uint64 (long_int_val));
            else
              magic_int = new octave_magic_int (octave_int64 (long_int_val));

            ov_value = octave_value (magic_int);
          }
      }

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = false;

    update_token_positions (yylng);

    if (ov_value.is_undefined ())
      ov_value = (imag
                  ? octave_value (Complex (0.0, value))
                  : octave_value (value));

    token *tok = new token (NUMBER, ov_value, yytxt, m_tok_beg, m_tok_end, get_comment_list ());

    return handle_token (tok);
  }

  template <>
  int
  base_lexer::handle_number<16> ()
  {
    // Skip 0[xX] prefix.
    std::string yytxt (flex_yytext () + 2);

    yytxt.erase (std::remove (yytxt.begin (), yytxt.end (), '_'),
                 yytxt.end ());

    std::size_t pos = yytxt.find_first_of ("su");

    bool unsigned_val = true;
    int bytes = -1;

    if (pos == std::string::npos)
      {
        std::size_t num_digits = yytxt.length ();

        if (num_digits <= 2)
          bytes = 1;
        else if (num_digits <= 4)
          bytes = 2;
        else if (num_digits <= 8)
          bytes = 4;
        else if (num_digits <= 16)
          bytes = 8;
      }
    else
      {
        unsigned_val = (yytxt[pos] == 'u');
        std::string size_str = yytxt.substr (pos+1);
        yytxt = yytxt.substr (0, pos);
        std::size_t num_digits = yytxt.length ();

        if (size_str == "8" && num_digits <= 2)
          bytes = 1;
        else if (size_str == "16" && num_digits <= 4)
          bytes = 2;
        else if (size_str == "32" && num_digits <= 8)
          bytes = 4;
        else if (size_str == "64" && num_digits <= 16)
          bytes = 8;
      }

    if (bytes < 0)
      {
        std::string msg {"too many digits for hexadecimal constant"};
        return syntax_error (msg);
      }

    uintmax_t long_int_val;
    if (sscanf (yytxt.c_str (), "%jx", &long_int_val) != 1)
      fatal_error ("sscanf failed in base_lexer::handle_number<16> - please report this bug");

    octave_value ov_value = make_integer_value (long_int_val, unsigned_val, bytes);

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = false;

    update_token_positions (flex_yyleng ());

    token *tok = new token (NUMBER, ov_value, yytxt, m_tok_beg, m_tok_end, get_comment_list ());

    return handle_token (tok);
  }

  void
  base_lexer::handle_continuation ()
  {
    char *yytxt = flex_yytext ();
    int yylng = flex_yyleng ();

    int offset = 1;
    if (yytxt[0] == '\\')
      warn_language_extension_continuation ();
    else
      offset = 3;

    bool have_space = false;
    while (offset < yylng)
      {
        char c = yytxt[offset];
        if (is_space_or_tab (c))
          {
            have_space = true;
            offset++;
          }
        else
          break;
      }

    if (have_space)
      mark_previous_token_trailing_space ();

    bool have_comment = false;
    bool first = true;
    while (offset < yylng)
      {
        char c = yytxt[offset];

        if (c == '#' || c == '%')
          {
            if (first && c == '#')
              {
                m_comment_uses_hash_char = true;
                first = false;
              }

            have_comment = true;
            offset++;
          }
        else
          break;
      }

    if (have_comment)
      {
        m_comment_text = &yytxt[offset];

        // finish_comment sets m_at_beginning_of_statement to true but
        // that's not be correct if we are handling a continued
        // statement.  Preserve the current state.

        bool saved_bos = m_at_beginning_of_statement;

        finish_comment (comment_elt::end_of_line);

        m_at_beginning_of_statement = saved_bos;
      }

    m_filepos.next_line ();
  }

  void
  base_lexer::finish_comment (comment_elt::comment_type typ)
  {
    if (looks_like_copyright (m_comment_text))
      typ = comment_elt::copyright;

    m_comment_list.append (m_comment_text, typ, m_comment_uses_hash_char);

    m_comment_text = "";
    m_comment_uses_hash_char = false;
    m_at_beginning_of_statement = true;
  }

  int
  base_lexer::handle_close_bracket (int bracket_type)
  {
    m_looking_at_object_index.pop_front ();

    m_looking_for_object_index = true;
    m_at_beginning_of_statement = false;

    if (! m_nesting_level.none ())
      {
        m_nesting_level.remove ();

        if (bracket_type == ']')
          m_bracketflag--;
        else if (bracket_type == '}')
          m_braceflag--;
        else
          error ("unexpected: bracket_type not ']' or '}' in base_lexer::handle_close_bracket - please report this bug");
      }

    pop_start_state ();

    return handle_token (bracket_type);
  }

  bool
  base_lexer::looks_like_command_arg ()
  {
    if (! m_allow_command_syntax)
      return false;

    bool space_before = space_follows_previous_token ();
    bool space_after = looking_at_space ();

    return (space_before && ! space_after
            && previous_token_may_be_command ());
  }

  int
  base_lexer::handle_superclass_identifier ()
  {
    update_token_positions (flex_yyleng ());

    std::string txt = flex_yytext ();

    txt.erase (std::remove_if (txt.begin (), txt.end (), is_space_or_tab),
               txt.end ());

    std::size_t pos = txt.find ("@");

    std::string meth = txt.substr (0, pos);
    std::string cls = txt.substr (pos + 1);

    if (iskeyword (meth) || fq_identifier_contains_keyword (cls))
      {
        std::string msg {"method, class, and package names may not be keywords"};
        return syntax_error (msg);
      }

    token *tok = new token (SUPERCLASSREF, meth, cls, m_tok_beg, m_tok_end, get_comment_list ());

    m_filepos.increment_column (flex_yyleng ());

    return handle_token (tok);
  }

  token *
  base_lexer::make_meta_identifier_token (const std::string& cls)
  {
    // Token positions should have already been updated before this
    // function is called.

    m_looking_for_object_index = true;

    token *tok = new token (METAQUERY, cls, m_tok_beg, m_tok_end, get_comment_list ());

    m_filepos.increment_column (flex_yyleng ());

    return tok;
  }

  token *
  base_lexer::make_fq_identifier_token (const std::string& ident)
  {
    // Token positions should have already been updated before this
    // function is called.

    m_looking_for_object_index = true;

    token *tok = new token (FQ_IDENT, ident, m_tok_beg, m_tok_end, get_comment_list ());

    m_filepos.increment_column (flex_yyleng ());

    return tok;
  }

  // Figure out exactly what kind of token to return when we have seen
  // an identifier.  Handles keywords.  Return -1 if the identifier
  // should be ignored.

  int
  base_lexer::handle_identifier ()
  {
    update_token_positions (flex_yyleng ());

    std::string ident = flex_yytext ();

    // If we are expecting a structure element, avoid recognizing
    // keywords and other special names and return STRUCT_ELT, which is
    // a string that is also a valid identifier.

    if (m_looking_at_indirect_ref)
      {
        token *tok = new token (STRUCT_ELT, ident, m_tok_beg, m_tok_end, get_comment_list ());

        m_looking_for_object_index = true;

        return handle_token (tok);
      }

    // If ident is a keyword token, then make_keyword_token will set
    // m_at_beginning_of_statement.  For example, if tok is an IF
    // token, then m_at_beginning_of_statement will be false.

    token *tok = make_keyword_token (ident);

    // If we have a regular keyword, return it.
    // Keywords can be followed by identifiers.

    if (tok)
      {
        m_looking_for_object_index = false;

        // The call to make_keyword_token set m_at_beginning_of_statement.

        return handle_token (tok);
      }

    tok = new token (NAME, ident, m_tok_beg, m_tok_end, get_comment_list ());

    // For compatibility with Matlab, the following symbols are
    // handled specially so that things like
    //
    //   pi +1
    //
    // are parsed as an addition expression instead of as a command-style
    // function call with the argument "+1".

    if (m_at_beginning_of_statement
        && ! (m_parsing_anon_fcn_body
              || ident == "e" || ident == "pi"
              || ident == "I" || ident == "i"
              || ident == "J" || ident == "j"
              || ident == "Inf" || ident == "inf"
              || ident == "NaN" || ident == "nan"))
      tok->mark_may_be_command ();

    // The magic end index can't be indexed.

    if (ident != "end")
      m_looking_for_object_index = true;

    m_at_beginning_of_statement = false;

    return handle_token (tok);
  }

  void
  base_lexer::check_comment_for_hash_char (const char *txt, std::size_t len)
  {
    if (m_comment_uses_hash_char)
      return;

    std::size_t i = 0;
    while (i < len && is_space_or_tab (txt[i]))
      i++;

    m_comment_uses_hash_char = txt[i] == '#';
  }

  void
  base_lexer::maybe_warn_separator_insert (char sep)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:separator-insert",
                       "potential auto-insertion of '%c' near line %d",
                       sep, m_filepos.line ());
    else
      warning_with_id ("Octave:separator-insert",
                       "potential auto-insertion of '%c' near line %d of file %s",
                       sep, m_filepos.line (), nm.c_str ());
  }

  void
  base_lexer::warn_language_extension (const std::string& msg)
  {
    std::string nm = m_fcn_file_full_name;

    if (nm.empty ())
      warning_with_id ("Octave:language-extension",
                       "Octave language extension used: %s",
                       msg.c_str ());
    else
      warning_with_id ("Octave:language-extension",
                       "Octave language extension used: %s near line %d of file %s",
                       msg.c_str (), m_filepos.line (), nm.c_str ());
  }

  void
  base_lexer::maybe_warn_language_extension_comment (char c)
  {
    if (c == '#')
      warn_language_extension ("# used as comment character");
  }

  void
  base_lexer::warn_language_extension_continuation ()
  {
    warn_language_extension ("\\ used as line continuation marker");
  }

  void
  base_lexer::warn_language_extension_operator (const std::string& op)
  {
    std::string t = op;
    int n = t.length ();
    if (t[n-1] == '\n')
      t.resize (n-1);
    warn_language_extension (t + " used as operator");
  }

  void
  base_lexer::warn_deprecated_syntax (const std::string& msg)
  {
    if (m_fcn_file_full_name.empty ())
      warning_with_id ("Octave:deprecated-syntax", "%s", msg.c_str ());
    else
      warning_with_id ("Octave:deprecated-syntax",
                       "%s; near line %d of file '%s'", msg.c_str (),
                       m_filepos.line (), m_fcn_file_full_name.c_str ());
  }

  int
  base_lexer::syntax_error (const std::string& msg)
  {
    return syntax_error (msg, m_tok_beg, m_tok_end);
  }

  int
  base_lexer::syntax_error (const std::string& msg, const filepos& pos)
  {
    return syntax_error (msg, pos, pos);
  }

  int
  base_lexer::syntax_error (const std::string& msg, const filepos& beg_pos, const filepos& end_pos)
  {
    token *tok = new token (LEXICAL_ERROR, msg, beg_pos, end_pos);

    push_token (tok);

    return count_token_internal (tok->token_id ());
  }

  void
  base_lexer::push_token (token *tok)
  {
    YYSTYPE *lval = yyget_lval (m_scanner);
    lval->tok = tok;
    m_tokens.push (tok);
  }

  token *
  base_lexer::current_token ()
  {
    YYSTYPE *lval = yyget_lval (m_scanner);
    return lval->tok;
  }

  std::size_t
  base_lexer::pending_token_count () const
  {
    return m_tokens.size ();
  }

  void
  base_lexer::display_token (int tok_id)
  {
    switch (tok_id)
      {
      case '=': std::cerr << "'='\n"; break;
      case ':': std::cerr << "':'\n"; break;
      case '-': std::cerr << "'-'\n"; break;
      case '+': std::cerr << "'+'\n"; break;
      case '*': std::cerr << "'*'\n"; break;
      case '/': std::cerr << "'/'\n"; break;
      case '~': std::cerr << "'~'\n"; break;
      case '!': std::cerr << "'!'\n"; break;
      case ADD_EQ: std::cerr << "ADD_EQ\n"; break;
      case SUB_EQ: std::cerr << "SUB_EQ\n"; break;
      case MUL_EQ: std::cerr << "MUL_EQ\n"; break;
      case DIV_EQ: std::cerr << "DIV_EQ\n"; break;
      case LEFTDIV_EQ: std::cerr << "LEFTDIV_EQ\n"; break;
      case POW_EQ: std::cerr << "POW_EQ\n"; break;
      case EMUL_EQ: std::cerr << "EMUL_EQ\n"; break;
      case EDIV_EQ: std::cerr << "EDIV_EQ\n"; break;
      case ELEFTDIV_EQ: std::cerr << "ELEFTDIV_EQ\n"; break;
      case EPOW_EQ: std::cerr << "EPOW_EQ\n"; break;
      case AND_EQ: std::cerr << "AND_EQ\n"; break;
      case OR_EQ: std::cerr << "OR_EQ\n"; break;
      case EXPR_AND_AND: std::cerr << "EXPR_AND_AND\n"; break;
      case EXPR_OR_OR: std::cerr << "EXPR_OR_OR\n"; break;
      case EXPR_AND: std::cerr << "EXPR_AND\n"; break;
      case EXPR_OR: std::cerr << "EXPR_OR\n"; break;
      case EXPR_LT: std::cerr << "EXPR_LT\n"; break;
      case EXPR_LE: std::cerr << "EXPR_LE\n"; break;
      case EXPR_EQ: std::cerr << "EXPR_EQ\n"; break;
      case EXPR_NE: std::cerr << "EXPR_NE\n"; break;
      case EXPR_GE: std::cerr << "EXPR_GE\n"; break;
      case EXPR_GT: std::cerr << "EXPR_GT\n"; break;
      case LEFTDIV: std::cerr << "LEFTDIV\n"; break;
      case EMUL: std::cerr << "EMUL\n"; break;
      case EDIV: std::cerr << "EDIV\n"; break;
      case ELEFTDIV: std::cerr << "ELEFTDIV\n"; break;
      case HERMITIAN: std::cerr << "HERMITIAN\n"; break;
      case TRANSPOSE: std::cerr << "TRANSPOSE\n"; break;
      case PLUS_PLUS: std::cerr << "PLUS_PLUS\n"; break;
      case MINUS_MINUS: std::cerr << "MINUS_MINUS\n"; break;
      case POW: std::cerr << "POW\n"; break;
      case EPOW: std::cerr << "EPOW\n"; break;

      case NUMBER:
        {
          token *tok = current_token ();
          std::cerr << "NUMBER [";
          octave_value num = tok->number ();
          num.print_raw (std::cerr);
          std::cerr << "]\n";
        }
        break;

      case STRUCT_ELT:
        {
          token *tok = current_token ();
          std::cerr << "STRUCT_ELT [" << tok->text () << "]\n";
        }
        break;

      case NAME:
        {
          token *tok = current_token ();
          std::cerr << "NAME [" << tok->text () << "]\n";
        }
        break;

      case END: std::cerr << "END\n"; break;

      case DQ_STRING:
      case SQ_STRING:
        {
          token *tok = current_token ();

          std::cerr << (tok_id == DQ_STRING ? "DQ_STRING" : "SQ_STRING")
                    << " [" << tok->text () << "]\n";
        }
        break;

      case FOR: std::cerr << "FOR\n"; break;
      case WHILE: std::cerr << "WHILE\n"; break;
      case DO: std::cerr << "DO\n"; break;
      case UNTIL: std::cerr << "UNTIL\n"; break;
      case IF: std::cerr << "IF\n"; break;
      case ELSEIF: std::cerr << "ELSEIF\n"; break;
      case ELSE: std::cerr << "ELSE\n"; break;
      case SWITCH: std::cerr << "SWITCH\n"; break;
      case CASE: std::cerr << "CASE\n"; break;
      case OTHERWISE: std::cerr << "OTHERWISE\n"; break;
      case BREAK: std::cerr << "BREAK\n"; break;
      case CONTINUE: std::cerr << "CONTINUE\n"; break;
      case RETURN: std::cerr << "RETURN\n"; break;
      case UNWIND: std::cerr << "UNWIND\n"; break;
      case CLEANUP: std::cerr << "CLEANUP\n"; break;
      case TRY: std::cerr << "TRY\n"; break;
      case CATCH: std::cerr << "CATCH\n"; break;
      case GLOBAL: std::cerr << "GLOBAL\n"; break;
      case PERSISTENT: std::cerr << "PERSISTENT\n"; break;
      case FCN_HANDLE: std::cerr << "FCN_HANDLE\n"; break;
      case END_OF_INPUT: std::cerr << "END_OF_INPUT\n\n"; break;
      case LEXICAL_ERROR: std::cerr << "LEXICAL_ERROR\n\n"; break;
      case FUNCTION: std::cerr << "FUNCTION\n"; break;
      case INPUT_FILE: std::cerr << "INPUT_FILE\n"; break;
      case SUPERCLASSREF: std::cerr << "SUPERCLASSREF\n"; break;
      case METAQUERY: std::cerr << "METAQUERY\n"; break;
      case GET: std::cerr << "GET\n"; break;
      case SET: std::cerr << "SET\n"; break;
      case PROPERTIES: std::cerr << "PROPERTIES\n"; break;
      case METHODS: std::cerr << "METHODS\n"; break;
      case EVENTS: std::cerr << "EVENTS\n"; break;
      case CLASSDEF: std::cerr << "CLASSDEF\n"; break;
      case '\n': std::cerr << "\\n\n"; break;
      case '\r': std::cerr << "\\r\n"; break;
      case '\t': std::cerr << "TAB\n"; break;
      default:
        {
          if (tok_id < 256 && tok_id > 31)
            std::cerr << static_cast<char> (tok_id) << "\n";
          else
            std::cerr << "UNKNOWN(" << tok_id << ")\n";
        }
        break;
      }
  }

  void
  base_lexer::fatal_error (const char *msg)
  {
    ::error ("fatal lexer error: %s", msg);
  }

  bool
  base_lexer::debug_flag () const
  {
    settings& stgs = m_interpreter.get_settings ();
    return stgs.lexer_debug_flag ();
  }

  bool
  base_lexer::display_tokens () const
  {
    settings& stgs = m_interpreter.get_settings ();
    return stgs.display_tokens ();
  }

  void
  base_lexer::increment_token_count ()
  {
    settings& stgs = m_interpreter.get_settings ();
    stgs.increment_token_count ();

    m_token_count++;
  }

  void
  base_lexer::lexer_debug (const char *pattern)
  {
    if (debug_flag ())
      {
        std::cerr << std::endl;

        display_start_state ();

        std::cerr << "P: " << pattern << std::endl;
        std::cerr << "T: " << flex_yytext () << std::endl;
      }
  }

  bool
  base_lexer::input_from_tmp_history_file ()
  {
    history_system& history_sys = m_interpreter.get_history_system ();

    return history_sys.input_from_tmp_file ();
  }

  void
  base_lexer::push_start_state (int state)
  {
    OCTAVE_YYG;

    start_state_stack.push (state);

    BEGIN (start_state ());
  }

  void
  base_lexer::pop_start_state ()
  {
    OCTAVE_YYG;

    start_state_stack.pop ();

    BEGIN (start_state ());
  }

  void
  base_lexer::clear_start_state ()
  {
    while (! start_state_stack.empty ())
      start_state_stack.pop ();

    push_start_state (INITIAL);
  }

  void
  base_lexer::display_start_state () const
  {
    std::cerr << "S: ";

    switch (start_state ())
      {
      case INITIAL:
        std::cerr << "INITIAL" << std::endl;
        break;

      case COMMAND_START:
        std::cerr << "COMMAND_START" << std::endl;
        break;

      case MATRIX_START:
        std::cerr << "MATRIX_START" << std::endl;
        break;

      case INPUT_FILE_START:
        std::cerr << "INPUT_FILE_START" << std::endl;
        break;

      case BLOCK_COMMENT_START:
        std::cerr << "BLOCK_COMMENT_START" << std::endl;
        break;

      case LINE_COMMENT_START:
        std::cerr << "LINE_COMMENT_START" << std::endl;
        break;

      case DQ_STRING_START:
        std::cerr << "DQ_STRING_START" << std::endl;
        break;

      case SQ_STRING_START:
        std::cerr << "SQ_STRING_START" << std::endl;
        break;

      case FQ_IDENT_START:
        std::cerr << "FQ_IDENT_START" << std::endl;
        break;

      default:
        std::cerr << "UNKNOWN START STATE!" << std::endl;
        break;
      }
  }

  bool
  base_lexer::maybe_unput_comma_before_unary_op (int tok_id)
  {
    int prev_tok_id = previous_token_id ();

    bool unput_comma = false;

    if (whitespace_is_significant () && space_follows_previous_token ())
      {
        int c = text_yyinput ();
        xunput (c);

        bool space_after = is_space_or_tab (c);

        if (! (prev_tok_id == '[' || prev_tok_id == '{'
               || previous_token_is_binop ()
               || ((tok_id == '+' || tok_id == '-') && space_after)))
          unput_comma = true;
      }

    return unput_comma;
  }

  int
  base_lexer::handle_op (int tok_id, bool bos, bool compat)
  {
    if (! compat)
      warn_language_extension_operator (flex_yytext ());

    update_token_positions (flex_yyleng ());

    token *tok = new token (tok_id, m_tok_beg, m_tok_end, get_comment_list ());

    m_looking_for_object_index = false;
    m_at_beginning_of_statement = bos;

    switch (tok_id)
      {
      case EXPR_LT:
        if (m_parsing_classdef_decl)
          {
            m_parsing_classdef_superclass = true;
            push_start_state (FQ_IDENT_START);
          }
        break;

      case EXPR_AND:
        if (m_parsing_classdef_superclass)
          push_start_state (FQ_IDENT_START);
        break;

      default:
        break;
      }

    return handle_token (tok);
  }

  // When a command argument boundary is detected, push out the current
  // argument being built.  This one seems like a good candidate for a
  // function call.

  int
  base_lexer::finish_command_arg ()
  {
    token *tok = new token (SQ_STRING, m_string_text, m_tok_beg, m_tok_end, get_comment_list ());

    m_string_text = "";
    m_command_arg_paren_count = 0;

    return handle_token (tok);
  }

  int
  base_lexer::handle_token (int tok_id)
  {
    return handle_token (new token (tok_id, m_tok_beg, m_tok_end));
  }

  int
  base_lexer::handle_token (token *tok)
  {
    push_token (tok);

    int tok_id = tok->token_id ();

    if (m_arguments_is_keyword
        && ! (tok_id == ';' || tok_id == ',' || tok_id == '\n'))
      m_arguments_is_keyword = false;

    return count_token_internal (tok_id);
  }

  int
  base_lexer::count_token_internal (int tok_id)
  {
    if (tok_id != '\n')
      increment_token_count ();

    return show_token (tok_id);
  }

  int
  base_lexer::show_token (int tok_id)
  {

    if (display_tokens ())
      display_token (tok_id);

    if (debug_flag ())
      {
        std::cerr << "R: ";
        display_token (tok_id);
        std::cerr << std::endl;
      }

    return tok_id;
  }

  int
  lexer::fill_flex_buffer (char *buf, unsigned max_size)
  {
    int status = 0;

    if (m_input_buf.empty ())
      {
        std::string ps
          = m_initial_input ? m_interpreter.PS1 () : m_interpreter.PS2 ();

        std::string prompt = command_editor::decode_prompt_string (ps);

        bool eof = false;
        m_current_input_line = m_reader.get_input (prompt, eof);

        m_input_buf.fill (m_current_input_line, eof);

        // Attempt to capture text for functions defined on the
        // command line.
        //
        // FIXME: the handling of newline here seems a bit clumsy.
        //
        // See also comments in push_lexer::append_input.

        if (m_buffer_function_text)
          {
            if (! m_current_input_line.empty ())
            {
              m_function_text += m_current_input_line;
              if (m_current_input_line.back () != '\n')
                m_function_text += '\n';
            }
          }
      }

    if (! m_input_buf.empty ())
      status = m_input_buf.copy_chunk (buf, max_size);
    else
      status = YY_NULL;

    m_initial_input = false;

    return status;
  }

  void
  push_lexer::append_input (const std::string& input, bool eof)
  {
    // FIXME: input may contain more than one line, so how can we
    // properly start buffering input for command-line functions?
    //
    // Currently, base_lexer::make_keyword_token starts buffering text
    // for command-line functions by setting the initial value of
    // m_function_text to m_current_input_line when function_kw is
    // recognized.  To make that work, we need to do something like
    // maintain a queue of input strings and pass them to the flex
    // buffer one line at a time, while also setting
    // m_current_input_line.  Some care will be needed if a single line
    // of input arrives in multiple calls to append_input.
    //
    // OR, should we require that the input string to append_input
    // IS a single line of input?  That seems to be what we are doing
    // here by setting m_current_input_line to input.

    m_input_buf.fill (input, eof);
    m_current_input_line = input;
  }

  int
  push_lexer::fill_flex_buffer (char *buf, unsigned max_size)
  {
    int status = 0;

    if (m_input_buf.empty () && ! m_input_buf.at_eof ())
      {
        // If the input buffer is empty or we are at the end of the
        // buffer, insert ASCII 1 as a marker for subsequent rules.
        // Don't insert a newline character in this case.  Instead of
        // calling input_buffer::fill followed immediately by
        // input_buffer::copy_chunk, simply insert the marker directly
        // in BUF.

        if (max_size <= 0)
          error ("unexpected: max_size <= 0 in push_lexer::fill_flex_buffer - please report this bug");

        buf[0] = static_cast<char> (1);
        status = 1;
      }
    else
      {
        // Note that the copy_chunk function may append a newline
        // character to the input.

        if (! m_input_buf.empty ())
          status = m_input_buf.copy_chunk (buf, max_size, true);
        else
          status = YY_NULL;
      }

    return status;
  }

OCTAVE_END_NAMESPACE(octave)

