  /* Copyright William F. Schelter 1991
   Bignum routines.
 

   
num_arith.c: add_int_big
num_arith.c: big_minus
num_arith.c: big_plus
num_arith.c: big_quotient_remainder
num_arith.c: big_sign
num_arith.c: big_times
num_arith.c: complement_big
num_arith.c: copy_big
num_arith.c: div_int_big
num_arith.c: mul_int_big
num_arith.c: normalize_big
num_arith.c: normalize_big_to_object
num_arith.c: stretch_big
num_arith.c: sub_int_big
num_comp.c: big_compare
num_comp.c: big_sign
num_log.c: big_sign
num_log.c: copy_to_big
num_log.c: normalize_big
num_log.c: normalize_big_to_object
num_log.c: stretch_big
num_pred.c: big_sign
number.c: big_to_double
predicate.c: big_compare
typespec.c: big_sign
print.d: big_minus
print.d: big_sign
print.d: big_zerop
print.d: copy_big
print.d: div_int_big
read.d: add_int_big
read.d: big_to_double
read.d: complement_big
read.d: mul_int_big
read.d: normalize_big
read.d: normalize_big_to_object

 */



#ifndef GMP_USE_MALLOC
object big_gcprotect;
object big_fixnum1;

#include "gmp.c"
init_big1(){
    mp_set_memory_functions( gcl_gmp_alloc,gcl_gmp_realloc,gcl_gmp_free);
}

#else
init_big1()
{
}
#endif  

object
new_bignum()
{ object ans;
 {BEGIN_NO_INTERRUPT;
 ans = alloc_object(t_bignum);
 MP_SELF(ans) = 0;
 mpz_init(MP(ans));
 END_NO_INTERRUPT;
 }
 return ans;
}

/* we have to store the body of a u in a bignum object
   so that the garbage collecter will move it and save
   it, and then we can copy it back
*/   
#define GCPROTECT(u) \
 MP_INT * __u = MP(big_gcprotect); \
 (__u)->_mp_d =   (u)->_mp_d; \
 (__u)->_mp_alloc = (u)->_mp_alloc 
#define GC_PROTECTED_SELF (__u)->_mp_d
#define END_GCPROTECT (__u)->_mp_d = 0
 


object
make_bignum(u)
mpz_t u;
{ object ans ;
 int size;
 mp_ptr wp, up;
 {BEGIN_NO_INTERRUPT;
 /* make sure we follow the bignum body of u if it gets moved... */
 { GCPROTECT(u);
 ans = alloc_object(t_bignum);
 MP(ans)->_mp_d = 0;
 size = (u->_mp_size >= 0 ? u->_mp_size : (- (u->_mp_size)));
 MP(ans)->_mp_d = (mp_ptr) gcl_gmp_alloc (size*MP_LIMB_SIZE);
 MP(ans)->_mp_alloc = size;
 MP(ans)->_mp_size = u->_mp_size;
 memcpy(MP(ans)->_mp_d,GC_PROTECTED_SELF,size*MP_LIMB_SIZE);
 END_GCPROTECT;
 }
 END_NO_INTERRUPT;
 return ans;
 }
} 

/* coerce a mpz_t to a bignum or fixnum */

object
make_integer(u)
mpz_t u;
{
  if (mpz_fits_sint_p(u)) {
    signed long int x = mpz_get_si(u);
    return make_fixnum(mpz_get_si(u));
      }
  return make_bignum(u);
}

/* like make_integer except that the storage of u is cleared
   if it is a fixnum, and if not the storage of u is actually
   copied to the new bignum
*/
#ifdef OBSOLETE
object
make_integer_clear(u)
mpz_t u;
{ object ans;
  if (mpz_fits_sint_p(u)) {
    signed long int x = mpz_get_si(u);
    mpz_clear(u);
    return make_fixnum(x);
      }
  {BEGIN_NO_INTERRUPT;
  { GCPROTECT(u);
  ans = alloc_object(t_bignum);
  MP(ans)->_mp_alloc = u->_mp_alloc;
  MP(ans)->_mp_size = u->_mp_size;
  /* the u->_mp_d may have moved */
  MP_SELF(ans) = GC_PROTECTED_SELF;
  mpz_clear(u);
  END_GCPROTECT;
  }
  END_NO_INTERRUPT;
  } 
  return ans;
}
#endif /* obsolete */

big_zerop(x)
 object x;
{ return (mpz_sgn(MP(x))== 0);}

big_compare(x, y)
     object x,y;
{return   mpz_cmp(MP(x),MP(y));
}


object
normalize_big_to_object(x)
 object x;
{
  return make_integer(MP(x));

}



gcopy_to_big(res,x)
     mpz_t res;
     object x;
{
  mpz_set(MP(x),res);
}

/* destructively modifies x = i - x; */
add_int_big(i, x)
int i;
object x;
{
       MPOP_DEST(x,addsi,i,MP(x));
}

sub_int_big(i, x)
int i;
object x;
{  SI_TEMP_DECL(mpz_int_temp);
  MPOP_DEST(x,subsi,i,MP(x));
}

mul_int_big(i, x)
int i;
object x;
{ MPOP_DEST(x,mulsi,i,MP(x));
}    



/*
	Div_int_big(i, x) destructively divides non-negative bignum x
	by positive int i.
	X will hold the quotient from  the division.
	Div_int_big(i, x) returns the remainder of the division.
	I should be positive.
	X should be non-negative.
*/

div_int_big(i, x)
int i;
object x;
{
  return mpz_tdiv_q_ui(MP(x),MP(x),i);
}


object
big_plus(x, y)
object x,y;
{
  MPOP(return,addii,MP(x),MP(y));
}

object
big_times(x, y)
object x,y;
{
 MPOP(return,mulii,MP(x),MP(y));

}

/* x is a big, and it is coerced to a fixnum (and the big is cleared)
   or it is smashed
*/
object
normalize_big(x)
     object x;
{
  if (mpz_fits_sint_p(MP(x))) {
    MP_INT *u = MP(x);
    signed long int x = mpz_get_si(u);
    return make_fixnum(x);
      }
  else return x;
}

object
big_minus(x)
     object x;
{ object y = new_bignum();
 mpz_neg(MP(y),MP(x));
 return normalize_big(y);
}


big_quotient_remainder(x0, y0, qp, rp)
     object x0,y0,*qp,*rp;
{
  object res,quot;
  res = new_bignum();
  quot = new_bignum();
  mpz_tdiv_qr(MP(quot),MP(res),MP(x0),MP(y0));
  *qp = normalize_big(quot);
  *rp = normalize_big(res);
  return;
}

	
double
big_to_double(x)
     object x;
{
  return mpz_get_d(MP(x));
}


object copy_big(x)
     object x;
{
  if (type_of(x)==t_bignum)
    return make_bignum(MP(x));
  else FEerror("bignum expected",0);
  return Cnil;

}

/* this differes from old copy_to_big in that it does not alter
   copy a bignum.
*/   
object
copy_to_big(x)
     object x;
{object y;
 if (type_of(x) == t_fixnum) {
   object ans = new_bignum();
   mpz_set_si(MP(ans),fix(x));
   return ans;
 } else {
   return x;
}
}




/* return object like *xpt coercing to a fixnum if necessary,
   or return the actual bignum replacing it with another
*/
object
maybe_replace_big(xpt)
     object *xpt;
{ object x = *xpt;
  if (mpz_fits_sint_p(MP(x))) {
    MP_INT *u = MP(x);
    signed long int xx = mpz_get_si(u);
    return make_fixnum(xx);
      }
  *xpt=new_bignum();
  return x;
}


object
bignum2(h,l)
 unsigned  int h,l;
{
  object x = new_bignum();
  mpz_set_ui(MP(x),h);
  mpz_mul_2exp(MP(x),MP(x),32);
  mpz_add_ui(MP(x),MP(x),l);
  return normalize_big(x);
}

integer_quotient_remainder_1(x, y, qp, rp)
object x, y;
object *qp, *rp;
{
  *qp = new_bignum();
  *rp = new_bignum();
  /* we may need to coerce the fixnums to MP here, and
     we use the temporary storage of the rp/qp as inputs.
     since overlap is allowed in the mpz_tdiv_qr operation..
  */    
  mpz_tdiv_qr(MP(*qp),MP(*rp),INTEGER_TO_MP(x,*qp),
	      INTEGER_TO_MP(y,*rp));
  *qp = normalize_big(*qp);
  *rp = normalize_big(*rp);
  return;
}

#define HAVE_MP_COERCE_TO_STRING
     
object
coerce_big_to_string(x,printbase)
     int printbase;
     object x;
{ int i;
 int sign = BIG_SIGN(x);
 int ss = mpz_sizeinbase(MP(x),printbase);
 char *p;
  object ans = alloc_simple_string(ss+2+(sign<0? 1: 0));
  ans->ust.ust_self=p=alloc_relblock(ans->ust.ust_dim);
  /*  if (sign < 0) *p++='-'; */
  mpz_get_str(p, printbase,MP(x));
  i = ans->ust.ust_dim-5;
  if (i <0 ) i=0;
  while(ans->ust.ust_self[i]) { i++;}
  ans->ust.ust_fillp=i;
  return ans;
}


init_big()
{
  big_gcprotect=alloc_object(t_bignum);
  MP_SELF(big_gcprotect)=0;
  MP_ALLOCATED(big_gcprotect)=0;
  big_fixnum1=new_bignum();
  big_fixnum2=new_bignum();
  enter_mark_origin(&big_fixnum1);
  enter_mark_origin(&big_gcprotect);
  enter_mark_origin(&big_fixnum2);


}

  








