/*
 * Electric(tm) VLSI Design System
 *
 * File: egraphics.h
 * Graphical definitions
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/******************************* GRAPHICS ********************************/

/* bit map colors (in GRAPHICS->bits) */
#define LAYERN   0000			/* nothing                               */
#define LAYERH   0001			/* highlight color and bit plane         */
#define LAYEROE  0002			/* opaque layer escape bit               */
#define LAYERO   0176			/* opaque layers                         */
#define LAYERT1  0004			/* transparent layer 1                   */
#define LAYERT2  0010			/* transparent layer 2                   */
#define LAYERT3  0020			/* transparent layer 3                   */
#define LAYERT4  0040			/* transparent layer 4                   */
#define LAYERT5  0100			/* transparent layer 5                   */
#define LAYERG   0200			/* grid line color and bit plane         */
#define LAYERA   0777			/* everything                            */

/* color map colors (in GRAPHICS->col) */
#define ALLOFF   0000			/* no color                              */
#define HIGHLIT  0001			/* highlight color and bit plane         */
#define COLORT1  0004			/* transparent color 1                   */
#define COLORT2  0010			/* transparent color 2                   */
#define COLORT3  0020			/* transparent color 3                   */
#define COLORT4  0040			/* transparent color 4                   */
#define COLORT5  0100			/* transparent color 5                   */
#define GRID     0200			/* grid line color and bit plane         */

#define WHITE    0002			/* white                                 */
#define BLACK    0006			/* black                                 */
#define RED      0012			/* red                                   */
#define BLUE     0016			/* blue                                  */
#define GREEN    0022			/* green                                 */
#define CYAN     0026			/* cyan                                  */
#define MAGENTA  0032			/* magenta                               */
#define YELLOW   0036			/* yellow                                */
#define FACETTXT 0042			/* facet and port names                  */
#define FACETOUT 0046			/* facet outline                         */
#define WINBOR   0052			/* window border color                   */
#define HWINBOR  0056			/* highlighted window border color       */
#define MENBOR   0062			/* menu border color                     */
#define HMENBOR  0066			/* highlighted menu border color         */
#define MENTXT   0072			/* menu text color                       */
#define MENGLY   0076			/* menu glyph color                      */
#define CURSOR   0102			/* cursor color                          */
#define GRAY     0106			/* gray                                  */
#define ORANGE   0112			/* orange                                */
#define PURPLE   0116			/* purple                                */
#define BROWN    0122			/* brown                                 */
#define LGRAY    0126			/* light gray                            */
#define DGRAY    0132			/* dark gray                             */
#define LRED     0136			/* light red                             */
#define DRED     0142			/* dark red                              */
#define LGREEN   0146			/* light green                           */
#define DGREEN   0152			/* dark green                            */
#define LBLUE    0156			/* light blue                            */
#define DBLUE    0162			/* dark blue                             */
/*               0166 */		/* unassigned                            */
/*               0172 */		/* unassigned                            */
/*               0176 */		/* unassigned (and should stay that way) */

/* drawing styles (in GRAPHICS->style) */
#define SOLIDC      0			/* solid colors                          */
#define PATTERNED   1			/* stippled with "raster"                */
#define NATURE      1			/* the above two choices                 */
#define INVISIBLE   2			/* don't draw this layer                 */
#define INVTEMP     4			/* temporary for INVISIBLE bit           */
#define OUTLINEPAT  8			/* if NATURE is PATTERNED, outline it    */

/* variables with the acutal colors to use for special graphics */
extern INTSML el_maplength;		/* number of entries in color map */
extern INTSML el_colfacettxt;	/* color to use for facet text and port names */
extern INTSML el_colfacet;		/* color to use for facet outline */
extern INTSML el_colwinbor;		/* color to use for window border */
extern INTSML el_colhwinbor;	/* color to use for highlighted window border */
extern INTSML el_colmenbor;		/* color to use for menu border */
extern INTSML el_colhmenbor;	/* color to use for highlighted menu border */
extern INTSML el_colmentxt;		/* color to use for menu text */
extern INTSML el_colmengly;		/* color to use for menu glyphs */
extern INTSML el_colcursor;		/* color to use for cursor */

/******************************* POLYGONS ********************************/

/* drawing styles (in POLYGON->style) */
		/* polygons */
#define FILLED        0			/* closed polygon, filled in                 */
#define CLOSED        1			/* closed polygon, outline                   */
		/* rectangles */
#define FILLEDRECT    2			/* closed rectangle, filled in               */
#define CLOSEDRECT    3			/* closed rectangle, outline                 */
#define CROSSED       4			/* closed rectangle, outline crossed         */
		/* lines */
#define OPENED        5			/* open outline, solid                       */
#define OPENEDT1      6			/* open outline, dotted                      */
#define OPENEDT2      7			/* open outline, dashed                      */
#define OPENEDT3      8			/* open outline, thicker                     */
#define OPENEDO1      9			/* open outline pushed by 1                  */
#define VECTORS      10			/* vector endpoint pairs, solid              */
		/* curves */
#define CIRCLE       11			/* circle at [0] radius to [1]               */
#define DISC         12			/* filled circle                             */
#define CIRCLEARC    13			/* arc of circle at [0] ends [1] and [2]     */
		/* text */
#define TEXTCENT     14			/* text at center                            */
#define TEXTTOP      15			/* text below top edge                       */
#define TEXTBOT      16			/* text above bottom edge                    */
#define TEXTLEFT     17			/* text to right of left edge                */
#define TEXTRIGHT    18			/* text to left of right edge                */
#define TEXTTOPLEFT  19			/* text to lower-right of top-left corner    */
#define TEXTBOTLEFT  20			/* text to upper-right of bottom-left corner */
#define TEXTTOPRIGHT 21			/* text to lower-left of top-right corner    */
#define TEXTBOTRIGHT 22			/* text to upper-left of bottom-right corner */
#define TEXTBOX      23			/* text that fits in box (may shrink)        */
		/* miscellaneous */
#define GRIDDOTS     24			/* grid dots in the window                   */
#define CROSS        25			/* cross                                     */
#define BIGCROSS     26			/* big cross                                 */

/* text font styles (in POLYGON->font) */
#define TXT4P         0			/* 4 point text                          */
#define TXT6P         1			/* 6 point text                          */
#define TXT8P         2			/* 8 point text                          */
#define TXT10P        3			/* 10 point text                         */
#define TXT12P        4			/* 12 point text                         */
#define TXT14P        5			/* 14 point text                         */
#define TXT16P        6			/* 16 point text                         */
#define TXT18P        7			/* 18 point text                         */
#define TXT20P        8			/* 20 point text                         */
#define TXTHL         9			/* half-lambda text                      */
#define TXT1L        10			/* 1-lambda text                         */
#define TXT2L        11			/* 2-lambda text                         */
#define TXT3L        12			/* 3-lambda text                         */
#define TXT4L        13			/* 4-lambda text                         */
#define TXT5L        14			/* 5-lambda text                         */
#define TXT6L        15			/* 6-lambda text                         */
#define TXTEDITOR    -1			/* fixed-width text for text editing     */
#define TXTMENU      -2			/* text for menu selection               */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
}
#endif
