/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import { TalerExchangeApi, setupI18n } from "@gnu-taler/taler-util";
import {
  ExchangeApiProviderTesting,
  ExchangeContextType,
  parseGroupImport,
} from "@gnu-taler/web-util/browser";
import * as tests from "@gnu-taler/web-util/testing";

// import * as components from "./components/index.examples.js";
import * as pages from "./pages/index.stories.js";

import { ComponentChildren, VNode, h as create } from "preact";

setupI18n("en", { en: {} });

describe("All the examples:", () => {
  const cms = parseGroupImport({ pages });
  cms.forEach((group) => {
    describe(`Example for group "${group.title}:"`, () => {
      group.list.forEach((component) => {
        describe(`Component ${component.name}:`, () => {
          component.examples.forEach((example) => {
            it(`should render example: ${example.name}`, () => {
              tests.renderUI(example.render, DefaultTestingContext);
            });
          });
        });
      });
    });
  });
});

function DefaultTestingContext({
  children,
}: {
  children: ComponentChildren;
}): VNode {
  const config: TalerExchangeApi.ExchangeVersionResponse = {
    currency: "ARS",
    currency_specification: {
      alt_unit_names: {},
      name: "ARS",
      num_fractional_input_digits: 2,
      num_fractional_normal_digits: 2,
      num_fractional_trailing_zero_digits: 2,
    },
    name: "taler-exchange",
    supported_kyc_requirements: [],
    version: "asd",
  };
  const value: ExchangeContextType = {
    cancelRequest: () => null,
    config,
    url: new URL("/", "http://localhost"),
    hints: [],
    lib: {
      exchange: undefined!, //FIXME: mock
    },
    onActivity: () => null!,
  };

  return create(ExchangeApiProviderTesting, { value, children });
}
