/*
 * Decompiled with CFR 0.152.
 */
package org.domterm;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;
import org.domterm.Backend;
import org.domterm.util.DomTermErrorStream;
import org.domterm.util.Utf8WriterOutputStream;
import org.domterm.util.WTDebug;

public class ClassBackend
extends Backend {
    Method methodToRun;
    String[] restArgs;
    Writer pin;

    public ClassBackend(String string, String[] stringArray) throws Exception {
        this(ClassBackend.getMainMethod(string), stringArray);
    }

    public ClassBackend(Method method, String[] stringArray) {
        this.methodToRun = method;
        this.restArgs = stringArray;
        this.lineEditingMode = (char)108;
    }

    public ClassBackend(List<String> list) throws Exception {
        this.methodToRun = ClassBackend.getMainMethod(list.get(0));
        int n = list.size();
        this.restArgs = new String[n - 1];
        list.subList(1, n).toArray(this.restArgs);
    }

    public static Method getMainMethod(String string) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = Class.forName(string, false, classLoader);
        return clazz.getDeclaredMethod("main", String[].class);
    }

    @Override
    public void run(Writer writer) throws Exception {
        this.termWriter = writer;
        this.sendInputMode('p');
        this.addVersionInfo("ClassClient;err-handled");
        Utf8WriterOutputStream utf8WriterOutputStream = new Utf8WriterOutputStream(writer);
        PrintStream printStream = new PrintStream(new BufferedOutputStream(utf8WriterOutputStream, 128), true);
        System.setOut(printStream);
        DomTermErrorStream.setSystemErr();
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.pin = new OutputStreamWriter(pipedOutputStream);
            System.setIn(new PipedInputStream(pipedOutputStream));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        try {
            System.setProperty("org.domterm", this.getVersionInfo());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    ClassBackend.this.methodToRun.invoke(null, new Object[]{ClassBackend.this.restArgs});
                }
                catch (Throwable throwable) {
                    WTDebug.println("caught while executing main " + throwable);
                }
            }
        }.start();
    }

    @Override
    public void processInputCharacters(String string) {
        try {
            this.pin.write(string.replaceAll("\r", "\n"));
            this.pin.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(-1);
        }
    }
}

