// -*- verilog -*-
//
//  USRP - Universal Software Radio Peripheral
//
//  Copyright (C) 2003 Matt Ettus
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//



// Basic Phase accumulator for DDS


module phase_acc (clk,reset,enable,strobe,freq,phase);   
  parameter resolution = 32;

   input    clk;
   input    reset;
   input    enable;
   input    strobe;
   input [resolution-1:0] freq;
  
   output [resolution-1:0] phase;
   reg [resolution-1:0] phase;

   always @(posedge clk)
     if(reset)
       phase <= #1 32'b0;
     else
       if(enable & strobe)
	 	phase <= #1 phase + freq;

endmodule // phase_acc

   
