# Copyright (C) 2018-2021 Free Software Foundation, Inc.
#
# This file is part of GNU Emacs.
#
# GNU Emacs is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or (at
# your option) any later version.
#
# GNU Emacs is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Emacs.  If not, see <https://www.gnu.org/licenses/>.

BEGIN {
  print "/* Generated by dmpstruct.awk */"
  print "#ifndef EMACS_DMPSTRUCT_H"
  print "#define EMACS_DMPSTRUCT_H"
  struct_name = ""
  tmpfile = "dmpstruct.tmp"
}
# Match a type followed by optional syntactic whitespace
/^(enum|struct|union) [a-zA-Z0-9_]+([\t ]|\/\*.*\*\/)*$/ {
  struct_name = $2
  close (tmpfile)
}
/^(enum|struct|union) [a-zA-Z0-9_]+([\t ]|\/\*.*\*\/)*$/, /^(  )?};$/ {
  print $0 > tmpfile
}
/^(  )?} *(GCALIGNED_STRUCT)? *;$/ {
  if (struct_name != "") {
    fflush (tmpfile)
    cmd = "../lib-src/make-fingerprint -r " tmpfile
    cmd | getline hash
    close (cmd)
    printf "#define HASH_%s_%.10s\n", struct_name, hash
    struct_name = ""
  }
}
END {
  print "#endif /* EMACS_DMPSTRUCT_H */"
}
