.TH @G@NROFF @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
@g@nroff \- emulate nroff command with groff
.
.
.\" ====================================================================
.\" Legalese
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2014 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.\" Redefine OP because no spaces are allowed after an option's argument.
.de OP
.  ie \\n(.$-1 \
.    RI "[\fB\\$1\fP" "\\$2" "]"
.  el \
.    RB "[" "\\$1" "]"
..

.SY @g@nroff
.OP \-CchipStUvwW
.OP \-d cs
.OP \-M dir
.OP \-m name
.OP \-n num
.OP \-o list
.OP \-r cn
.OP \-T name
.RI [ file\~ .\|.\|.]
.
.SY @g@nroff
.B \-\-help
.
.SY @g@nroff
.B \-v
|
.B \-\-version
.YS
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
The
.B @g@nroff
script emulates the
.B nroff
command using groff.
.
Only
.BR ascii ,
.BR latin1 ,
.BR utf8 ,
and
.B cp1047
are devices accepted by
.BR nroff
to select the output encoding emitted by
.BR grotty ,
groff's TTY output device.
.
If neither the
.B GROFF_TYPESETTER
environment variable nor the
.B \-T
command-line option (which overrides the environment variable)
specifies a (valid) device,
.B @g@nroff
checks the current locale to select a default output device.
.
It first tries the
.B locale
program, then the environment variables
.BR LC_ALL ,
.BR LC_CTYPE ,
and
.BR LANG ,
and finally the
.B LESSCHARSET
environment variable.
.
.
.PP
The
.B \-h
and
.B \-c
options
are equivalent to
.BR grotty 's
options
.B \-h
(using tabs in the output) and
.B \-c
(using the old output scheme instead of SGR escape sequences).
.
The
.BR \-d ,
.BR \-C ,
.BR \-i ,
.BR \-M ,
.BR \-m ,
.BR \-n ,
.BR \-o ,
.BR \-r ,
.BR \-w ,
and
.B \-W
options have the effect described in
.BR @g@troff (@MAN1EXT@).
.
In addition,
.B @g@nroff
silently ignores the options
.BR \-e ,
.BR \-q ,
and
.BR \-s
(which are not implemented in
.BR @g@troff ).
.
Options
.B \-p
(pic),
.B \-t
(tbl),
.B \-S
(safer), and
.B \-U
(unsafe) are passed to
.BR groff .
.
.B \-v
and
.B \-\-version
show the version number,
.B \-\-help
prints a help message.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
.TP
.SM
.B GROFF_TYPESETTER
The default device for
.BR groff .
If not set (which is the normal case), it defaults to \(oqps\(cq.
.
.TP
.SM
.B GROFF_BIN_PATH
A colon separated list of directories in which to search for the
.B groff
executable before searching in PATH.
.
If unset, \(oq@BINDIR@\(cq is used.
.
.
.\" ====================================================================
.SH NOTES
.\" ====================================================================
.
This shell script is basically intended for use with
.BR man (1).
nroff-style character definitions (in the file tty-char.tmac) are also
loaded to emulate unrepresentable glyphs.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR grotty (@MAN1EXT@)
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
