# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os

class SoundInitException:
    pass
class SyscallException(SoundInitException):
    def __init__(self, msg, n):
        self.m_msg = msg
        self.m_errno = n
    def __str__(self):
        return self.m_msg + "\n%s" % os.strerror(self.m_errno)

class SeqNoSynthsException(SoundInitException):
    def __init__(self, dev):
        self.m_dev = dev
    def __str__(self):
        return "SNDCTL_SEQ_NRSYNTHS report that there are not synths on %s." % self.m_dev


