/*
   This file is part of TALER
   Copyright (C) 2024 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_update_donau_instance_receipts_amount.h
 * @brief implementation of the update_donau_instance function for Postgres
 * @author Bohdan Potuzhnyi
 * @author Vlada Svirsh
 */
#ifndef PG_UPDATE_DONAU_INSTANCE_RECEIPTS_AMOUNT_H
#define PG_UPDATE_DONAU_INSTANCE_RECEIPTS_AMOUNT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "taler_merchantdb_plugin.h"

/**
 * Update information about a Donau charity instance.
 *
 * @param cls closure
 * @param donau_instances_serial serial of the Donau instance to update
 * @param new_amount new amount to set for the Donau instance receipts to date
 * @return transaction status code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_update_donau_instance_receipts_amount (
  void *cls,
  uint64_t *donau_instances_serial,
  const struct TALER_Amount *new_amount);

#endif
