#include <stdio.h>
#include <fcntl.h>

#define NYMSDIR "/home/ghio/alpha/nyms"
#define DOMAIN "alpha.c2.org"
#define OUTMSG "aliasoutfile"
#define SENDMAIL "/usr/lib/sendmail"

int strbegin(char str1[],char str2[]) {
  int x=0;
  int match=0;

  while ((str1[x]==str2[x]||str1[x]==(str2[x]-32))&&str1[x]!=0) {
    x++;
    if (str2[x]==0) match=1;
  }
  return(match);
}

void main(int argc,char *argv[]) {
  char passwordfile[256];
  char replyblockfile[256];
  char input[256];
  char nym[80];
  char nymaddr[256];
  char password[80];
  char subject[256]="";
  char recipients[1024]="";
  int recipientslen=0;
  int x,y,z;
  FILE *infile;  
  FILE *tempfile;
  FILE *outfile;
  FILE *outmsg;
  int pipefd[2];
  int auth=0;
  int newpw=0;
  int newrb=0;
  int noack=0;

/* Parse the From: line to get the nym */
  infile=fopen(argv[1],"r");
  while(fgets(input,256,infile)>0&&input[0]>32) {
    if (strbegin(input,"from:")) {
      x=0;y=0;
      while(input[x]!=':'&&x<80) x++;
      x++;
      while(input[x]<=32&&x<80) x++;
      z=x;
      while(input[x]>32&&x<80){
        nym[y]=input[x];
        x=x+1;y=y+1;
      }
      nym[y]=0;
      x=0; /* look for <address> */
      while(input[x]>31&&input[x]!='<'&&x<80){x=x+1;}
      if(input[x]=='<'){
        y=0;x=x+1;
        while(input[x]>32&&input[x]!='>'&&x<80){
          nym[y]=input[x];
          x=x+1;y=y+1;
        }
        nym[y]=0;
      }
      /*strip off site name if they included the entire address*/ 
      x=0;
      while(nym[x]>0){
        if (nym[x]=='@') {nym[x]=0;}
        else x++;
      }
      /* de-capitalize and remove funky characters */
      /* (don't allow any create-a-file-anywhere hacks! :) */
      x=0;
      while(nym[x]!=0){
        if (nym[x]>='A'&&nym[x]<='Z') {
          nym[x]+=32;
	}
        if ((nym[x]<'a'||nym[x]>'z')&&
            (nym[x]<'0'||nym[x]>'9')&&nym[x]!='-') {
          nym[x]='_';
        }
        x++;
      }
    }
  }
  fclose(infile);
  
  /* Get the password */
  sprintf(passwordfile,"%s/%s.password",NYMSDIR,nym); /* should be ok, nym is limited to 80 chars */
  sprintf(replyblockfile,"%s/%s.replyblock",NYMSDIR,nym);
  *password=0;
  if(tempfile=fopen(passwordfile,"r")){
    fscanf(tempfile,"%80s",password);
    fclose(tempfile);
  }
  if (password[0]<=32) {auth=1;password[0]=0;}

  /* Process the rest of the headers */
  infile=fopen(argv[1],"r");
  outmsg=fopen(OUTMSG,"w");
#ifdef SAMEER
  fprintf(outmsg,"X-Plug: Community ConneXion offers privacy on the internet.  http://www.c2.org/\n");
#endif
  while(fgets(input,256,infile)>0) {
    if (strbegin(input,"password:")&&(*password)) {
      auth=1;
      for(x=0;input[x]!=':';x++) {}
      x++;while(input[x]==32) x++;
      y=0;while(password[y]>32){
        if (input[x]!=password[y]) auth=0;
        x++;y++;
      }
    }else if ((strbegin(input,"new-password:")&&auth)
             ||(strbegin(input,"password:")&&(*password==0))) {
      outfile=fopen(passwordfile,"w");
      for(x=0;input[x]!=':';x++) {}
      x++;while(input[x]==32) x++;
      y=0;
      while(input[x]>32&&y<80){
        fprintf(outfile,"%c",input[x]);
        password[y++]=input[x];
        x++;
      }
      fclose(outfile);password[y]=0;
      newpw=1;
    }else if (strbegin(input,"reply-block")&&auth) {
      outfile=fopen(replyblockfile,"w");
      while((fgets(input,256,infile)>0)
         &&(strbegin(input,"::")==0)) {}
      fprintf(outfile,"::\n");
      while(fgets(input,256,infile)>0) {
        fprintf(outfile,"%s",input);
      }
      fclose(outfile);
      newrb=1;
    }else if (strbegin(input,"from:")) {
      fprintf(outmsg,"From: %s@%s",nym,DOMAIN);
      for(x=0;input[x]>0;x++){
        if (input[x]=='(') {
          fprintf(outmsg," (");x++;
          while (input[x]>=32&&input[x]!=')') {
            fprintf(outmsg,"%c",input[x]);
            x++;
          }
          fprintf(outmsg,")");
        }
      }
      fprintf(outmsg,"\n");
    }else if (strbegin(input,"ack: off")||strbegin(input,"ack: no")) {
      noack=1;
    }else if (input[0]<32&&auth){
      fprintf(outmsg,"\n");
      while(fgets(input,256,infile)>0){
        fprintf(outmsg,"%s",input);
      }
    }else{
      fprintf(outmsg,"%s",input);
      if(strbegin(input,"to:")||strbegin(input,"cc:")){
        for(x=0;recipientslen<1023&&input[x];x++) {
          recipients[recipientslen++]=input[x];
        }
        recipients[recipientslen]=0;
      }
      if(strbegin(input,"subject:")){
        strcpy(subject,input);
      }
    }
  }
  fclose(outmsg);
  fclose(infile);

  /* If the password was bogus, kill the message */
  if (auth==0||password[0]<=32) {
    outmsg=fopen(OUTMSG,"w");fclose(outmsg);recipientslen=0;
  }

  /* Setting null password deletes a nym */
  if(password[0]<=32) {
    unlink(replyblockfile);
    unlink(passwordfile);
    exit(0);
  }

  /* Deliver remailed message */
  if(recipientslen) {
    if(!fork()) {
      sprintf(nymaddr,"%s@%s",nym,DOMAIN);
      dup2(open(OUTMSG,O_RDONLY),0); /* Hopefully this won't break under any weird filesystems */
      rewind(stdin);
      unlink(OUTMSG);
      execl(SENDMAIL,SENDMAIL,"-f",nymaddr,"-t","-odq",(char *)0);
      exit(1);
    }
  }else unlink(OUTMSG);
   
  /* Send acknowledgements */
  if(!noack) {
    if(recipientslen) {
      pipe(pipefd);
      if(!fork()) {
        dup2(pipefd[0],0);
        close(pipefd[1]);
        execl(SENDMAIL,SENDMAIL,"-f","nobody","-t","-odq",(char *)0);
        exit(1); }
      close(pipefd[0]);
      outfile=fdopen(pipefd[1],"w");
      fprintf(outfile,"From: alias@%s\n",DOMAIN);
      fprintf(outfile,"To: %s@%s\n",nym,DOMAIN);
      fprintf(outfile,"Subject: Acknowledgement for Remailed Message\n\n");
      fprintf(outfile,"This is to inform you that your message\n");
      fprintf(outfile,"%s",subject);
      fprintf(outfile,"was mailed\n");
      fprintf(outfile,"%s",recipients);
      fclose(outfile);
    }
    if(newpw||newrb) {
      pipe(pipefd);
      if(!fork()) {
        dup2(pipefd[0],0);
        close(pipefd[1]);
        execl(SENDMAIL,SENDMAIL,"-f","nobody","-t","-odq",(char *)0);
        exit(1); }
      close(pipefd[0]);
      outfile=fdopen(pipefd[1],"w");
      fprintf(outfile,"From: alias@%s\n",DOMAIN);
      fprintf(outfile,"To: %s@%s\n",nym,DOMAIN);
      fprintf(outfile,"Subject: Acknowledgement of your request to alias@%s\n\n",DOMAIN);
      fprintf(outfile,"This is to confirm that your ");
      if(newpw&&newrb)fprintf(outfile,"password and reply-block have\n");
      else if(newrb)fprintf(outfile,"new reply-block has\n");
      else if(newpw)fprintf(outfile,"new password has\n");
      fprintf(outfile,"been set for %s\n",nym);
      fclose(outfile);
    }
  }
}
