/****************************************************************************
  This file is part of the Freedom Remailer.  It is:
  Copyright (C) 1995-1997  John B. Fleming (jfleming@indiana.edu)
  Changes are (C) 1997-1998  Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#ifndef FREEDOM_H
#define FREEDOM_H

#define DISCLAIMER \
"Comments: Please report problems with this automated remailing service\n" \
"\tto <%s>. The message sender's identity\n" \
"\tis unknown, unlogged, and not replyable.\n", COMPLAINTS

#define SYSLOG_FACILITY	LOG_USER

#define VERSION		"2.4"

#ifndef REMAILER_DIR
#define REMAILER_DIR	""
#endif /* !REMAILER_DIR */

#define REMAILER_BIN	"remailer"

/* Useful macros.  */
#define blank(s) (!strcmp ((s), "\n") || !strcmp ((s), "\r\n"))
#define hdrmarks(s) (!strcmp ((s), "::\n") || !strcmp ((s), "::\r\n"))
#define hashmarks(s) (!strcmp ((s), "##\n") || !strcmp ((s), "##\r\n"))
#define ekmarks(s) (!strcmp ((s), "**\n") || !strcmp ((s), "**\r\n"))
#define beginpgp(s) \
(!strcmp ((s), "-----BEGIN PGP MESSAGE-----\n")\
 || !strcmp ((s), "-----BEGIN PGP MESSAGE------\r\n"))
#define endpgp(s) \
(!strcmp ((s), "-----END PGP MESSAGE-----\n")\
 || !strcmp ((s), "-----END PGP MESSAGE------\r\n"))

/* Argument values of updatestats().  */
enum stats_flag
  {
    STATS_MESSAGE,
    STATS_PGP
  };

/* Return values of scan_message().  */
enum message_type
  {
    NON_ANON,
    BLOCKED_SENDER,
    NULL_MESSAGE,
    PGP_MESSAGE,
    REMIX_MESSAGE,
    REPGP_MESSAGE,
    ANON_MESSAGE,
    ANON_POST,
    STATS_REQ,
    HELP_REQ,
    KEY_REQ,
    CONF_REQ,
    CUTMARKS,
    ENCRYPT_SUB,
    ENCRYPT_KEY,
    LATENT_TIME,
    URL_REQUEST
  };

/* Declarations of extern variables.  */
extern int USE_SYSLOG;
extern int USE_STATS;
extern int USE_MIX;
extern int ALLOW_PGP;
extern int ALLOW_GPG;
extern int ALLOW_POST;
extern int ALLOW_WWW;
extern int ALLOW_LTIME;
extern int SIZE_LIMIT;
extern char remailer_dir[];
extern char cur_dir[];
extern char MIX_DIR[];
extern char QUEUE_DIR[];
extern char PGP_DIR[];
extern char GPG_DIR[];
extern char MAIL_SPOOL[];
extern char MIXMASTER[];
extern char TYPE2_LIST[];
extern char SENDMAIL[];
extern char INEWS[];
extern char PGP[];
extern char GPG[];
extern char WGET[];
extern char HELP_FILE[];
extern char KEY_FILE[];
extern char STATS_FILE[];
extern char PASS_FILE[];
extern char REPGP_KEYS[];
extern char SOURCE_BLOCK[];
extern char DEST_BLOCK[];
extern char GROUP_BLOCK[];
extern char URL_BLOCK[];
extern char HDRFILTER[];
extern char REMAILER_NAME[];
extern char ANON_NAME[];
extern char ORGANIZATION[];
extern char MAIL2NEWS[];
extern char REMAILER_ADDR[];
extern char ANON_ADDR[];
extern char COMPLAINTS[];
extern FILE *repgplist;
extern FILE *remixlist;

/* Function prototypes.  */
int init_remailer (void);
enum message_type scan_message (const char *, char *, const int);
void get_from (const char *, char *);
void remove_headers (FILE *, FILE *, enum message_type);
int rxmatch (const char *, const char *);
void flushleft (char *, const unsigned);
void chop (char *);
int strileft (const char *, const char *);
int strifind (const char *, const char *);
int strieq (const char *, const char *);
int rxfind (const char *, const char *);
int findline (const char *, FILE *);
void print_list (FILE *, FILE *);
void cut (const char *, const char *, const char *, const char *);
void mailfile (const char *, const char *);
void runlatentqueue (void);
void queuelatent (const char *, const char *);
int parsetime (const char *, const int);
int run_cmd (const char *, const char *, const char *, FILE *, FILE *, FILE *);
int append_url (const char *, const char *, const char *);
void encrypt_sub (const char *, const char *);
void updatestats (enum stats_flag);
void mailstats (const char *);
void mailconf (const char *);

#endif /* !FREEDOM_H */
