/****************************************************************************
  This file is part of the Freedom Remailer.  It is:
  Copyright (C) 1995  John B. Fleming (jfleming@indiana.edu)
  Changes are (C) 1997 Johannes Kroeger (hanne@squirrel.owl.de)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "config.h"

void queuelatent(const char *origfile, char *queuefile, char *controlfile,
		 const char *latentTime)
{
  char input[BUFSIZ], temp[BUFSIZ];
  FILE *in, *out;
  int time1, time2, linenum, headers, day;
  struct tm *curtime;
  time_t now;

  now = time(NULL);
  curtime = localtime(&now);
  time1 = (curtime->tm_hour * 60) + curtime->tm_min;
  day = curtime->tm_wday;
  time2 = parsetime(latentTime, time1);
  if (time2 < time1) {
    day++;
    if (day == 7)
      day = 0;
  }
  out = fopen(controlfile, "w");
  fprintf(out, "%d\n%d\n", day, time2);
  fclose(out);

  in = fopen(origfile, "r");
  if (in == NULL) {
    out = fopen(queuefile, "w");
    fclose(out);
    return;
  }
  out = fopen(queuefile, "w");

  headers = 1;
  linenum = 0;
  while (fgets(input, sizeof(input), in)) {
    if (!headers) {
      if ((linenum > 1) || (strlen(input) > 1))
	linenum++;
      if ((linenum == 1) && (strstr(input, "::") != NULL))
	headers = 1;
      fputs(input, out);
    } else {
      if (strlen(input) <= 1)
	headers = 0;
      strcpy(temp, input);
      stringlower(temp);
      if (strncmp(temp, "latent-time:", 12) != 0)
	fputs(input, out);
    }
  }
  fclose(in);
  fclose(out);
}

int parsetime(const char *latent, const int time_now)
{
  char hour[3], minute[3];
  int tim, ranmax;
  hour[2] = '\0'; minute[2] = '\0';

  srand(time(NULL) & RAND_MAX); /* RAND_MAX + 1 should be a power of 2 */
  if (isdigit(latent[0])) { /* no '+': parse as time given */
    if (isdigit(latent[1]) && (latent[2] == ':') &&
	isdigit(latent[3]) && isdigit(latent[4])) { /* two-digit hour */
      hour[0] = latent[0]; hour[1] = latent[1];
      minute[0] = latent[3]; minute[1] = latent[4];
      if (tolower(latent[5]) == 'r') { /* hh:mmR */
	ranmax = (atoi(hour) * 60) + atoi(minute) - time_now;
	if (ranmax < 0) ranmax += 1440;
	tim = ((rand() % ranmax) + time_now) % 1440;
      } else { /* hh:mm */
	tim = ((atoi(hour) * 60) + atoi(minute)) % 1440;
      }
    } else if ((latent[1] == ':') &&
	       isdigit(latent[2]) && isdigit(latent[3])) { /* one-digit hour */
      hour[0] = latent[0]; hour[1] = '\0';
      minute[0] = latent[2]; minute[1] = latent[3];
      if (tolower(latent[4]) == 'r') { /* h:mmR */
	ranmax = (atoi(hour) * 60) + atoi(minute) - time_now;
	if (ranmax < 0) ranmax += 1440;
	tim = ((rand() % ranmax) + time_now) % 1440;
      } else { /* h:mm */
	tim = ((atoi(hour) * 60) + atoi(minute)) % 1440;
      }
    } else { /* invalid time string: no latency */
      tim = time_now % 1440;
    }
  } else if (latent[0] == '+') { /* '+': parse as delay */
    if (isdigit(latent[1]) && isdigit(latent[2]) && (latent[3] == ':') &&
	isdigit(latent[4]) && isdigit(latent[5])) { /* two-digit hour */
      hour[0] = latent[1]; hour[1] = latent[2];
      minute[0] = latent[4]; minute[1] = latent[5];
      if (tolower(latent[6]) == 'r') { /* +hh:mmR */
	ranmax = (atoi(hour) * 60) + atoi(minute);
	tim = ((rand() % ranmax) + time_now) % 1440;
      } else { /* +hh:mm */
	tim = (time_now + (atoi(hour) * 60) + atoi(minute)) % 1440;
      }
    } else if (isdigit(latent[1]) && (latent[2] == ':') &&
	       isdigit(latent[3]) && isdigit(latent[4])) { /* one-digit hour */
      hour[0] = latent[1]; hour[1] = '\0';
      minute[0] = latent[3]; minute[1] = latent[4];
      if (tolower(latent[5]) == 'r') { /* +h:mmR */
	ranmax = (atoi(hour) * 60) + atoi(minute);
	tim = ((rand() % ranmax) + time_now) % 1440;
      } else { /* +h:mm */
	tim = (time_now + (atoi(hour) * 60) + atoi(minute)) % 1440;
      }
    } else { /* invalid time string: no latency */
      tim = time_now % 1440;
    }
  } else { /* invalid time string: no latency */
    tim = time_now % 1440;
  }
  return tim;
}
