/* traditional rot13 caesar crypt.
 * Jun-ichiro "itojun" Itoh (itojun@csl.sony.co.jp)
 * Freely redistributable.
 */

#ifndef STANDALONE
# include "defs.h"
# include "interfac.h"
#else
# include <stdio.h>
# include <stdlib.h>
#endif

char	*rot13(str)
	char	*str;
{
	static	char	*cnvtbl = NULL;
	unsigned char	*p;

	if (!cnvtbl)
	{
		int	i;

#ifndef STANDALONE
		cnvtbl = m_alloc(256);
#else
		cnvtbl = malloc(256);
#endif
		for (i = 0; i < 256; i++)
		{
			cnvtbl[i] = i;
		}
		for (i = 'A'; i <= 'Z'; i++)
		{
			cnvtbl[i] = (i - 'A' + 13) % 26 + 'A';
		}
		for (i = 'a'; i <= 'z'; i++)
		{
			cnvtbl[i] = (i - 'a' + 13) % 26 + 'a';
		}
	}

	for (p = (unsigned char *)str; *p; p++)
	{
		*p = cnvtbl[*p];
	}

	return str;
}

#ifdef STANDALONE
void	main()
{
	char	buf[1024];

	while (fgets(buf, 1024, stdin))
	{
		rot13(buf);
		fputs(buf, stdout);
	}
}
#endif
