/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.Vector;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.LiveRef;

class ConnectionInputStream
extends MarshalInputStream {
    private boolean ack = false;
    private Vector objList;
    private UID ackID = new UID();

    ConnectionInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    void readID() throws IOException {
        this.ackID = UID.read(this);
    }

    void saveRef(LiveRef liveRef) {
        if (this.objList == null) {
            this.objList = new Vector();
        }
        this.objList.addElement(liveRef);
    }

    void registerRefs() throws IOException {
        try {
            try {
                if (this.objList != null) {
                    Enumeration enumeration = this.objList.elements();
                    while (enumeration.hasMoreElements()) {
                        LiveRef liveRef = (LiveRef)enumeration.nextElement();
                        DGCClient.referenced(liveRef);
                    }
                }
            }
            catch (RemoteException remoteException) {
                if (DGCImpl.logLevel >= 10) {
                    LogStream logStream = LogStream.log("dgc");
                    logStream.println("ConnectionInputStream.registerRefs: exception: ");
                    remoteException.printStackTrace(logStream);
                }
                throw remoteException;
            }
            Object var2_5 = null;
            this.objList = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.objList = null;
            throw throwable;
        }
    }

    void setAckNeeded() {
        this.ack = true;
    }

    void done(Connection connection) {
        if (this.ack) {
            Connection connection2 = null;
            Channel channel = null;
            boolean bl = true;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("ConnectionInputStream.done: send ack");
            }
            try {
                channel = connection.getChannel();
                connection2 = channel.newConnection();
                DataOutputStream dataOutputStream = new DataOutputStream(connection2.getOutputStream());
                dataOutputStream.writeByte(84);
                this.ackID.write(dataOutputStream);
                connection2.releaseOutputStream();
            }
            catch (RemoteException remoteException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            try {
                if (connection2 != null) {
                    channel.free(connection2, bl);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

