/*
**  This is Snefru, derived from the Xerox Secure Hash Function.
**  Snefru is a one-way hash function that provides authentication.
**  It does not provide secrecy.
**
**  Snefru is named after a Pharaoh of ancient Egypt.
**
**  It is based on code that is:
**	Copyright (c) Xerox Corporation 1989.  All rights reserved.
**
**	License to copy and use this software is granted provided that it
**	is identified as the 'Xerox Secure Hash Function' in all material
**	mentioning or referencing this software or this hash function.
**
**	License is also granted to make and use derivative works provided
**	that such works are identified as 'derived from the Xerox Secure
**	Hash Function' in all material mentioning or referencing the
**	derived work.
**
**	Xerox Corporation makes no representations concerning either the
**	merchantability of this software or the suitability of this
**	software for any particular purpose.  It is provided "as is"
**	without express or implied warranty of any kind.
**
**	These notices must be retained in any copies of any part of this
**	software.
**
**  Based on the reference implementation (no algorithm changes) of
**  version 2.0, July 31, 1989.  Implementor:  Ralph C. Merkle.
**  This edition is by Rich $alz, <rsalz@bbn.com>.
**
**  This is the standard S box used by the one-way hash function Snefru.
**  See the paper 'A Software One Way Hash Function', by Ralph C. Merkle,
**  for a more detailed explanation.
*/
#include "snefru.h"
#ifdef	RCSID
static char RCS[] =
	"$Header: sboxes.c,v 1.1 90/03/22 13:00:03 rsalz Exp $";
#endif	/* RCSID */


WORD32	SnefruSBoxes[SBOXCOUNT][256] = {
    {	/* Start of S box 0 */
	0x64F9001B, /*  0  */
	0xFEDDCDF6, /*  1  */
	0x7C8FF1E2, /*  2  */
	0x11D71514, /*  3  */
	0x8B8C18D3, /*  4  */
	0xDDDF881E, /*  5  */
	0x6EAB5056, /*  6  */
	0x88CED8E1, /*  7  */
	0x49148959, /*  8  */
	0x69C56FD5, /*  9  */
	0xB7994F03, /*  10  */
	0x0FBCEE3E, /*  11  */
	0x3C264940, /*  12  */
	0x21557E58, /*  13  */
	0xE14B3FC2, /*  14  */
	0x2E5CF591, /*  15  */
	0xDCEFF8CE, /*  16  */
	0x092A1648, /*  17  */
	0xBE812936, /*  18  */
	0xFF7B0C6A, /*  19  */
	0xD5251037, /*  20  */
	0xAFA448F1, /*  21  */
	0x7DAFC95A, /*  22  */
	0x1EA69C3F, /*  23  */
	0xA417ABE7, /*  24  */
	0x5890E423, /*  25  */
	0xB0CB70C0, /*  26  */
	0xC85025F7, /*  27  */
	0x244D97E3, /*  28  */
	0x1FF3595F, /*  29  */
	0xC4EC6396, /*  30  */
	0x59181E17, /*  31  */
	0xE635B477, /*  32  */
	0x354E7DBF, /*  33  */
	0x796F7753, /*  34  */
	0x66EB52CC, /*  35  */
	0x77C3F995, /*  36  */
	0x32E3A927, /*  37  */
	0x80CCAED6, /*  38  */
	0x4E2BE89D, /*  39  */
	0x375BBD28, /*  40  */
	0xAD1A3D05, /*  41  */
	0x2B1B42B3, /*  42  */
	0x16C44C71, /*  43  */
	0x4D54BFA8, /*  44  */
	0xE57DDC7A, /*  45  */
	0xEC6D8144, /*  46  */
	0x5A71046B, /*  47  */
	0xD8229650, /*  48  */
	0x87FC8F24, /*  49  */
	0xCBC60E09, /*  50  */
	0xB6390366, /*  51  */
	0xD9F76092, /*  52  */
	0xD393A70B, /*  53  */
	0x1D31A08A, /*  54  */
	0x9CD971C9, /*  55  */
	0x5C1EF445, /*  56  */
	0x86FAB694, /*  57  */
	0xFDB44165, /*  58  */
	0x8EAAFCBE, /*  59  */
	0x4BCAC6EB, /*  60  */
	0xFB7A94E5, /*  61  */
	0x5789D04E, /*  62  */
	0xFA13CF35, /*  63  */
	0x236B8DA9, /*  64  */
	0x4133F000, /*  65  */
	0x6224261C, /*  66  */
	0xF412F23B, /*  67  */
	0xE75E56A4, /*  68  */
	0x30022116, /*  69  */
	0xBAF17F1F, /*  70  */
	0xD09872F9, /*  71  */
	0xC1A3699C, /*  72  */
	0xF1E802AA, /*  73  */
	0x0DD145DC, /*  74  */
	0x4FDCE093, /*  75  */
	0x8D8412F0, /*  76  */
	0x6CD0F376, /*  77  */
	0x3DE6B73D, /*  78  */
	0x84BA737F, /*  79  */
	0xB43A30F2, /*  80  */
	0x44569F69, /*  81  */
	0x00E4EACA, /*  82  */
	0xB58DE3B0, /*  83  */
	0x959113C8, /*  84  */
	0xD62EFEE9, /*  85  */
	0x90861F83, /*  86  */
	0xCED69874, /*  87  */
	0x2F793CEE, /*  88  */
	0xE8571C30, /*  89  */
	0x483665D1, /*  90  */
	0xAB07B031, /*  91  */
	0x914C844F, /*  92  */
	0x15BF3BE8, /*  93  */
	0x2C3F2A9A, /*  94  */
	0x9EB95FD4, /*  95  */
	0x92E7472D, /*  96  */
	0x2297CC5B, /*  97  */
	0xEE5F2782, /*  98  */
	0x5377B562, /*  99  */
	0xDB8EBBCF, /*  100  */
	0xF961DEDD, /*  101  */
	0xC59B5C60, /*  102  */
	0x1BD3910D, /*  103  */
	0x26D206AD, /*  104  */
	0xB28514D8, /*  105  */
	0x5ECF6B52, /*  106  */
	0x7FEA78BB, /*  107  */
	0x504879AC, /*  108  */
	0xED34A884, /*  109  */
	0x36E51D3C, /*  110  */
	0x1753741D, /*  111  */
	0x8C47CAED, /*  112  */
	0x9D0A40EF, /*  113  */
	0x3145E221, /*  114  */
	0xDA27EB70, /*  115  */
	0xDF730BA3, /*  116  */
	0x183C8789, /*  117  */
	0x739AC0A6, /*  118  */
	0x9A58DFC6, /*  119  */
	0x54B134C1, /*  120  */
	0xAC3E242E, /*  121  */
	0xCC493902, /*  122  */
	0x7B2DDA99, /*  123  */
	0x8F15BC01, /*  124  */
	0x29FD38C7, /*  125  */
	0x27D5318F, /*  126  */
	0x604AAFF5, /*  127  */
	0xF29C6818, /*  128  */
	0xC38AA2EC, /*  129  */
	0x1019D4C3, /*  130  */
	0xA8FB936E, /*  131  */
	0x20ED7B39, /*  132  */
	0x0B686119, /*  133  */
	0x89A0906F, /*  134  */
	0x1CC7829E, /*  135  */
	0x9952EF4B, /*  136  */
	0x850E9E8C, /*  137  */
	0xCD063A90, /*  138  */
	0x67002F8E, /*  139  */
	0xCFAC8CB7, /*  140  */
	0xEAA24B11, /*  141  */
	0x988B4E6C, /*  142  */
	0x46F066DF, /*  143  */
	0xCA7EEC08, /*  144  */
	0xC7BBA664, /*  145  */
	0x831D17BD, /*  146  */
	0x63F575E6, /*  147  */
	0x9764350E, /*  148  */
	0x47870D42, /*  149  */
	0x026CA4A2, /*  150  */
	0x8167D587, /*  151  */
	0x61B6ADAB, /*  152  */
	0xAA6564D2, /*  153  */
	0x70DA237B, /*  154  */
	0x25E1C74A, /*  155  */
	0xA1C901A0, /*  156  */
	0x0EB0A5DA, /*  157  */
	0x7670F741, /*  158  */
	0x51C05AEA, /*  159  */
	0x933DFA32, /*  160  */
	0x0759FF1A, /*  161  */
	0x56010AB8, /*  162  */
	0x5FDECB78, /*  163  */
	0x3F32EDF8, /*  164  */
	0xAEBEDBB9, /*  165  */
	0x39F8326D, /*  166  */
	0xD20858C5, /*  167  */
	0x9B638BE4, /*  168  */
	0xA572C80A, /*  169  */
	0x28E0A19F, /*  170  */
	0x432099FC, /*  171  */
	0x3A37C3CD, /*  172  */
	0xBF95C585, /*  173  */
	0xB392C12A, /*  174  */
	0x6AA707D7, /*  175  */
	0x52F66A61, /*  176  */
	0x12D483B1, /*  177  */
	0x96435B5E, /*  178  */
	0x3E75802B, /*  179  */
	0x3BA52B33, /*  180  */
	0xA99F51A5, /*  181  */
	0xBDA1E157, /*  182  */
	0x78C2E70C, /*  183  */
	0xFCAE7CE0, /*  184  */
	0xD1602267, /*  185  */
	0x2AFFAC4D, /*  186  */
	0x4A510947, /*  187  */
	0x0AB2B83A, /*  188  */
	0x7A04E579, /*  189  */
	0x340DFD80, /*  190  */
	0xB916E922, /*  191  */
	0xE29D5E9B, /*  192  */
	0xF5624AF4, /*  193  */
	0x4CA9D9AF, /*  194  */
	0x6BBD2CFE, /*  195  */
	0xE3B7F620, /*  196  */
	0xC2746E07, /*  197  */
	0x5B42B9B6, /*  198  */
	0xA06919BC, /*  199  */
	0xF0F2C40F, /*  200  */
	0x72217AB5, /*  201  */
	0x14C19DF3, /*  202  */
	0xF3802DAE, /*  203  */
	0xE094BEB4, /*  204  */
	0xA2101AFF, /*  205  */
	0x0529575D, /*  206  */
	0x55CDB27C, /*  207  */
	0xA33BDDB2, /*  208  */
	0x6528B37D, /*  209  */
	0x740C05DB, /*  210  */
	0xE96A62C4, /*  211  */
	0x40782846, /*  212  */
	0x6D30D706, /*  213  */
	0xBBF48E2C, /*  214  */
	0xBCE2D3DE, /*  215  */
	0x049E37FA, /*  216  */
	0x01B5E634, /*  217  */
	0x2D886D8D, /*  218  */
	0x7E5A2E7E, /*  219  */
	0xD7412013, /*  220  */
	0x06E90F97, /*  221  */
	0xE45D3EBA, /*  222  */
	0xB8AD3386, /*  223  */
	0x13051B25, /*  224  */
	0x0C035354, /*  225  */
	0x71C89B75, /*  226  */
	0xC638FBD0, /*  227  */
	0x197F11A1, /*  228  */
	0xEF0F08FB, /*  229  */
	0xF8448651, /*  230  */
	0x38409563, /*  231  */
	0x452F4443, /*  232  */
	0x5D464D55, /*  233  */
	0x03D8764C, /*  234  */
	0xB1B8D638, /*  235  */
	0xA70BBA2F, /*  236  */
	0x94B3D210, /*  237  */
	0xEB6692A7, /*  238  */
	0xD409C2D9, /*  239  */
	0x68838526, /*  240  */
	0xA6DB8A15, /*  241  */
	0x751F6C98, /*  242  */
	0xDE769A88, /*  243  */
	0xC9EE4668, /*  244  */
	0x1A82A373, /*  245  */
	0x0896AA49, /*  246  */
	0x42233681, /*  247  */
	0xF62C55CB, /*  248  */
	0x9F1C5404, /*  249  */
	0xF74FB15C, /*  250  */
	0xC06E4312, /*  251  */
	0x6FFE5D72, /*  252  */
	0x8AA8678B, /*  253  */
	0x337CD129, /*  254  */
	0x8211CEFD  /*  255  */
    },

    {	/* Start of S box 1 */
	0x074A1D09, /*  0  */
	0x52A10E5A, /*  1  */
	0x9275A3F8, /*  2  */
	0x4B82506C, /*  3  */
	0x37DF7E1B, /*  4  */
	0x4C78B3C5, /*  5  */
	0xCEFAB1DA, /*  6  */
	0xF472267E, /*  7  */
	0xB63045F6, /*  8  */
	0xD66A1FC0, /*  9  */
	0x400298E3, /*  10  */
	0x27E60C94, /*  11  */
	0x87D2F1B8, /*  12  */
	0xDF9E56CC, /*  13  */
	0x45CD1803, /*  14  */
	0x1D35E098, /*  15  */
	0xCCE7C736, /*  16  */
	0x03483BF1, /*  17  */
	0x1F7307D7, /*  18  */
	0xC6E8F948, /*  19  */
	0xE613C111, /*  20  */
	0x3955C6FF, /*  21  */
	0x1170ED7C, /*  22  */
	0x8E95DA41, /*  23  */
	0x99C31BF4, /*  24  */
	0xA4DA8021, /*  25  */
	0x7B5F94FB, /*  26  */
	0xDD0DA51F, /*  27  */
	0x6562AA77, /*  28  */
	0x556BCB23, /*  29  */
	0xDB1BACC6, /*  30  */
	0x798040B9, /*  31  */
	0xBFE5378F, /*  32  */
	0x731D55E6, /*  33  */
	0xDAA5BFEE, /*  34  */
	0x389BBC60, /*  35  */
	0x1B33FBA4, /*  36  */
	0x9C567204, /*  37  */
	0x36C26C68, /*  38  */
	0x77EE9D69, /*  39  */
	0x8AEB3E88, /*  40  */
	0x2D50B5CE, /*  41  */
	0x9579E790, /*  42  */
	0x42B13CFC, /*  43  */
	0x33FBD32B, /*  44  */
	0xEE0503A7, /*  45  */
	0xB5862824, /*  46  */
	0x15E41EAD, /*  47  */
	0xC8412EF7, /*  48  */
	0x9D441275, /*  49  */
	0x2FCEC582, /*  50  */
	0x5FF483B7, /*  51  */
	0x8F3931DF, /*  52  */
	0x2E5D2A7B, /*  53  */
	0x49467BF9, /*  54  */
	0x0653DEA9, /*  55  */
	0x2684CE35, /*  56  */
	0x7E655E5C, /*  57  */
	0xF12771D8, /*  58  */
	0xBB15CC67, /*  59  */
	0xAB097CA1, /*  60  */
	0x983DCF52, /*  61  */
	0x10DDF026, /*  62  */
	0x21267F57, /*  63  */
	0x2C58F6B4, /*  64  */
	0x31043265, /*  65  */
	0x0BAB8C01, /*  66  */
	0xD5492099, /*  67  */
	0xACAAE619, /*  68  */
	0x944CE54A, /*  69  */
	0xF2D13D39, /*  70  */
	0xADD3FC32, /*  71  */
	0xCDA08A40, /*  72  */
	0xE2B0D451, /*  73  */
	0x9EFE08AE, /*  74  */
	0xB9D50FD2, /*  75  */
	0xEA5CD7FD, /*  76  */
	0xC9A749DD, /*  77  */
	0x13EA2253, /*  78  */
	0x832DEBAA, /*  79  */
	0x24BE640F, /*  80  */
	0xE03E926A, /*  81  */
	0x29E01CDE, /*  82  */
	0x8BF59F18, /*  83  */
	0x0F9D00B6, /*  84  */
	0xE1238B46, /*  85  */
	0x1E7D8E34, /*  86  */
	0x93619ADB, /*  87  */
	0x76B32F9F, /*  88  */
	0xBD972CEC, /*  89  */
	0xE31FA976, /*  90  */
	0xA68FBB10, /*  91  */
	0xFB3BA49D, /*  92  */
	0x8587C41D, /*  93  */
	0xA5ADD1D0, /*  94  */
	0xF3CF84BF, /*  95  */
	0xD4E11150, /*  96  */
	0xD9FFA6BC, /*  97  */
	0xC3F6018C, /*  98  */
	0xAEF10572, /*  99  */
	0x74A64B2F, /*  100  */
	0xE7DC9559, /*  101  */
	0x2AAE35D5, /*  102  */
	0x5B6F587F, /*  103  */
	0xA9E353FE, /*  104  */
	0xCA4FB674, /*  105  */
	0x04BA24A8, /*  106  */
	0xE5C6875F, /*  107  */
	0xDCBC6266, /*  108  */
	0x6BC5C03F, /*  109  */
	0x661EEF02, /*  110  */
	0xED740BAB, /*  111  */
	0x058E34E4, /*  112  */
	0xB7E946CF, /*  113  */
	0x88698125, /*  114  */
	0x72EC48ED, /*  115  */
	0xB11073A3, /*  116  */
	0xA13485EB, /*  117  */
	0xA2A2429C, /*  118  */
	0xFA407547, /*  119  */
	0x50B76713, /*  120  */
	0x5418C37D, /*  121  */
	0x96192DA5, /*  122  */
	0x170BB04B, /*  123  */
	0x518A021E, /*  124  */
	0xB0AC13D1, /*  125  */
	0x0963FA2A, /*  126  */
	0x4A6E10E1, /*  127  */
	0x58472BDC, /*  128  */
	0xF7F8D962, /*  129  */
	0x979139EA, /*  130  */
	0x8D856538, /*  131  */
	0xC0997042, /*  132  */
	0x48324D7A, /*  133  */
	0x447623CB, /*  134  */
	0x8CBBE364, /*  135  */
	0x6E0C6B0E, /*  136  */
	0xD36D63B0, /*  137  */
	0x3F244C84, /*  138  */
	0x3542C971, /*  139  */
	0x2B228DC1, /*  140  */
	0xCB0325BB, /*  141  */
	0xF8C0D6E9, /*  142  */
	0xDE11066B, /*  143  */
	0xA8649327, /*  144  */
	0xFC31F83E, /*  145  */
	0x7DD80406, /*  146  */
	0xF916DD61, /*  147  */
	0xD89F79D3, /*  148  */
	0x615144C2, /*  149  */
	0xEBB45D31, /*  150  */
	0x28002958, /*  151  */
	0x56890A37, /*  152  */
	0xF05B3808, /*  153  */
	0x123AE844, /*  154  */
	0x86839E16, /*  155  */
	0x914B0D83, /*  156  */
	0xC506B43C, /*  157  */
	0xCF3CBA5E, /*  158  */
	0x7C60F5C9, /*  159  */
	0x22DEB2A0, /*  160  */
	0x5D9C2715, /*  161  */
	0xC77BA0EF, /*  162  */
	0x4F45360B, /*  163  */
	0xC1017D8B, /*  164  */
	0xE45ADC29, /*  165  */
	0xA759909B, /*  166  */
	0x412CD293, /*  167  */
	0xD7D796B1, /*  168  */
	0x00C8FF30, /*  169  */
	0x23A34A80, /*  170  */
	0x4EC15C91, /*  171  */
	0x714E78B5, /*  172  */
	0x47B9E42E, /*  173  */
	0x78F3EA4D, /*  174  */
	0x7F078F5B, /*  175  */
	0x346C593A, /*  176  */
	0xA3A87A1A, /*  177  */
	0x9BCBFE12, /*  178  */
	0x3D439963, /*  179  */
	0xB2EF6D8E, /*  180  */
	0xB8D46028, /*  181  */
	0x6C2FD5CA, /*  182  */
	0x62675256, /*  183  */
	0x01F2A2F3, /*  184  */
	0xBC96AE0A, /*  185  */
	0x709A8920, /*  186  */
	0xB4146E87, /*  187  */
	0x6308B9E2, /*  188  */
	0x64BDA7BA, /*  189  */
	0xAFED6892, /*  190  */
	0x6037F2A2, /*  191  */
	0xF52969E0, /*  192  */
	0x0ADB43A6, /*  193  */
	0x82811400, /*  194  */
	0x90D0BDF0, /*  195  */
	0x19C9549E, /*  196  */
	0x203F6A73, /*  197  */
	0x1ACCAF4F, /*  198  */
	0x89714E6D, /*  199  */
	0x164D4705, /*  200  */
	0x67665F07, /*  201  */
	0xEC206170, /*  202  */
	0x0C2182B2, /*  203  */
	0xA02B9C81, /*  204  */
	0x53289722, /*  205  */
	0xF6A97686, /*  206  */
	0x140E4179, /*  207  */
	0x9F778849, /*  208  */
	0x9A88E15D, /*  209  */
	0x25CADB54, /*  210  */
	0xD157F36F, /*  211  */
	0x32A421C3, /*  212  */
	0xB368E98A, /*  213  */
	0x5A92CD0D, /*  214  */
	0x757AA8D4, /*  215  */
	0xC20AC278, /*  216  */
	0x08B551C7, /*  217  */
	0x849491E8, /*  218  */
	0x4DC75AD6, /*  219  */
	0x697C33BE, /*  220  */
	0xBAF0CA33, /*  221  */
	0x46125B4E, /*  222  */
	0x59D677B3, /*  223  */
	0x30D9C8F2, /*  224  */
	0xD0AF860C, /*  225  */
	0x1C7FD0FA, /*  226  */
	0xFE0FF72C, /*  227  */
	0x5C8D6F43, /*  228  */
	0x57FDEC3B, /*  229  */
	0x6AB6AD97, /*  230  */
	0xD22ADF89, /*  231  */
	0x18171785, /*  232  */
	0x02BFE22D, /*  233  */
	0x6DB80917, /*  234  */
	0x80B216AF, /*  235  */
	0xE85E4F9A, /*  236  */
	0x7A1C306E, /*  237  */
	0x6FC49BF5, /*  238  */
	0x3AF7A11C, /*  239  */
	0x81E215E7, /*  240  */
	0x68363FCD, /*  241  */
	0x3E9357C8, /*  242  */
	0xEF52FD55, /*  243  */
	0x3B8BAB4C, /*  244  */
	0x3C8CF495, /*  245  */
	0xBEFCEEBD, /*  246  */
	0xFD25B714, /*  247  */
	0xC498D83D, /*  248  */
	0x0D2E1A8D, /*  249  */
	0xE9F966AC, /*  250  */
	0x0E387445, /*  251  */
	0x435419E5, /*  252  */
	0x5E7EBEC4, /*  253  */
	0xAA90B8D9, /*  254  */
	0xFF1A3A96  /*  255  */
    },

    {	/* Start of S box 2 */
	0x4A8FE4E3, /*  0  */
	0xF27D99CD, /*  1  */
	0xD04A40CA, /*  2  */
	0xCB5FF194, /*  3  */
	0x3668275A, /*  4  */
	0xFF4816BE, /*  5  */
	0xA78B394C, /*  6  */
	0x4C6BE9DB, /*  7  */
	0x4EEC38D2, /*  8  */
	0x4296EC80, /*  9  */
	0xCDCE96F8, /*  10  */
	0x888C2F38, /*  11  */
	0xE75508F5, /*  12  */
	0x7B916414, /*  13  */
	0x060AA14A, /*  14  */
	0xA214F327, /*  15  */
	0xBE608DAF, /*  16  */
	0x1EBBDEC2, /*  17  */
	0x61F98CE9, /*  18  */
	0xE92156FE, /*  19  */
	0x4F22D7A3, /*  20  */
	0x3F76A8D9, /*  21  */
	0x559A4B33, /*  22  */
	0x38AD2959, /*  23  */
	0xF3F17E9E, /*  24  */
	0x85E1BA91, /*  25  */
	0xE5EBA6FB, /*  26  */
	0x73DCD48C, /*  27  */
	0xF5C3FF78, /*  28  */
	0x481B6058, /*  29  */
	0x8A3297F7, /*  30  */
	0x8F1F3BF4, /*  31  */
	0x93785AB2, /*  32  */
	0x477A4A5B, /*  33  */
	0x6334EB5D, /*  34  */
	0x6D251B2E, /*  35  */
	0x74A9102D, /*  36  */
	0x07E38FFA, /*  37  */
	0x915C9C62, /*  38  */
	0xCCC275EA, /*  39  */
	0x6BE273EC, /*  40  */
	0x3EBDDD70, /*  41  */
	0xD895796C, /*  42  */
	0xDC54A91B, /*  43  */
	0xC9AFDF81, /*  44  */
	0x23633F73, /*  45  */
	0x275119B4, /*  46  */
	0xB19F6B67, /*  47  */
	0x50756E22, /*  48  */
	0x2BB152E2, /*  49  */
	0x76EA46A2, /*  50  */
	0xA353E232, /*  51  */
	0x2F596AD6, /*  52  */
	0x0B1EDB0B, /*  53  */
	0x02D3D9A4, /*  54  */
	0x78B47843, /*  55  */
	0x64893E90, /*  56  */
	0x40F0CAAD, /*  57  */
	0xF68D3AD7, /*  58  */
	0x46FD1707, /*  59  */
	0x1C9C67EF, /*  60  */
	0xB5E086DE, /*  61  */
	0x96EE6CA6, /*  62  */
	0x9AA34774, /*  63  */
	0x1BA4F48A, /*  64  */
	0x8D01ABFD, /*  65  */
	0x183EE1F6, /*  66  */
	0x5FF8AA7A, /*  67  */
	0x17E4FAAE, /*  68  */
	0x303983B0, /*  69  */
	0x6C08668B, /*  70  */
	0xD4AC4382, /*  71  */
	0xE6C5849F, /*  72  */
	0x92FEFB53, /*  73  */
	0xC1CAC4CE, /*  74  */
	0x43501388, /*  75  */
	0x441118CF, /*  76  */
	0xEC4FB308, /*  77  */
	0x53A08E86, /*  78  */
	0x9E0FE0C5, /*  79  */
	0xF91C1525, /*  80  */
	0xAC45BE05, /*  81  */
	0xD7987CB5, /*  82  */
	0x49BA1487, /*  83  */
	0x57938940, /*  84  */
	0xD5877648, /*  85  */
	0xA958727F, /*  86  */
	0x58DFE3C3, /*  87  */
	0xF436CF77, /*  88  */
	0x399E4D11, /*  89  */
	0xF0A5BFA9, /*  90  */
	0xEF61A33B, /*  91  */
	0xA64CAC60, /*  92  */
	0x04A8D0BA, /*  93  */
	0x030DD572, /*  94  */
	0xB83D320F, /*  95  */
	0xCAB23045, /*  96  */
	0xE366F2F0, /*  97  */
	0x815D008D, /*  98  */
	0xC897A43A, /*  99  */
	0x1D352DF3, /*  100  */
	0xB9CC571D, /*  101  */
	0x8BF38744, /*  102  */
	0x72209092, /*  103  */
	0xEBA124EB, /*  104  */
	0xFB99CE5E, /*  105  */
	0x3BB94293, /*  106  */
	0x28DA549C, /*  107  */
	0xAAB8A228, /*  108  */
	0xA4197785, /*  109  */
	0x33C70296, /*  110  */
	0x25F6259B, /*  111  */
	0x5C85DA21, /*  112  */
	0xDF15BDEE, /*  113  */
	0x15B7C7E8, /*  114  */
	0xE2ABEF75, /*  115  */
	0xFCC19BC1, /*  116  */
	0x417FF868, /*  117  */
	0x14884434, /*  118  */
	0x62825179, /*  119  */
	0xC6D5C11C, /*  120  */
	0x0E4705DC, /*  121  */
	0x22700DE0, /*  122  */
	0xD3D2AF18, /*  123  */
	0x9BE822A0, /*  124  */
	0x35B669F1, /*  125  */
	0xC42BB55C, /*  126  */
	0x0A801252, /*  127  */
	0x115BF0FC, /*  128  */
	0x3CD7D856, /*  129  */
	0xB43F5F9D, /*  130  */
	0xC2306516, /*  131  */
	0xA1231C47, /*  132  */
	0xF149207E, /*  133  */
	0x5209A795, /*  134  */
	0x34B3CCD8, /*  135  */
	0x67AEFE54, /*  136  */
	0x2C83924E, /*  137  */
	0x6662CBAC, /*  138  */
	0x5EEDD161, /*  139  */
	0x84E681AA, /*  140  */
	0x5D57D26B, /*  141  */
	0xFA465CC4, /*  142  */
	0x7E3AC3A8, /*  143  */
	0xBF7C0CC6, /*  144  */
	0xE18A9AA1, /*  145  */
	0xC32F0A6F, /*  146  */
	0xB22CC00D, /*  147  */
	0x3D280369, /*  148  */
	0x994E554F, /*  149  */
	0x68F480D3, /*  150  */
	0xADCFF5E6, /*  151  */
	0x3A8EB265, /*  152  */
	0x83269831, /*  153  */
	0xBD568A09, /*  154  */
	0x4BC8AE6A, /*  155  */
	0x69F56D2B, /*  156  */
	0x0F17EAC8, /*  157  */
	0x772EB6C7, /*  158  */
	0x9F41343C, /*  159  */
	0xAB1D0742, /*  160  */
	0x826A6F50, /*  161  */
	0xFEA2097C, /*  162  */
	0x1912C283, /*  163  */
	0xCE185899, /*  164  */
	0xE4444839, /*  165  */
	0x2D8635D5, /*  166  */
	0x65D0B1FF, /*  167  */
	0x865A7F17, /*  168  */
	0x326D9FB1, /*  169  */
	0x59E52820, /*  170  */
	0x0090ADE1, /*  171  */
	0x753C7149, /*  172  */
	0x9DDD8B98, /*  173  */
	0xA5A691DA, /*  174  */
	0x0D0382BB, /*  175  */
	0x8904C930, /*  176  */
	0x086CB000, /*  177  */
	0x6E69D3BD, /*  178  */
	0x24D4E7A7, /*  179  */
	0x05244FD0, /*  180  */
	0x101A5E0C, /*  181  */
	0x6A947DCB, /*  182  */
	0xE840F77B, /*  183  */
	0x7D0C5003, /*  184  */
	0x7C370F1F, /*  185  */
	0x805245ED, /*  186  */
	0xE05E3D3F, /*  187  */
	0x7906880E, /*  188  */
	0xBABFCD35, /*  189  */
	0x1A7EC697, /*  190  */
	0x8C052324, /*  191  */
	0x0C6EC8DF, /*  192  */
	0xD129A589, /*  193  */
	0xC7A75B02, /*  194  */
	0x12D81DE7, /*  195  */
	0xD9BE2A66, /*  196  */
	0x1F4263AB, /*  197  */
	0xDE73FDB6, /*  198  */
	0x2A00680A, /*  199  */
	0x56649E36, /*  200  */
	0x3133ED55, /*  201  */
	0x90FA0BF2, /*  202  */
	0x2910A02A, /*  203  */
	0x949D9D46, /*  204  */
	0xA0D1DCDD, /*  205  */
	0xCFC9B7D4, /*  206  */
	0xD2677BE5, /*  207  */
	0x95CB36B3, /*  208  */
	0x13CD9410, /*  209  */
	0xDBF73313, /*  210  */
	0xB7C6E8C0, /*  211  */
	0xF781414B, /*  212  */
	0x510B016D, /*  213  */
	0xB0DE1157, /*  214  */
	0xD6B0F62C, /*  215  */
	0xBB074ECC, /*  216  */
	0x7F1395B7, /*  217  */
	0xEE792CF9, /*  218  */
	0xEA6FD63E, /*  219  */
	0x5BD6938E, /*  220  */
	0xAF02FC64, /*  221  */
	0xDAB57AB8, /*  222  */
	0x8EDB3784, /*  223  */
	0x8716318F, /*  224  */
	0x164D1A01, /*  225  */
	0x26F26141, /*  226  */
	0xB372E6B9, /*  227  */
	0xF8FC2B06, /*  228  */
	0x7AC00E04, /*  229  */
	0x3727B89A, /*  230  */
	0x97E9BCA5, /*  231  */
	0x9C2A742F, /*  232  */
	0xBC3B1F7D, /*  233  */
	0x7165B471, /*  234  */
	0x609B4C29, /*  235  */
	0x20925351, /*  236  */
	0x5AE72112, /*  237  */
	0x454BE5D1, /*  238  */
	0xC0FFB95F, /*  239  */
	0xDD0EF919, /*  240  */
	0x6F2D70C9, /*  241  */
	0x0974C5BF, /*  242  */
	0x98AA6263, /*  243  */
	0x01D91E4D, /*  244  */
	0x2184BB6E, /*  245  */
	0x70C43C1E, /*  246  */
	0x4D435915, /*  247  */
	0xAE7B8523, /*  248  */
	0xB6FB06BC, /*  249  */
	0x5431EE76, /*  250  */
	0xFDBC5D26, /*  251  */
	0xED77493D, /*  252  */
	0xC5712EE4, /*  253  */
	0xA8380437, /*  254  */
	0x2EEF261A  /*  255  */
    },

    {	/* Start of S box 3 */
	0x5A79392B, /*  0  */
	0xB8AF32C2, /*  1  */
	0x41F7720A, /*  2  */
	0x833A61EC, /*  3  */
	0x13DFEDAC, /*  4  */
	0xC4990BC4, /*  5  */
	0xDC0F54BC, /*  6  */
	0xFEDD5E88, /*  7  */
	0x80DA1881, /*  8  */
	0x4DEA1AFD, /*  9  */
	0xFD402CC6, /*  10  */
	0xAE67CC7A, /*  11  */
	0xC5238525, /*  12  */
	0x8EA01254, /*  13  */
	0xB56B9BD5, /*  14  */
	0x862FBD6D, /*  15  */
	0xAC8575D3, /*  16  */
	0x6FBA3714, /*  17  */
	0xDA7EBF46, /*  18  */
	0x59CD5238, /*  19  */
	0x8AC9DBFE, /*  20  */
	0x353729FC, /*  21  */
	0xE497D7F2, /*  22  */
	0xC3AB84E0, /*  23  */
	0xF05A114B, /*  24  */
	0x7B887A75, /*  25  */
	0xEDC603DD, /*  26  */
	0x5E6FE680, /*  27  */
	0x2C84B399, /*  28  */
	0x884EB1DA, /*  29  */
	0x1CB8C8BF, /*  30  */
	0xAA51098A, /*  31  */
	0xC862231C, /*  32  */
	0x8BAC2221, /*  33  */
	0x21B387E5, /*  34  */
	0x208A430D, /*  35  */
	0x2A3F0F8B, /*  36  */
	0xA5FF9CD2, /*  37  */
	0x6012A2EA, /*  38  */
	0x147A9EE7, /*  39  */
	0xF62A501D, /*  40  */
	0xB4B2E51A, /*  41  */
	0x3EF3484C, /*  42  */
	0xC0253C59, /*  43  */
	0x2B82B536, /*  44  */
	0x0AA9696B, /*  45  */
	0xBE0C109B, /*  46  */
	0xC70B7929, /*  47  */
	0xCE3E8A19, /*  48  */
	0x2F66950E, /*  49  */
	0x459F1C2C, /*  50  */
	0xE68FB93D, /*  51  */
	0xA3C3FF3E, /*  52  */
	0x62B45C62, /*  53  */
	0x300991CB, /*  54  */
	0x01914C57, /*  55  */
	0x7F7BC06A, /*  56  */
	0x182831F5, /*  57  */
	0xE7B74BCA, /*  58  */
	0xFA50F6D0, /*  59  */
	0x523CAA61, /*  60  */
	0xE3A7CF05, /*  61  */
	0xE9E41311, /*  62  */
	0x280A21D1, /*  63  */
	0x6A4297E1, /*  64  */
	0xF24DC67E, /*  65  */
	0xFC3189E6, /*  66  */
	0xB72BF34F, /*  67  */
	0x4B1E67AF, /*  68  */
	0x543402CE, /*  69  */
	0x79A59867, /*  70  */
	0x0648E02A, /*  71  */
	0x00A3AC17, /*  72  */
	0xC6208D35, /*  73  */
	0x6E7F5F76, /*  74  */
	0xA45BB4BE, /*  75  */
	0xF168FA63, /*  76  */
	0x3F4125F3, /*  77  */
	0xF311406F, /*  78  */
	0x02706565, /*  79  */
	0xBFE58022, /*  80  */
	0x0CFCFDD9, /*  81  */
	0x0735A7F7, /*  82  */
	0x8F049092, /*  83  */
	0xD98EDC27, /*  84  */
	0xF5C5D55C, /*  85  */
	0xE0F201DB, /*  86  */
	0x0DCAFC9A, /*  87  */
	0x7727FB79, /*  88  */
	0xAF43ABF4, /*  89  */
	0x26E938C1, /*  90  */
	0x401B26A6, /*  91  */
	0x900720FA, /*  92  */
	0x2752D97B, /*  93  */
	0xCFF1D1B3, /*  94  */
	0xA9D9E424, /*  95  */
	0x42DB99AB, /*  96  */
	0x6CF8BE5F, /*  97  */
	0xE82CEBE3, /*  98  */
	0x3AFB733B, /*  99  */
	0x6B734EB6, /*  100  */
	0x1036414A, /*  101  */
	0x975F667C, /*  102  */
	0x049D6377, /*  103  */
	0xBA587C60, /*  104  */
	0xB1D10483, /*  105  */
	0xDE1AEFCC, /*  106  */
	0x1129D055, /*  107  */
	0x72051E91, /*  108  */
	0x6946D623, /*  109  */
	0xF9E86EA7, /*  110  */
	0x48768C00, /*  111  */
	0xB0166C93, /*  112  */
	0x9956BBF0, /*  113  */
	0x1F1F6D84, /*  114  */
	0xFB15E18E, /*  115  */
	0x033B495D, /*  116  */
	0x56E3362E, /*  117  */
	0x4F44C53C, /*  118  */
	0x747CBA51, /*  119  */
	0x89D37872, /*  120  */
	0x5D9C331B, /*  121  */
	0xD2EF9FA8, /*  122  */
	0x254917F8, /*  123  */
	0x1B106F47, /*  124  */
	0x37D75553, /*  125  */
	0xB3F053B0, /*  126  */
	0x7DCCD8EF, /*  127  */
	0xD30EB802, /*  128  */
	0x5889F42D, /*  129  */
	0x610206D7, /*  130  */
	0x1A7D34A1, /*  131  */
	0x92D87DD8, /*  132  */
	0xE5F4A315, /*  133  */
	0xD1CF0E71, /*  134  */
	0xB22DFE45, /*  135  */
	0xB901E8EB, /*  136  */
	0x0FC0CE5E, /*  137  */
	0x2EFA60C9, /*  138  */
	0x2DE74290, /*  139  */
	0x36D0C906, /*  140  */
	0x381C70E4, /*  141  */
	0x4C6DA5B5, /*  142  */
	0x3D81A682, /*  143  */
	0x7E381F34, /*  144  */
	0x396C4F52, /*  145  */
	0x95AD5901, /*  146  */
	0x1DB50C5A, /*  147  */
	0x29982E9E, /*  148  */
	0x1557689F, /*  149  */
	0x3471EE42, /*  150  */
	0xD7E2F7C0, /*  151  */
	0x8795A1E2, /*  152  */
	0xBC324D8D, /*  153  */
	0xE224C3C8, /*  154  */
	0x12837E39, /*  155  */
	0xCDEE3D74, /*  156  */
	0x7AD2143F, /*  157  */
	0x0E13D40C, /*  158  */
	0x78BD4A68, /*  159  */
	0xA2EB194D, /*  160  */
	0xDB9451F9, /*  161  */
	0x859B71DC, /*  162  */
	0x5C4F5B89, /*  163  */
	0xCA14A8A4, /*  164  */
	0xEF92F003, /*  165  */
	0x16741D98, /*  166  */
	0x33AA4444, /*  167  */
	0x9E967FBB, /*  168  */
	0x092E3020, /*  169  */
	0xD86A35B8, /*  170  */
	0x8CC17B10, /*  171  */
	0xE1BF08AE, /*  172  */
	0x55693FC5, /*  173  */
	0x7680AD13, /*  174  */
	0x1E6546E8, /*  175  */
	0x23B6E7B9, /*  176  */
	0xEE77A4B2, /*  177  */
	0x08ED0533, /*  178  */
	0x44FD2895, /*  179  */
	0xB6393B69, /*  180  */
	0x05D6CACF, /*  181  */
	0x9819B209, /*  182  */
	0xECBBB72F, /*  183  */
	0x9A75779C, /*  184  */
	0xEAEC0749, /*  185  */
	0x94A65AEE, /*  186  */
	0xBDF52DC3, /*  187  */
	0xD6A25D04, /*  188  */
	0x82008E4E, /*  189  */
	0xA6DE160F, /*  190  */
	0x9B036AFB, /*  191  */
	0x228B3A66, /*  192  */
	0x5FB10A70, /*  193  */
	0xCC338B58, /*  194  */
	0x5378A9DF, /*  195  */
	0xC908BCA9, /*  196  */
	0x4959E25B, /*  197  */
	0x46909A97, /*  198  */
	0x66AE8F6E, /*  199  */
	0xDD0683E9, /*  200  */
	0x65F994B4, /*  201  */
	0x6426CDA5, /*  202  */
	0xC24B8840, /*  203  */
	0x32539DA0, /*  204  */
	0x63175650, /*  205  */
	0xD0C815FF, /*  206  */
	0x50CBC41E, /*  207  */
	0xF7C774A3, /*  208  */
	0x31B0C231, /*  209  */
	0x8D0D8116, /*  210  */
	0x24BEF16C, /*  211  */
	0xD555D256, /*  212  */
	0xDF47EA8C, /*  213  */
	0x6D21ECCD, /*  214  */
	0xA887A012, /*  215  */
	0x84542AED, /*  216  */
	0xA7B9C1BD, /*  217  */
	0x914C1BB1, /*  218  */
	0xA0D5B67D, /*  219  */
	0x438CE937, /*  220  */
	0x7030F873, /*  221  */
	0x71F6B0C7, /*  222  */
	0x574576BA, /*  223  */
	0xF8BC4541, /*  224  */
	0x9C61D348, /*  225  */
	0x1960579D, /*  226  */
	0x17C4DAAD, /*  227  */
	0x96A4CB0B, /*  228  */
	0xC193F2F6, /*  229  */
	0x756EAFA2, /*  230  */
	0x7C1D2F94, /*  231  */
	0xF4FE2B43, /*  232  */
	0xCB86E33A, /*  233  */
	0xEBD4C728, /*  234  */
	0x9D18AE64, /*  235  */
	0x9FE13E30, /*  236  */
	0x3CE0F5DE, /*  237  */
	0xABA1F985, /*  238  */
	0xADDC2718, /*  239  */
	0x68CE6278, /*  240  */
	0xD45E241F, /*  241  */
	0xA15C82B7, /*  242  */
	0x3B2293D4, /*  243  */
	0x739EDD32, /*  244  */
	0x674A6BF1, /*  245  */
	0x5B5D587F, /*  246  */
	0x4772DEAA, /*  247  */
	0x4A63968F, /*  248  */
	0x0BE68686, /*  249  */
	0x513D6426, /*  250  */
	0x939A4787, /*  251  */
	0xBBA89296, /*  252  */
	0x4EC20007, /*  253  */
	0x818D0D08, /*  254  */
	0xFF64DFD6  /*  255  */
    },

    {	/* Start of S box 4 */
	0xCB2297CB, /*  0  */
	0xDB48A144, /*  1  */
	0xA16CBE4B, /*  2  */
	0xBBEA1D6C, /*  3  */
	0x5AF6B6B7, /*  4  */
	0x8A8110B6, /*  5  */
	0xF9236EF9, /*  6  */
	0xC98F83E6, /*  7  */
	0x0F9C65B8, /*  8  */
	0x252D4A89, /*  9  */
	0xA497F068, /*  10  */
	0xA5D7ED2D, /*  11  */
	0x94C22845, /*  12  */
	0x9DA1C8C4, /*  13  */
	0xE27C2E2E, /*  14  */
	0x6E8BA2B4, /*  15  */
	0xC3DD17FB, /*  16  */
	0x498CD482, /*  17  */
	0x0DFE6A9F, /*  18  */
	0xB0705829, /*  19  */
	0x9A1E6DC1, /*  20  */
	0xF829717C, /*  21  */
	0x07BB8E3A, /*  22  */
	0xDA3C0B02, /*  23  */
	0x1AF82FC7, /*  24  */
	0x73B70955, /*  25  */
	0x7A04379C, /*  26  */
	0x5EE20A28, /*  27  */
	0x83712AE5, /*  28  */
	0xF4C47C6D, /*  29  */
	0xDF72BA56, /*  30  */
	0xD794858D, /*  31  */
	0x8C0CF709, /*  32  */
	0x18F0F390, /*  33  */
	0xB6C69B35, /*  34  */
	0xBF2F01DB, /*  35  */
	0x2FA74DCA, /*  36  */
	0xD0CD9127, /*  37  */
	0xBDE66CEC, /*  38  */
	0x3DEEBD46, /*  39  */
	0x57C88FC3, /*  40  */
	0xCEE1406F, /*  41  */
	0x0066385A, /*  42  */
	0xF3C3444F, /*  43  */
	0x3A79D5D5, /*  44  */
	0x75751EB9, /*  45  */
	0x3E7F8185, /*  46  */
	0x521C2605, /*  47  */
	0xE1AAAB6E, /*  48  */
	0x38EBB80F, /*  49  */
	0xBEE7E904, /*  50  */
	0x61CB9647, /*  51  */
	0xEA54904E, /*  52  */
	0x05AE00E4, /*  53  */
	0x2D7AC65F, /*  54  */
	0x087751A1, /*  55  */
	0xDCD82915, /*  56  */
	0x0921EE16, /*  57  */
	0xDD86D33B, /*  58  */
	0xD6BD491A, /*  59  */
	0x40FBADF0, /*  60  */
	0x4232CBD2, /*  61  */
	0x33808D10, /*  62  */
	0x39098C42, /*  63  */
	0x193F3199, /*  64  */
	0x0BC1E47A, /*  65  */
	0x4A82B149, /*  66  */
	0x02B65A8A, /*  67  */
	0x104CDC8E, /*  68  */
	0x24A8F52C, /*  69  */
	0x685C6077, /*  70  */
	0xC79F95C9, /*  71  */
	0x1D11FE50, /*  72  */
	0xC08DAFCD, /*  73  */
	0x7B1A9A03, /*  74  */
	0x1C1F11D8, /*  75  */
	0x84250E7F, /*  76  */
	0x979DB248, /*  77  */
	0xEBDC0501, /*  78  */
	0xB9553395, /*  79  */
	0xE3C05EA8, /*  80  */
	0xB1E51C4C, /*  81  */
	0x13B0E681, /*  82  */
	0x3B407766, /*  83  */
	0x36DB3087, /*  84  */
	0xEE17C9FC, /*  85  */
	0x6C53ECF2, /*  86  */
	0xADCCC58F, /*  87  */
	0xC427660B, /*  88  */
	0xEFD5867D, /*  89  */
	0x9B6D54A5, /*  90  */
	0x6FF1AEFF, /*  91  */
	0x8E787952, /*  92  */
	0x9E2BFFE0, /*  93  */
	0x8761D034, /*  94  */
	0xE00BDBAD, /*  95  */
	0xAE99A8D3, /*  96  */
	0xCC03F6E2, /*  97  */
	0xFD0ED807, /*  98  */
	0x0E508AE3, /*  99  */
	0xB74182AB, /*  100  */
	0x4349245D, /*  101  */
	0xD120A465, /*  102  */
	0xB246A641, /*  103  */
	0xAF3B7AB0, /*  104  */
	0x2A6488BB, /*  105  */
	0x4B3A0D1F, /*  106  */
	0xE7C7E58C, /*  107  */
	0x3FAFF2EB, /*  108  */
	0x90445FFD, /*  109  */
	0xCF38C393, /*  110  */
	0x995D07E7, /*  111  */
	0xF24F1B36, /*  112  */
	0x356F6891, /*  113  */
	0x6D6EBCBE, /*  114  */
	0x8DA9E262, /*  115  */
	0x50FD520E, /*  116  */
	0x5BCA9E1E, /*  117  */
	0x37472CF3, /*  118  */
	0x69075057, /*  119  */
	0x7EC5FDED, /*  120  */
	0x0CAB892A, /*  121  */
	0xFB2412BA, /*  122  */
	0x1728DEBF, /*  123  */
	0xA000A988, /*  124  */
	0xD843CE79, /*  125  */
	0x042E20DD, /*  126  */
	0x4FE8F853, /*  127  */
	0x56659C3C, /*  128  */
	0x2739D119, /*  129  */
	0xA78A6120, /*  130  */
	0x80960375, /*  131  */
	0x70420611, /*  132  */
	0x85E09F78, /*  133  */
	0xABD17E96, /*  134  */
	0x1B513EAF, /*  135  */
	0x1E01EB63, /*  136  */
	0x26AD2133, /*  137  */
	0xA890C094, /*  138  */
	0x7613CF60, /*  139  */
	0x817E781B, /*  140  */
	0xA39113D7, /*  141  */
	0xE957FA58, /*  142  */
	0x4131B99E, /*  143  */
	0x28B1EFDA, /*  144  */
	0x66ACFBA7, /*  145  */
	0xFF68944A, /*  146  */
	0x77A44FD1, /*  147  */
	0x7F331522, /*  148  */
	0x59FFB3FA, /*  149  */
	0xA6DF935B, /*  150  */
	0xFA12D9DF, /*  151  */
	0xC6BF6F3F, /*  152  */
	0x89520CF6, /*  153  */
	0x659EDD6A, /*  154  */
	0x544DA739, /*  155  */
	0x8B052538, /*  156  */
	0x7C30EA21, /*  157  */
	0xC2345525, /*  158  */
	0x15927FB2, /*  159  */
	0x144A436B, /*  160  */
	0xBA107B8B, /*  161  */
	0x1219AC97, /*  162  */
	0x06730432, /*  163  */
	0x31831AB3, /*  164  */
	0xC55A5C24, /*  165  */
	0xAA0FCD3E, /*  166  */
	0xE5606BE8, /*  167  */
	0x5C88F19B, /*  168  */
	0x4C0841EE, /*  169  */
	0x1FE37267, /*  170  */
	0x11F9C4F4, /*  171  */
	0x9F1B9DAE, /*  172  */
	0x864E76D0, /*  173  */
	0xE637C731, /*  174  */
	0xD97D23A6, /*  175  */
	0x32F53D5C, /*  176  */
	0xB8161980, /*  177  */
	0x93FA0F84, /*  178  */
	0xCAEF0870, /*  179  */
	0x8874487E, /*  180  */
	0x98F2CC73, /*  181  */
	0x645FB5C6, /*  182  */
	0xCD853659, /*  183  */
	0x2062470D, /*  184  */
	0x16EDE8E9, /*  185  */
	0x6B06DAB5, /*  186  */
	0x78B43900, /*  187  */
	0xFC95B786, /*  188  */
	0x5D8E7DE1, /*  189  */
	0x465B5954, /*  190  */
	0xFE7BA014, /*  191  */
	0xF7D23F7B, /*  192  */
	0x92BC8B18, /*  193  */
	0x03593592, /*  194  */
	0x55CEF4F7, /*  195  */
	0x74B27317, /*  196  */
	0x79DE1FC2, /*  197  */
	0xC8A0BFBD, /*  198  */
	0x229398CC, /*  199  */
	0x62A602CE, /*  200  */
	0xBCB94661, /*  201  */
	0x5336D206, /*  202  */
	0xD2A375FE, /*  203  */
	0x6A6AB483, /*  204  */
	0x4702A5A4, /*  205  */
	0xA2E9D73D, /*  206  */
	0x23A2E0F1, /*  207  */
	0x9189140A, /*  208  */
	0x581D18DC, /*  209  */
	0xB39A922B, /*  210  */
	0x82356212, /*  211  */
	0xD5F432A9, /*  212  */
	0xD356C2A3, /*  213  */
	0x5F765B4D, /*  214  */
	0x450AFCC8, /*  215  */
	0x4415E137, /*  216  */
	0xE8ECDFBC, /*  217  */
	0xED0DE3EA, /*  218  */
	0x60D42B13, /*  219  */
	0xF13DF971, /*  220  */
	0x71FC5DA2, /*  221  */
	0xC1455340, /*  222  */
	0xF087742F, /*  223  */
	0xF55E5751, /*  224  */
	0x67B3C1F8, /*  225  */
	0xAC6B8774, /*  226  */
	0x7DCFAAAC, /*  227  */
	0x95983BC0, /*  228  */
	0x489BB0B1, /*  229  */
	0x2C184223, /*  230  */
	0x964B6726, /*  231  */
	0x2BD3271C, /*  232  */
	0x72266472, /*  233  */
	0xDED64530, /*  234  */
	0x0A2AA343, /*  235  */
	0xD4F716A0, /*  236  */
	0xB4DAD6D9, /*  237  */
	0x2184345E, /*  238  */
	0x512C990C, /*  239  */
	0x29D92D08, /*  240  */
	0x2EBE709A, /*  241  */
	0x01144C69, /*  242  */
	0x34584B9D, /*  243  */
	0xE4634ED6, /*  244  */
	0xECC963CF, /*  245  */
	0x3C6984AA, /*  246  */
	0x4ED056EF, /*  247  */
	0x9CA56976, /*  248  */
	0x8F3E80D4, /*  249  */
	0xB5BAE7C5, /*  250  */
	0x30B5CAF5, /*  251  */
	0x63F33A64, /*  252  */
	0xA9E4BBDE, /*  253  */
	0xF6B82298, /*  254  */
	0x4D673C1D  /*  255  */
    },

    {	/* Start of S box 5 */
	0x4B4F1121, /*  0  */
	0xBA183081, /*  1  */
	0xC784F41F, /*  2  */
	0xD17D0BAC, /*  3  */
	0x083D2267, /*  4  */
	0x37B1361E, /*  5  */
	0x3581AD05, /*  6  */
	0xFDA2F6BC, /*  7  */
	0x1E892CDD, /*  8  */
	0xB56D3C3A, /*  9  */
	0x32140E46, /*  10  */
	0x138D8AAB, /*  11  */
	0xE14773D4, /*  12  */
	0x5B0E71DF, /*  13  */
	0x5D1FE055, /*  14  */
	0x3FB991D3, /*  15  */
	0xF1F46C71, /*  16  */
	0xA325988C, /*  17  */
	0x10F66E80, /*  18  */
	0xB1006348, /*  19  */
	0x726A9F60, /*  20  */
	0x3B67F8BA, /*  21  */
	0x4E114EF4, /*  22  */
	0x05C52115, /*  23  */
	0x4C5CA11C, /*  24  */
	0x99E1EFD8, /*  25  */
	0x471B83B3, /*  26  */
	0xCBF7E524, /*  27  */
	0x43AD82F5, /*  28  */
	0x690CA93B, /*  29  */
	0xFAA61BB2, /*  30  */
	0x12A832B5, /*  31  */
	0xB734F943, /*  32  */
	0xBD22AEA7, /*  33  */
	0x88FEC626, /*  34  */
	0x5E80C3E7, /*  35  */
	0xBE3EAF5E, /*  36  */
	0x44617652, /*  37  */
	0xA5724475, /*  38  */
	0xBB3B9695, /*  39  */
	0x7F3FEE8F, /*  40  */
	0x964E7DEB, /*  41  */
	0x518C052D, /*  42  */
	0x2A0BBC2B, /*  43  */
	0xC2175F5C, /*  44  */
	0x9A7B3889, /*  45  */
	0xA70D8D0C, /*  46  */
	0xEACCDD29, /*  47  */
	0xCCCD6658, /*  48  */
	0x34BB25E6, /*  49  */
	0xB8391090, /*  50  */
	0xF651356F, /*  51  */
	0x52987C9E, /*  52  */
	0x0C16C1CD, /*  53  */
	0x8E372D3C, /*  54  */
	0x2FC6EBBD, /*  55  */
	0x6E5DA3E3, /*  56  */
	0xB0E27239, /*  57  */
	0x5F685738, /*  58  */
	0x45411786, /*  59  */
	0x067F65F8, /*  60  */
	0x61778B40, /*  61  */
	0x81AB2E65, /*  62  */
	0x14C8F0F9, /*  63  */
	0xA6B7B4CE, /*  64  */
	0x4036EAEC, /*  65  */
	0xBF62B00A, /*  66  */
	0xECFD5E02, /*  67  */
	0x045449A6, /*  68  */
	0xB20AFD28, /*  69  */
	0x2166D273, /*  70  */
	0x0D13A863, /*  71  */
	0x89508756, /*  72  */
	0xD51A7530, /*  73  */
	0x2D653F7A, /*  74  */
	0x3CDBDBC3, /*  75  */
	0x80C9DF4F, /*  76  */
	0x3D5812D9, /*  77  */
	0x53FBB1F3, /*  78  */
	0xC0F185C0, /*  79  */
	0x7A3C3D7E, /*  80  */
	0x68646410, /*  81  */
	0x857607A0, /*  82  */
	0x1D12622E, /*  83  */
	0x97F33466, /*  84  */
	0xDB4C9917, /*  85  */
	0x6469607C, /*  86  */
	0x566E043D, /*  87  */
	0x79EF1EDB, /*  88  */
	0x2C05898D, /*  89  */
	0xC9578E25, /*  90  */
	0xCD380101, /*  91  */
	0x46E04377, /*  92  */
	0x7D1CC7A9, /*  93  */
	0x6552B837, /*  94  */
	0x20192608, /*  95  */
	0xB97500C5, /*  96  */
	0xED296B44, /*  97  */
	0x368648B4, /*  98  */
	0x62995CD5, /*  99  */
	0x82731400, /*  100  */
	0xF9AEBD8B, /*  101  */
	0x3844C0C7, /*  102  */
	0x7C2DE794, /*  103  */
	0x33A1A770, /*  104  */
	0x8AE528C2, /*  105  */
	0x5A2BE812, /*  106  */
	0x1F8F4A07, /*  107  */
	0x2B5ED7CA, /*  108  */
	0x937EB564, /*  109  */
	0x6FDA7E11, /*  110  */
	0xE49B5D6C, /*  111  */
	0xB4B3244E, /*  112  */
	0x18AA53A4, /*  113  */
	0x3A061334, /*  114  */
	0x4D6067A3, /*  115  */
	0x83BA5868, /*  116  */
	0x9BDF4DFE, /*  117  */
	0x7449F261, /*  118  */
	0x709F8450, /*  119  */
	0xCAD133CB, /*  120  */
	0xDE941C3F, /*  121  */
	0xF52AE484, /*  122  */
	0x781D77ED, /*  123  */
	0x7E4395F0, /*  124  */
	0xAE103B59, /*  125  */
	0x922331BB, /*  126  */
	0x42CE50C8, /*  127  */
	0xE6F08153, /*  128  */
	0xE7D941D0, /*  129  */
	0x5028ED6B, /*  130  */
	0xB3D2C49B, /*  131  */
	0xAD4D9C3E, /*  132  */
	0xD201FB6E, /*  133  */
	0xA45BD5BE, /*  134  */
	0xFFCB7F4B, /*  135  */
	0x579D7806, /*  136  */
	0xF821BB5B, /*  137  */
	0x59D592AD, /*  138  */
	0xD0BE0C31, /*  139  */
	0xD4E3B676, /*  140  */
	0x0107165A, /*  141  */
	0x0FE939D2, /*  142  */
	0x49BCAAFD, /*  143  */
	0x55FFCFE5, /*  144  */
	0x2EC1F783, /*  145  */
	0xF39A09A5, /*  146  */
	0x3EB42772, /*  147  */
	0x19B55A5D, /*  148  */
	0x024A0679, /*  149  */
	0x8C83B3F7, /*  150  */
	0x8642BA1D, /*  151  */
	0xACACD9EA, /*  152  */
	0x87D352C4, /*  153  */
	0x60931F45, /*  154  */
	0xA05F97D7, /*  155  */
	0x1CECD42C, /*  156  */
	0xE2FCC87B, /*  157  */
	0xB60F94E2, /*  158  */
	0x67A34B0B, /*  159  */
	0xFCDD40C9, /*  160  */
	0x0B150A27, /*  161  */
	0xD3EE9E04, /*  162  */
	0x582E29E9, /*  163  */
	0x4AC22B41, /*  164  */
	0x6AC4E1B8, /*  165  */
	0xBCCAA51A, /*  166  */
	0x237AF30E, /*  167  */
	0xEBC3B709, /*  168  */
	0xC4A59D19, /*  169  */
	0x284BC98A, /*  170  */
	0xE9D41A93, /*  171  */
	0x6BFA2018, /*  172  */
	0x73B2D651, /*  173  */
	0x11F9A2FA, /*  174  */
	0xCE09BFF1, /*  175  */
	0x41A470AA, /*  176  */
	0x25888F22, /*  177  */
	0x77E754E8, /*  178  */
	0xF7330D8E, /*  179  */
	0x158EAB16, /*  180  */
	0xC5D68842, /*  181  */
	0xC685A6F6, /*  182  */
	0xE5B82FDE, /*  183  */
	0x09EA3A96, /*  184  */
	0x6DDE1536, /*  185  */
	0x4FA919DA, /*  186  */
	0x26C0BE9F, /*  187  */
	0x9EED6F69, /*  188  */
	0xF05555F2, /*  189  */
	0xE06FC285, /*  190  */
	0x9CD76D23, /*  191  */
	0xAF452A92, /*  192  */
	0xEFC74CB7, /*  193  */
	0x9D6B4732, /*  194  */
	0x8BE408EE, /*  195  */
	0x22401D0D, /*  196  */
	0xEE6C459D, /*  197  */
	0x7587CB82, /*  198  */
	0xE8746862, /*  199  */
	0x5CBDDE87, /*  200  */
	0x98794278, /*  201  */
	0x31AFB94D, /*  202  */
	0xC11E0F2F, /*  203  */
	0x30E8FC2A, /*  204  */
	0xCF3261EF, /*  205  */
	0x1A3023E1, /*  206  */
	0xAA2F86CF, /*  207  */
	0xF202E24A, /*  208  */
	0x8D08DCFF, /*  209  */
	0x764837C6, /*  210  */
	0xA26374CC, /*  211  */
	0x9F7C3E88, /*  212  */
	0x949CC57D, /*  213  */
	0xDD26A07F, /*  214  */
	0xC39EFAB0, /*  215  */
	0xC8F879A1, /*  216  */
	0xDCE67BB9, /*  217  */
	0xF4B0A435, /*  218  */
	0x912C9AE0, /*  219  */
	0xD85603E4, /*  220  */
	0x953A9BBF, /*  221  */
	0xFB8290D6, /*  222  */
	0x0AEBCD5F, /*  223  */
	0x16206A9A, /*  224  */
	0x6C787A14, /*  225  */
	0xD9A0F16A, /*  226  */
	0x29BF4F74, /*  227  */
	0x8F8BCE91, /*  228  */
	0x0E5A9354, /*  229  */
	0xAB038CB1, /*  230  */
	0x1B8AD11B, /*  231  */
	0xE327FF49, /*  232  */
	0x0053DA20, /*  233  */
	0x90CF51DC, /*  234  */
	0xDA92FE6D, /*  235  */
	0x0390CA47, /*  236  */
	0xA8958097, /*  237  */
	0xA9DC5BAF, /*  238  */
	0x3931E3C1, /*  239  */
	0x840446B6, /*  240  */
	0x63D069FB, /*  241  */
	0xD7460299, /*  242  */
	0x7124ECD1, /*  243  */
	0x0791E613, /*  244  */
	0x485918FC, /*  245  */
	0xD635D04C, /*  246  */
	0xDF96AC33, /*  247  */
	0x66F2D303, /*  248  */
	0x247056AE, /*  249  */
	0xA1A7B2A8, /*  250  */
	0x27D8CC9C, /*  251  */
	0x17B6E998, /*  252  */
	0x7BF5590F, /*  253  */
	0xFE97F557, /*  254  */
	0x5471D8A2  /*  255  */
    },

    {	/* Start of S box 6 */
	0x83A327A1, /*  0  */
	0x9F379F51, /*  1  */
	0x40A7D007, /*  2  */
	0x11307423, /*  3  */
	0x224587C1, /*  4  */
	0xAC27D63B, /*  5  */
	0x3B7E64EA, /*  6  */
	0x2E1CBFA6, /*  7  */
	0x09996000, /*  8  */
	0x03BC0E2C, /*  9  */
	0xD4C4478A, /*  10  */
	0x4542E0AB, /*  11  */
	0xFEDA26D4, /*  12  */
	0xC1D10FCB, /*  13  */
	0x8252F596, /*  14  */
	0x4494EB5C, /*  15  */
	0xA362F314, /*  16  */
	0xF5BA81FD, /*  17  */
	0x75C3A376, /*  18  */
	0x4CA214CA, /*  19  */
	0xE164DEDD, /*  20  */
	0x5088FA97, /*  21  */
	0x4B0930E0, /*  22  */
	0x2FCFB7E8, /*  23  */
	0x33A6F4B2, /*  24  */
	0xC7E94211, /*  25  */
	0x2D66C774, /*  26  */
	0x43BE8BAE, /*  27  */
	0xC663D445, /*  28  */
	0x908EB130, /*  29  */
	0xF4E3BE15, /*  30  */
	0x63B9D566, /*  31  */
	0x529396B5, /*  32  */
	0x1E1BE743, /*  33  */
	0x4D5FF63F, /*  34  */
	0x985E4A83, /*  35  */
	0x71AB9DF7, /*  36  */
	0xC516C6F5, /*  37  */
	0x85C19AB4, /*  38  */
	0x1F4DAEE4, /*  39  */
	0xF2973431, /*  40  */
	0xB713DC5E, /*  41  */
	0x3F2E159A, /*  42  */
	0xC824DA16, /*  43  */
	0x06BF376A, /*  44  */
	0xB2FE23EC, /*  45  */
	0xE39B1C22, /*  46  */
	0xF1EECB5F, /*  47  */
	0x08E82D52, /*  48  */
	0x565686C2, /*  49  */
	0xAB0AEA93, /*  50  */
	0xFD47219F, /*  51  */
	0xEBDBABD7, /*  52  */
	0x2404A185, /*  53  */
	0x8C7312B9, /*  54  */
	0xA8F2D828, /*  55  */
	0x0C8902DA, /*  56  */
	0x65B42B63, /*  57  */
	0xC0BBEF62, /*  58  */
	0x4E3E4CEF, /*  59  */
	0x788F8018, /*  60  */
	0xEE1EBAB7, /*  61  */
	0x93928F9D, /*  62  */
	0x683D2903, /*  63  */
	0xD3B60689, /*  64  */
	0xAFCB0DDC, /*  65  */
	0x88A4C47A, /*  66  */
	0xF6DD9C3D, /*  67  */
	0x7EA5FCA0, /*  68  */
	0x8A6D7244, /*  69  */
	0xBE11F120, /*  70  */
	0x04FF91B8, /*  71  */
	0x8D2DC8C0, /*  72  */
	0x27F97FDB, /*  73  */
	0x7F9E1F47, /*  74  */
	0x1734F0C7, /*  75  */
	0x26F3ED8E, /*  76  */
	0x0DF8F2BF, /*  77  */
	0xB0833D9E, /*  78  */
	0xE420A4E5, /*  79  */
	0xA423CAE6, /*  80  */
	0x95616772, /*  81  */
	0x9AE6C049, /*  82  */
	0x075941F2, /*  83  */
	0xD8E12812, /*  84  */
	0xF6F4F, /*  85  */
	0x3C0D6B05, /*  86  */
	0x6CEF921C, /*  87  */
	0xB82BC264, /*  88  */
	0x396CB008, /*  89  */
	0x5D608A6F, /*  90  */
	0x6D7782C8, /*  91  */
	0x186550AA, /*  92  */
	0x6B6FEC09, /*  93  */
	0x28E70B13, /*  94  */
	0x57CE5688, /*  95  */
	0xECD3AF84, /*  96  */
	0x23335A95, /*  97  */
	0x91F40CD2, /*  98  */
	0x7B6A3B26, /*  99  */
	0xBD32B3B6, /*  100  */
	0x3754A6FB, /*  101  */
	0x8ED088F0, /*  102  */
	0xF867E87C, /*  103  */
	0x20851746, /*  104  */
	0x6410F9C6, /*  105  */
	0x35380442, /*  106  */
	0xC2CA10A7, /*  107  */
	0x1ADEA27F, /*  108  */
	0x76BDDD79, /*  109  */
	0x92742CF4, /*  110  */
	0x0E98F7EE, /*  111  */
	0x164E931D, /*  112  */
	0xB9C835B3, /*  113  */
	0x69060A99, /*  114  */
	0xB44C531E, /*  115  */
	0xFA7B66FE, /*  116  */
	0xC98A5B53, /*  117  */
	0x7D95AAE9, /*  118  */
	0x302F467B, /*  119  */
	0x74B811DE, /*  120  */
	0xF3866ABD, /*  121  */
	0xB5B3D32D, /*  122  */
	0xFC3157A4, /*  123  */
	0xD251FE19, /*  124  */
	0x0B5D8EAC, /*  125  */
	0xDA71FFD5, /*  126  */
	0x47EA05A3, /*  127  */
	0x05C6A9E1, /*  128  */
	0xCA0EE958, /*  129  */
	0x9939034D, /*  130  */
	0x25DC5EDF, /*  131  */
	0x79083CB1, /*  132  */
	0x86768450, /*  133  */
	0xCF757D6D, /*  134  */
	0x5972B6BC, /*  135  */
	0xA78D59C9, /*  136  */
	0xC4AD8D41, /*  137  */
	0x2A362AD3, /*  138  */
	0xD1179991, /*  139  */
	0x601407FF, /*  140  */
	0xDCF50917, /*  141  */
	0x587069D0, /*  142  */
	0xE0821ED6, /*  143  */
	0xDBB59427, /*  144  */
	0x73911A4B, /*  145  */
	0x7C904FC3, /*  146  */
	0x844AFB92, /*  147  */
	0x6F8C955D, /*  148  */
	0xE8C0C5BB, /*  149  */
	0xB67AB987, /*  150  */
	0xA529D96C, /*  151  */
	0xF91F7181, /*  152  */
	0x618B1B06, /*  153  */
	0xE718BB0C, /*  154  */
	0x8BD7615B, /*  155  */
	0xD5A93A59, /*  156  */
	0x54AEF81B, /*  157  */
	0x772136E3, /*  158  */
	0xCE44FD9C, /*  159  */
	0x10CDA57E, /*  160  */
	0x87D66E0B, /*  161  */
	0x3D798967, /*  162  */
	0x1B2C1804, /*  163  */
	0x3EDFBD68, /*  164  */
	0x15F6E62B, /*  165  */
	0xEF68B854, /*  166  */
	0x3896DB35, /*  167  */
	0x12B7B5E2, /*  168  */
	0xCB489029, /*  169  */
	0x9E4F98A5, /*  170  */
	0x62EB77A8, /*  171  */
	0x217C24A2, /*  172  */
	0x964152F6, /*  173  */
	0x49B2080A, /*  174  */
	0x53D23EE7, /*  175  */
	0x48FB6D69, /*  176  */
	0x1903D190, /*  177  */
	0x9449E494, /*  178  */
	0xBF6E7886, /*  179  */
	0xFB356CFA, /*  180  */
	0x3A261365, /*  181  */
	0x424BC1EB, /*  182  */
	0xA1192570, /*  183  */
	0x019CA782, /*  184  */
	0x9D3F7E0E, /*  185  */
	0x9C127575, /*  186  */
	0xEDF02039, /*  187  */
	0xAD57BCCE, /*  188  */
	0x5C153277, /*  189  */
	0x81A84540, /*  190  */
	0xBCAA7356, /*  191  */
	0xCCD59B60, /*  192  */
	0xA62A629B, /*  193  */
	0xA25CCD10, /*  194  */
	0x2B5B65CF, /*  195  */
	0x1C535832, /*  196  */
	0x55FD4E3A, /*  197  */
	0x31D9790D, /*  198  */
	0xF06BC37D, /*  199  */
	0x4AFC1D71, /*  200  */
	0xAEED5533, /*  201  */
	0xBA461634, /*  202  */
	0xBB694B78, /*  203  */
	0x5F3A5C73, /*  204  */
	0x6A3C764A, /*  205  */
	0x8FB0CCA9, /*  206  */
	0xF725684C, /*  207  */
	0x4FE5382F, /*  208  */
	0x1D0163AF, /*  209  */
	0x5AA07A8F, /*  210  */
	0xE205A8ED, /*  211  */
	0xC30BAD38, /*  212  */
	0xFF22CF1F, /*  213  */
	0x72432E2E, /*  214  */
	0x32C2518B, /*  215  */
	0x3487CE4E, /*  216  */
	0x7AE0AC02, /*  217  */
	0x709FA098, /*  218  */
	0x0A3B395A, /*  219  */
	0x5B4043F8, /*  220  */
	0xA9E48C36, /*  221  */
	0x149A8521, /*  222  */
	0xD07DEE6B, /*  223  */
	0x46ACD2F3, /*  224  */
	0x8958DFFC, /*  225  */
	0xB3A1223C, /*  226  */
	0xB11D31C4, /*  227  */
	0xCD7F4D3E, /*  228  */
	0x0F28E3AD, /*  229  */
	0xE5B100BE, /*  230  */
	0xAAC54824, /*  231  */
	0xE9C9D7BA, /*  232  */
	0x9BD47001, /*  233  */
	0x80F149B0, /*  234  */
	0x66022F0F, /*  235  */
	0x020C4048, /*  236  */
	0x6EFA192A, /*  237  */
	0x67073F8D, /*  238  */
	0x13EC7BF9, /*  239  */
	0x3655011A, /*  240  */
	0xE6AFE157, /*  241  */
	0xD9845F6E, /*  242  */
	0xDECC4425, /*  243  */
	0x511AE2CC, /*  244  */
	0xDF81B4D8, /*  245  */
	0xD7809E55, /*  246  */
	0xD6D883D9, /*  247  */
	0x2CC7978C, /*  248  */
	0x5E787CC5, /*  249  */
	0xDD0033D1, /*  250  */
	0xA050C937, /*  251  */
	0x97F75DCD, /*  252  */
	0x299DE580, /*  253  */
	0x41E2B261, /*  254  */
	0xEA5A54F1  /*  255  */
    },

    {	/* Start of S box 7 */
	0x7E672590, /*  0  */
	0xBEA513BB, /*  1  */
	0x2C906FE6, /*  2  */
	0x86029C2B, /*  3  */
	0x55DC4F74, /*  4  */
	0x0553398E, /*  5  */
	0x63E09647, /*  6  */
	0xCAFD0BAB, /*  7  */
	0x264C37DF, /*  8  */
	0x8272210F, /*  9  */
	0x67AFA669, /*  10  */
	0x12D98A5F, /*  11  */
	0x8CAB23C4, /*  12  */
	0x75C68BD1, /*  13  */
	0xC3370470, /*  14  */
	0x33F37F4E, /*  15  */
	0x283992FF, /*  16  */
	0xE73A3A67, /*  17  */
	0x1032F283, /*  18  */
	0xF5AD9FC2, /*  19  */
	0x963F0C5D, /*  20  */
	0x664FBC45, /*  21  */
	0x202BA41C, /*  22  */
	0xC7C02D80, /*  23  */
	0x54731E84, /*  24  */
	0x8A1085F5, /*  25  */
	0x601D80FB, /*  26  */
	0x2F968E55, /*  27  */
	0x35E96812, /*  28  */
	0xE45A8F78, /*  29  */
	0xBD7DE662, /*  30  */
	0x3B6E6EAD, /*  31  */
	0x8097C5EF, /*  32  */
	0x070B6781, /*  33  */
	0xB1E508F3, /*  34  */
	0x24E4FAE3, /*  35  */
	0xB81A7805, /*  36  */
	0xEC0FC918, /*  37  */
	0x43C8774B, /*  38  */
	0x9B2512A9, /*  39  */
	0x2B05AD04, /*  40  */
	0x32C2536F, /*  41  */
	0xEDF236E0, /*  42  */
	0x8BC4B0CF, /*  43  */
	0xBACEB837, /*  44  */
	0x4535B289, /*  45  */
	0x0D0E94C3, /*  46  */
	0xA5A371D0, /*  47  */
	0xAD695A58, /*  48  */
	0x39E3437D, /*  49  */
	0x9186BFFC, /*  50  */
	0x21038C3B, /*  51  */
	0x0AA9DFF9, /*  52  */
	0x5D1F06CE, /*  53  */
	0x62DEF8A4, /*  54  */
	0xF740A2B4, /*  55  */
	0xA2575868, /*  56  */
	0x682683C1, /*  57  */
	0xDBB30FAC, /*  58  */
	0x61FE1928, /*  59  */
	0x468A6511, /*  60  */
	0xC61CD5F4, /*  61  */
	0xE54D9800, /*  62  */
	0x6B98D7F7, /*  63  */
	0x8418B6A5, /*  64  */
	0x5F09A5D2, /*  65  */
	0x90B4E80B, /*  66  */
	0x49B2C852, /*  67  */
	0x69F11C77, /*  68  */
	0x17412B7E, /*  69  */
	0x7F6FC0ED, /*  70  */
	0x56838DCC, /*  71  */
	0x6E9546A2, /*  72  */
	0xD0758619, /*  73  */
	0x087B9B9A, /*  74  */
	0xD231A01D, /*  75  */
	0xAF46D415, /*  76  */
	0x097060FD, /*  77  */
	0xD920F657, /*  78  */
	0x882D3F9F, /*  79  */
	0x3AE7C3C9, /*  80  */
	0xE8A00D9B, /*  81  */
	0x4FE67EBE, /*  82  */
	0x2EF80EB2, /*  83  */
	0xC1916B0C, /*  84  */
	0xF4DFFEA0, /*  85  */
	0xB97EB3EB, /*  86  */
	0xFDFF84DD, /*  87  */
	0xFF8B14F1, /*  88  */
	0xE96B0572, /*  89  */
	0xF64B508C, /*  90  */
	0xAE220A6E, /*  91  */
	0x4423AE5A, /*  92  */
	0xC2BECE5E, /*  93  */
	0xDE27567C, /*  94  */
	0xFC935C63, /*  95  */
	0x47075573, /*  96  */
	0xE65B27F0, /*  97  */
	0xE121FD22, /*  98  */
	0xF2668753, /*  99  */
	0x2DEBF5D7, /*  100  */
	0x8347E08D, /*  101  */
	0xAC5EDA03, /*  102  */
	0x2A7CEBE9, /*  103  */
	0x3FE8D92E, /*  104  */
	0x23542FE4, /*  105  */
	0x1FA7BD50, /*  106  */
	0xCF9B4102, /*  107  */
	0x9D0DBA39, /*  108  */
	0x9CB8902A, /*  109  */
	0xA7249D8B, /*  110  */
	0x0F6D667A, /*  111  */
	0x5EBFA9EC, /*  112  */
	0x6A594DF2, /*  113  */
	0x79600938, /*  114  */
	0x023B7591, /*  115  */
	0xEA2C79C8, /*  116  */
	0xC99D07EA, /*  117  */
	0x64CB5EE1, /*  118  */
	0x1A9CAB3D, /*  119  */
	0x76DB9527, /*  120  */
	0xC08E012F, /*  121  */
	0x3DFB481A, /*  122  */
	0x872F22E7, /*  123  */
	0x2948D15C, /*  124  */
	0xA4782C79, /*  125  */
	0x6F50D232, /*  126  */
	0x78F0728A, /*  127  */
	0x5A87AAB1, /*  128  */
	0xC4E2C19C, /*  129  */
	0xEE767387, /*  130  */
	0x1B2A1864, /*  131  */
	0x7B8D10D3, /*  132  */
	0xD1713161, /*  133  */
	0x0EEAC456, /*  134  */
	0xD8799E06, /*  135  */
	0xB645B548, /*  136  */
	0x4043CB65, /*  137  */
	0xA874FB29, /*  138  */
	0x4B12D030, /*  139  */
	0x7D687413, /*  140  */
	0x18EF9A1F, /*  141  */
	0xD7631D4C, /*  142  */
	0x5829C7DA, /*  143  */
	0xCDFA30FA, /*  144  */
	0xC5084BB0, /*  145  */
	0x92CD20E2, /*  146  */
	0xD4C16940, /*  147  */
	0x03283EC0, /*  148  */
	0xA917813F, /*  149  */
	0x9A587D01, /*  150  */
	0x70041F8F, /*  151  */
	0xDC6AB1DC, /*  152  */
	0xDDAEE3D5, /*  153  */
	0x31829742, /*  154  */
	0x198C022D, /*  155  */
	0x1C9EAFCB, /*  156  */
	0x5BBC6C49, /*  157  */
	0xD3D3293A, /*  158  */
	0x16D50007, /*  159  */
	0x04BB8820, /*  160  */
	0x3C5C2A41, /*  161  */
	0x37EE7AF8, /*  162  */
	0x8EB04025, /*  163  */
	0x9313ECBA, /*  164  */
	0xBFFC4799, /*  165  */
	0x8955A744, /*  166  */
	0xEF85D633, /*  167  */
	0x504499A7, /*  168  */
	0xA6CA6A86, /*  169  */
	0xBB3D3297, /*  170  */
	0xB34A8236, /*  171  */
	0x6DCCBE4F, /*  172  */
	0x06143394, /*  173  */
	0xCE19FC7B, /*  174  */
	0xCCC3C6C6, /*  175  */
	0xE36254AE, /*  176  */
	0x77B7EDA1, /*  177  */
	0xA133DD9E, /*  178  */
	0xEBF9356A, /*  179  */
	0x513CCF88, /*  180  */
	0xE2A1B417, /*  181  */
	0x972EE5BD, /*  182  */
	0x853824CD, /*  183  */
	0x5752F4EE, /*  184  */
	0x6C1142E8, /*  185  */
	0x3EA4F309, /*  186  */
	0xB2B5934A, /*  187  */
	0xDFD628AA, /*  188  */
	0x59ACEA3E, /*  189  */
	0xA01EB92C, /*  190  */
	0x389964BC, /*  191  */
	0xDA305DD4, /*  192  */
	0x019A59B7, /*  193  */
	0x11D2CA93, /*  194  */
	0xFAA6D3B9, /*  195  */
	0x4E772ECA, /*  196  */
	0x72651776, /*  197  */
	0xFB4E5B0E, /*  198  */
	0xA38F91A8, /*  199  */
	0x1D0663B5, /*  200  */
	0x30F4F192, /*  201  */
	0xB50051B6, /*  202  */
	0xB716CCB3, /*  203  */
	0x4ABD1B59, /*  204  */
	0x146C5F26, /*  205  */
	0xF134E2DE, /*  206  */
	0x00F67C6C, /*  207  */
	0xB0E1B795, /*  208  */
	0x98AA4EC7, /*  209  */
	0x0CC73B34, /*  210  */
	0x654276A3, /*  211  */
	0x8D1BA871, /*  212  */
	0x740A5216, /*  213  */
	0xE0D01A23, /*  214  */
	0x9ED161D6, /*  215  */
	0x9F36A324, /*  216  */
	0x993EBB7F, /*  217  */
	0xFEB9491B, /*  218  */
	0x365DDCDB, /*  219  */
	0x810CFFC5, /*  220  */
	0x71EC0382, /*  221  */
	0x2249E7BF, /*  222  */
	0x48817046, /*  223  */
	0xF3A24A5B, /*  224  */
	0x4288E4D9, /*  225  */
	0x0BF5C243, /*  226  */
	0x257FE151, /*  227  */
	0x95B64C0D, /*  228  */
	0x4164F066, /*  229  */
	0xAAF7DB08, /*  230  */
	0x73B1119D, /*  231  */
	0x8F9F7BB8, /*  232  */
	0xD6844596, /*  233  */
	0xF07A34A6, /*  234  */
	0x53943D0A, /*  235  */
	0xF9DD166D, /*  236  */
	0x7A8957AF, /*  237  */
	0xF8BA3CE5, /*  238  */
	0x27C9621E, /*  239  */
	0x5CDAE910, /*  240  */
	0xC8518998, /*  241  */
	0x941538FE, /*  242  */
	0x136115D8, /*  243  */
	0xABA8443C, /*  244  */
	0x4D01F931, /*  245  */
	0x34EDF760, /*  246  */
	0xB45F266B, /*  247  */
	0xD5D4DE14, /*  248  */
	0x52D8AC35, /*  249  */
	0x15CFD885, /*  250  */
	0xCBC5CD21, /*  251  */
	0x4CD76D4D, /*  252  */
	0x7C80EF54, /*  253  */
	0xBC92EE75, /*  254  */
	0x1E56A1F6  /*  255  */
    }
};
