#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/CustomPlugin.pm
#
#   This file is part of perl-Dist-Zilla-Plugin-Manifest-Write.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package CustomPlugin;

use Moose;
use namespace::autoclean;

with 'Dist::Zilla::Role::FileGatherer';

use Dist::Zilla::File::FromCode;
use Dist::Zilla::File::InMemory;

sub gather_files {
    my ( $self ) = @_;
    $self->add_file( Dist::Zilla::File::FromCode->new(
        name => 'GeneratedFile.txt',
        code_return_type => 'bytes',
        code => sub {
            "Generated content.\n"
        }
    ) );
    my $file = Dist::Zilla::File::InMemory->new(
        name => 'lib/GeneratedModule.pm',
        content => join( "\n",
            "package GeneratedModule;",
            "",
            "1;"
        ) . "\n"
    );
    $self->add_file( $file );
};

1;

# end of file #
