#!perl
use strict;
use warnings;

use Test::More;
use InfluxDB::Client;

if ($ENV{INFLUXDB_URLS}) {
    plan tests => 1;
} else {
    plan skip_all => 'environment variable INFLUXDB_URLS not set';
}

my @urls = split(/\s+/,$ENV{INFLUXDB_URLS});
my $client = InfluxDB::Client->new( url => \@urls, username => $ENV{INFLUXDB_USER}, password => $ENV{INFLUXDB_PASSWORD} );
subtest 'SHOW DATABASES' => sub {
    my $res = $client->show_databases();
    is($res->status,InfluxDB::Client::Response::Status::OK)
        or diag($res->error);
};

done_testing;