package Pod::Weaver::Plugin::SubSpec;
BEGIN {
  $Pod::Weaver::Plugin::SubSpec::VERSION = '0.01';
}
# ABSTRACT: Insert POD for subs from spec

use 5.010;
use Moose;
with 'Pod::Weaver::Role::Section';

use Moose::Autobox;
use Pod::Elemental;
use Pod::Elemental::Element::Nested;
use Pod::Elemental::Element::Pod5::Verbatim;
use Sub::Spec::Pod qw(gen_pod);


sub weave_section {
    my ($self, $document, $input) = @_;

    my $filename = $input->{filename} || 'file';

    # guess package name from filename
    my $package;
    if ($filename =~ m!^lib/(.+)\.pm$!) {
        $package = $1;
        $package =~ s!/!::!g;
    } else {
        #$self->log(["skipped file %s (not a Perl module)", $filename]);
        return;
    }

    # find the FUNCTIONS section in the POD
    my $funcs_section;
    for my $i (0 .. $#{ $input->{pod_document}->children }) {
        my $para = $input->{pod_document}->children->[$i];
        next unless $para->isa('Pod::Elemental::Element::Nested') &&
            $para->command eq 'head1' && $para->content =~ /^FUNCTIONS$/s;
        $funcs_section = $para;
        last;
    }
    unless ($funcs_section) {
        #$self->log(["skipped file %s (no =head1 FUNCTIONS)", $filename]);
        return;
    }

    # generate the POD and insert it to FUNCTIONS section
    my $pod_text = gen_pod(module=>$package, path=>$filename);
    while ($pod_text =~ /^=head2 ([^\n]+)\n(.+?)(?=^=head2|\z)/msg) {
        my $fpara = Pod::Elemental::Element::Nested->new({
            command  => 'head2',
            content  => $1,
            children => Pod::Elemental->read_string($2)->children,
        });
        $self->log(["adding spec POD for %s", $filename]);
        $funcs_section->children->push($fpara);
    }
}

1;


=pod

=head1 NAME

Pod::Weaver::Plugin::SubSpec - Insert POD for subs from spec

=head1 VERSION

version 0.01

=head1 SYNOPSIS

In your C<weaver.ini>:

 [-SubSpec]

=head1 DESCRIPTION

This plugin inserts POD documentation (generated by Sub::Spec::Pod>) at the end
of the C<=head1 FUNCTIONS> section. That section must already exists, or the
file will be skipped.

=for Pod::Coverage weave_section

=head1 SEE ALSO

L<Sub::Spec::Pod>

L<Sub::Spec>

L<Pod::Weaver>

=head1 AUTHOR

Steven Haryanto <stevenharyanto@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Steven Haryanto.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

