# Load the Module::Install bundled in ./inc/
use inc::Module::Install;
use Config;
use POSIX qw/strftime/;
use Term::Menus;

# Define metadata
name            'Net-FullAuto';
all_from        'lib/Net/FullAuto.pm';

if ($^O eq 'MSWin32' || $^O eq 'MSWin64') {
   print "\n       FATAL ERROR! : Cygwin Linux Emulation Layer".
         "\n                      is required to use FullAuto".
         "\n                      on Windows - goto www.cygwin.com.".
         "\n\n           Be sure to install the following programs in ".
         "\n           addition to the base package:".
         "\n\n           OpenSSH and the sshd service [as provided by Cygwin]".
         "\n           inetutils \(if telnet and/or ftp services are desired\)".
         "\n           perl [as provided by Cygwin] (NOT CPAN)".
         "\n           libwin32 [as provided by Cygwin] (NOT CPAN)".
         "\n           gcc [as provided by Cygwin]".
         "\n\n";
   exit;
}
if ($^O eq 'cygwin' && !can_cc()) {
   my $die="\n       FATAL ERROR! : The Gnu C Compiler 'gcc'".
           "\n                      as provided by Cygwin".
           "\n                      is required to install FullAuto".
           "\n                      on Windows - goto www.cygwin.com.".
           "\n\n";
   die $die;
} elsif (!can_cc()) {
   my $die="\n       FATAL ERROR! : A C Compiler (such as cc or gcc)".
           "\n                      is required to install FullAuto".
           "\n                      (Hint: goto www.gnu.org).".
           "\n\n";
   die $die;
}

if ($^O eq 'cygwin' && !(can_run('/bin/ssh') || can_run('/bin/telnet'))) {
   print "\n       WARNING! : The Secure Shell - 'ssh'".
         "\n                  and/or 'telnet' (via inetutils)".
         "\n                  as provided by Cygwin".
         "\n                  is required to install FullAuto".
         "\n                  on Windows - goto www.cygwin.com.".
         "\n\n";
   print "Press <ENTER> if you wish to continue . . .";<STDIN>;
}

unless (can_run('make')) {
   my $die="\n       FATAL ERROR! : Cannot locate 'make'. This program ".
           "\n                      is required to install FullAuto".
           "\n                      (Hint: goto www.gnu.org).".
           "\n\n";
   die $die;
}

unless (can_run('lynx')) {
   print "\n       WARNING! : Cannot locate 'lynx'. This program ".
         "\n                  is recommended for installing FullAuto".
         "\n                  from the CPAN (Hint: goto www.gnu.org).".
         "\n\n";
   print "Press <ENTER> if you wish to continue . . .";<STDIN>;
}

#Specific dependencies
requires        'Sort::Versions'         => 0;
requires        'Crypt::CBC'             => 0;
requires        'Crypt::DES'             => 0;
requires        'Getopt::Long'           => 0;
requires        'HTTP::Date'             => 0;
requires        'IO::Pty'                => 0;
requires	'IO::Capture::Stderr'    => 0;
requires        'LWP'                    => 0;
requires        'Mail::Internet'         => 0;
requires        'Mail::Sender'           => 0;
requires        'MemHandle'              => 0;
requires        'MLDBM'                  => 0;
requires        'MLDBM::Sync'            => 0;
requires        'MLDBM::Sync::SDBM_File' => 0;
requires        'Net::Telnet'            => 0;
requires        'Term::Menus'            => 1.24;
requires        'Tie::Cache'             => 0;
requires        'URI'                    => 0;
recommends      'Crypt::Rijndael'        => 0;

my $c_file='';
my $date=strftime('%D',localtime);

open(FH,">fullauto.c");

print FH '/* program: fullauto'."\n".
"   author:  Brian Kelly\n".
"   date:    $date\n".
"\n".
"   purpose: C program wrapper that calls $Config{installsitebin}/fullauto.pl script\n".
"   WARNING: This file is auto-generated by Makefile.PL, please change Makefile.PL.\n".
"            Any modifications made to this source file will be lost!\n".
'*/'."\n".
"\n".
'#define REAL_PL '.'"'.$Config{installsitebin}."/fullauto.pl\"\n".
"main(argc, argv)\n".
"char **argv;\n".
'{'."\n".
"\tsetuid(0);\n".
"\tseteuid(0);\n".
"\texecv(REAL_PL, argv);\n".
'}'."\n";

close FH;

my @list=('Default','Setuid','Setgid');
my %Menu_1=(

   Item_1 => {

      Text    => "Install with ]Convey[ Permissions",
      Convey  => \@list,
#      Default => 'Default'

   },

   Select => 'One',
   Banner => "\n   Choose a Permission Setting :"
);

my $selection=&Menu(\%Menu_1);
my $permission = 'Default';
print "SELECTION = $selection\n";

if (-1<index $selection,'Setuid') {
   $permission = 'Setuid';
} elsif (-1<index $selection,'Setgid') {
   $permission = 'Setgid';
}

if ($^O eq 'cygwin') {
   install_script 'bin/fullauto.exe';
} else {
   install_script 'bin/fullauto';
}
install_script 'bin/fullauto.pl';

auto_install;
WriteAll;

package MY; # so that "SUPER" works right
sub MY::top_targets {

   my $inherited = shift->SUPER::top_targets(@_);

   $inherited =~ s/pure_all :: /pure_all :: fullauto\$(EXE_EXT) /;
   $inherited =~ s/ linkext//;

   $inherited;

}

package MY; # so that "SUPER" works right
sub makefile {

   my $inherited = shift->SUPER::makefile(@_);

   $inherited .= "fullauto\$(EXE_EXT): fullauto.c\n\t\$(CC) fullauto.c -o \$@".
                 "\n\t\$(CP) \$@ bin\n\n";

   $inherited;

}

package MY; # so that "SUPER" works right
sub constants {

   my $inherited = shift->SUPER::constants(@_);

   $inherited =~ 
      s/(PERM_RWX = \d+)/$1\nPERM_S_X = 4511\nPERM_G_X = 2551/m;
   $inherited =~
      s/(PERM_G_X = \d+)/$1\nPERM_R+X = 555\nPERM_R-X = 550\nPERM_R_X = 500/m;
   $inherited =~
      s/(PERM_R_X = \d+)/$1\nPERM_D-X = 750\nPERM_D_X = 700/m;


   $inherited;

}

package MY; # so that "SUPER works right
sub MY::installbin {

   my $inherited = shift->SUPER::installbin(@_);

   $inherited =~ s/RM_F\) \\/RM_F\) bin\/fullauto\$(EXE_EXT) fullauto.c fullauto\$(EXE_EXT)\\/;

   $inherited;

}

package MY; # so that "SUPER" works right
sub install {

   my $inherited = shift->SUPER::install(@_);

   if ($permission eq 'Setuid') {
      $inherited =~ s/(install ::.*)$/$1 setuid_permissions/m;
   } elsif ($permission eq 'Setgid') {
      $inherited =~ s/(install ::.*)$/$1 setgid_permissions/m;
   } else {
      $inherited =~ s/(install ::.*)$/$1 default_permissions/m;
   }

   $inherited .= "\nsetuid_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Setuid Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_S_X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_D_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R_X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n\n";
   $inherited .= "\nsetgid_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Setgid Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_G_X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_D-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R-X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n\n";
   $inherited .= "\ndefault_permissions ::\n".
      "\t\$(NOECHO) \$(ECHO) \"Applying Default Permissions\"\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto\$(EXE_EXT)\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITESCRIPT)\/fullauto.pl\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto.pm\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_DIR) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\n".
      "\t\$(NOECHO) \$(CHMOD) \$(PERM_R+X) \$(DESTINSTALLSITELIB)\/Net\/FullAuto\/*\n\n"; 

   $inherited;

}

