package Bencher::Scenario::DataModeMerge::Startup;

our $DATE = '2016-07-22'; # DATE
our $VERSION = '0.002'; # VERSION

our $scenario = {
    summary => 'Benchmark module startup overhead of Data::ModeMerge',

    module_startup => 1,

    participants => [
        {module=>'Data::ModeMerge'},
    ],
};

1;
# ABSTRACT: Benchmark module startup overhead of Data::ModeMerge

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataModeMerge::Startup - Benchmark module startup overhead of Data::ModeMerge

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::DataModeMerge::Startup (from Perl distribution Bencher-Scenarios-DataModeMerge), released on 2016-07-22.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataModeMerge::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::ModeMerge> 0.34

=head1 BENCHMARK PARTICIPANTS

=over

=item * Data::ModeMerge (perl_code)

L<Data::ModeMerge>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m DataModeMerge::Startup --include-path archive/0.22/lib --include-path archive/0.23/lib --include-path archive/0.26/lib --include-path archive/0.31/lib --include-path archive/0.32/lib --include-path archive/0.33/lib --include-path archive/0.34/lib --module-startup --multimodver Data::ModeMerge >>:

 #table1#
 +---------------------+--------+-----------+------------------------+------------+-----------+---------+
 | participant         | modver | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +---------------------+--------+-----------+------------------------+------------+-----------+---------+
 | Data::ModeMerge     | 0.22   |     200   |                  198   |        1   |   0.0014  |      20 |
 | Data::ModeMerge     | 0.26   |      40   |                   38   |        5   |   0.0007  |      21 |
 | Data::ModeMerge     | 0.23   |      34   |                   32   |        5.9 |   0.00017 |      20 |
 | Data::ModeMerge     | 0.31   |      20   |                   18   |       10   |   0.00018 |      21 |
 | Data::ModeMerge     | 0.33   |       9.6 |                    7.6 |       21   | 3.5e-05   |      20 |
 | Data::ModeMerge     | 0.34   |       6.9 |                    4.9 |       30   | 4.6e-05   |      20 |
 | Data::ModeMerge     | 0.32   |       6.8 |                    4.8 |       30   | 2.6e-05   |      20 |
 | perl -e1 (baseline) |        |       2   |                    0   |      100   | 1.6e-05   |      20 |
 +---------------------+--------+-----------+------------------------+------------+-----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataModeMerge>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataModeMerge>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataModeMerge>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
