package Bencher::Scenario::LevenshteinModules;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various modules calculating the Levenshtein edit distance',
    participants => [
        {
            fcall_template => "PERLANCAR::Text::Levenshtein::editdist(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::Levenshtein::fastdistance(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::Levenshtein::XS::distance(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::LevenshteinXS::distance(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::Levenshtein::Damerau::PP::pp_edistance(<word1>, <word2>)",
        },
        {
            fcall_template => "Text::Levenshtein::Damerau::XS::xs_edistance(<word1>, <word2>)",
        },
    ],
    datasets => [
        { name=>"a",       args => {word1=>"a"      , word2=>"aa"},      result => 1 },
        { name=>"foo",     args => {word1=>"foo"    , word2=>"bar"},     result => 3 },
        { name=>"program", args => {word1=>"program", word2=>"porgram"}, result => 2 },
    ],
};

1;
# ABSTRACT: Benchmark various modules calculating the Levenshtein edit distance

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LevenshteinModules

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::LevenshteinModules (from Perl distribution Bencher-Scenario-LevenshteinModules), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LevenshteinModules

To run module startup overhead benchmark:

 % bencher --module-startup -m LevenshteinModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<PERLANCAR::Text::Levenshtein>

L<Text::Levenshtein>

L<Text::Levenshtein::XS>

L<Text::LevenshteinXS>

L<Text::Levenshtein::Damerau::PP>

L<Text::Levenshtein::Damerau::XS>

=head1 SAMPLE BENCHMARK RESULTS

Run on: CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+----------------------------------------------------------------------------------+-------------+------------+---------+---------+
 | seq | name                                                                             | rate        | time       | errors  | samples |
 +-----+----------------------------------------------------------------------------------+-------------+------------+---------+---------+
 | 5   | {dataset=>"program",participant=>"Text::Levenshtein::fastdistance"}              | 1.13e+04    | 88.3μs     | 1.3e-07 | 20      |
 | 14  | {dataset=>"program",participant=>"Text::Levenshtein::Damerau::PP::pp_edistance"} | 1.29e+04    | 77.2μs     | 2.7e-08 | 20      |
 | 2   | {dataset=>"program",participant=>"PERLANCAR::Text::Levenshtein::editdist"}       | 1.84e+04    | 54.3μs     | 1.1e-07 | 20      |
 | 4   | {dataset=>"foo",participant=>"Text::Levenshtein::fastdistance"}                  | 5.08e+04    | 19.7μs     | 6.7e-09 | 20      |
 | 13  | {dataset=>"foo",participant=>"Text::Levenshtein::Damerau::PP::pp_edistance"}     | 5.12e+04    | 19.5μs     | 6.7e-09 | 20      |
 | 1   | {dataset=>"foo",participant=>"PERLANCAR::Text::Levenshtein::editdist"}           | 7.03e+04    | 14.2μs     | 2e-08   | 20      |
 | 12  | {dataset=>"a",participant=>"Text::Levenshtein::Damerau::PP::pp_edistance"}       | 1.4952e+05  | 6.688μs    | 9.3e-11 | 35      |
 | 3   | {dataset=>"a",participant=>"Text::Levenshtein::fastdistance"}                    | 1.5103e+05  | 6.6212μs   | 2.3e-11 | 29      |
 | 0   | {dataset=>"a",participant=>"PERLANCAR::Text::Levenshtein::editdist"}             | 2.8e+05     | 3.57μs     | 4.9e-09 | 21      |
 | 17  | {dataset=>"program",participant=>"Text::Levenshtein::Damerau::XS::xs_edistance"} | 3.972e+05   | 2.517μs    | 7.6e-10 | 24      |
 | 8   | {dataset=>"program",participant=>"Text::Levenshtein::XS::distance"}              | 4.25e+05    | 2.36μs     | 2.5e-09 | 20      |
 | 16  | {dataset=>"foo",participant=>"Text::Levenshtein::Damerau::XS::xs_edistance"}     | 6.43e+05    | 1.55μs     | 4.2e-09 | 20      |
 | 7   | {dataset=>"foo",participant=>"Text::Levenshtein::XS::distance"}                  | 6.48e+05    | 1.54μs     | 8.3e-10 | 20      |
 | 6   | {dataset=>"a",participant=>"Text::Levenshtein::XS::distance"}                    | 785985      | 1.27229μs  | 0       | 20      |
 | 15  | {dataset=>"a",participant=>"Text::Levenshtein::Damerau::XS::xs_edistance"}       | 8.47e+05    | 1.18μs     | 1.7e-09 | 20      |
 | 11  | {dataset=>"program",participant=>"Text::LevenshteinXS::distance"}                | 2.8e+06     | 0.35μs     | 3.5e-09 | 20      |
 | 10  | {dataset=>"foo",participant=>"Text::LevenshteinXS::distance"}                    | 5.56156e+06 | 0.179806μs | 0       | 20      |
 | 9   | {dataset=>"a",participant=>"Text::LevenshteinXS::distance"}                      | 6.626e+06   | 0.1509μs   | 1.2e-11 | 20      |
 +-----+----------------------------------------------------------------------------------+-------------+------------+---------+---------+


Benchmark module startup overhead:

 +-----+--------------------------------+-------+-------------------+---------+---------+
 | seq | name                           | time  | mod_overhead_time | errors  | samples |
 +-----+--------------------------------+-------+-------------------+---------+---------+
 | 4   | Text::LevenshteinXS            | 14ms  | 9.3ms             | 8.6e-05 | 20      |
 | 2   | Text::Levenshtein              | 12ms  | 7ms               | 4.8e-05 | 22      |
 | 3   | Text::Levenshtein::XS          | 9.3ms | 4.2ms             | 0.0001  | 20      |
 | 5   | Text::Levenshtein::Damerau::PP | 7.3ms | 2.2ms             | 4.2e-05 | 20      |
 | 6   | Text::Levenshtein::Damerau::XS | 6.8ms | 1.7ms             | 5.8e-05 | 21      |
 | 1   | PERLANCAR::Text::Levenshtein   | 5.3ms | 0.14ms            | 3.8e-05 | 20      |
 | 0   | perl -e1 (baseline)            | 5.1ms | 0ms               | 6.3e-05 | 21      |
 +-----+--------------------------------+-------+-------------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-LevenshteinModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-LevenshteinModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-LevenshteinModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
