/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  int limit;    /* The LIMIT value.  -1 if there is no limit */
  int offset;   /* The OFFSET.  0 if there is none */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };


#line 34 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 220
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct LimitVal yy22;
  Expr* yy164;
  Expr * yy206;
  ExprList* yy232;
  IdList* yy246;
  SrcList* yy283;
  struct {int value; int mask;} yy299;
  Token yy318;
  TriggerStep * yy353;
  Select* yy375;
  struct TrigEvent yy414;
  int yy424;
  int yy439;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 564
#define YYNRULE 292
#define YYERRORSYMBOL 130
#define YYERRSYMDT yy439
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static YYACTIONTYPE yy_action[] = {
 /*     0 */   264,  283,  262,  119,  123,  117,  121,  129,  131,  133,
 /*    10 */   135,  144,  146,  148,  150,  152,  154,  664,  143,  857,
 /*    20 */     1,  563,    3,  142,  129,  131,  133,  135,  144,  146,
 /*    30 */   148,  150,  152,  154,  561,  562,  727,  115,  103,  139,
 /*    40 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*    50 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*    60 */   154,  105,  262,  143,  263,  387,   11,  328,  142,  344,
 /*    70 */   144,  146,  148,  150,  152,  154,   45,  264,    5,  262,
 /*    80 */   844,  174,  115,  103,  139,  127,  125,  156,  161,  157,
 /*    90 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   100 */   144,  146,  148,  150,  152,  154,  298,   35,   53,   59,
 /*   110 */    61,  306,  337,  169,  721,  171,  172,  244,  339,  545,
 /*   120 */   543,   37,  346,  349,  263,  143,  219,  466,   12,   13,
 /*   130 */   142,  343,  169,  345,  171,  172,  352,  353,    8,  296,
 /*   140 */   536,  263,  837,  280,  115,  103,  139,  127,  125,  156,
 /*   150 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   160 */   133,  135,  144,  146,  148,  150,  152,  154,  584,   68,
 /*   170 */   143,  148,  150,  152,  154,  142,  169,  839,  171,  172,
 /*   180 */    29,  281,  259,  362,  354,  266,  282,  159,  689,  115,
 /*   190 */   103,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*   200 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*   210 */   150,  152,  154,  569,  455,  143,  289,  367,  158,  173,
 /*   220 */   142,  369,  375,  380,  169,  245,  171,  172,  426,  428,
 /*   230 */   427,  652,  383,  137,  115,  103,  139,  127,  125,  156,
 /*   240 */   161,  157,  162,  166,  119,  123,  117,  121,  129,  131,
 /*   250 */   133,  135,  144,  146,  148,  150,  152,  154,   11,  564,
 /*   260 */   143,  489,  461,  451,  169,  142,  171,  172,  561,  562,
 /*   270 */    31,  341,   72,  169,   67,  171,  172,  336,   63,  115,
 /*   280 */   103,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*   290 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*   300 */   150,  152,  154,  213,  169,  193,  171,  172,  528,  363,
 /*   310 */   485,  304,   11,  691,  641,  175,  365,   27,   28,   37,
 /*   320 */    12,   13,   11,  367,  105,  535,  572,  369,  375,  380,
 /*   330 */   143,  181,  179,  301,   72,  142,  364,  396,  383,  177,
 /*   340 */    65,   66,  110,  793,  116,  111,  104,  525,  191,  115,
 /*   350 */   103,  139,  127,  125,  156,  161,  157,  162,  166,  119,
 /*   360 */   123,  117,  121,  129,  131,  133,  135,  144,  146,  148,
 /*   370 */   150,  152,  154,  792,   12,   13,  105,   10,  112,  113,
 /*   380 */   183,  105,  367,   69,   12,   13,  369,  375,  380,  401,
 /*   390 */   450,  105,  311,  537,  538,  539,  297,  383,  143,  852,
 /*   400 */   575,  174,  256,  142,  662,  363,  373,  392,  328,   68,
 /*   410 */    23,  102,  254,  397,   28,  221,   68,  115,  103,  139,
 /*   420 */   127,  125,  156,  161,  157,  162,  166,  119,  123,  117,
 /*   430 */   121,  129,  131,  133,  135,  144,  146,  148,  150,  152,
 /*   440 */   154,  474,   15,  143,  313,   96,  218,  435,  142,  339,
 /*   450 */     4,    6,  436,   11,   20,  189,  460,  209,  448,   45,
 /*   460 */   506,  458,  115,  103,  139,  127,  125,  156,  161,  157,
 /*   470 */   162,  166,  119,  123,  117,  121,  129,  131,  133,  135,
 /*   480 */   144,  146,  148,  150,  152,  154,   68,   32,  342,  576,
 /*   490 */    35,   53,   59,   61,  306,  337,  197,  319,  577,  105,
 /*   500 */   169,  339,  171,  172,  555,  201,  105,  690,  293,  251,
 /*   510 */   842,  519,  143,   83,   85,   12,   13,  142,  205,  174,
 /*   520 */   320,  195,  447,  402,   82,  170,  102,  232,  667,   17,
 /*   530 */   794,  115,  164,  139,  127,  125,  156,  161,  157,  162,
 /*   540 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   550 */   146,  148,  150,  152,  154,  299,   11,  143,  802,   94,
 /*   560 */   237,  410,  142,  405,  219,  816,   64,  394,  310,  316,
 /*   570 */   314,  321,  323,  253,  393,  546,  115,  103,  139,  127,
 /*   580 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   590 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   600 */   252,  573,  143,  311,    9,   34,  169,  142,  171,  172,
 /*   610 */   541,  336,  169,  542,  171,  172,  295,  534,   12,   13,
 /*   620 */   294,  115,  227,  139,  127,  125,  156,  161,  157,  162,
 /*   630 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   640 */   146,  148,  150,  152,  154,  167,  251,  143,  432,   11,
 /*   650 */   691,  431,  142,  382,  357,  313,  358,  350,  592,   19,
 /*   660 */   351,  318,  347,  317,  578,  348,  433,  103,  139,  127,
 /*   670 */   125,  156,  161,  157,  162,  166,  119,  123,  117,  121,
 /*   680 */   129,  131,  133,  135,  144,  146,  148,  150,  152,  154,
 /*   690 */   230,  574,  143,  216,   11,  217,  137,  142,  355,  249,
 /*   700 */   259,   57,  262,  494,   67,   11,    2,    3,   63,   58,
 /*   710 */   253,   12,   13,  139,  127,  125,  156,  161,  157,  162,
 /*   720 */   166,  119,  123,  117,  121,  129,  131,  133,  135,  144,
 /*   730 */   146,  148,  150,  152,  154,  193,   72,  252,   40,  105,
 /*   740 */   279,  503,  221,  497,   11,  175,   67,   41,  276,  482,
 /*   750 */    63,  809,   21,  143,  332,   24,   12,   13,  142,  184,
 /*   760 */    42,  181,  179,   43,  263,   11,  105,   12,   13,  177,
 /*   770 */    65,   66,  110,  231,   44,  111,  104,  193,  105,   25,
 /*   780 */   225,  229,  105,  444,  274,  691,  174,  175,  479,   67,
 /*   790 */   274,  429,  691,   63,   72,  221,  579,  481,  488,   68,
 /*   800 */   430,  185,  488,  181,  179,  224,   12,   13,  112,  113,
 /*   810 */   183,  177,   65,   66,  110,  500,  105,  111,  104,  105,
 /*   820 */   193,  333,  233,   68,  452,  105,  691,   12,   13,  105,
 /*   830 */   175,  219,  168,  327,  471,  328,  118,  836,  527,  120,
 /*   840 */   221,  831,  484,  721,  332,  174,  181,  179,  290,  469,
 /*   850 */   112,  113,  183,  795,  177,   65,   66,  110,   68,  832,
 /*   860 */   111,  104,    7,  332,   14,   16,   18,  400,   67,  105,
 /*   870 */   471,  450,   63,  386,  332,  487,  332,  485,  549,  266,
 /*   880 */    90,  215,  221,  445,  105,  328,  558,  654,  105,  176,
 /*   890 */   219,  517,  326,  112,  113,  183,  105,   68,  105,  193,
 /*   900 */   531,  105,  455,  377,  122,  372,   88,  529,  151,  175,
 /*   910 */   284,  333,  105,  424,  425,   51,  278,  640,  124,   26,
 /*   920 */   247,  126,  474,   52,  583,  181,  179,  465,  105,  300,
 /*   930 */   333,  217,  212,  177,   65,   66,  110,  456,  105,  111,
 /*   940 */   104,  333,  458,  333,  105,  105,  105,  105,  303,  507,
 /*   950 */   512,  451,  420,  332,  245,  493,  105,  105,  128,  105,
 /*   960 */    72,  105,  105,  105,  246,  473,  130,  214,  105,  105,
 /*   970 */   105,  105,  112,  113,  183,  105,  192,  132,  105,  241,
 /*   980 */   291,  180,  134,  163,  105,  105,  105,  266,  190,  136,
 /*   990 */   138,  210,  105,   30,  234,  141,  217,  105,  165,  105,
 /*  1000 */   288,  524,  105,  105,  178,  381,  145,  276,  105,  105,
 /*  1010 */   248,  409,  421,  105,   46,  105,  276,  147,  267,  228,
 /*  1020 */   329,  105,  149,  226,   74,   48,  399,   68,  114,  486,
 /*  1030 */    22,  287,  398,  153,  273,  182,  274,   68,  378,   33,
 /*  1040 */   328,  155,   37,   36,   38,   47,   39,   50,   49,   54,
 /*  1050 */    55,   56,   68,   62,  593,   60,   72,  594,   70,  272,
 /*  1060 */    75,   71,  245,   81,   73,  242,   78,  240,  478,   77,
 /*  1070 */    76,   92,   87,   84,   86,   79,   93,   89,   91,   95,
 /*  1080 */    80,   99,  100,   98,  101,  154,  106,  108,  107,  109,
 /*  1090 */   160,  220,  668,  669,  211,   97,  188,  670,  194,  198,
 /*  1100 */   196,  199,  137,  140,  200,  202,  186,  203,  187,  204,
 /*  1110 */   206,  207,  208,  221,  223,  222,  235,  243,  239,  217,
 /*  1120 */   238,  236,  250,  258,  261,  277,  268,  255,  257,  260,
 /*  1130 */   265,  270,  271,  275,  292,  302,  305,  325,  307,  269,
 /*  1140 */   285,  309,  286,  360,  312,  370,  371,  376,  384,  385,
 /*  1150 */   330,  334,  308,  388,   48,  408,  310,  415,  422,  315,
 /*  1160 */   322,  324,  338,  368,  331,  335,  361,  389,  824,  356,
 /*  1170 */   403,  413,  359,  340,  406,  404,  411,  407,  374,  412,
 /*  1180 */   379,  416,  417,  414,  423,  390,  395,  366,  829,  434,
 /*  1190 */   391,  830,  437,  438,  441,  439,  442,  440,  443,  800,
 /*  1200 */   446,  801,  449,  457,  823,  459,  728,  729,  454,  452,
 /*  1210 */   464,  453,  838,  463,  462,  468,  467,  840,  470,  472,
 /*  1220 */   477,  483,  475,  841,  490,  476,  492,  843,  491,  661,
 /*  1230 */   663,  495,  808,  849,  498,  720,  508,  496,  511,  513,
 /*  1240 */   499,  418,  501,  480,  504,  502,  419,  505,  509,  510,
 /*  1250 */   515,  516,  514,  723,  520,  521,  526,  518,  522,  726,
 /*  1260 */   530,  523,  810,  532,  811,  812,  813,  814,  533,  817,
 /*  1270 */   540,  819,  820,  818,  544,  547,  815,  557,  553,  548,
 /*  1280 */   551,  850,  552,  550,  851,  554,  556,  560,  559,  855,
};
static YYCODETYPE yy_lookahead[] = {
 /*     0 */    21,   20,   23,   68,   69,   70,   71,   72,   73,   74,
 /*    10 */    75,   76,   77,   78,   79,   80,   81,    9,   39,  131,
 /*    20 */   132,  133,  134,   44,   72,   73,   74,   75,   76,   77,
 /*    30 */    78,   79,   80,   81,    9,   10,    9,   58,   59,   60,
 /*    40 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    50 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*    60 */    81,  138,   23,   39,   85,   20,   23,   22,   44,   23,
 /*    70 */    76,   77,   78,   79,   80,   81,   60,   21,    9,   23,
 /*    80 */     9,  158,   58,   59,   60,   61,   62,   63,   64,   65,
 /*    90 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   100 */    76,   77,   78,   79,   80,   81,   20,   91,   92,   93,
 /*   110 */    94,   95,   96,  105,    9,  107,  108,  194,  102,   76,
 /*   120 */    77,   97,   76,   77,   85,   39,  203,   22,   85,   86,
 /*   130 */    44,   85,  105,   87,  107,  108,   90,   91,  137,   20,
 /*   140 */    97,   85,   11,  145,   58,   59,   60,   61,   62,   63,
 /*   150 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   160 */    74,   75,   76,   77,   78,   79,   80,   81,    9,  171,
 /*   170 */    39,   78,   79,   80,   81,   44,  105,   14,  107,  108,
 /*   180 */   148,  183,  184,  151,  152,  151,  188,   60,   20,   58,
 /*   190 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   200 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   210 */    79,   80,   81,    9,   51,   39,  182,   88,   91,   20,
 /*   220 */    44,   92,   93,   94,  105,  120,  107,  108,   98,   99,
 /*   230 */   100,    9,  103,  199,   58,   59,   60,   61,   62,   63,
 /*   240 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   250 */    74,   75,   76,   77,   78,   79,   80,   81,   23,    0,
 /*   260 */    39,   98,   99,  100,  105,   44,  107,  108,    9,   10,
 /*   270 */   154,  155,  109,  105,   19,  107,  108,  161,   23,   58,
 /*   280 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   290 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   300 */    79,   80,   81,  127,  105,   50,  107,  108,   20,  138,
 /*   310 */    22,   20,   23,    9,   20,   60,   22,  146,  147,   97,
 /*   320 */    85,   86,   23,   88,  138,  138,    9,   92,   93,   94,
 /*   330 */    39,   76,   77,   78,  109,   44,  165,  166,  103,   84,
 /*   340 */    85,   86,   87,   14,  158,   90,   91,  122,  127,   58,
 /*   350 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   360 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   370 */    79,   80,   81,   14,   85,   86,  138,  138,  123,  124,
 /*   380 */   125,  138,   88,  145,   85,   86,   92,   93,   94,  141,
 /*   390 */   145,  138,   45,  206,  207,  208,  158,  103,   39,    9,
 /*   400 */     9,  158,  113,   44,    9,  138,   20,   60,   22,  171,
 /*   410 */   143,  158,  113,  146,  147,  111,  171,   58,   59,   60,
 /*   420 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   430 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   440 */    81,  196,  137,   39,   97,  192,  203,   18,   44,  102,
 /*   450 */   135,  136,  204,   23,  139,  126,  211,  128,  210,   60,
 /*   460 */   145,  216,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   470 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   480 */    76,   77,   78,   79,   80,   81,  171,   88,   89,    9,
 /*   490 */    91,   92,   93,   94,   95,   96,   15,   29,    9,  138,
 /*   500 */   105,  102,  107,  108,  114,   24,  138,   20,   78,   22,
 /*   510 */     9,  196,   39,   76,   77,   85,   86,   44,   37,  158,
 /*   520 */    52,   40,   93,   17,   87,  106,  158,   20,  109,  137,
 /*   530 */   126,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   540 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   550 */    77,   78,   79,   80,   81,  194,   23,   39,  129,  191,
 /*   560 */   192,   55,   44,   57,  203,    9,   19,  161,  162,  101,
 /*   570 */    98,   99,  100,   86,  168,   19,   58,   59,   60,   61,
 /*   580 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   590 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   600 */   113,    9,   39,   45,   12,  155,  105,   44,  107,  108,
 /*   610 */    87,  161,  105,   90,  107,  108,  106,   61,   85,   86,
 /*   620 */   110,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   630 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   640 */    77,   78,   79,   80,   81,   19,   22,   39,   25,   23,
 /*   650 */    19,   28,   44,  156,   20,   97,   22,   87,  111,  137,
 /*   660 */    90,   89,   87,   91,    9,   90,   43,   59,   60,   61,
 /*   670 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   680 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   690 */    19,    9,   39,   20,   23,   22,  199,   44,   19,  183,
 /*   700 */   184,   26,   23,   17,   19,   23,  133,  134,   23,   34,
 /*   710 */    86,   85,   86,   60,   61,   62,   63,   64,   65,   66,
 /*   720 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   730 */    77,   78,   79,   80,   81,   50,  109,  113,   15,  138,
 /*   740 */    19,   55,  111,   57,   23,   60,   19,   24,  138,  122,
 /*   750 */    23,    9,  140,   39,  138,  144,   85,   86,   44,  158,
 /*   760 */    37,   76,   77,   40,   85,   23,  138,   85,   86,   84,
 /*   770 */    85,   86,   87,  145,   51,   90,   91,   50,  138,   20,
 /*   780 */    66,   67,  138,  167,   22,  101,  158,   60,   20,   19,
 /*   790 */    22,   47,   21,   23,  109,  111,    9,  145,  158,  171,
 /*   800 */   190,  200,  158,   76,   77,   91,   85,   86,  123,  124,
 /*   810 */   125,   84,   85,   86,   87,  129,  138,   90,   91,  138,
 /*   820 */    50,  205,  194,  171,   58,  138,   97,   85,   86,  138,
 /*   830 */    60,  203,  145,   20,  138,   22,  158,   11,  198,  158,
 /*   840 */   111,   97,  198,    9,  138,  158,   76,   77,   78,  158,
 /*   850 */   123,  124,  125,  126,   84,   85,   86,   87,  171,   97,
 /*   860 */    90,   91,   11,  138,   13,   14,   15,   16,   19,  138,
 /*   870 */   138,  145,   23,  167,  138,   20,  138,   22,   27,  151,
 /*   880 */    22,  194,  111,   20,  138,   22,   35,  121,  138,  158,
 /*   890 */   203,  195,  167,  123,  124,  125,  138,  171,  138,   50,
 /*   900 */    49,  138,   51,  167,  158,  167,   48,   56,  158,   60,
 /*   910 */   182,  205,  138,   53,   54,   33,  158,   20,  158,   22,
 /*   920 */    22,  158,  196,   41,    9,   76,   77,  195,  138,   20,
 /*   930 */   205,   22,  158,   84,   85,   86,   87,  211,  138,   90,
 /*   940 */    91,  205,  216,  205,  138,  138,  138,  138,  158,   98,
 /*   950 */    99,  100,  126,  138,  120,  104,  138,  138,  158,  138,
 /*   960 */   109,  138,  138,  138,  158,  158,  158,  158,  138,  138,
 /*   970 */   138,  138,  123,  124,  125,  138,  158,  158,  138,  158,
 /*   980 */   138,  158,  158,  158,  138,  138,  138,  151,  158,  158,
 /*   990 */   158,  158,  138,  149,   20,  158,   22,  138,  158,  138,
 /*  1000 */   158,  145,  138,  138,  158,  158,  158,  138,  138,  138,
 /*  1010 */   112,  145,  158,  138,   91,  138,  138,  158,  182,  158,
 /*  1020 */   205,  138,  158,  158,  174,  102,  145,  171,  158,  158,
 /*  1030 */    19,  181,   21,  158,   20,  158,   22,  171,   20,  138,
 /*  1040 */    22,  158,   97,  156,   31,  156,  170,   42,  164,   46,
 /*  1050 */   157,  156,  171,   19,  111,  156,  109,  111,  172,  190,
 /*  1060 */   175,  171,  120,  119,  173,  117,  178,  118,  190,  177,
 /*  1070 */   176,  115,  153,   87,   87,  179,  116,  153,  153,   22,
 /*  1080 */   180,   96,   23,  157,  150,   81,  111,  111,  138,  138,
 /*  1090 */    91,  138,  109,  109,  126,  193,   14,  109,   19,   22,
 /*  1100 */    20,  138,  199,  199,   20,   22,  201,  138,  202,   20,
 /*  1110 */    22,  138,   20,  111,  142,  138,  138,  116,  157,   22,
 /*  1120 */   193,  142,  185,  113,  142,   97,  186,  138,  138,  138,
 /*  1130 */   138,  114,   19,  138,  111,   20,  156,   19,  138,  187,
 /*  1140 */   186,  160,  187,   20,  138,   46,   19,   19,   46,   19,
 /*  1150 */   193,  193,  159,   95,  102,   21,  162,   97,   38,  163,
 /*  1160 */   163,  163,  150,  138,  157,  157,  151,  138,   11,  153,
 /*  1170 */   138,  212,  153,  164,  138,  142,  138,  142,  156,  142,
 /*  1180 */   156,  138,  142,  213,   36,  159,  166,  166,   97,   47,
 /*  1190 */   160,   97,  129,  138,  138,  142,  142,   97,   19,    9,
 /*  1200 */   156,  129,   11,   14,    9,    9,  121,  121,  169,   58,
 /*  1210 */   101,  170,   14,  138,  169,   61,  138,    9,  176,   61,
 /*  1220 */    19,   19,  121,    9,  112,  138,  176,    9,  138,    9,
 /*  1230 */     9,  138,    9,    9,  138,    9,  112,  142,  176,  169,
 /*  1240 */   142,  214,  138,  197,  138,  142,  215,  142,  138,  142,
 /*  1250 */   142,  101,  138,    9,  121,  138,   19,  176,  142,    9,
 /*  1260 */   138,  197,    9,  138,    9,    9,    9,    9,  142,    9,
 /*  1270 */   209,    9,    9,    9,  209,  138,    9,   32,  138,   20,
 /*  1280 */   151,    9,   21,  217,    9,  218,  151,  138,  217,    9,
};
#define YY_SHIFT_USE_DFLT (-66)
static short yy_shift_ofst[] = {
 /*     0 */    25,  259,  -66,  851,   69,  -66,  204,  592,  317,  682,
 /*    10 */   391,  -66,  -66,  -66,  592,  480,  592,  489,  592,  655,
 /*    20 */  1011,  787,  533,  897,  759,  915,  235,  -66,   39,  -66,
 /*    30 */   399,  -66,  533,   16,  -66,  945,  -66, 1013,  723,  -66,
 /*    40 */   -66,  -66,  -66,  -66,  -66,  923,  945,  -66, 1005,  -66,
 /*    50 */   882,  -66,  -66, 1003,  675,  945,  -66,  -66,  -66,  945,
 /*    60 */   -66, 1034,  849,  547,  255,  943,  946,  685,  -66,  119,
 /*    70 */   947,  -66,  510,  -66,  898,  942,  948,  949,  956,  944,
 /*    80 */   -66,  437,  -66,  986,  -66,  987,  -66,  858,  437,  -66,
 /*    90 */   437,  -66,  960,  849, 1057,  849,  985,  675,  -66, 1059,
 /*   100 */   -66,  -66,  518,  849,  -66,  975,  533,  976,  533,  -66,
 /*   110 */   -66,  -66,  -66,  -66,  653,  849,  608,  849,  -48,  849,
 /*   120 */   -48,  849,  -48,  849,  -48,  849,  -65,  849,  -65,  849,
 /*   130 */    -6,  849,   -6,  849,   -6,  849,   -6,  849,  -65,  714,
 /*   140 */   849,  -65,  -66,  -66,  849,   93,  849,   93,  849, 1004,
 /*   150 */   849, 1004,  849, 1004,  849,  -66,  -66,  127,  -66,  999,
 /*   160 */   -66,  -66,  849,  473,  849,  -65,  626,  685,  199,  419,
 /*   170 */   983,  984,  988,  -66,  518,  849,  653,  849,  -66,  849,
 /*   180 */   -66,  849,  -66,  727,  404,  968,  329, 1082,  -66,  849,
 /*   190 */   221,  849,  518, 1079,  481, 1080,  -66, 1077,  533, 1084,
 /*   200 */   -66, 1083,  533, 1089,  -66, 1088,  533, 1092,  -66,  849,
 /*   210 */   359,  849,  176,  849,  518,  673,  -66,  849,  -66,  -66,
 /*   220 */  1002,  533,  -66,  -66,  -66,  849,  563,  849,  653,  671,
 /*   230 */   685,  507,  -66,  974,  -66, 1002,  -66,  985,  675,  -66,
 /*   240 */   849,  518, 1001,  849, 1097,  849,  518,  -66,  -66,  624,
 /*   250 */   -66,  -66,  -66,  299,  -66,  289,  -66, 1010,  -66,  721,
 /*   260 */  1002,   56,  -66,  -66,  533,  -66,  -66, 1028, 1017,  -66,
 /*   270 */  1113,  533, 1014,  -66,  533,  -66,  -66,  849,  518,  947,
 /*   280 */   168,  487,  -19,   56, 1028, 1017,  -66,  770,  -21,  -66,
 /*   290 */   -66, 1023,  430,  -66,  -66,  -66,  -66,   86,  -66,  909,
 /*   300 */   -66, 1115,  -66,  291,  945,  -66,  533, 1118,  -66,  558,
 /*   310 */   -66,  533,  -66,  472,  468,  -66,  572,  -66,  -66,  -66,
 /*   320 */   -66,  468,  -66,  468,  -66,  533,  813,  -66,  533,  985,
 /*   330 */   675,  -66,  -66,  985,  675,  -66,  -66, 1059,  -66, 1005,
 /*   340 */   -66,  -66,   46,  -66,  -66,  -66,  575,  -66,  -66,  570,
 /*   350 */   -66,  -66,  -66,  -66,  679,  437,  634,  -66,  437, 1123,
 /*   360 */   -66,  -66,  -66,  -66,  294,  129,  -66,  533,  -66, 1099,
 /*   370 */  1127,  533,  386,  945,  -66, 1128,  533, 1018,  945,  -66,
 /*   380 */   849,   24,  -66, 1102, 1130,  533,   45, 1058,  533, 1118,
 /*   390 */   -66,  347, 1052,  -66,  -66,  -66,  -66,  -66,  947,  159,
 /*   400 */   429,  506,  533, 1002,  -66,  533,  771, 1134,  947,  395,
 /*   410 */   533, 1002,  623,  130, 1060,  533, 1002, 1120,  826, 1157,
 /*   420 */   849,  131, 1148,  860,  -66,  -66, 1091, 1094,  744,  533,
 /*   430 */   762,  -66,  -66, 1142,  -66,  -66, 1063,  533,  729, 1100,
 /*   440 */   533,  631, 1179,  533,  863,  222, 1190, 1072, 1191,  163,
 /*   450 */    71,  766,  723,  -66, 1085, 1086, 1189, 1195, 1196,  163,
 /*   460 */  1198, 1151,  533, 1109,  533,  105,  533, 1154,  849,  518,
 /*   470 */  1208, 1158,  849,  518, 1101,  533, 1201,  533,  768,  -66,
 /*   480 */   627,  501, 1202,  849,  855,  849,  518, 1214,  518, 1112,
 /*   490 */   533,  834, 1218,  686,  533,  304, 1220,  533,  304, 1221,
 /*   500 */   533,  304, 1223,  533,  304, 1224,    8, 1124,  533, 1002,
 /*   510 */   834, 1226, 1151,  533,  684, 1150,  533,  105, 1244, 1133,
 /*   520 */   533, 1002, 1201,  225,   27, 1237,  849,  288, 1250,  742,
 /*   530 */  1253,  533, 1002,  556,   43, 1255, 1256, 1257, 1258,  523,
 /*   540 */  1260, 1262, 1263,  523, 1264,  -66,  533, 1259, 1267, 1245,
 /*   550 */    39, 1261,  533,  390, 1272,   39, 1275,  -66, 1245,  533,
 /*   560 */  1280,  -66,  -66,  -66,
};
#define YY_REDUCE_USE_DFLT (-113)
static short yy_reduce_ofst[] = {
 /*     0 */  -112,  573, -113,  315, -113, -113, -113,    1, -113,  239,
 /*    10 */  -113, -113, -113, -113,  305, -113,  392, -113,  522, -113,
 /*    20 */   612, -113,  267,  611, -113, -113,  171, -113,   32,  844,
 /*    30 */   116, -113,  901,  450, -113,  887, -113, -113,  876, -113,
 /*    40 */  -113, -113, -113, -113, -113, -113,  889, -113,  884, -113,
 /*    50 */  -113, -113, -113, -113,  893,  895, -113, -113, -113,  899,
 /*    60 */  -113, -113,  790, -113,  361, -113, -113,  238, -113,  886,
 /*    70 */   890, -113,  891,  850,  885,  894,  892,  888,  896,  900,
 /*    80 */  -113,  919, -113, -113, -113, -113, -113, -113,  924, -113,
 /*    90 */   925, -113, -113,  368, -113,  253,  902,  926, -113,  934,
 /*   100 */  -113, -113,  903,  870, -113, -113,  950, -113,  951, -113,
 /*   110 */  -113, -113, -113, -113,  903,  186,  903,  678,  903,  681,
 /*   120 */   903,  746,  903,  760,  903,  763,  903,  800,  903,  808,
 /*   130 */   903,  819,  903,  824,  903,  831,  903,  832,  903,  904,
 /*   140 */   837,  903, -113, -113,  848,  903,  859,  903,  864,  903,
 /*   150 */   750,  903,  875,  903,  883,  903, -113, -113, -113, -113,
 /*   160 */  -113, -113,  825,  903,  840,  903,  953,  687,  886, -113,
 /*   170 */  -113, -113, -113, -113,  903,  731,  903,  846,  903,  823,
 /*   180 */   903,  877,  903,  601,  903,  905,  906, -113, -113,  830,
 /*   190 */   903,  818,  903, -113, -113, -113, -113, -113,  963, -113,
 /*   200 */  -113, -113,  969, -113, -113, -113,  973, -113, -113,  833,
 /*   210 */   903,  774,  903,  809,  903, -113, -113,  243, -113, -113,
 /*   220 */   972,  977, -113, -113, -113,  865,  903,  861,  903,  978,
 /*   230 */   628,  886, -113, -113, -113,  979, -113,  927,  961, -113,
 /*   240 */   821,  903, -113,  -77, -113,  806,  903, -113,  516,  937,
 /*   250 */  -113, -113, -113,  989, -113,  990, -113, -113, -113,  991,
 /*   260 */   982,  836, -113, -113,  992, -113, -113,  940,  952, -113,
 /*   270 */  -113,  869, -113, -113,  995, -113, -113,  758,  903,   -2,
 /*   280 */   886,  937, -113,  728,  954,  955, -113,  842,   34, -113,
 /*   290 */  -113, -113,  950, -113, -113, -113, -113,  903, -113, -113,
 /*   300 */  -113, -113, -113,  903,  980, -113, 1000,  993,  981,  994,
 /*   310 */  -113, 1006, -113, -113,  996, -113, -113, -113, -113, -113,
 /*   320 */  -113,  997, -113,  998, -113,  725, -113, -113,  815,  957,
 /*   330 */  1007, -113, -113,  958, 1008, -113, -113, 1012, -113, 1009,
 /*   340 */  -113, -113, -113, -113, -113, -113, -113, -113, -113, -113,
 /*   350 */  -113, -113, -113, -113, 1015, 1016, -113, -113, 1019, -113,
 /*   360 */  -113, -113, -113, -113, 1020, 1021, -113, 1025, -113, -113,
 /*   370 */  -113,  738, -113, 1022, -113, -113,  736, -113, 1024, -113,
 /*   380 */   847,  497, -113, -113, -113,  706, -113, -113, 1029, 1026,
 /*   390 */  1030,  406, -113, -113, -113, -113, -113, -113,  881,  886,
 /*   400 */   248, -113, 1032, 1033, -113, 1036, 1035, -113,  866,  886,
 /*   410 */  1038, 1037,  959,  970, -113, 1043, 1040, 1027, 1031, -113,
 /*   420 */   854,  903, -113, -113, -113, -113, -113, -113, -113,  610,
 /*   430 */  -113, -113, -113, -113, -113, -113, -113, 1055, 1053, -113,
 /*   440 */  1056, 1054, -113,  616, -113, 1044, -113, -113, -113,  726,
 /*   450 */   886, 1039, 1041, -113, -113, -113, -113, -113, -113,  245,
 /*   460 */  -113, 1045, 1075, -113,  732, 1042, 1078, -113,  691,  903,
 /*   470 */  -113, -113,  807,  903, -113, 1087, 1046,  878, -113, -113,
 /*   480 */   652,  886, -113,  644, -113,  871,  903, -113,  903, -113,
 /*   490 */  1090, 1050, -113, -113, 1093, 1095, -113, 1096, 1098, -113,
 /*   500 */  1104, 1103, -113, 1106, 1105, -113,  886, -113, 1110, 1107,
 /*   510 */  1062, -113, 1070, 1114, 1108, -113,  696, 1081, -113, -113,
 /*   520 */  1117, 1116, 1064,  856,  886, -113,  640, -113, -113, 1122,
 /*   530 */  -113, 1125, 1126, -113,  187, -113, -113, -113, -113, 1061,
 /*   540 */  -113, -113, -113, 1065, -113, -113, 1137, -113, -113, 1066,
 /*   550 */  1129, -113, 1140, 1067, -113, 1135, -113, -113, 1071, 1149,
 /*   560 */  -113, -113, -113, -113,
};
static YYACTIONTYPE yy_default[] = {
 /*     0 */   571,  571,  565,  856,  856,  567,  856,  856,  856,  856,
 /*    10 */   856,  592,  593,  594,  856,  856,  856,  856,  856,  856,
 /*    20 */   856,  856,  856,  856,  856,  856,  856,  585,  595,  605,
 /*    30 */   587,  604,  856,  856,  606,  652,  617,  856,  856,  653,
 /*    40 */   656,  657,  658,  659,  660,  856,  652,  618,  637,  635,
 /*    50 */   856,  638,  639,  856,  709,  652,  619,  707,  708,  652,
 /*    60 */   620,  856,  856,  738,  799,  744,  739,  856,  665,  856,
 /*    70 */   856,  666,  674,  676,  683,  721,  712,  714,  702,  716,
 /*    80 */   671,  856,  601,  856,  602,  856,  603,  717,  856,  718,
 /*    90 */   856,  719,  856,  856,  703,  856,  710,  709,  704,  856,
 /*   100 */   589,  711,  706,  856,  737,  856,  856,  740,  856,  741,
 /*   110 */   742,  743,  745,  746,  749,  856,  750,  856,  751,  856,
 /*   120 */   752,  856,  753,  856,  754,  856,  755,  856,  756,  856,
 /*   130 */   757,  856,  758,  856,  759,  856,  760,  856,  761,  856,
 /*   140 */   856,  762,  763,  764,  856,  765,  856,  766,  856,  767,
 /*   150 */   856,  768,  856,  769,  856,  770,  771,  856,  772,  856,
 /*   160 */   775,  773,  856,  856,  856,  781,  856,  799,  856,  856,
 /*   170 */   856,  856,  856,  784,  798,  856,  776,  856,  777,  856,
 /*   180 */   778,  856,  779,  856,  856,  856,  856,  856,  789,  856,
 /*   190 */   856,  856,  790,  856,  856,  856,  845,  856,  856,  856,
 /*   200 */   846,  856,  856,  856,  847,  856,  856,  856,  848,  856,
 /*   210 */   856,  856,  856,  856,  791,  856,  783,  799,  796,  797,
 /*   220 */   691,  856,  692,  787,  774,  856,  856,  856,  782,  856,
 /*   230 */   799,  856,  786,  856,  785,  691,  788,  710,  709,  705,
 /*   240 */   856,  715,  856,  799,  713,  856,  722,  675,  686,  684,
 /*   250 */   685,  693,  694,  856,  695,  856,  696,  856,  697,  856,
 /*   260 */   691,  682,  590,  591,  856,  680,  681,  699,  701,  687,
 /*   270 */   856,  856,  856,  700,  856,  734,  735,  856,  698,  686,
 /*   280 */   856,  856,  856,  682,  699,  701,  688,  856,  682,  677,
 /*   290 */   678,  856,  856,  679,  672,  673,  780,  856,  736,  856,
 /*   300 */   747,  856,  748,  856,  652,  621,  856,  803,  625,  622,
 /*   310 */   626,  856,  627,  856,  856,  628,  856,  631,  632,  633,
 /*   320 */   634,  856,  629,  856,  630,  856,  856,  804,  856,  710,
 /*   330 */   709,  805,  807,  710,  709,  806,  623,  856,  624,  637,
 /*   340 */   636,  607,  856,  608,  609,  610,  856,  611,  614,  856,
 /*   350 */   612,  615,  613,  616,  596,  856,  856,  597,  856,  856,
 /*   360 */   598,  600,  599,  588,  856,  856,  642,  856,  645,  856,
 /*   370 */   856,  856,  856,  652,  646,  856,  856,  856,  652,  647,
 /*   380 */   856,  652,  648,  856,  856,  856,  856,  856,  856,  803,
 /*   390 */   625,  650,  856,  649,  651,  643,  644,  586,  856,  856,
 /*   400 */   582,  856,  856,  691,  580,  856,  856,  856,  856,  856,
 /*   410 */   856,  691,  828,  856,  856,  856,  691,  833,  856,  856,
 /*   420 */   856,  856,  856,  856,  834,  835,  856,  856,  856,  856,
 /*   430 */   856,  825,  826,  856,  827,  581,  856,  856,  856,  856,
 /*   440 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   450 */   856,  856,  856,  655,  856,  856,  856,  856,  856,  856,
 /*   460 */   856,  654,  856,  856,  856,  856,  856,  856,  856,  724,
 /*   470 */   856,  856,  856,  725,  856,  856,  732,  856,  856,  733,
 /*   480 */   856,  856,  856,  856,  856,  856,  730,  856,  731,  856,
 /*   490 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  856,
 /*   500 */   856,  856,  856,  856,  856,  856,  856,  856,  856,  691,
 /*   510 */   856,  856,  654,  856,  856,  856,  856,  856,  856,  856,
 /*   520 */   856,  691,  732,  856,  856,  856,  856,  856,  856,  856,
 /*   530 */   856,  856,  691,  856,  822,  856,  856,  856,  856,  856,
 /*   540 */   856,  856,  856,  856,  856,  821,  856,  856,  856,  854,
 /*   550 */   856,  856,  856,  856,  856,  856,  856,  853,  854,  856,
 /*   560 */   856,  568,  570,  566,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*    CLUSTER => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*   DEFERRED => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*       GLOB => ID */
   23,  /*     IGNORE => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*       LIKE => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         EQ => nothing */
    0,  /*         NE => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*         GT => nothing */
    0,  /*         GE => nothing */
    0,  /*         LT => nothing */
    0,  /*         LE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /*    INTEGER => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "SEMI",          "EXPLAIN",       "BEGIN",       
  "TRANSACTION",   "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CLUSTER",       "CONFLICT",    
  "DATABASE",      "DEFERRED",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "GLOB",        
  "IGNORE",        "IMMEDIATE",     "INITIALLY",     "INSTEAD",     
  "LIKE",          "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "OR",            "AND",         
  "NOT",           "EQ",            "NE",            "ISNULL",      
  "NOTNULL",       "IS",            "BETWEEN",       "IN",          
  "GT",            "GE",            "LT",            "LE",          
  "BITAND",        "BITOR",         "LSHIFT",        "RSHIFT",      
  "PLUS",          "MINUS",         "STAR",          "SLASH",       
  "REM",           "CONCAT",        "UMINUS",        "UPLUS",       
  "BITNOT",        "STRING",        "JOIN_KW",       "INTEGER",     
  "CONSTRAINT",    "DEFAULT",       "FLOAT",         "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "COLLATE",       "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "INTERSECT",   
  "EXCEPT",        "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "BLOB",        
  "VARIABLE",      "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "error",         "input",       
  "cmdlist",       "ecmd",          "explain",       "cmdx",        
  "cmd",           "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "carg",          "ccons",       
  "onconf",        "sortorder",     "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "expritem",    
  "uniqueflag",    "idxitem",       "plus_num",      "minus_num",   
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= explain cmdx SEMI",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "cmdx ::= cmd",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "explain ::=",
 /*   8 */ "cmd ::= BEGIN trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "cmd ::= COMMIT trans_opt",
 /*  13 */ "cmd ::= END trans_opt",
 /*  14 */ "cmd ::= ROLLBACK trans_opt",
 /*  15 */ "cmd ::= create_table create_table_args",
 /*  16 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  17 */ "temp ::= TEMP",
 /*  18 */ "temp ::=",
 /*  19 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  20 */ "create_table_args ::= AS select",
 /*  21 */ "columnlist ::= columnlist COMMA column",
 /*  22 */ "columnlist ::= column",
 /*  23 */ "column ::= columnid type carglist",
 /*  24 */ "columnid ::= nm",
 /*  25 */ "id ::= ID",
 /*  26 */ "ids ::= ID",
 /*  27 */ "ids ::= STRING",
 /*  28 */ "nm ::= ID",
 /*  29 */ "nm ::= STRING",
 /*  30 */ "nm ::= JOIN_KW",
 /*  31 */ "type ::=",
 /*  32 */ "type ::= typename",
 /*  33 */ "type ::= typename LP signed RP",
 /*  34 */ "type ::= typename LP signed COMMA signed RP",
 /*  35 */ "typename ::= ids",
 /*  36 */ "typename ::= typename ids",
 /*  37 */ "signed ::= INTEGER",
 /*  38 */ "signed ::= PLUS INTEGER",
 /*  39 */ "signed ::= MINUS INTEGER",
 /*  40 */ "carglist ::= carglist carg",
 /*  41 */ "carglist ::=",
 /*  42 */ "carg ::= CONSTRAINT nm ccons",
 /*  43 */ "carg ::= ccons",
 /*  44 */ "carg ::= DEFAULT STRING",
 /*  45 */ "carg ::= DEFAULT ID",
 /*  46 */ "carg ::= DEFAULT INTEGER",
 /*  47 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  48 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  49 */ "carg ::= DEFAULT FLOAT",
 /*  50 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  51 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  52 */ "carg ::= DEFAULT NULL",
 /*  53 */ "ccons ::= NULL onconf",
 /*  54 */ "ccons ::= NOT NULL onconf",
 /*  55 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  56 */ "ccons ::= UNIQUE onconf",
 /*  57 */ "ccons ::= CHECK LP expr RP onconf",
 /*  58 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  59 */ "ccons ::= defer_subclause",
 /*  60 */ "ccons ::= COLLATE id",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= ROLLBACK",
 /*  93 */ "resolvetype ::= ABORT",
 /*  94 */ "resolvetype ::= FAIL",
 /*  95 */ "resolvetype ::= IGNORE",
 /*  96 */ "resolvetype ::= REPLACE",
 /*  97 */ "cmd ::= DROP TABLE nm dbnm",
 /*  98 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  99 */ "cmd ::= DROP VIEW nm dbnm",
 /* 100 */ "cmd ::= select",
 /* 101 */ "select ::= oneselect",
 /* 102 */ "select ::= select multiselect_op oneselect",
 /* 103 */ "multiselect_op ::= UNION",
 /* 104 */ "multiselect_op ::= UNION ALL",
 /* 105 */ "multiselect_op ::= INTERSECT",
 /* 106 */ "multiselect_op ::= EXCEPT",
 /* 107 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 108 */ "distinct ::= DISTINCT",
 /* 109 */ "distinct ::= ALL",
 /* 110 */ "distinct ::=",
 /* 111 */ "sclp ::= selcollist COMMA",
 /* 112 */ "sclp ::=",
 /* 113 */ "selcollist ::= sclp expr as",
 /* 114 */ "selcollist ::= sclp STAR",
 /* 115 */ "selcollist ::= sclp nm DOT STAR",
 /* 116 */ "as ::= AS nm",
 /* 117 */ "as ::= ids",
 /* 118 */ "as ::=",
 /* 119 */ "from ::=",
 /* 120 */ "from ::= FROM seltablist",
 /* 121 */ "stl_prefix ::= seltablist joinop",
 /* 122 */ "stl_prefix ::=",
 /* 123 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 124 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 125 */ "seltablist_paren ::= select",
 /* 126 */ "seltablist_paren ::= seltablist",
 /* 127 */ "dbnm ::=",
 /* 128 */ "dbnm ::= DOT nm",
 /* 129 */ "joinop ::= COMMA",
 /* 130 */ "joinop ::= JOIN",
 /* 131 */ "joinop ::= JOIN_KW JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm JOIN",
 /* 133 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 134 */ "on_opt ::= ON expr",
 /* 135 */ "on_opt ::=",
 /* 136 */ "using_opt ::= USING LP inscollist RP",
 /* 137 */ "using_opt ::=",
 /* 138 */ "orderby_opt ::=",
 /* 139 */ "orderby_opt ::= ORDER BY sortlist",
 /* 140 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 141 */ "sortlist ::= sortitem collate sortorder",
 /* 142 */ "sortitem ::= expr",
 /* 143 */ "sortorder ::= ASC",
 /* 144 */ "sortorder ::= DESC",
 /* 145 */ "sortorder ::=",
 /* 146 */ "collate ::=",
 /* 147 */ "collate ::= COLLATE id",
 /* 148 */ "groupby_opt ::=",
 /* 149 */ "groupby_opt ::= GROUP BY exprlist",
 /* 150 */ "having_opt ::=",
 /* 151 */ "having_opt ::= HAVING expr",
 /* 152 */ "limit_opt ::=",
 /* 153 */ "limit_opt ::= LIMIT signed",
 /* 154 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 155 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 156 */ "cmd ::= DELETE FROM nm dbnm where_opt",
 /* 157 */ "where_opt ::=",
 /* 158 */ "where_opt ::= WHERE expr",
 /* 159 */ "cmd ::= UPDATE orconf nm dbnm SET setlist where_opt",
 /* 160 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 161 */ "setlist ::= nm EQ expr",
 /* 162 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt VALUES LP itemlist RP",
 /* 163 */ "cmd ::= insert_cmd INTO nm dbnm inscollist_opt select",
 /* 164 */ "insert_cmd ::= INSERT orconf",
 /* 165 */ "insert_cmd ::= REPLACE",
 /* 166 */ "itemlist ::= itemlist COMMA expr",
 /* 167 */ "itemlist ::= expr",
 /* 168 */ "inscollist_opt ::=",
 /* 169 */ "inscollist_opt ::= LP inscollist RP",
 /* 170 */ "inscollist ::= inscollist COMMA nm",
 /* 171 */ "inscollist ::= nm",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "expr ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "expr ::= INTEGER",
 /* 179 */ "expr ::= FLOAT",
 /* 180 */ "expr ::= STRING",
 /* 181 */ "expr ::= BLOB",
 /* 182 */ "expr ::= VARIABLE",
 /* 183 */ "expr ::= ID LP exprlist RP",
 /* 184 */ "expr ::= ID LP STAR RP",
 /* 185 */ "expr ::= expr AND expr",
 /* 186 */ "expr ::= expr OR expr",
 /* 187 */ "expr ::= expr LT expr",
 /* 188 */ "expr ::= expr GT expr",
 /* 189 */ "expr ::= expr LE expr",
 /* 190 */ "expr ::= expr GE expr",
 /* 191 */ "expr ::= expr NE expr",
 /* 192 */ "expr ::= expr EQ expr",
 /* 193 */ "expr ::= expr BITAND expr",
 /* 194 */ "expr ::= expr BITOR expr",
 /* 195 */ "expr ::= expr LSHIFT expr",
 /* 196 */ "expr ::= expr RSHIFT expr",
 /* 197 */ "expr ::= expr likeop expr",
 /* 198 */ "expr ::= expr NOT likeop expr",
 /* 199 */ "likeop ::= LIKE",
 /* 200 */ "likeop ::= GLOB",
 /* 201 */ "expr ::= expr PLUS expr",
 /* 202 */ "expr ::= expr MINUS expr",
 /* 203 */ "expr ::= expr STAR expr",
 /* 204 */ "expr ::= expr SLASH expr",
 /* 205 */ "expr ::= expr REM expr",
 /* 206 */ "expr ::= expr CONCAT expr",
 /* 207 */ "expr ::= expr ISNULL",
 /* 208 */ "expr ::= expr IS NULL",
 /* 209 */ "expr ::= expr NOTNULL",
 /* 210 */ "expr ::= expr NOT NULL",
 /* 211 */ "expr ::= expr IS NOT NULL",
 /* 212 */ "expr ::= NOT expr",
 /* 213 */ "expr ::= BITNOT expr",
 /* 214 */ "expr ::= MINUS expr",
 /* 215 */ "expr ::= PLUS expr",
 /* 216 */ "expr ::= LP select RP",
 /* 217 */ "expr ::= expr BETWEEN expr AND expr",
 /* 218 */ "expr ::= expr NOT BETWEEN expr AND expr",
 /* 219 */ "expr ::= expr IN LP exprlist RP",
 /* 220 */ "expr ::= expr IN LP select RP",
 /* 221 */ "expr ::= expr NOT IN LP exprlist RP",
 /* 222 */ "expr ::= expr NOT IN LP select RP",
 /* 223 */ "expr ::= expr IN nm dbnm",
 /* 224 */ "expr ::= expr NOT IN nm dbnm",
 /* 225 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 226 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 227 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 228 */ "case_else ::= ELSE expr",
 /* 229 */ "case_else ::=",
 /* 230 */ "case_operand ::= expr",
 /* 231 */ "case_operand ::=",
 /* 232 */ "exprlist ::= exprlist COMMA expritem",
 /* 233 */ "exprlist ::= expritem",
 /* 234 */ "expritem ::= expr",
 /* 235 */ "expritem ::=",
 /* 236 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm dbnm LP idxlist RP onconf",
 /* 237 */ "uniqueflag ::= UNIQUE",
 /* 238 */ "uniqueflag ::=",
 /* 239 */ "idxlist_opt ::=",
 /* 240 */ "idxlist_opt ::= LP idxlist RP",
 /* 241 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 242 */ "idxlist ::= idxitem collate sortorder",
 /* 243 */ "idxitem ::= nm",
 /* 244 */ "cmd ::= DROP INDEX nm dbnm",
 /* 245 */ "cmd ::= VACUUM",
 /* 246 */ "cmd ::= VACUUM nm",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 248 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 249 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 250 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 251 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 252 */ "cmd ::= PRAGMA nm dbnm",
 /* 253 */ "plus_num ::= plus_opt number",
 /* 254 */ "minus_num ::= MINUS number",
 /* 255 */ "number ::= INTEGER",
 /* 256 */ "number ::= FLOAT",
 /* 257 */ "plus_opt ::= PLUS",
 /* 258 */ "plus_opt ::=",
 /* 259 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 260 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 261 */ "trigger_time ::= BEFORE",
 /* 262 */ "trigger_time ::= AFTER",
 /* 263 */ "trigger_time ::= INSTEAD OF",
 /* 264 */ "trigger_time ::=",
 /* 265 */ "trigger_event ::= DELETE",
 /* 266 */ "trigger_event ::= INSERT",
 /* 267 */ "trigger_event ::= UPDATE",
 /* 268 */ "trigger_event ::= UPDATE OF inscollist",
 /* 269 */ "foreach_clause ::=",
 /* 270 */ "foreach_clause ::= FOR EACH ROW",
 /* 271 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 272 */ "when_clause ::=",
 /* 273 */ "when_clause ::= WHEN expr",
 /* 274 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 275 */ "trigger_cmd_list ::=",
 /* 276 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 277 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 278 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 279 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 280 */ "trigger_cmd ::= select",
 /* 281 */ "expr ::= RAISE LP IGNORE RP",
 /* 282 */ "expr ::= RAISE LP ROLLBACK COMMA nm RP",
 /* 283 */ "expr ::= RAISE LP ABORT COMMA nm RP",
 /* 284 */ "expr ::= RAISE LP FAIL COMMA nm RP",
 /* 285 */ "cmd ::= DROP TRIGGER nm dbnm",
 /* 286 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 287 */ "key_opt ::= USING ids",
 /* 288 */ "key_opt ::=",
 /* 289 */ "database_kw_opt ::= DATABASE",
 /* 290 */ "database_kw_opt ::=",
 /* 291 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 145:
#line 286 "parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1233 "parse.c"
      break;
    case 158:
#line 533 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1238 "parse.c"
      break;
    case 159:
#line 747 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1243 "parse.c"
      break;
    case 167:
#line 745 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1248 "parse.c"
      break;
    case 171:
#line 288 "parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1253 "parse.c"
      break;
    case 174:
#line 322 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1258 "parse.c"
      break;
    case 175:
#line 353 "parse.y"
{sqlite3SrcListDelete((yypminor->yy283));}
#line 1263 "parse.c"
      break;
    case 176:
#line 483 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1268 "parse.c"
      break;
    case 177:
#line 459 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1273 "parse.c"
      break;
    case 178:
#line 464 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1278 "parse.c"
      break;
    case 179:
#line 431 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1283 "parse.c"
      break;
    case 181:
#line 324 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1288 "parse.c"
      break;
    case 183:
#line 349 "parse.y"
{sqlite3SrcListDelete((yypminor->yy283));}
#line 1293 "parse.c"
      break;
    case 184:
#line 351 "parse.y"
{sqlite3SrcListDelete((yypminor->yy283));}
#line 1298 "parse.c"
      break;
    case 186:
#line 420 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1303 "parse.c"
      break;
    case 187:
#line 425 "parse.y"
{sqlite3IdListDelete((yypminor->yy246));}
#line 1308 "parse.c"
      break;
    case 188:
#line 400 "parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1313 "parse.c"
      break;
    case 190:
#line 522 "parse.y"
{sqlite3IdListDelete((yypminor->yy246));}
#line 1318 "parse.c"
      break;
    case 191:
#line 433 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1323 "parse.c"
      break;
    case 192:
#line 435 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1328 "parse.c"
      break;
    case 194:
#line 720 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1333 "parse.c"
      break;
    case 195:
#line 489 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1338 "parse.c"
      break;
    case 197:
#line 520 "parse.y"
{sqlite3IdListDelete((yypminor->yy246));}
#line 1343 "parse.c"
      break;
    case 198:
#line 514 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1348 "parse.c"
      break;
    case 201:
#line 703 "parse.y"
{sqlite3ExprListDelete((yypminor->yy232));}
#line 1353 "parse.c"
      break;
    case 203:
#line 722 "parse.y"
{sqlite3ExprDelete((yypminor->yy164));}
#line 1358 "parse.c"
      break;
    case 211:
#line 839 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy353));}
#line 1363 "parse.c"
      break;
    case 213:
#line 823 "parse.y"
{sqlite3IdListDelete((yypminor->yy414).b);}
#line 1368 "parse.c"
      break;
    case 216:
#line 847 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy353));}
#line 1373 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 131, 1 },
  { 132, 2 },
  { 132, 1 },
  { 133, 3 },
  { 133, 1 },
  { 135, 1 },
  { 134, 1 },
  { 134, 0 },
  { 136, 2 },
  { 137, 0 },
  { 137, 1 },
  { 137, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 136, 2 },
  { 139, 5 },
  { 141, 1 },
  { 141, 0 },
  { 140, 4 },
  { 140, 2 },
  { 143, 3 },
  { 143, 1 },
  { 146, 3 },
  { 147, 1 },
  { 150, 1 },
  { 151, 1 },
  { 151, 1 },
  { 138, 1 },
  { 138, 1 },
  { 138, 1 },
  { 148, 0 },
  { 148, 1 },
  { 148, 4 },
  { 148, 6 },
  { 152, 1 },
  { 152, 2 },
  { 153, 1 },
  { 153, 2 },
  { 153, 2 },
  { 149, 2 },
  { 149, 0 },
  { 154, 3 },
  { 154, 1 },
  { 154, 2 },
  { 154, 2 },
  { 154, 2 },
  { 154, 3 },
  { 154, 3 },
  { 154, 2 },
  { 154, 3 },
  { 154, 3 },
  { 154, 2 },
  { 155, 2 },
  { 155, 3 },
  { 155, 4 },
  { 155, 2 },
  { 155, 5 },
  { 155, 4 },
  { 155, 1 },
  { 155, 2 },
  { 160, 0 },
  { 160, 2 },
  { 162, 2 },
  { 162, 3 },
  { 162, 3 },
  { 162, 3 },
  { 163, 2 },
  { 163, 2 },
  { 163, 1 },
  { 163, 1 },
  { 161, 3 },
  { 161, 2 },
  { 164, 0 },
  { 164, 2 },
  { 164, 2 },
  { 144, 0 },
  { 144, 2 },
  { 165, 3 },
  { 165, 2 },
  { 165, 1 },
  { 166, 2 },
  { 166, 6 },
  { 166, 5 },
  { 166, 3 },
  { 166, 10 },
  { 168, 0 },
  { 168, 1 },
  { 156, 0 },
  { 156, 3 },
  { 169, 0 },
  { 169, 2 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 136, 4 },
  { 136, 7 },
  { 136, 4 },
  { 136, 1 },
  { 145, 1 },
  { 145, 3 },
  { 172, 1 },
  { 172, 2 },
  { 172, 1 },
  { 172, 1 },
  { 171, 9 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 181, 2 },
  { 181, 0 },
  { 174, 3 },
  { 174, 2 },
  { 174, 4 },
  { 182, 2 },
  { 182, 1 },
  { 182, 0 },
  { 175, 0 },
  { 175, 2 },
  { 184, 2 },
  { 184, 0 },
  { 183, 6 },
  { 183, 7 },
  { 188, 1 },
  { 188, 1 },
  { 142, 0 },
  { 142, 2 },
  { 185, 1 },
  { 185, 1 },
  { 185, 2 },
  { 185, 3 },
  { 185, 4 },
  { 186, 2 },
  { 186, 0 },
  { 187, 4 },
  { 187, 0 },
  { 179, 0 },
  { 179, 3 },
  { 191, 5 },
  { 191, 3 },
  { 192, 1 },
  { 157, 1 },
  { 157, 1 },
  { 157, 0 },
  { 193, 0 },
  { 193, 2 },
  { 177, 0 },
  { 177, 3 },
  { 178, 0 },
  { 178, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 4 },
  { 180, 4 },
  { 136, 5 },
  { 176, 0 },
  { 176, 2 },
  { 136, 7 },
  { 195, 5 },
  { 195, 3 },
  { 136, 9 },
  { 136, 6 },
  { 196, 2 },
  { 196, 1 },
  { 198, 3 },
  { 198, 1 },
  { 197, 0 },
  { 197, 3 },
  { 190, 3 },
  { 190, 1 },
  { 158, 3 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 3 },
  { 158, 5 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 1 },
  { 158, 4 },
  { 158, 4 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 4 },
  { 199, 1 },
  { 199, 1 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 2 },
  { 158, 3 },
  { 158, 4 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 2 },
  { 158, 3 },
  { 158, 5 },
  { 158, 6 },
  { 158, 5 },
  { 158, 5 },
  { 158, 6 },
  { 158, 6 },
  { 158, 4 },
  { 158, 5 },
  { 158, 5 },
  { 201, 5 },
  { 201, 4 },
  { 202, 2 },
  { 202, 0 },
  { 200, 1 },
  { 200, 0 },
  { 194, 3 },
  { 194, 1 },
  { 203, 1 },
  { 203, 0 },
  { 136, 12 },
  { 204, 1 },
  { 204, 0 },
  { 159, 0 },
  { 159, 3 },
  { 167, 5 },
  { 167, 3 },
  { 205, 1 },
  { 136, 4 },
  { 136, 1 },
  { 136, 2 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 5 },
  { 136, 6 },
  { 136, 3 },
  { 206, 2 },
  { 207, 2 },
  { 209, 1 },
  { 209, 1 },
  { 208, 1 },
  { 208, 0 },
  { 136, 5 },
  { 210, 11 },
  { 212, 1 },
  { 212, 1 },
  { 212, 2 },
  { 212, 0 },
  { 213, 1 },
  { 213, 1 },
  { 213, 1 },
  { 213, 3 },
  { 214, 0 },
  { 214, 3 },
  { 214, 3 },
  { 215, 0 },
  { 215, 2 },
  { 211, 3 },
  { 211, 0 },
  { 216, 6 },
  { 216, 8 },
  { 216, 5 },
  { 216, 4 },
  { 216, 1 },
  { 158, 4 },
  { 158, 6 },
  { 158, 6 },
  { 158, 6 },
  { 136, 4 },
  { 136, 6 },
  { 218, 2 },
  { 218, 0 },
  { 217, 1 },
  { 217, 0 },
  { 136, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        /* No destructor defined for cmdlist */
        break;
      case 1:
        /* No destructor defined for cmdlist */
        /* No destructor defined for ecmd */
        break;
      case 2:
        /* No destructor defined for ecmd */
        break;
      case 3:
        /* No destructor defined for explain */
        /* No destructor defined for cmdx */
        /* No destructor defined for SEMI */
        break;
      case 4:
        /* No destructor defined for SEMI */
        break;
      case 5:
#line 72 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1898 "parse.c"
        /* No destructor defined for cmd */
        break;
      case 6:
#line 73 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1904 "parse.c"
        /* No destructor defined for EXPLAIN */
        break;
      case 7:
#line 74 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1910 "parse.c"
        break;
      case 8:
#line 79 "parse.y"
{sqlite3BeginTransaction(pParse);}
#line 1915 "parse.c"
        /* No destructor defined for BEGIN */
        /* No destructor defined for trans_opt */
        break;
      case 9:
        break;
      case 10:
        /* No destructor defined for TRANSACTION */
        break;
      case 11:
        /* No destructor defined for TRANSACTION */
        /* No destructor defined for nm */
        break;
      case 12:
#line 83 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1931 "parse.c"
        /* No destructor defined for COMMIT */
        /* No destructor defined for trans_opt */
        break;
      case 13:
#line 84 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1938 "parse.c"
        /* No destructor defined for END */
        /* No destructor defined for trans_opt */
        break;
      case 14:
#line 85 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1945 "parse.c"
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for trans_opt */
        break;
      case 15:
        /* No destructor defined for create_table */
        /* No destructor defined for create_table_args */
        break;
      case 16:
#line 90 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318,yymsp[-3].minor.yy424,0);
}
#line 1958 "parse.c"
        /* No destructor defined for TABLE */
        break;
      case 17:
#line 94 "parse.y"
{yygotominor.yy424 = 1;}
#line 1964 "parse.c"
        /* No destructor defined for TEMP */
        break;
      case 18:
#line 95 "parse.y"
{yygotominor.yy424 = 0;}
#line 1970 "parse.c"
        break;
      case 19:
#line 96 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[0].minor.yy0,0);
}
#line 1977 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for columnlist */
        /* No destructor defined for conslist_opt */
        break;
      case 20:
#line 99 "parse.y"
{
  sqlite3EndTable(pParse,0,yymsp[0].minor.yy375);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 1988 "parse.c"
        /* No destructor defined for AS */
        break;
      case 21:
        /* No destructor defined for columnlist */
        /* No destructor defined for COMMA */
        /* No destructor defined for column */
        break;
      case 22:
        /* No destructor defined for column */
        break;
      case 23:
        /* No destructor defined for columnid */
        /* No destructor defined for type */
        /* No destructor defined for carglist */
        break;
      case 24:
#line 111 "parse.y"
{sqlite3AddColumn(pParse,&yymsp[0].minor.yy318);}
#line 2007 "parse.c"
        break;
      case 25:
#line 117 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2012 "parse.c"
        break;
      case 26:
#line 149 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2017 "parse.c"
        break;
      case 27:
#line 150 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2022 "parse.c"
        break;
      case 28:
#line 155 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2027 "parse.c"
        break;
      case 29:
#line 156 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2032 "parse.c"
        break;
      case 30:
#line 157 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 2037 "parse.c"
        break;
      case 31:
        break;
      case 32:
#line 160 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy318,&yymsp[0].minor.yy318);}
#line 2044 "parse.c"
        break;
      case 33:
#line 161 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy318,&yymsp[0].minor.yy0);}
#line 2049 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        break;
      case 34:
#line 163 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy318,&yymsp[0].minor.yy0);}
#line 2056 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for signed */
        /* No destructor defined for COMMA */
        /* No destructor defined for signed */
        break;
      case 35:
#line 165 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 2065 "parse.c"
        break;
      case 36:
#line 166 "parse.y"
{yygotominor.yy318.z=yymsp[-1].minor.yy318.z; yygotominor.yy318.n=yymsp[-1].minor.yy318.n+Addr(yymsp[0].minor.yy318.z)-Addr(yymsp[-1].minor.yy318.z);}
#line 2070 "parse.c"
        break;
      case 37:
#line 168 "parse.y"
{ yygotominor.yy424 = atoi(yymsp[0].minor.yy0.z); }
#line 2075 "parse.c"
        break;
      case 38:
#line 169 "parse.y"
{ yygotominor.yy424 = atoi(yymsp[0].minor.yy0.z); }
#line 2080 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 39:
#line 170 "parse.y"
{ yygotominor.yy424 = -atoi(yymsp[0].minor.yy0.z); }
#line 2086 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 40:
        /* No destructor defined for carglist */
        /* No destructor defined for carg */
        break;
      case 41:
        break;
      case 42:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        /* No destructor defined for ccons */
        break;
      case 43:
        /* No destructor defined for ccons */
        break;
      case 44:
#line 175 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2106 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 45:
#line 176 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2112 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 46:
#line 177 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2118 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 47:
#line 178 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2124 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 48:
#line 179 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2131 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 49:
#line 180 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2138 "parse.c"
        /* No destructor defined for DEFAULT */
        break;
      case 50:
#line 181 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,0);}
#line 2144 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for PLUS */
        break;
      case 51:
#line 182 "parse.y"
{sqlite3AddDefaultValue(pParse,&yymsp[0].minor.yy0,1);}
#line 2151 "parse.c"
        /* No destructor defined for DEFAULT */
        /* No destructor defined for MINUS */
        break;
      case 52:
        /* No destructor defined for DEFAULT */
        /* No destructor defined for NULL */
        break;
      case 53:
        /* No destructor defined for NULL */
        /* No destructor defined for onconf */
        break;
      case 54:
#line 189 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy424);}
#line 2166 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for NULL */
        break;
      case 55:
#line 190 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[0].minor.yy424);}
#line 2173 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for sortorder */
        break;
      case 56:
#line 191 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy424,0,0);}
#line 2181 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 57:
        /* No destructor defined for CHECK */
        /* No destructor defined for LP */
  yy_destructor(158,&yymsp[-2].minor);
        /* No destructor defined for RP */
        /* No destructor defined for onconf */
        break;
      case 58:
#line 194 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy318,yymsp[-1].minor.yy232,yymsp[0].minor.yy424);}
#line 2194 "parse.c"
        /* No destructor defined for REFERENCES */
        break;
      case 59:
#line 195 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy424);}
#line 2200 "parse.c"
        break;
      case 60:
#line 196 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy318.z, yymsp[0].minor.yy318.n);}
#line 2205 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 61:
#line 204 "parse.y"
{ yygotominor.yy424 = OE_Restrict * 0x010101; }
#line 2211 "parse.c"
        break;
      case 62:
#line 205 "parse.y"
{ yygotominor.yy424 = (yymsp[-1].minor.yy424 & yymsp[0].minor.yy299.mask) | yymsp[0].minor.yy299.value; }
#line 2216 "parse.c"
        break;
      case 63:
#line 207 "parse.y"
{ yygotominor.yy299.value = 0;     yygotominor.yy299.mask = 0x000000; }
#line 2221 "parse.c"
        /* No destructor defined for MATCH */
        /* No destructor defined for nm */
        break;
      case 64:
#line 208 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424;     yygotominor.yy299.mask = 0x0000ff; }
#line 2228 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for DELETE */
        break;
      case 65:
#line 209 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<8;  yygotominor.yy299.mask = 0x00ff00; }
#line 2235 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for UPDATE */
        break;
      case 66:
#line 210 "parse.y"
{ yygotominor.yy299.value = yymsp[0].minor.yy424<<16; yygotominor.yy299.mask = 0xff0000; }
#line 2242 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for INSERT */
        break;
      case 67:
#line 212 "parse.y"
{ yygotominor.yy424 = OE_SetNull; }
#line 2249 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for NULL */
        break;
      case 68:
#line 213 "parse.y"
{ yygotominor.yy424 = OE_SetDflt; }
#line 2256 "parse.c"
        /* No destructor defined for SET */
        /* No destructor defined for DEFAULT */
        break;
      case 69:
#line 214 "parse.y"
{ yygotominor.yy424 = OE_Cascade; }
#line 2263 "parse.c"
        /* No destructor defined for CASCADE */
        break;
      case 70:
#line 215 "parse.y"
{ yygotominor.yy424 = OE_Restrict; }
#line 2269 "parse.c"
        /* No destructor defined for RESTRICT */
        break;
      case 71:
#line 217 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2275 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for DEFERRABLE */
        break;
      case 72:
#line 218 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2282 "parse.c"
        /* No destructor defined for DEFERRABLE */
        break;
      case 73:
#line 220 "parse.y"
{yygotominor.yy424 = 0;}
#line 2288 "parse.c"
        break;
      case 74:
#line 221 "parse.y"
{yygotominor.yy424 = 1;}
#line 2293 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for DEFERRED */
        break;
      case 75:
#line 222 "parse.y"
{yygotominor.yy424 = 0;}
#line 2300 "parse.c"
        /* No destructor defined for INITIALLY */
        /* No destructor defined for IMMEDIATE */
        break;
      case 76:
        break;
      case 77:
        /* No destructor defined for COMMA */
        /* No destructor defined for conslist */
        break;
      case 78:
        /* No destructor defined for conslist */
        /* No destructor defined for COMMA */
        /* No destructor defined for tcons */
        break;
      case 79:
        /* No destructor defined for conslist */
        /* No destructor defined for tcons */
        break;
      case 80:
        /* No destructor defined for tcons */
        break;
      case 81:
        /* No destructor defined for CONSTRAINT */
        /* No destructor defined for nm */
        break;
      case 82:
#line 234 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-2].minor.yy232,yymsp[0].minor.yy424);}
#line 2329 "parse.c"
        /* No destructor defined for PRIMARY */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 83:
#line 236 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy232,yymsp[0].minor.yy424,0,0);}
#line 2338 "parse.c"
        /* No destructor defined for UNIQUE */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 84:
        /* No destructor defined for CHECK */
  yy_destructor(158,&yymsp[-1].minor);
        /* No destructor defined for onconf */
        break;
      case 85:
#line 239 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy232, &yymsp[-3].minor.yy318, yymsp[-2].minor.yy232, yymsp[-1].minor.yy424);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy424);
}
#line 2354 "parse.c"
        /* No destructor defined for FOREIGN */
        /* No destructor defined for KEY */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        /* No destructor defined for REFERENCES */
        break;
      case 86:
#line 244 "parse.y"
{yygotominor.yy424 = 0;}
#line 2364 "parse.c"
        break;
      case 87:
#line 245 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2369 "parse.c"
        break;
      case 88:
#line 253 "parse.y"
{ yygotominor.yy424 = OE_Default; }
#line 2374 "parse.c"
        break;
      case 89:
#line 254 "parse.y"
{ yygotominor.yy424 = yymsp[0].minor.yy424; }
#line 2379 "parse.c"
        /* No destructor defined for ON */
        /* No destructor defined for CONFLICT */
        break;
      case 90:
#line 255 "parse.y"
{ yygotominor.yy424 = OE_Default; }
#line 2386 "parse.c"
        break;
      case 91:
#line 256 "parse.y"
{ yygotominor.yy424 = yymsp[0].minor.yy424; }
#line 2391 "parse.c"
        /* No destructor defined for OR */
        break;
      case 92:
#line 257 "parse.y"
{ yygotominor.yy424 = OE_Rollback; }
#line 2397 "parse.c"
        /* No destructor defined for ROLLBACK */
        break;
      case 93:
#line 258 "parse.y"
{ yygotominor.yy424 = OE_Abort; }
#line 2403 "parse.c"
        /* No destructor defined for ABORT */
        break;
      case 94:
#line 259 "parse.y"
{ yygotominor.yy424 = OE_Fail; }
#line 2409 "parse.c"
        /* No destructor defined for FAIL */
        break;
      case 95:
#line 260 "parse.y"
{ yygotominor.yy424 = OE_Ignore; }
#line 2415 "parse.c"
        /* No destructor defined for IGNORE */
        break;
      case 96:
#line 261 "parse.y"
{ yygotominor.yy424 = OE_Replace; }
#line 2421 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 97:
#line 265 "parse.y"
{
  sqlite3DropTable(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318), 0);
}
#line 2429 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TABLE */
        break;
      case 98:
#line 271 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318, yymsp[0].minor.yy375, yymsp[-5].minor.yy424);
}
#line 2438 "parse.c"
        /* No destructor defined for VIEW */
        /* No destructor defined for AS */
        break;
      case 99:
#line 274 "parse.y"
{
  sqlite3DropTable(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318), 1);
}
#line 2447 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for VIEW */
        break;
      case 100:
#line 280 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy375, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2457 "parse.c"
        break;
      case 101:
#line 290 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2462 "parse.c"
        break;
      case 102:
#line 291 "parse.y"
{
  if( yymsp[0].minor.yy375 ){
    yymsp[0].minor.yy375->op = yymsp[-1].minor.yy424;
    yymsp[0].minor.yy375->pPrior = yymsp[-2].minor.yy375;
  }
  yygotominor.yy375 = yymsp[0].minor.yy375;
}
#line 2473 "parse.c"
        break;
      case 103:
#line 299 "parse.y"
{yygotominor.yy424 = TK_UNION;}
#line 2478 "parse.c"
        /* No destructor defined for UNION */
        break;
      case 104:
#line 300 "parse.y"
{yygotominor.yy424 = TK_ALL;}
#line 2484 "parse.c"
        /* No destructor defined for UNION */
        /* No destructor defined for ALL */
        break;
      case 105:
#line 301 "parse.y"
{yygotominor.yy424 = TK_INTERSECT;}
#line 2491 "parse.c"
        /* No destructor defined for INTERSECT */
        break;
      case 106:
#line 302 "parse.y"
{yygotominor.yy424 = TK_EXCEPT;}
#line 2497 "parse.c"
        /* No destructor defined for EXCEPT */
        break;
      case 107:
#line 304 "parse.y"
{
  yygotominor.yy375 = sqlite3SelectNew(yymsp[-6].minor.yy232,yymsp[-5].minor.yy283,yymsp[-4].minor.yy164,yymsp[-3].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy232,yymsp[-7].minor.yy424,yymsp[0].minor.yy22.limit,yymsp[0].minor.yy22.offset);
}
#line 2505 "parse.c"
        /* No destructor defined for SELECT */
        break;
      case 108:
#line 312 "parse.y"
{yygotominor.yy424 = 1;}
#line 2511 "parse.c"
        /* No destructor defined for DISTINCT */
        break;
      case 109:
#line 313 "parse.y"
{yygotominor.yy424 = 0;}
#line 2517 "parse.c"
        /* No destructor defined for ALL */
        break;
      case 110:
#line 314 "parse.y"
{yygotominor.yy424 = 0;}
#line 2523 "parse.c"
        break;
      case 111:
#line 325 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 2528 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 112:
#line 326 "parse.y"
{yygotominor.yy232 = 0;}
#line 2534 "parse.c"
        break;
      case 113:
#line 327 "parse.y"
{
   yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[-1].minor.yy164,yymsp[0].minor.yy318.n?&yymsp[0].minor.yy318:0);
}
#line 2541 "parse.c"
        break;
      case 114:
#line 330 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-1].minor.yy232, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2548 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 115:
#line 333 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-3].minor.yy232, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2558 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for STAR */
        break;
      case 116:
#line 343 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 2565 "parse.c"
        /* No destructor defined for AS */
        break;
      case 117:
#line 344 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 2571 "parse.c"
        break;
      case 118:
#line 345 "parse.y"
{ yygotominor.yy318.n = 0; }
#line 2576 "parse.c"
        break;
      case 119:
#line 357 "parse.y"
{yygotominor.yy283 = sqliteMalloc(sizeof(*yygotominor.yy283));}
#line 2581 "parse.c"
        break;
      case 120:
#line 358 "parse.y"
{yygotominor.yy283 = yymsp[0].minor.yy283;}
#line 2586 "parse.c"
        /* No destructor defined for FROM */
        break;
      case 121:
#line 363 "parse.y"
{
   yygotominor.yy283 = yymsp[-1].minor.yy283;
   if( yygotominor.yy283 && yygotominor.yy283->nSrc>0 ) yygotominor.yy283->a[yygotominor.yy283->nSrc-1].jointype = yymsp[0].minor.yy424;
}
#line 2595 "parse.c"
        break;
      case 122:
#line 367 "parse.y"
{yygotominor.yy283 = 0;}
#line 2600 "parse.c"
        break;
      case 123:
#line 368 "parse.y"
{
  yygotominor.yy283 = sqlite3SrcListAppend(yymsp[-5].minor.yy283,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318);
  if( yymsp[-2].minor.yy318.n ) sqlite3SrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2616 "parse.c"
        break;
      case 124:
#line 381 "parse.y"
{
  yygotominor.yy283 = sqlite3SrcListAppend(yymsp[-6].minor.yy283,0,0);
  yygotominor.yy283->a[yygotominor.yy283->nSrc-1].pSelect = yymsp[-4].minor.yy375;
  if( yymsp[-2].minor.yy318.n ) sqlite3SrcListAddAlias(yygotominor.yy283,&yymsp[-2].minor.yy318);
  if( yymsp[-1].minor.yy164 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pOn = yymsp[-1].minor.yy164; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy164); }
  }
  if( yymsp[0].minor.yy246 ){
    if( yygotominor.yy283 && yygotominor.yy283->nSrc>1 ){ yygotominor.yy283->a[yygotominor.yy283->nSrc-2].pUsing = yymsp[0].minor.yy246; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy246); }
  }
}
#line 2633 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 125:
#line 401 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2640 "parse.c"
        break;
      case 126:
#line 402 "parse.y"
{
   yygotominor.yy375 = sqlite3SelectNew(0,yymsp[0].minor.yy283,0,0,0,0,0,-1,0);
}
#line 2647 "parse.c"
        break;
      case 127:
#line 407 "parse.y"
{yygotominor.yy318.z=0; yygotominor.yy318.n=0;}
#line 2652 "parse.c"
        break;
      case 128:
#line 408 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 2657 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 129:
#line 412 "parse.y"
{ yygotominor.yy424 = JT_INNER; }
#line 2663 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 130:
#line 413 "parse.y"
{ yygotominor.yy424 = JT_INNER; }
#line 2669 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 131:
#line 414 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2675 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 132:
#line 415 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy318,0); }
#line 2681 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 133:
#line 417 "parse.y"
{ yygotominor.yy424 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318); }
#line 2687 "parse.c"
        /* No destructor defined for JOIN */
        break;
      case 134:
#line 421 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2693 "parse.c"
        /* No destructor defined for ON */
        break;
      case 135:
#line 422 "parse.y"
{yygotominor.yy164 = 0;}
#line 2699 "parse.c"
        break;
      case 136:
#line 426 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 2704 "parse.c"
        /* No destructor defined for USING */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 137:
#line 427 "parse.y"
{yygotominor.yy246 = 0;}
#line 2712 "parse.c"
        break;
      case 138:
#line 437 "parse.y"
{yygotominor.yy232 = 0;}
#line 2717 "parse.c"
        break;
      case 139:
#line 438 "parse.y"
{yygotominor.yy232 = yymsp[0].minor.yy232;}
#line 2722 "parse.c"
        /* No destructor defined for ORDER */
        /* No destructor defined for BY */
        break;
      case 140:
#line 439 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232,yymsp[-2].minor.yy164,yymsp[-1].minor.yy318.n>0?&yymsp[-1].minor.yy318:0);
  if( yygotominor.yy232 ) yygotominor.yy232->a[yygotominor.yy232->nExpr-1].sortOrder = yymsp[0].minor.yy424;
}
#line 2732 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 141:
#line 443 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy164,yymsp[-1].minor.yy318.n>0?&yymsp[-1].minor.yy318:0);
  if( yygotominor.yy232 && yygotominor.yy232->a ) yygotominor.yy232->a[0].sortOrder = yymsp[0].minor.yy424;
}
#line 2741 "parse.c"
        break;
      case 142:
#line 447 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2746 "parse.c"
        break;
      case 143:
#line 452 "parse.y"
{yygotominor.yy424 = SQLITE_SO_ASC;}
#line 2751 "parse.c"
        /* No destructor defined for ASC */
        break;
      case 144:
#line 453 "parse.y"
{yygotominor.yy424 = SQLITE_SO_DESC;}
#line 2757 "parse.c"
        /* No destructor defined for DESC */
        break;
      case 145:
#line 454 "parse.y"
{yygotominor.yy424 = SQLITE_SO_ASC;}
#line 2763 "parse.c"
        break;
      case 146:
#line 455 "parse.y"
{yygotominor.yy318.z = 0; yygotominor.yy318.n = 0;}
#line 2768 "parse.c"
        break;
      case 147:
#line 456 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 2773 "parse.c"
        /* No destructor defined for COLLATE */
        break;
      case 148:
#line 460 "parse.y"
{yygotominor.yy232 = 0;}
#line 2779 "parse.c"
        break;
      case 149:
#line 461 "parse.y"
{yygotominor.yy232 = yymsp[0].minor.yy232;}
#line 2784 "parse.c"
        /* No destructor defined for GROUP */
        /* No destructor defined for BY */
        break;
      case 150:
#line 465 "parse.y"
{yygotominor.yy164 = 0;}
#line 2791 "parse.c"
        break;
      case 151:
#line 466 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2796 "parse.c"
        /* No destructor defined for HAVING */
        break;
      case 152:
#line 469 "parse.y"
{yygotominor.yy22.limit = -1; yygotominor.yy22.offset = 0;}
#line 2802 "parse.c"
        break;
      case 153:
#line 470 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = 0;}
#line 2807 "parse.c"
        /* No destructor defined for LIMIT */
        break;
      case 154:
#line 472 "parse.y"
{yygotominor.yy22.limit = yymsp[-2].minor.yy424; yygotominor.yy22.offset = yymsp[0].minor.yy424;}
#line 2813 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for OFFSET */
        break;
      case 155:
#line 474 "parse.y"
{yygotominor.yy22.limit = yymsp[0].minor.yy424; yygotominor.yy22.offset = yymsp[-2].minor.yy424;}
#line 2820 "parse.c"
        /* No destructor defined for LIMIT */
        /* No destructor defined for COMMA */
        break;
      case 156:
#line 478 "parse.y"
{
   sqlite3DeleteFrom(pParse, sqlite3SrcListAppend(0,&yymsp[-2].minor.yy318,&yymsp[-1].minor.yy318), yymsp[0].minor.yy164);
}
#line 2829 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 157:
#line 485 "parse.y"
{yygotominor.yy164 = 0;}
#line 2836 "parse.c"
        break;
      case 158:
#line 486 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 2841 "parse.c"
        /* No destructor defined for WHERE */
        break;
      case 159:
#line 494 "parse.y"
{sqlite3Update(pParse,sqlite3SrcListAppend(0,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318),yymsp[-1].minor.yy232,yymsp[0].minor.yy164,yymsp[-5].minor.yy424);}
#line 2847 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 160:
#line 497 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2854 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for EQ */
        break;
      case 161:
#line 498 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,&yymsp[-2].minor.yy318);}
#line 2861 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 162:
#line 504 "parse.y"
{sqlite3Insert(pParse, sqlite3SrcListAppend(0,&yymsp[-6].minor.yy318,&yymsp[-5].minor.yy318), yymsp[-1].minor.yy232, 0, yymsp[-4].minor.yy246, yymsp[-8].minor.yy424);}
#line 2867 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 163:
#line 506 "parse.y"
{sqlite3Insert(pParse, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318), 0, yymsp[0].minor.yy375, yymsp[-1].minor.yy246, yymsp[-5].minor.yy424);}
#line 2876 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 164:
#line 509 "parse.y"
{yygotominor.yy424 = yymsp[0].minor.yy424;}
#line 2882 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 165:
#line 510 "parse.y"
{yygotominor.yy424 = OE_Replace;}
#line 2888 "parse.c"
        /* No destructor defined for REPLACE */
        break;
      case 166:
#line 516 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[0].minor.yy164,0);}
#line 2894 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 167:
#line 517 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,0);}
#line 2900 "parse.c"
        break;
      case 168:
#line 524 "parse.y"
{yygotominor.yy246 = 0;}
#line 2905 "parse.c"
        break;
      case 169:
#line 525 "parse.y"
{yygotominor.yy246 = yymsp[-1].minor.yy246;}
#line 2910 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 170:
#line 526 "parse.y"
{yygotominor.yy246 = sqlite3IdListAppend(yymsp[-2].minor.yy246,&yymsp[0].minor.yy318);}
#line 2917 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 171:
#line 527 "parse.y"
{yygotominor.yy246 = sqlite3IdListAppend(0,&yymsp[0].minor.yy318);}
#line 2923 "parse.c"
        break;
      case 172:
#line 535 "parse.y"
{yygotominor.yy164 = yymsp[-1].minor.yy164; sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2928 "parse.c"
        break;
      case 173:
#line 536 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_NULL, 0, 0, &yymsp[0].minor.yy0);}
#line 2933 "parse.c"
        break;
      case 174:
#line 537 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2938 "parse.c"
        break;
      case 175:
#line 538 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2943 "parse.c"
        break;
      case 176:
#line 539 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2952 "parse.c"
        /* No destructor defined for DOT */
        break;
      case 177:
#line 544 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy318);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy318);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy318);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy164 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2964 "parse.c"
        /* No destructor defined for DOT */
        /* No destructor defined for DOT */
        break;
      case 178:
#line 551 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_INTEGER, 0, 0, &yymsp[0].minor.yy0);}
#line 2971 "parse.c"
        break;
      case 179:
#line 552 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_FLOAT, 0, 0, &yymsp[0].minor.yy0);}
#line 2976 "parse.c"
        break;
      case 180:
#line 553 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy0);}
#line 2981 "parse.c"
        break;
      case 181:
#line 554 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_BLOB, 0, 0, &yymsp[0].minor.yy0);}
#line 2986 "parse.c"
        break;
      case 182:
#line 555 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_VARIABLE, 0, 0, &yymsp[0].minor.yy0);
  if( yygotominor.yy164 ) yygotominor.yy164->iTable = ++pParse->nVar;
}
#line 2994 "parse.c"
        break;
      case 183:
#line 559 "parse.y"
{
  yygotominor.yy164 = sqlite3ExprFunction(yymsp[-1].minor.yy232, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3002 "parse.c"
        /* No destructor defined for LP */
        break;
      case 184:
#line 563 "parse.y"
{
  yygotominor.yy164 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3011 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for STAR */
        break;
      case 185:
#line 567 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_AND, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3018 "parse.c"
        /* No destructor defined for AND */
        break;
      case 186:
#line 568 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_OR, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3024 "parse.c"
        /* No destructor defined for OR */
        break;
      case 187:
#line 569 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_LT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3030 "parse.c"
        /* No destructor defined for LT */
        break;
      case 188:
#line 570 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_GT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3036 "parse.c"
        /* No destructor defined for GT */
        break;
      case 189:
#line 571 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_LE, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3042 "parse.c"
        /* No destructor defined for LE */
        break;
      case 190:
#line 572 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_GE, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3048 "parse.c"
        /* No destructor defined for GE */
        break;
      case 191:
#line 573 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_NE, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3054 "parse.c"
        /* No destructor defined for NE */
        break;
      case 192:
#line 574 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_EQ, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3060 "parse.c"
        /* No destructor defined for EQ */
        break;
      case 193:
#line 575 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_BITAND, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3066 "parse.c"
        /* No destructor defined for BITAND */
        break;
      case 194:
#line 576 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_BITOR, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3072 "parse.c"
        /* No destructor defined for BITOR */
        break;
      case 195:
#line 577 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_LSHIFT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3078 "parse.c"
        /* No destructor defined for LSHIFT */
        break;
      case 196:
#line 578 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_RSHIFT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3084 "parse.c"
        /* No destructor defined for RSHIFT */
        break;
      case 197:
#line 579 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-2].minor.yy164, 0);
  yygotominor.yy164 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-2].minor.yy164->span, &yymsp[0].minor.yy164->span);
}
#line 3096 "parse.c"
        break;
      case 198:
#line 586 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[0].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy164, 0);
  yygotominor.yy164 = sqlite3ExprFunction(pList, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->op = yymsp[-1].minor.yy424;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 3108 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 199:
#line 595 "parse.y"
{yygotominor.yy424 = TK_LIKE;}
#line 3114 "parse.c"
        /* No destructor defined for LIKE */
        break;
      case 200:
#line 596 "parse.y"
{yygotominor.yy424 = TK_GLOB;}
#line 3120 "parse.c"
        /* No destructor defined for GLOB */
        break;
      case 201:
#line 597 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_PLUS, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3126 "parse.c"
        /* No destructor defined for PLUS */
        break;
      case 202:
#line 598 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_MINUS, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3132 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 203:
#line 599 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_STAR, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3138 "parse.c"
        /* No destructor defined for STAR */
        break;
      case 204:
#line 600 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_SLASH, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3144 "parse.c"
        /* No destructor defined for SLASH */
        break;
      case 205:
#line 601 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_REM, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3150 "parse.c"
        /* No destructor defined for REM */
        break;
      case 206:
#line 602 "parse.y"
{yygotominor.yy164 = sqlite3Expr(TK_CONCAT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, 0);}
#line 3156 "parse.c"
        /* No destructor defined for CONCAT */
        break;
      case 207:
#line 603 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3165 "parse.c"
        break;
      case 208:
#line 607 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3173 "parse.c"
        /* No destructor defined for IS */
        break;
      case 209:
#line 611 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3182 "parse.c"
        break;
      case 210:
#line 615 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3190 "parse.c"
        /* No destructor defined for NOT */
        break;
      case 211:
#line 619 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3199 "parse.c"
        /* No destructor defined for IS */
        /* No destructor defined for NOT */
        break;
      case 212:
#line 623 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3209 "parse.c"
        break;
      case 213:
#line 627 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_BITNOT, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3217 "parse.c"
        break;
      case 214:
#line 631 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3225 "parse.c"
        break;
      case 215:
#line 635 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy164->span);
}
#line 3233 "parse.c"
        break;
      case 216:
#line 639 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_SELECT, 0, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
}
#line 3242 "parse.c"
        break;
      case 217:
#line 644 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 3253 "parse.c"
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 218:
#line 651 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy164, 0);
  yygotominor.yy164 = sqlite3Expr(TK_BETWEEN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = pList;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy164->span);
}
#line 3267 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for BETWEEN */
        /* No destructor defined for AND */
        break;
      case 219:
#line 659 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3279 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 220:
#line 664 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3290 "parse.c"
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 221:
#line 669 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-1].minor.yy232;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3302 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 222:
#line 675 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-5].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = yymsp[-1].minor.yy375;
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-5].minor.yy164->span,&yymsp[0].minor.yy0);
}
#line 3315 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        /* No destructor defined for LP */
        break;
      case 223:
#line 681 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-3].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 3328 "parse.c"
        /* No destructor defined for IN */
        break;
      case 224:
#line 687 "parse.y"
{
  SrcList *pSrc = sqlite3SrcListAppend(0, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
  yygotominor.yy164 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy164, 0, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,-1,0);
  yygotominor.yy164 = sqlite3Expr(TK_NOT, yygotominor.yy164, 0, 0);
  sqlite3ExprSpan(yygotominor.yy164,&yymsp[-4].minor.yy164->span,yymsp[0].minor.yy318.z?&yymsp[0].minor.yy318:&yymsp[-1].minor.yy318);
}
#line 3340 "parse.c"
        /* No destructor defined for NOT */
        /* No destructor defined for IN */
        break;
      case 225:
#line 697 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, 0);
  if( yygotominor.yy164 ) yygotominor.yy164->pList = yymsp[-2].minor.yy232;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3351 "parse.c"
        break;
      case 226:
#line 704 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqlite3ExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 3359 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 227:
#line 708 "parse.y"
{
  yygotominor.yy232 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy164, 0);
  yygotominor.yy232 = sqlite3ExprListAppend(yygotominor.yy232, yymsp[0].minor.yy164, 0);
}
#line 3369 "parse.c"
        /* No destructor defined for WHEN */
        /* No destructor defined for THEN */
        break;
      case 228:
#line 713 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 3376 "parse.c"
        /* No destructor defined for ELSE */
        break;
      case 229:
#line 714 "parse.y"
{yygotominor.yy164 = 0;}
#line 3382 "parse.c"
        break;
      case 230:
#line 716 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 3387 "parse.c"
        break;
      case 231:
#line 717 "parse.y"
{yygotominor.yy164 = 0;}
#line 3392 "parse.c"
        break;
      case 232:
#line 725 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-2].minor.yy232,yymsp[0].minor.yy164,0);}
#line 3397 "parse.c"
        /* No destructor defined for COMMA */
        break;
      case 233:
#line 726 "parse.y"
{yygotominor.yy232 = sqlite3ExprListAppend(0,yymsp[0].minor.yy164,0);}
#line 3403 "parse.c"
        break;
      case 234:
#line 727 "parse.y"
{yygotominor.yy164 = yymsp[0].minor.yy164;}
#line 3408 "parse.c"
        break;
      case 235:
#line 728 "parse.y"
{yygotominor.yy164 = 0;}
#line 3413 "parse.c"
        break;
      case 236:
#line 733 "parse.y"
{
  if( yymsp[-10].minor.yy424!=OE_None ) yymsp[-10].minor.yy424 = yymsp[0].minor.yy424;
  if( yymsp[-10].minor.yy424==OE_Default) yymsp[-10].minor.yy424 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-8].minor.yy318, &yymsp[-7].minor.yy318, sqlite3SrcListAppend(0,&yymsp[-5].minor.yy318,&yymsp[-4].minor.yy318),
      yymsp[-2].minor.yy232, yymsp[-10].minor.yy424, &yymsp[-11].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 3423 "parse.c"
        /* No destructor defined for INDEX */
        /* No destructor defined for ON */
        /* No destructor defined for LP */
        break;
      case 237:
#line 741 "parse.y"
{ yygotominor.yy424 = OE_Abort; }
#line 3431 "parse.c"
        /* No destructor defined for UNIQUE */
        break;
      case 238:
#line 742 "parse.y"
{ yygotominor.yy424 = OE_None; }
#line 3437 "parse.c"
        break;
      case 239:
#line 750 "parse.y"
{yygotominor.yy232 = 0;}
#line 3442 "parse.c"
        break;
      case 240:
#line 751 "parse.y"
{yygotominor.yy232 = yymsp[-1].minor.yy232;}
#line 3447 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 241:
#line 752 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy318.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy318.z, yymsp[-1].minor.yy318.n);
  }
  yygotominor.yy232 = sqlite3ExprListAppend(yymsp[-4].minor.yy232, p, &yymsp[-2].minor.yy318);
}
#line 3461 "parse.c"
        /* No destructor defined for COMMA */
        /* No destructor defined for sortorder */
        break;
      case 242:
#line 760 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy318.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy318.z, yymsp[-1].minor.yy318.n);
  }
  yygotominor.yy232 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy318);
}
#line 3475 "parse.c"
        /* No destructor defined for sortorder */
        break;
      case 243:
#line 768 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 3481 "parse.c"
        break;
      case 244:
#line 774 "parse.y"
{
  sqlite3DropIndex(pParse, sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 3488 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for INDEX */
        break;
      case 245:
#line 780 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 3495 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 246:
#line 781 "parse.y"
{sqlite3Vacuum(pParse,&yymsp[0].minor.yy318);}
#line 3501 "parse.c"
        /* No destructor defined for VACUUM */
        break;
      case 247:
#line 785 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 3507 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 248:
#line 786 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy0,0);}
#line 3514 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 249:
#line 787 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,0);}
#line 3521 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 250:
#line 788 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy318,&yymsp[-2].minor.yy318,&yymsp[0].minor.yy318,1);
}
#line 3530 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for EQ */
        break;
      case 251:
#line 791 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy318,&yymsp[-3].minor.yy318,&yymsp[-1].minor.yy318,0);}
#line 3537 "parse.c"
        /* No destructor defined for PRAGMA */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 252:
#line 792 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318,0,0);}
#line 3545 "parse.c"
        /* No destructor defined for PRAGMA */
        break;
      case 253:
#line 793 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 3551 "parse.c"
        /* No destructor defined for plus_opt */
        break;
      case 254:
#line 794 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy318;}
#line 3557 "parse.c"
        /* No destructor defined for MINUS */
        break;
      case 255:
#line 795 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 3563 "parse.c"
        break;
      case 256:
#line 796 "parse.y"
{yygotominor.yy318 = yymsp[0].minor.yy0;}
#line 3568 "parse.c"
        break;
      case 257:
        /* No destructor defined for PLUS */
        break;
      case 258:
        break;
      case 259:
#line 802 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy318.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy318.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy353, &all);
}
#line 3583 "parse.c"
        /* No destructor defined for CREATE */
        /* No destructor defined for BEGIN */
        break;
      case 260:
#line 810 "parse.y"
{
  SrcList *pTab = sqlite3SrcListAppend(0, &yymsp[-3].minor.yy318, &yymsp[-2].minor.yy318);
  sqlite3BeginTrigger(pParse, &yymsp[-8].minor.yy318, &yymsp[-7].minor.yy318, yymsp[-6].minor.yy424, yymsp[-5].minor.yy414.a, yymsp[-5].minor.yy414.b, pTab, yymsp[-1].minor.yy424, yymsp[0].minor.yy206, yymsp[-10].minor.yy424);
  yygotominor.yy318 = (yymsp[-7].minor.yy318.n==0?yymsp[-8].minor.yy318:yymsp[-7].minor.yy318);
}
#line 3594 "parse.c"
        /* No destructor defined for TRIGGER */
        /* No destructor defined for ON */
        break;
      case 261:
#line 817 "parse.y"
{ yygotominor.yy424 = TK_BEFORE; }
#line 3601 "parse.c"
        /* No destructor defined for BEFORE */
        break;
      case 262:
#line 818 "parse.y"
{ yygotominor.yy424 = TK_AFTER;  }
#line 3607 "parse.c"
        /* No destructor defined for AFTER */
        break;
      case 263:
#line 819 "parse.y"
{ yygotominor.yy424 = TK_INSTEAD;}
#line 3613 "parse.c"
        /* No destructor defined for INSTEAD */
        /* No destructor defined for OF */
        break;
      case 264:
#line 820 "parse.y"
{ yygotominor.yy424 = TK_BEFORE; }
#line 3620 "parse.c"
        break;
      case 265:
#line 824 "parse.y"
{ yygotominor.yy414.a = TK_DELETE; yygotominor.yy414.b = 0; }
#line 3625 "parse.c"
        /* No destructor defined for DELETE */
        break;
      case 266:
#line 825 "parse.y"
{ yygotominor.yy414.a = TK_INSERT; yygotominor.yy414.b = 0; }
#line 3631 "parse.c"
        /* No destructor defined for INSERT */
        break;
      case 267:
#line 826 "parse.y"
{ yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = 0;}
#line 3637 "parse.c"
        /* No destructor defined for UPDATE */
        break;
      case 268:
#line 827 "parse.y"
{yygotominor.yy414.a = TK_UPDATE; yygotominor.yy414.b = yymsp[0].minor.yy246; }
#line 3643 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for OF */
        break;
      case 269:
#line 830 "parse.y"
{ yygotominor.yy424 = TK_ROW; }
#line 3650 "parse.c"
        break;
      case 270:
#line 831 "parse.y"
{ yygotominor.yy424 = TK_ROW; }
#line 3655 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for ROW */
        break;
      case 271:
#line 832 "parse.y"
{ yygotominor.yy424 = TK_STATEMENT; }
#line 3663 "parse.c"
        /* No destructor defined for FOR */
        /* No destructor defined for EACH */
        /* No destructor defined for STATEMENT */
        break;
      case 272:
#line 835 "parse.y"
{ yygotominor.yy206 = 0; }
#line 3671 "parse.c"
        break;
      case 273:
#line 836 "parse.y"
{ yygotominor.yy206 = yymsp[0].minor.yy164; }
#line 3676 "parse.c"
        /* No destructor defined for WHEN */
        break;
      case 274:
#line 840 "parse.y"
{
  yymsp[-2].minor.yy353->pNext = yymsp[0].minor.yy353;
  yygotominor.yy353 = yymsp[-2].minor.yy353;
}
#line 3685 "parse.c"
        /* No destructor defined for SEMI */
        break;
      case 275:
#line 844 "parse.y"
{ yygotominor.yy353 = 0; }
#line 3691 "parse.c"
        break;
      case 276:
#line 850 "parse.y"
{ yygotominor.yy353 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy318, yymsp[-1].minor.yy232, yymsp[0].minor.yy164, yymsp[-4].minor.yy424); }
#line 3696 "parse.c"
        /* No destructor defined for UPDATE */
        /* No destructor defined for SET */
        break;
      case 277:
#line 855 "parse.y"
{yygotominor.yy353 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy318, yymsp[-4].minor.yy246, yymsp[-1].minor.yy232, 0, yymsp[-7].minor.yy424);}
#line 3703 "parse.c"
        /* No destructor defined for INTO */
        /* No destructor defined for VALUES */
        /* No destructor defined for LP */
        /* No destructor defined for RP */
        break;
      case 278:
#line 858 "parse.y"
{yygotominor.yy353 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy318, yymsp[-1].minor.yy246, 0, yymsp[0].minor.yy375, yymsp[-4].minor.yy424);}
#line 3712 "parse.c"
        /* No destructor defined for INTO */
        break;
      case 279:
#line 862 "parse.y"
{yygotominor.yy353 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy318, yymsp[0].minor.yy164);}
#line 3718 "parse.c"
        /* No destructor defined for DELETE */
        /* No destructor defined for FROM */
        break;
      case 280:
#line 865 "parse.y"
{yygotominor.yy353 = sqlite3TriggerSelectStep(yymsp[0].minor.yy375); }
#line 3725 "parse.c"
        break;
      case 281:
#line 868 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy164->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3734 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for IGNORE */
        break;
      case 282:
#line 873 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Rollback;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3745 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ROLLBACK */
        /* No destructor defined for COMMA */
        break;
      case 283:
#line 878 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Abort;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3757 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for ABORT */
        /* No destructor defined for COMMA */
        break;
      case 284:
#line 883 "parse.y"
{
  yygotominor.yy164 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy318); 
  yygotominor.yy164->iColumn = OE_Fail;
  sqlite3ExprSpan(yygotominor.yy164, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3769 "parse.c"
        /* No destructor defined for LP */
        /* No destructor defined for FAIL */
        /* No destructor defined for COMMA */
        break;
      case 285:
#line 890 "parse.y"
{
  sqlite3DropTrigger(pParse,sqlite3SrcListAppend(0,&yymsp[-1].minor.yy318,&yymsp[0].minor.yy318));
}
#line 3779 "parse.c"
        /* No destructor defined for DROP */
        /* No destructor defined for TRIGGER */
        break;
      case 286:
#line 895 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy318, &yymsp[-1].minor.yy318, &yymsp[0].minor.yy318);
}
#line 3788 "parse.c"
        /* No destructor defined for ATTACH */
        /* No destructor defined for database_kw_opt */
        /* No destructor defined for AS */
        break;
      case 287:
#line 899 "parse.y"
{ yygotominor.yy318 = yymsp[0].minor.yy318; }
#line 3796 "parse.c"
        /* No destructor defined for USING */
        break;
      case 288:
#line 900 "parse.y"
{ yygotominor.yy318.z = 0; yygotominor.yy318.n = 0; }
#line 3802 "parse.c"
        break;
      case 289:
        /* No destructor defined for DATABASE */
        break;
      case 290:
        break;
      case 291:
#line 906 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy318);
}
#line 3814 "parse.c"
        /* No destructor defined for DETACH */
        /* No destructor defined for database_kw_opt */
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }

#line 3868 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    if( yymajor==0 ) return;
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
