package BoardStreams::Exception;

use Mojo::Base -strict;

use Exporter 'import';
our @EXPORT_OK = qw/ db_duplicate_error /;

sub db_duplicate_error {
    DbError::Duplicate->throw;
}


package DbError;

use Moo;
with 'Throwable';

has desc => (
    is       => 'ro',
    required => 1,
);


package DbError::Duplicate;

use Moo;
extends 'DbError';

has '+desc' => (
    default => 'Attempted to create row with duplicate key.'
);


1;
