# build_common.inc -- Build file common info -*- perl -*-
# RCS Info        : $Id: build_common.pl,v 1.18 2008/04/09 20:39:16 jv Exp $
# Author          : Johan Vromans
# Created On      : Thu Sep  1 17:28:26 2005
# Last Modified By: Johan Vromans
# Last Modified On: Wed Apr  9 22:38:27 2008
# Update Count    : 83
# Status          : Unknown, Use with caution!

use strict;
use Config;
use File::Spec;

our $data;

$data =
  { %$data,
    author          => 'Johan Vromans (jvromans@squirrel.nl)',
    abstract        => 'Elementary Bookkeeping (for the Dutch/European market)',
    pl_files        => {},
    installtype     => 'site',
    modname         => 'EekBoek',
    distname        => 'EekBoek',
    license         => "perl",
    script_files    => [ map { File::Spec->catfile("script", $_) }
			 qw(ebshell) ],
    prereq_pm =>
    { 'Getopt::Long'        => '2.13',
      'Term::ReadLine'      => 0,
      $^O eq "linux" ? ('Term::ReadLine::Gnu' => 0) : (),
      'DBI'                 => '1.40',
#     'Config::IniFiles'    => '2.38',
#     'Text::CSV_XS'        => 0,
#     'Locale::gettext'     => '1.05',
      #
      # These are required for the build/test, and will be included.
      'Module::Build'	    => '0.26',
      'IPC::Run3'	    => '0.034',
    },
    recomm_pm =>
    { 'Getopt::Long'        => '2.32',
      'Archive::Zip'	    => '1.16',
      'HTML::Entities'	    => '1.35',
      'DBD::Pg'             => '1.41',
      'DBD::SQLite'         => '1.13',
    },
    usrbin => "/usr/bin",
  };

sub checkbin {
    my ($msg) = @_;
    my $installscript = $Config{installscript};

    return if $installscript eq $data->{usrbin};
    print STDERR <<EOD;

WARNING: This build process will install a user accessible script.
The default location for user accessible scripts is
$installscript.
EOD
    print STDERR ($msg);
}

sub filelist {
    my ($dir, $pfx) = @_;
    $pfx ||= "";
    my $dirp = quotemeta($dir . "/");
    my $pm;

    open(my $mf, "MANIFEST") or return filelist_dyn($dir, $pfx);
    while ( <$mf> ) {
	chomp;
	next unless /$dirp(.*)/;
	$pm->{$_} = $pfx ? $pfx . $1 : $_;
    }
    close($mf);
    $pm;
}

sub filelist_dyn {
    my ($dir, $pfx) = @_;
    use File::Find;
    $pfx ||= "";
    my $dirl = length($dir);
    my $pm;
    find(sub {
	     if ( $_ eq "CVS" ) {
		 $File::Find::prune = 1;
		 return;
	     }
	     return if /^#.*#/;
	     return if /~$/;
	     return unless -f $_;
	     if ( $pfx ) {
		 $pm->{$File::Find::name} = $pfx .
		   substr($File::Find::name, $dirl);
	     }
	     else {
		 $pm->{$File::Find::name} = $pfx . $File::Find::name;
	     }
	 }, $dir);
    $pm;
}

sub WriteSpecfile {
    my $name    = shift;
    my $version = shift;

    my ($mv) = $version =~ /^\d+\.(\d+)/;

    vcopy( _tag	    => "RPM spec file",
	   _dst	    => "$name.spec",
	   PkgName  => $name,
	   pkgname  => lc($name),
	   version  => $version,
	   stable   => $mv % 2 ? "-unstable" : "",
	 );
}

sub WriteDebianControl {
    my $version = shift;

    my ($mv) = $version =~ /^\d+\.(\d+)/;

    vcopy( _tag	    => "Debian control file",
	   _dst	    => "debian/control",
	   version  => $version,
	   stable   => $mv % 2 ? "-unstable" : "",
	 );

    vcopy( _tag	    => "Debian changelog file",
	   _dst	    => "debian/changelog",
	   version  => $version,
	   stable   => $mv % 2 ? "unstable" : "stable",
	 );
}

sub vcopy {
    my (%ctrl) = @_;

    $ctrl{_src} ||= $ctrl{_dst} . ".in";

    return unless open(my $fh, "<", $ctrl{_src});

    print("Writing ", $ctrl{_tag}, "...\n") if $ctrl{_tag};

    my $newfh;
    open ($newfh, ">", $ctrl{_dst})
      or die($ctrl{_dst}, ": $!\n");

    my $pat = "(";
    foreach ( grep { ! /^_/ } keys(%ctrl) ) {
	$pat .= quotemeta($_) . "|";
    }
    chop($pat);
    $pat .= ")";

    $pat = qr/\[\%\s+$pat\s+\%\]/;

    while ( <$fh> ) {
	s/$pat/$ctrl{$1}/ge;
	print { $newfh } $_;
    }
    close($newfh);
}

1;
