# -*- perl -*-

# t/006_refresh_list.t

use 5.010;
use CPAN::Mini::Visit::Simple;
use CPAN::Mini::Visit::Simple::Auxiliary qw(
    create_minicpan_for_testing
    create_one_new_distro_version
    create_file
);
use Carp;
use File::Spec;
use Test::More;
require CPAN::Mini;
my $config_file = CPAN::Mini->config_file({});
unless ( defined $config_file and -e $config_file ) {
    plan skip_all => 'No .minicpanrc located';
}
else {
    plan tests => 38;
}


{
    my ($tdir, $author_dir) = create_minicpan_for_testing();

    # Create object and get primary list
    my $self = CPAN::Mini::Visit::Simple->new({
        minicpan => $tdir,
    });
    isa_ok ($self, 'CPAN::Mini::Visit::Simple');

    ok( $self->identify_distros(),
        "identify_distros() returned true value" );

    my $old_primary_list_ref = $self->get_list_ref();


    create_one_new_distro_version($author_dir);

    # We have now changed what is in our minicpan repository.
    # We need to refresh what is in $old_primary_list_ref.
    # (Since we did not use 'start_dir' or 'pattern' to create the old primary
    # list, we will not provide those arguments to refresh_list().

    my $refreshed_list_ref = $self->refresh_list( {
        derived_list    => $old_primary_list_ref,
    } );

    my $expected_list_ref = {
        map { my $path = qq|$author_dir/$_|; $path => 1 } qw(
            Alpha-Beta-0.01.tar.gz
            Gamma-Delta-0.02.tar.gz
            Epsilon-Zeta-0.04.tar.gz
        )
    };
    is_deeply(
        { map { $_ => 1 } @{$refreshed_list_ref} },
        $expected_list_ref,
        "Got expected refreshed list"
    );
}

{
    my ($tdir, $author_dir) = create_minicpan_for_testing();
    my $self = CPAN::Mini::Visit::Simple->new({ minicpan => $tdir });
    isa_ok ($self, 'CPAN::Mini::Visit::Simple');
    ok( $self->identify_distros(),
        "identify_distros() returned true value" );
    my $old_primary_list_ref = $self->get_list_ref();
    create_one_new_distro_version($author_dir);
    my $refreshed_list_ref;
    eval {
        $refreshed_list_ref = $self->refresh_list( { } );
    };
    like($@, qr/Need 'derived_list' whose value is list of distributions needing refreshment/,
        "Got expected error message due to absence of 'derived_list' argument");
}

{
    my ($tdir, $author_dir) = create_minicpan_for_testing();
    my $self = CPAN::Mini::Visit::Simple->new({ minicpan => $tdir });
    isa_ok ($self, 'CPAN::Mini::Visit::Simple');
    ok( $self->identify_distros(),
        "identify_distros() returned true value" );
    my $old_primary_list_ref = $self->get_list_ref();
    create_one_new_distro_version($author_dir);
    my $refreshed_list_ref;
    eval {
        $refreshed_list_ref = $self->refresh_list( { derived_list => {} } );
    };
    like($@, qr/Value of 'derived_list' must be array reference/,
        "Got expected error message due to bad 'derived_list' argument");
}

{
    my ($tdir, $author_dir) = create_minicpan_for_testing();
    my $self = CPAN::Mini::Visit::Simple->new({ minicpan => $tdir });
    isa_ok ($self, 'CPAN::Mini::Visit::Simple');
    ok( $self->identify_distros(),
        "identify_distros() returned true value" );
    my $old_primary_list_ref = $self->get_list_ref();

    # Create a stray item in the derived_list.  Since it is not found in the
    # minicpan, it should not be included in the list generated by the
    # operation of refresh_list().

    my $stray = File::Spec->catfile( $author_dir, 'Iota-Kappa-0.06.tar.gz' );
    push @{$old_primary_list_ref}, $stray;

    my $refreshed_list_ref = $self->refresh_list( {
        derived_list    => $old_primary_list_ref,
    } );

    my $expected_list_ref = {
        map { my $path = qq|$author_dir/$_|; $path => 1 } qw(
            Alpha-Beta-0.01.tar.gz
            Gamma-Delta-0.02.tar.gz
            Epsilon-Zeta-0.03.tar.gz
        )
    };
    is_deeply(
        { map { $_ => 1 } @{$refreshed_list_ref} },
        $expected_list_ref,
        "Got expected refreshed list"
    );
}

