use strict;
use warnings;

use lib 'lib';
use List::Util qw(shuffle);

use Net::IPAM::Tree;
use Net::IPAM::Block;

my $routes = {
  '0.0.0.0/0'         => 'next-hop 134.60.112.248 via Vl256 (ospf)',
  '0.0.0.0/8'         => 'Null0',
  '10.0.0.0/8'        => 'Null0',
  '10.96.2.0/24'      => 'next-hop 193.197.66.5',
  '10.96.3.0/24'      => 'next-hop 193.197.66.40',
  '10.96.4.0/24'      => 'next-hop 193.197.66.8',
  '10.96.5.0/24'      => 'next-hop 193.197.66.10',
  '10.96.6.0/24'      => 'next-hop 193.197.66.38',
  '10.96.7.0/24'      => 'next-hop 193.197.66.37',
  '10.96.8.0/24'      => 'next-hop 193.197.66.42',
  '10.104.64.0/24'    => 'next-hop 193.197.66.75',
  '10.104.128.0/19'   => 'connected Vl248',
  '10.104.160.0/19'   => 'connected Vl246',
  '10.104.192.0/23'   => 'connected Vl470',
  '10.104.194.0/23'   => 'connected Vl471',
  '10.104.196.0/23'   => 'connected Vl472',
  '10.104.198.0/23'   => 'connected Vl473',
  '10.104.200.0/23'   => 'connected Vl474',
  '10.104.202.0/23'   => 'connected Vl475',
  '10.104.210.0/23'   => 'connected Vl479',
  '10.104.255.0/24'   => 'connected Vl499',
  '10.105.0.0/20'     => 'next-hop 134.60.112.93',
  '10.105.16.0/20'    => 'next-hop 134.60.112.93',
  '10.105.61.0/24'    => 'next-hop 134.60.112.93',
  '10.105.62.0/24'    => 'next-hop 134.60.112.93',
  '10.105.63.0/24'    => 'next-hop 134.60.112.93',
  '10.105.64.0/24'    => 'connected Vl600',
  '10.105.65.0/24'    => 'connected Vl601',
  '10.105.66.0/24'    => 'connected Vl602',
  '10.105.67.0/24'    => 'connected Vl603',
  '10.105.68.0/24'    => 'connected Vl604',
  '10.254.254.254/32' => 'next-hop 134.60.112.248 via Vl256 (ospf)',
  '10.254.254.254/32' => 'next-hop 134.60.112.249 via Vl256 (ospf)',
  '127.0.0.0/8'       => 'Null0',
  '129.143.87.60/31'  => 'next-hop 134.60.112.248 via Vl256 (ospf)',
  '129.143.87.112/31' => 'next-hop 134.60.112.249 via Vl256 (ospf)',
  '134.60.1.0/24'     => 'connected Vl1111',
  '134.60.2.0/24'     => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.3.0/24'     => 'connected Vl3',
  '134.60.4.0/24'     => 'connected Vl4',
  '134.60.7.0/24'     => 'connected Vl7',
  '134.60.8.0/24'     => 'next-hop 134.60.112.165',
  '134.60.9.0/24'     => 'connected Vl9',
  '134.60.10.0/24'    => 'connected Vl10',
  '134.60.12.0/24'    => 'connected Vl12',
  '134.60.13.0/24'    => 'connected Vl13',
  '134.60.14.0/24'    => 'connected Vl14',
  '134.60.15.0/24'    => 'connected Vl15',
  '134.60.16.0/24'    => 'connected Vl16',
  '134.60.17.0/24'    => 'connected Vl17',
  '134.60.18.0/24'    => 'connected Vl18',
  '134.60.19.0/24'    => 'connected Vl19',
  '134.60.20.0/24'    => 'connected Vl20',
  '134.60.21.0/24'    => 'connected Vl21',
  '134.60.22.0/24'    => 'connected Vl22',
  '134.60.23.0/24'    => 'connected Vl23',
  '134.60.24.0/24'    => 'connected Vl24',
  '134.60.25.0/24'    => 'connected Vl25',
  '134.60.26.0/24'    => 'connected Vl26',
  '134.60.27.0/24'    => 'connected Vl27',
  '134.60.28.0/24'    => 'connected Vl28',
  '134.60.29.0/24'    => 'connected Vl29',
  '134.60.30.0/24'    => 'connected Vl30',
  '134.60.31.0/24'    => 'connected Vl31',
  '134.60.32.0/24'    => 'connected Vl32',
  '134.60.33.0/24'    => 'connected Vl33',
  '134.60.34.0/24'    => 'connected Vl34',
  '134.60.35.0/24'    => 'connected Vl35',
  '134.60.36.0/24'    => 'connected Vl36',
  '134.60.37.0/24'    => 'connected Vl37',
  '134.60.38.0/24'    => 'connected Vl38',
  '134.60.39.0/24'    => 'connected Vl39',
  '134.60.40.0/24'    => 'connected Vl40',
  '134.60.41.0/24'    => 'connected Vl41',
  '134.60.42.0/24'    => 'connected Vl42',
  '134.60.43.0/24'    => 'connected Vl43',
  '134.60.44.0/24'    => 'connected Vl44',
  '134.60.45.0/24'    => 'connected Vl45',
  '134.60.46.0/24'    => 'connected Vl46',
  '134.60.48.0/24'    => 'connected Vl48',
  '134.60.50.0/24'    => 'connected Vl50',
  '134.60.51.0/24'    => 'connected Vl51',
  '134.60.52.0/24'    => 'connected Vl52',
  '134.60.53.0/24'    => 'connected Vl53',
  '134.60.54.0/24'    => 'connected Vl54',
  '134.60.55.0/24'    => 'connected Vl55',
  '134.60.56.0/23'    => 'connected Vl56',
  '134.60.58.0/24'    => 'connected Vl58',
  '134.60.59.0/24'    => 'connected Vl59',
  '134.60.60.0/24'    => 'connected Vl60',
  '134.60.62.0/24'    => 'connected Vl62',
  '134.60.63.0/24'    => 'connected Vl63',
  '134.60.64.0/24'    => 'connected Vl64',
  '134.60.65.0/26'    => 'connected Vl65',
  '134.60.66.0/23'    => 'connected Vl66',
  '134.60.68.0/25'    => 'connected Vl68',
  '134.60.69.0/24'    => 'connected Vl69',
  '134.60.70.0/24'    => 'connected Vl70',
  '134.60.71.0/24'    => 'connected Vl71',
  '134.60.72.0/24'    => 'connected Vl72',
  '134.60.73.0/24'    => 'connected Vl73',
  '134.60.74.0/24'    => 'connected Vl74',
  '134.60.75.0/24'    => 'connected Vl75',
  '134.60.76.0/24'    => 'connected Vl76',
  '134.60.77.0/24'    => 'connected Vl77',
  '134.60.78.0/24'    => 'connected Vl78',
  '134.60.79.0/24'    => 'connected Vl79',
  '134.60.80.0/24'    => 'connected Vl80',
  '134.60.81.0/24'    => 'connected Vl81',
  '134.60.82.0/24'    => 'connected Vl82',
  '134.60.83.0/24'    => 'connected Vl83',
  '134.60.84.0/24'    => 'connected Vl84',
  '134.60.85.0/24'    => 'connected Vl85',
  '134.60.86.0/24'    => 'connected Vl86',
  '134.60.87.0/24'    => 'connected Vl87',
  '134.60.88.0/24'    => 'connected Vl88',
  '134.60.89.0/24'    => 'connected Vl89',
  '134.60.92.0/23'    => 'next-hop 134.60.111.68',
  '134.60.92.32/27'   => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.94.0/24'    => 'next-hop 134.60.111.68',
  '134.60.96.0/24'    => 'connected Vl96',
  '134.60.97.0/24'    => 'connected Vl97',
  '134.60.99.0/24'    => 'connected Vl99',
  '134.60.100.0/23'   => 'next-hop 134.60.111.68',
  '134.60.103.0/24'   => 'next-hop 134.60.112.28',
  '134.60.107.0/24'   => 'connected Vl107',
  '134.60.108.0/24'   => 'connected Vl108',
  '134.60.109.0/24'   => 'connected Vl109',
  '134.60.110.0/24'   => 'connected Vl110',
  '134.60.111.0/26'   => 'connected Te5/5',
  '134.60.111.64/28'  => 'connected Vl304',
  '134.60.111.80/28'  => 'connected Vl303',
  '134.60.111.96/27'  => 'connected Vl306',
  '134.60.111.128/27' => 'connected Vl307',
  '134.60.111.208/28' => 'next-hop 134.60.112.248 via Vl256 (ospf)',
  '134.60.111.208/28' => 'next-hop 134.60.112.249 via Vl256 (ospf)',
  '134.60.111.224/27' => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.112.0/28'   => 'connected Vl300',
  '134.60.112.16/28'  => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.112.16/28'  => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '134.60.112.32/27'  => 'connected Vl322',
  '134.60.112.64/28'  => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.112.64/28'  => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '134.60.112.80/29'  => 'connected Vl315',
  '134.60.112.88/29'  => 'connected Vl1124',
  '134.60.112.96/28'  => 'connected Vl1127',
  '134.60.112.112/29' => 'connected Vl305',
  '134.60.112.120/29' => 'connected Vl301',
  '134.60.112.128/27' => 'connected Vl318',
  '134.60.112.160/28' => 'connected Vl319',
  '134.60.112.180/32' => 'next-hop 0.0.0.0                Lo0',
  '134.60.112.181/32' => 'next-hop 134.60.112.247 via Vl256 (ospf)',
  '134.60.112.182/32' => 'next-hop 134.60.112.248 via Vl256 (ospf)',
  '134.60.112.183/32' => 'next-hop 134.60.112.249 via Vl256 (ospf)',
  '134.60.112.184/32' => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.112.185/32' => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '134.60.112.192/28' => 'connected Vl316',
  '134.60.112.208/30' => 'next-hop 134.60.112.203',
  '134.60.112.212/30' => 'next-hop 134.60.112.202',
  '134.60.112.216/29' => 'next-hop 134.60.112.204',
  '134.60.112.240/28' => 'connected via Vl256',
  '134.60.113.0/25'   => 'next-hop 193.197.66.75',
  '134.60.114.0/23'   => 'connected Vl114',
  '134.60.120.0/24'   => 'connected Vl120',
  '134.60.121.0/24'   => 'connected Vl121',
  '134.60.122.0/24'   => 'connected Vl122',
  '134.60.123.0/24'   => 'connected Vl123',
  '134.60.124.0/24'   => 'connected Vl124',
  '134.60.126.0/23'   => 'next-hop 134.60.111.68',
  '134.60.128.0/24'   => 'connected Vl128',
  '134.60.130.0/24'   => 'connected Vl130',
  '134.60.132.0/24'   => 'connected Vl132',
  '134.60.133.0/24'   => 'connected Vl133',
  '134.60.152.0/21'   => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.152.0/21'   => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '134.60.193.0/24'   => 'connected Vl193',
  '134.60.194.0/24'   => 'connected Vl194',
  '134.60.200.0/24'   => 'next-hop 134.60.111.68',
  '134.60.202.0/24'   => 'connected Vl202',
  '134.60.203.0/24'   => 'connected Vl203',
  '134.60.204.0/24'   => 'connected Vl204',
  '134.60.205.0/24'   => 'connected Vl205',
  '134.60.206.0/24'   => 'connected Vl206',
  '134.60.208.0/24'   => 'connected Vl208',
  '134.60.209.0/24'   => 'connected Vl209',
  '134.60.215.0/24'   => 'connected Vl215',
  '134.60.240.0/23'   => 'next-hop 134.60.112.202',
  '134.60.242.0/27'   => 'connected Vl340',
  '134.60.244.0/23'   => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '134.60.244.0/23'   => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '134.60.246.0/23'   => 'next-hop 134.60.112.202',
  '134.60.252.0/22'   => 'next-hop 134.60.112.93',
  '134.60.255.255/32' => 'Null0',
  '169.254.0.0/16'    => 'Null0',
  '172.16.0.0/12'     => 'Null0',
  '172.16.72.0/29'    => 'connected Vl407',
  '192.0.2.0/24'      => 'Null0',
  '192.168.0.0/16'    => 'Null0',
  '192.168.3.0/24'    => 'next-hop 134.60.2.16',
  '192.168.128.0/24'  => 'next-hop 134.60.112.247 via Vl256 (ospf)',
  '192.168.216.0/29'  => 'connected Vl405',
  '193.197.61.16/31'  => 'next-hop 134.60.112.248 via Vl256 (ospf)',
  '193.197.62.192/29' => 'connected Vl315',
  '193.197.63.16/31'  => 'next-hop 134.60.112.249 via Vl256 (ospf)',
  '193.197.64.0/23'   => 'next-hop 134.60.112.117',
  '193.197.65.128/27' => 'connected Vl401',
  '193.197.65.224/27' => 'next-hop 134.60.112.204',
  '193.197.66.0/27'   => 'connected Vl330',
  '193.197.66.32/27'  => 'connected Vl331',
  '193.197.66.64/27'  => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '193.197.66.64/27'  => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '193.197.228.0/22'  => 'next-hop 134.60.112.250 via Vl256 (ospf)',
  '193.197.228.0/22'  => 'next-hop 134.60.112.251 via Vl256 (ospf)',
  '198.51.100.0/24'   => 'Null0',
  '203.0.113.0/24'    => 'Null0',
};

my $decorate_cb = sub {
  my $item       = shift;
  my $block      = $item->to_string;
  my $annotation = $routes->{$block};

  my $ruler = '.' x ( 40 - length($block) );
  return "$block $ruler $annotation";
};

my $t = Net::IPAM::Tree->new;

my @blocks;
foreach my $b ( keys %$routes ) {
  push @blocks, Net::IPAM::Block->new($b);
}

$t->insert(@blocks);
print $t->to_string($decorate_cb);

1;
