#!/usr/bin/perl -w 
#
# test_exec.pl - test execution of stored procedures.
#
# XXX execution of stored procedures is not working yet.
# I am working on it, but I ran into bugs that looked like
# they were going to take some time to fix, so I ifdef'd
# out the procedure stuff in IBPerl.xs.  Something to
# add to the next release.
#
# Copyright 1998-1999 Bill Karwin

use strict;
use IBPerl;

print <<__WARNING__;

    # XXX execution of stored procedures is not working yet.
    # I am working on it, but I ran into bugs that looked like
    # they were going to take some time to fix, so I ifdef'd
    # out the procedure stuff in IBPerl.xs.  Something to
    # add to the next release.

__WARNING__

my $DBPATH = 'test_exec.gdb';
my ($db, $tr, $st, %row);

print "IBPerl version $IBPerl::VERSION\n";

print "Trying connect database...\n";
$db = new IBPerl::Connection(
    Path=>$DBPATH,
    User=>'sysdba',
    Password=>'masterkey'
);

if ($db->{Handle} < 0) { print STDERR "$db->{Error}\n"; exit 1; }

$tr = new IBPerl::Transaction(Database=>$db);
if ($tr->{Handle} < 0) { print "$tr->{Error}\n"; exit 1; }

# ----------------------------------------------------------------------
# Simple SELECT

$st = new IBPerl::Statement(Transaction=>$tr,
    Stmt=>"SELECT \* FROM FOOB");
if ($st->{Handle} < 0) { print "$st->{Error}\n"; exit 1; }

print "Trying to SELECT \n";
if ($st->open() < 0) { print "$st->{Error}\n"; exit 1; }

while ($st->fetch(\%row) == 0)
{
    foreach (keys %row)
    {
	print "$_: $row{$_}\n";
    }
}
if ($st->close() < 0) { print "$st->{Error}\n"; exit 1; }

# ----------------------------------------------------------------------
# EXECUTE PROCEDURE without parameters

$st = new IBPerl::Statement(Transaction=>$tr,
    Stmt=>"EXECUTE PROCEDURE FOO(10, 'Bill')");
if ($st->{Handle} < 0) { print "$st->{Error}\n"; exit 1; }

print "Trying to execute static EXECUTE PROCEDURE stmt\n";
if ($st->open() < 0) { print "$st->{Error}\n"; exit 1; }

while ($st->fetch(\%row) == 0)
{
    foreach (keys %row)
    {
	print "$_: $row{$_}\n";
    }
}
if ($st->close() < 0) { print "$st->{Error}\n"; exit 1; }

# ----------------------------------------------------------------------
# EXECUTE PROCEDURE with parameters

$st = new IBPerl::Statement(Transaction=>$tr,
    Stmt=>"EXECUTE PROCEDURE FOO(?, ?)");
if ($st->{Handle} < 0) { print "$st->{Error}\n"; exit 1; }

print "Trying to execute parameterized EXECUTE PROCEDURE stmt\n";
if ($st->open(20, 'Karwin') < 0) { print "$st->{Error}\n"; exit 1; }

while ($st->fetch(\%row) == 0)
{
    foreach (keys %row)
    {
	print "$_: $row{$_}\n";
    }
}
if ($st->close() < 0) { print "$st->{Error}\n"; exit 1; }

# ----------------------------------------------------------------------

print "Committing... ";
if ($tr->commit() < 0)
{
    print "Commit Error:\n$tr->{Error}\n";
    exit 1;
}
print "ok\n";

print "Disconnecting... ";
if ($db->disconnect() < 0)
{
    print "Disconnection Error:\n$db->{Error}\n";
    exit 1;
}
print "ok\n";

exit 0;
