use ExtUtils::MakeMaker;
WriteMakefile(
    NAME	=> 'Finance::Shares',
    VERSION	=> '0.90',
    ABSTRACT	=> 'Collecting and tracking share prices',
    AUTHOR      => 'Christopher Willmot <chris@willmot.org>',
    NORECURS    => 1,
    PREREQ_PM	=> { 
	#'Test::More'		    => 0,
	'Date::Calc'                => 0,
	'Text::CSV_XS'              => 0,
	'LWP::UserAgent'            => 0,
	'DBIx::Namespace'           => 0.03,
	'PostScript::File'	    => 1.00,
	'PostScript::Graph::Bar'    => 0.03,
	'PostScript::Graph::Key'    => 1.00,
	'PostScript::Graph::Paper'  => 1.00,
	'PostScript::Graph::Style'  => 1.00,
	'PostScript::Graph::XY'	    => 0.04,
    },
    EXE_FILES => [qw(fs_model fs_fetch)],
    PM	=> {
	'Shares/Averages.pm'	=> '$(INST_LIBDIR)/Shares/Averages.pm',
	'Shares/Bands.pm'   	=> '$(INST_LIBDIR)/Shares/Bands.pm',
	'Shares/Chart.pm'	=> '$(INST_LIBDIR)/Shares/Chart.pm',
	'Shares/Model.pm'   	=> '$(INST_LIBDIR)/Shares/Model.pm',
	'Shares/Momentum.pm'   	=> '$(INST_LIBDIR)/Shares/Momentum.pm',
	'Shares/MySQL.pm'	=> '$(INST_LIBDIR)/Shares/MySQL.pm',
	'Shares/Sample.pm'	=> '$(INST_LIBDIR)/Shares/Sample.pm',
    },
    MAN3PODS => {
	'Shares/Averages.pm'	=> '$(INST_MAN3DIR)/Finance::Shares::Averages.3pm',
	'Shares/Bands.pm'   	=> '$(INST_MAN3DIR)/Finance::Shares::Bands.3pm',
	'Shares/Chart.pm'	=> '$(INST_MAN3DIR)/Finance::Shares::Chart.3pm',
	'Shares/Model.pm'   	=> '$(INST_MAN3DIR)/Finance::Shares::Model.3pm',
	'Shares/Momentum.pm'  	=> '$(INST_MAN3DIR)/Finance::Shares::Momentum.3pm',
	'Shares/MySQL.pm'	=> '$(INST_MAN3DIR)/Finance::Shares::MySQL.3pm',
	'Shares/Sample.pm'	=> '$(INST_MAN3DIR)/Finance::Shares::Sample.3pm',
	'Shares/Overview.pod'	=> '$(INST_MAN3DIR)/Finance::Shares::Overview.3pm',
	'Shares/Lesson1.pod'	=> '$(INST_MAN3DIR)/Finance::Shares::Lesson1.3pm',
	'Shares/Lesson2.pod'	=> '$(INST_MAN3DIR)/Finance::Shares::Lesson2.3pm',
	'Shares/Lesson3.pod'	=> '$(INST_MAN3DIR)/Finance::Shares::Lesson3.3pm',
	'Shares/Lesson4.pod'	=> '$(INST_MAN3DIR)/Finance::Shares::Lesson4.3pm',
	'Shares/Lesson5.pod'	=> '$(INST_MAN3DIR)/Finance::Shares::Lesson5.3pm',
    },
);
