/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.xpath.LowerCaseFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.objects.XObject;

class XPathAdapter {
    private Expression mainExp_;
    private FunctionTable funcTable_;
    public static final int SELECT = 0;
    public static final int MATCH = 1;

    private void initFunctionTable() {
        this.funcTable_ = new FunctionTable();
        this.funcTable_.installFunction("lower-case", LowerCaseFunction.class);
    }

    XPathAdapter(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        Expression expr;
        this.initFunctionTable();
        if (errorListener == null) {
            errorListener = new DefaultErrorHandler();
        }
        exprString = XPathAdapter.preProcessXPath(exprString);
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator, this.funcTable_);
        if (0 == type) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XSLMessages.createXPATHMessage((String)"ER_CANNOT_DEAL_XPATH_TYPE", (Object[])new Object[]{Integer.toString(type)}));
        }
        this.mainExp_ = expr = compiler.compile(0);
        if (locator != null && locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    private static String preProcessXPath(String string) {
        Pattern pattern = Pattern.compile("(@[a-zA-Z]+)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String attribute = matcher.group(1);
            string = string.replace(attribute, attribute.toLowerCase());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XObject execute(XPathContext xpathContext, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        XObject xobj;
        block11: {
            xpathContext.pushNamespaceContext(namespaceContext);
            xpathContext.pushCurrentNodeAndExpression(contextNode, contextNode);
            xobj = null;
            try {
                xobj = this.mainExp_.execute(xpathContext);
            }
            catch (TransformerException te) {
                te.setLocator((SourceLocator)this.mainExp_);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = XSLMessages.createXPATHMessage((String)"ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, (SourceLocator)this.mainExp_, e);
                ErrorListener el = xpathContext.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xpathContext.popNamespaceContext();
                xpathContext.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }
}

