use Test::More;
use Syntax::Keyword::Combine::Keys qw/ckeys/;
my @keys = ckeys { $_ }
	a => 1,
	b => 2,
	c => 3,
	a => 4,
	b => 5,
	c => 6;
use Data::Dumper;

is_deeply(\@keys, [qw/a b c/]);

my $first_hash = {
	a => 1,
	b => 2,
	c => 3
};

my %second_hash = (
	c => 3,
	d => 4,
	e => 5
);

@keys = ckeys {
	uc $_;
} %second_hash, %{$first_hash};

is_deeply(\@keys, [qw/A B C D E/]);

my %hash = ckeys {
	$_ => 100;
} %second_hash, %{$first_hash};


is_deeply(\%hash, {
	a => 100,
	b => 100,
	c => 100,
	d => 100,
	e => 100
});

done_testing;
