# Generated by default/object.tt
package Paws::SSMContacts::Engagement;
  use Moose;
  has ContactArn => (is => 'ro', isa => 'Str', required => 1);
  has EngagementArn => (is => 'ro', isa => 'Str', required => 1);
  has IncidentId => (is => 'ro', isa => 'Str');
  has Sender => (is => 'ro', isa => 'Str', required => 1);
  has StartTime => (is => 'ro', isa => 'Str');
  has StopTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMContacts::Engagement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMContacts::Engagement object:

  $service_obj->Method(Att1 => { ContactArn => $value, ..., StopTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMContacts::Engagement object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactArn

=head1 DESCRIPTION

Incident Manager reaching out to a contact or escalation plan to engage
contact during an incident.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContactArn => Str

The ARN of the escalation plan or contact that Incident Manager is
engaging.


=head2 B<REQUIRED> EngagementArn => Str

The Amazon Resource Name (ARN) of the engagement.


=head2 IncidentId => Str

The ARN of the incident that's engaging the contact.


=head2 B<REQUIRED> Sender => Str

The user that started the engagement.


=head2 StartTime => Str

The time that the engagement began.


=head2 StopTime => Str

The time that the engagement ended.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMContacts>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

