case $CONFIG in
'')
	if test ! -f config.sh; then
		ln ../config.sh . || \
		ln ../../config.sh . || \
		ln ../../../config.sh . || \
		ln ../../../../config.sh . || \
		(echo "Can't find config.sh."; exit 1)
	fi 2>/dev/null
	. ./config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting Makefile (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.  You may delete these comments.
$spitshell >Makefile <<!GROK!THIS!
########################################################
##
##   Project:  Tcl Modules
##   Created:  Sep 3 1991
##    Author:  John L. Furlani<john.furlani@East.Sun.COM>
##
##  Description of File:
##	 Makefile for modulecmd
##
##  $Id: Makefile.SH,v 2.0 1993/02/21 00:01:39 jlf Exp jlf $
##
##  Makefile generated from Makefile.SH on $DATE
##
########################################################
##
##	Installation
INSTALL=./myinstall

#######
##  Where modulecmd is placed
MODULESBINDEST=$modules_bin
MODULESFILESDEST=$modules_files
MODULESINITDEST=$modules_init
MODULESMANDDEST=$module_man

##
##  C compiler and flags
##
CC=$cc
CFLAGS=$ccflags $optimize

##
##	Special Defines and Include Directories
##
CPPFLAGS= $cppflags -I. $tcl_incdir_flags $x11_incdir_flags


##
##	Libraries to Link With
##
LDLIBS= $static_linking $tcl_lib $x11_libs $addl_x11_libs $libs
LDFLAGS= $x11_libdir_flags $ldflags

!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>Makefile <<'!NO!SUBS!'
##
##	All Source Files C, C++ and Headers
##
##	Keep alphabetic...
##
CFILES= LocateModule.c \
	ModuleCmd_Avail.c \
	ModuleCmd_Clear.c \
	ModuleCmd_Display.c \
	ModuleCmd_Help.c \
	ModuleCmd_Init.c \
	ModuleCmd_List.c \
	ModuleCmd_Load.c \
	ModuleCmd_Purge.c \
	ModuleCmd_Switch.c \
	ModuleCmd_Update.c \
	ModuleCmd_Use.c \
	cmdAlias.c \
	cmdConflict.c \
	cmdInfo.c \
	cmdMisc.c \
	cmdModule.c \
	cmdPath.c \
	cmdSetenv.c \
	cmdUname.c \
        cmdXResource.c \
	init.c \
	main.c \
	utility.c

HFILES= global.h

OBJFILES= $(CFILES:%.c=%.o)

##
##	Name of the Program we're building
##
PROGNAME= modulecmd

all:	$(PROGNAME)
##
##	Build the Program
##
$(PROGNAME):	$(HFILES) $(OBJFILES)
	$(CC) -o $@ $(OBJFILES) $(LDFLAGS) $(LDLIBS)

##
##	Install Myself
##
install: $(PROGNAME)
	$(INSTALL) -m 0755 -d $(MODULESBINDEST)
	$(INSTALL) -m 0755 -d $(MODULESFILESDEST)
	$(INSTALL) -c -m 0555 $(PROGNAME) $(MODULESBINDEST)
	(cd init;make install)

##
##	How to clean up after myself
##
clean:
	rm -f *.o core y.tab.c lex.yy.c
!NO!SUBS!
chmod 755 Makefile
$eunicefix Makefile
